/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.multipage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import net.sf.sdedit.multipage.MultipagePaintDevice;

public class ExportDocument {
    private MultipagePaintDevice mpd;
    private Class<? extends Graphics2D> graphicsClass;
    private Graphics2D graphics;

    public ExportDocument(Class<? extends Graphics2D> graphicsClass, MultipagePaintDevice mpd, OutputStream stream, String format, String orientation) {
        this.mpd = mpd;
        this.graphicsClass = graphicsClass;
        try {
            this.graphics = graphicsClass.getConstructor(OutputStream.class, Dimension.class).newInstance(stream, mpd.getPageSize());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Cannot create instance of " + graphicsClass.getSimpleName());
        }
        this.invoke("setMultiPage", Boolean.TYPE, Boolean.TRUE);
        Properties properties = new Properties();
        properties.setProperty(this.getStringConstant("ORIENTATION"), orientation);
        properties.setProperty(this.getStringConstant("PAGE_SIZE"), format);
        this.invoke("setProperties", Properties.class, properties);
    }

    private void invoke(String methodName) {
        this.invoke(methodName, null, null);
    }

    private String getStringConstant(String name) {
        try {
            Field field = this.graphicsClass.getField(name);
            return (String)field.get(null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("cannot resolve string constant " + name);
        }
    }

    private <T> void invoke(String methodName, Class<? extends T> argClass, T arg) {
        try {
            Object[] objectArray;
            Class[] classArray;
            if (argClass == null) {
                classArray = new Class[]{};
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = argClass;
            }
            Class[] argTypes = classArray;
            Method method = this.graphicsClass.getMethod(methodName, argTypes);
            if (arg == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = arg;
            }
            Object[] args = objectArray;
            method.invoke((Object)this.graphics, args);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException("invocation of " + methodName + " failed");
        }
    }

    public void export() throws IOException {
        this.invoke("startExport");
        for (MultipagePaintDevice.MultipagePanel panel : this.mpd.getPanels()) {
            this.invoke("openPage", Component.class, panel);
            panel.paintComponent(this.graphics);
            this.invoke("closePage");
        }
        this.invoke("endExport");
    }
}

