/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.navigator;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sf.sdedit.ui.components.Stainable;
import net.sf.sdedit.ui.components.StainedListener;
import net.sf.sdedit.ui.components.navigator.ContextActionsProvider;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorModel;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorNode;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorPane;

class TreeNavigatorControl
implements TreeSelectionListener,
StainedListener,
MouseListener {
    private TreeNavigatorModel treeModel;
    private TreeNavigatorPane navigator;
    private TreePath[] formerSelection;
    private boolean ignoreValueChanged;
    private ContextActionsProvider contextActionsProvider;

    protected TreeNavigatorControl(TreeNavigatorPane navigator, TreeNavigatorModel treeModel) {
        this.navigator = navigator;
        this.treeModel = treeModel;
        this.formerSelection = new TreePath[0];
    }

    protected void setContextActionsProvider(ContextActionsProvider provider) {
        this.contextActionsProvider = provider;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.ignoreValueChanged) {
            return;
        }
        JComponent firstComp = null;
        TreePath[] paths = this.navigator.getTree().getSelectionPaths();
        if (paths != null) {
            for (TreePath path : this.navigator.getTree().getSelectionPaths()) {
                TreeNavigatorNode node = (TreeNavigatorNode)path.getLastPathComponent();
                JComponent comp = node.getComponent();
                if (comp == null) {
                    this.ignoreValueChanged = true;
                    this.navigator.getTree().setSelectionPaths(this.formerSelection);
                    this.ignoreValueChanged = false;
                    return;
                }
                if (firstComp != null) continue;
                firstComp = comp;
            }
            if (firstComp != null) {
                this.navigator.setSelectedComponent(firstComp, false, true);
                this.formerSelection = this.navigator.getTree().getSelectionPaths();
            }
        }
    }

    @Override
    public void stainedStatusChanged(Stainable stainable, boolean stained) {
        JComponent changed = (JComponent)JComponent.class.cast(stainable);
        this.treeModel.fireComponentChanged(changed);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        List<Action> actions;
        TreePath path;
        TreeNavigatorNode node;
        if (SwingUtilities.isRightMouseButton(e) && this.contextActionsProvider != null && (node = (TreeNavigatorNode)(path = this.navigator.getPathFor(e)).getLastPathComponent()).getComponent() != null && (actions = this.contextActionsProvider.getContextActions(node.getComponent())) != null && !actions.isEmpty()) {
            JPopupMenu menu = new JPopupMenu();
            this.navigator.setSelectedComponent(node.getComponent());
            for (Action action : actions) {
                menu.add(action);
            }
            menu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

