/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAnimationEffect.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSComputedEffectTiming.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEffectTiming.h"
#include "JSOptionalEffectTiming.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsAnimationEffectPrototypeFunction_getTiming);
static JSC_DECLARE_HOST_FUNCTION(jsAnimationEffectPrototypeFunction_getComputedTiming);
static JSC_DECLARE_HOST_FUNCTION(jsAnimationEffectPrototypeFunction_updateTiming);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAnimationEffectConstructor);

class JSAnimationEffectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAnimationEffectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnimationEffectPrototype* ptr = new (NotNull, JSC::allocateCell<JSAnimationEffectPrototype>(vm)) JSAnimationEffectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationEffectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnimationEffectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationEffectPrototype, JSAnimationEffectPrototype::Base);

using JSAnimationEffectDOMConstructor = JSDOMConstructorNotConstructable<JSAnimationEffect>;

template<> const ClassInfo JSAnimationEffectDOMConstructor::s_info = { "AnimationEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEffectDOMConstructor) };

template<> JSValue JSAnimationEffectDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAnimationEffectDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AnimationEffect"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAnimationEffect::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAnimationEffectPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAnimationEffectConstructor, 0 } },
    { "getTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAnimationEffectPrototypeFunction_getTiming, 0 } },
    { "getComputedTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAnimationEffectPrototypeFunction_getComputedTiming, 0 } },
    { "updateTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAnimationEffectPrototypeFunction_updateTiming, 0 } },
};

const ClassInfo JSAnimationEffectPrototype::s_info = { "AnimationEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEffectPrototype) };

void JSAnimationEffectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnimationEffect::info(), JSAnimationEffectPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAnimationEffect::s_info = { "AnimationEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEffect) };

JSAnimationEffect::JSAnimationEffect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnimationEffect>&& impl)
    : JSDOMWrapper<AnimationEffect>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, AnimationEffect>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAnimationEffect::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAnimationEffectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSAnimationEffectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSAnimationEffect::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAnimationEffect>(vm, globalObject);
}

JSValue JSAnimationEffect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnimationEffectDOMConstructor, DOMConstructorID::AnimationEffect>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAnimationEffect::destroy(JSC::JSCell* cell)
{
    JSAnimationEffect* thisObject = static_cast<JSAnimationEffect*>(cell);
    thisObject->JSAnimationEffect::~JSAnimationEffect();
}

JSC_DEFINE_CUSTOM_GETTER(jsAnimationEffectConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationEffectPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAnimationEffect::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsAnimationEffectPrototypeFunction_getTimingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnimationEffect>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<EffectTiming>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getBindingsTiming())));
}

JSC_DEFINE_HOST_FUNCTION(jsAnimationEffectPrototypeFunction_getTiming, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAnimationEffect>::call<jsAnimationEffectPrototypeFunction_getTimingBody>(*lexicalGlobalObject, *callFrame, "getTiming");
}

static inline JSC::EncodedJSValue jsAnimationEffectPrototypeFunction_getComputedTimingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnimationEffect>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<ComputedEffectTiming>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getBindingsComputedTiming())));
}

JSC_DEFINE_HOST_FUNCTION(jsAnimationEffectPrototypeFunction_getComputedTiming, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAnimationEffect>::call<jsAnimationEffectPrototypeFunction_getComputedTimingBody>(*lexicalGlobalObject, *callFrame, "getComputedTiming");
}

static inline JSC::EncodedJSValue jsAnimationEffectPrototypeFunction_updateTimingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnimationEffect>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto timingConversionResult = convert<IDLDictionary<OptionalEffectTiming>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(timingConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindingsUpdateTiming(timingConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAnimationEffectPrototypeFunction_updateTiming, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAnimationEffect>::call<jsAnimationEffectPrototypeFunction_updateTimingBody>(*lexicalGlobalObject, *callFrame, "updateTiming");
}

JSC::GCClient::IsoSubspace* JSAnimationEffect::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAnimationEffect, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAnimationEffect.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAnimationEffect = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAnimationEffect.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAnimationEffect = std::forward<decltype(space)>(space); }
    );
}

void JSAnimationEffect::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAnimationEffect*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSAnimationEffectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAnimationEffectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAnimationEffect = static_cast<JSAnimationEffect*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAnimationEffect->protectedWrapped().ptr(), jsAnimationEffect);
}

AnimationEffect* JSAnimationEffect::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAnimationEffect*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
