/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCommandEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CommandEvent::Init>> convertDictionary<CommandEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CommandEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(bubblesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(composedConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue commandValue;
    if (isNullOrUndefined)
        commandValue = jsUndefined();
    else {
        commandValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "command"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto commandConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, commandValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(commandConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.command = commandConversionResult.releaseReturnValue();
    JSValue invokerValue;
    if (isNullOrUndefined)
        invokerValue = jsUndefined();
    else {
        invokerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "invoker"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto invokerConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, invokerValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<Element>>> { return typename Converter<IDLNullable<IDLInterface<Element>>>::ReturnType { nullptr }; });
    if (UNLIKELY(invokerConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.invoker = invokerConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCommandEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCommandEvent_invoker);
static JSC_DECLARE_CUSTOM_GETTER(jsCommandEvent_command);

class JSCommandEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCommandEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCommandEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSCommandEventPrototype>(vm)) JSCommandEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCommandEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCommandEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCommandEventPrototype, JSCommandEventPrototype::Base);

using JSCommandEventDOMConstructor = JSDOMConstructor<JSCommandEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCommandEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCommandEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<CommandEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(eventInitDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = CommandEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CommandEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CommandEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCommandEventDOMConstructorConstruct, JSCommandEventDOMConstructor::construct);

template<> const ClassInfo JSCommandEventDOMConstructor::s_info = { "CommandEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandEventDOMConstructor) };

template<> JSValue JSCommandEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSCommandEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CommandEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCommandEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCommandEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCommandEventConstructor, 0 } },
    { "invoker"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCommandEvent_invoker, 0 } },
    { "command"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCommandEvent_command, 0 } },
};

const ClassInfo JSCommandEventPrototype::s_info = { "CommandEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandEventPrototype) };

void JSCommandEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCommandEvent::info(), JSCommandEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCommandEvent::s_info = { "CommandEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandEvent) };

JSCommandEvent::JSCommandEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CommandEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<CommandEvent> JSCommandEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CommandEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCommandEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCommandEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCommandEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCommandEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCommandEvent>(vm, globalObject);
}

JSValue JSCommandEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCommandEventDOMConstructor, DOMConstructorID::CommandEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCommandEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCommandEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCommandEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCommandEvent_invokerGetter(JSGlobalObject& lexicalGlobalObject, JSCommandEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.invoker())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCommandEvent_invoker, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCommandEvent>::get<jsCommandEvent_invokerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCommandEvent_commandGetter(JSGlobalObject& lexicalGlobalObject, JSCommandEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.command())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCommandEvent_command, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCommandEvent>::get<jsCommandEvent_commandGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCommandEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCommandEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCommandEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCommandEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCommandEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCommandEvent = std::forward<decltype(space)>(space); }
    );
}

void JSCommandEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCommandEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CommandEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12CommandEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CommandEvent>, void>> static inline void verifyVTable(CommandEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CommandEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12CommandEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CommandEvent has subclasses. If CommandEvent has subclasses that get passed
        // to toJS() we currently require CommandEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CommandEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CommandEvent>(impl.ptr());
#endif
    return createWrapper<CommandEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CommandEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
