/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD)

#include "JSGamepadEffectParameters.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(GAMEPAD)

template<> ConversionResult<IDLDictionary<GamepadEffectParameters>> convertDictionary<GamepadEffectParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GamepadEffectParameters result;
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto durationConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, durationValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (UNLIKELY(durationConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.duration = durationConversionResult.releaseReturnValue();
    JSValue leftTriggerValue;
    if (isNullOrUndefined)
        leftTriggerValue = jsUndefined();
    else {
        leftTriggerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "leftTrigger"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto leftTriggerConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, leftTriggerValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (UNLIKELY(leftTriggerConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.leftTrigger = leftTriggerConversionResult.releaseReturnValue();
    JSValue rightTriggerValue;
    if (isNullOrUndefined)
        rightTriggerValue = jsUndefined();
    else {
        rightTriggerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rightTrigger"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto rightTriggerConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, rightTriggerValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (UNLIKELY(rightTriggerConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.rightTrigger = rightTriggerConversionResult.releaseReturnValue();
    JSValue startDelayValue;
    if (isNullOrUndefined)
        startDelayValue = jsUndefined();
    else {
        startDelayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "startDelay"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto startDelayConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, startDelayValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (UNLIKELY(startDelayConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.startDelay = startDelayConversionResult.releaseReturnValue();
    JSValue strongMagnitudeValue;
    if (isNullOrUndefined)
        strongMagnitudeValue = jsUndefined();
    else {
        strongMagnitudeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "strongMagnitude"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto strongMagnitudeConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, strongMagnitudeValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (UNLIKELY(strongMagnitudeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.strongMagnitude = strongMagnitudeConversionResult.releaseReturnValue();
    JSValue weakMagnitudeValue;
    if (isNullOrUndefined)
        weakMagnitudeValue = jsUndefined();
    else {
        weakMagnitudeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "weakMagnitude"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto weakMagnitudeConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, weakMagnitudeValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (UNLIKELY(weakMagnitudeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.weakMagnitude = weakMagnitudeConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(GAMEPAD)
