/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSecurityPolicyViolationEventDisposition.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(SecurityPolicyViolationEventDisposition enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("enforce"),
        MAKE_STATIC_STRING_IMPL("report"),
    };
    static_assert(static_cast<size_t>(SecurityPolicyViolationEventDisposition::Enforce) == 0, "SecurityPolicyViolationEventDisposition::Enforce is not 0 as expected");
    static_assert(static_cast<size_t>(SecurityPolicyViolationEventDisposition::Report) == 1, "SecurityPolicyViolationEventDisposition::Report is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, SecurityPolicyViolationEventDisposition enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<SecurityPolicyViolationEventDisposition> parseEnumerationFromString<SecurityPolicyViolationEventDisposition>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, SecurityPolicyViolationEventDisposition> mappings[] = {
        { "enforce", SecurityPolicyViolationEventDisposition::Enforce },
        { "report", SecurityPolicyViolationEventDisposition::Report },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<SecurityPolicyViolationEventDisposition> parseEnumeration<SecurityPolicyViolationEventDisposition>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<SecurityPolicyViolationEventDisposition>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<SecurityPolicyViolationEventDisposition>()
{
    return "\"enforce\", \"report\""_s;
}

} // namespace WebCore
