// Copyright (C) 2016 The Qt Company Ltd.
// Copyright (c) Meta Platforms, Inc. and affiliates.
//
// SPDX-License-Identifier: MIT

#include <yoga/Yoga.h>

#include "log.h"
#include "YGConfig.h"
#include "YGNode.h"

QT_YOGA_NAMESPACE_BEGIN

namespace facebook {
namespace yoga {
namespace detail {

namespace {

void vlog(
    YGConfig* config,
    YGNode* node,
    YGLogLevel level,
    void* context,
    const char* format,
    va_list args) {
  YGConfig* logConfig = config != nullptr ? config : YGConfigGetDefault();
  logConfig->log(logConfig, node, level, context, format, args);
}
} // namespace

YOGA_EXPORT void Log::log(
    YGNode* node,
    YGLogLevel level,
    void* context,
    const char* format,
    ...) noexcept {
  va_list args;
  va_start(args, format);
  vlog(
      node == nullptr ? nullptr : node->getConfig(),
      node,
      level,
      context,
      format,
      args);
  va_end(args);
}

void Log::log(
    YGConfig* config,
    YGLogLevel level,
    void* context,
    const char* format,
    ...) noexcept {
  va_list args;
  va_start(args, format);
  vlog(config, nullptr, level, context, format, args);
  va_end(args);
}

} // namespace detail
} // namespace yoga
} // namespace facebook

QT_YOGA_NAMESPACE_END
