/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** No Commercial Usage
**
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**************************************************************************/

#include "copytaskhandler.h"

#include "task.h"

#include <coreplugin/coreconstants.h>

#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QClipboard>

using namespace ProjectExplorer::Internal;

CopyTaskHandler::CopyTaskHandler() :
    ITaskHandler(QLatin1String(Core::Constants::COPY))
{ }

void CopyTaskHandler::handle(const ProjectExplorer::Task &task)
{
    QString type;
    switch (task.type) {
    case Task::Error:
        type = tr("error: ", "Task is of type error");
        break;
    case Task::Warning:
        type = tr("warning: ", "Task is of type warning");
        break;
    default:
        break;
    }

    QApplication::clipboard()->setText(task.file + ':' +
                                       QString::number(task.line) + ": "
                                       + type + task.description);
}

QAction *CopyTaskHandler::createAction(QObject *parent)
{
    QAction *copyAction = new QAction(tr("&Copy", "Name of the action triggering the copytaskhandler"), parent);
    copyAction->setToolTip(tr("Copy task to clipboard"));
    return copyAction;
}
