/****************************************************************************
**
** Copyright (C) 2012 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
****************************************************************************/
#include "remotelinuxdeployconfiguration.h"

#include "deploymentinfo.h"
#include "remotelinuxdeployconfigurationwidget.h"
#include "typespecificdeviceconfigurationlistmodel.h"

#include <projectexplorer/devicesupport/devicemanager.h>
#include <projectexplorer/project.h>
#include <projectexplorer/target.h>
#include <qt4projectmanager/qt4project.h>

using namespace ProjectExplorer;
using namespace Qt4ProjectManager;

namespace {
const char DEPLOYMENT_INFO_SETTING[] = "RemoteLinux.DeploymentInfo";
} // namespace

namespace RemoteLinux {

using namespace Internal;

RemoteLinuxDeployConfiguration::RemoteLinuxDeployConfiguration(ProjectExplorer::Target *target,
        const Core::Id id, const QString &defaultDisplayName)
    : DeployConfiguration(target, id)
{
    setDefaultDisplayName(defaultDisplayName);

    // Make sure we have deploymentInfo, but create it only once:
    DeploymentInfo *info
            = qobject_cast<DeploymentInfo *>(target->project()->namedSettings(QLatin1String(DEPLOYMENT_INFO_SETTING)).value<QObject *>());
    if (!info) {
        info = new DeploymentInfo(static_cast<Qt4ProjectManager::Qt4Project *>(target->project()));
        QVariant data = QVariant::fromValue(static_cast<QObject *>(info));
        target->project()->setNamedSettings(QLatin1String(DEPLOYMENT_INFO_SETTING), data);
    }
}

RemoteLinuxDeployConfiguration::RemoteLinuxDeployConfiguration(ProjectExplorer::Target *target,
        RemoteLinuxDeployConfiguration *source)
    : DeployConfiguration(target, source)
{ }

DeploymentInfo *RemoteLinuxDeployConfiguration::deploymentInfo() const
{
    DeploymentInfo *info
            = qobject_cast<DeploymentInfo *>(target()->project()->namedSettings(QLatin1String(DEPLOYMENT_INFO_SETTING)).value<QObject *>());
    return info;
}

QString RemoteLinuxDeployConfiguration::qmakeScope() const
{
    return QLatin1String("unix");
}

QString RemoteLinuxDeployConfiguration::installPrefix() const
{
    return QString();
}

DeployConfigurationWidget *RemoteLinuxDeployConfiguration::configurationWidget() const
{
    return new RemoteLinuxDeployConfigurationWidget;
}

} // namespace RemoteLinux
