import QtQuick
import QtQuick.Controls


/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd
** All rights reserved.
** For any questions to The Qt Company, please use contact form at http://www.qt.io/contact-us
**
** This file is part of the Qt Asset Importer module.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** If you have questions regarding the use of this file, please use
** contact form at http://www.qt.io/contact-us
**
******************************************************************************/

//TV:1
import QtQuick.Templates 2.1 as T

T.Button {
    id: buttonControl

    implicitWidth: background.width
    implicitHeight: background.height

    property alias buttonText: content.labelText
    contentItem: BasicButtoncontent {
        id: content
        width: 93
        height: 96
        anchors.verticalCenter: parent.verticalCenter
        anchors.horizontalCenter: parent.horizontalCenter
        state: "state_idle"
        clip: true
        anchors.horizontalCenterOffset: -1
    }
    background: BasicButtonbackground {
        id: background
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: -1
        anchors.rightMargin: 1
        state: "state_idle"
    }

    states: [
        State {
            name: "state_idle"
            when: buttonControl.enabled && !buttonControl.down
                  && !buttonControl.hovered && !buttonControl.checked

            PropertyChanges {
                target: content
                state: "state_idle"
            }

            PropertyChanges {
                target: background
                state: "state_idle"
            }
        },
        State {
            name: "state_hovered"
            when: buttonControl.hovered && buttonControl.enabled
                  && !buttonControl.checked && !buttonControl.down

            PropertyChanges {
                target: content
                state: "state_hovered"
            }

            PropertyChanges {
                target: background
                state: "state_hovered"
            }
        },
        State {
            name: "state_pressed"
            when: buttonControl.down && buttonControl.enabled
                  && !buttonControl.checked

            PropertyChanges {
                target: content
                state: "state_pressed"
            }

            PropertyChanges {
                target: background
                state: "state_pressed"
            }
        },
        State {
            name: "state_checked"
            when: buttonControl.checked && buttonControl.enabled
                  && !buttonControl.down && !buttonControl.hovered

            PropertyChanges {
                target: content
                state: "state_checked"
            }

            PropertyChanges {
                target: background
                state: "state_checked"
            }
        },
        State {
            name: "state_checkedHovered"
            when: buttonControl.hovered && buttonControl.checked
                  && buttonControl.enabled && !buttonControl.down

            PropertyChanges {
                target: content
                state: "state_checkedHovered"
            }

            PropertyChanges {
                target: background
                state: "state_checkedHovered"
            }
        },
        State {
            name: "state_checkedPressed"
            when: buttonControl.checked && buttonControl.enabled
                  && buttonControl.down

            PropertyChanges {
                target: content
                state: "state_checkedPressed"
            }

            PropertyChanges {
                target: background
                state: "state_checkedPressed"
            }
        },
        State {
            name: "state_blocked"
            when: !buttonControl.enabled

            PropertyChanges {
                target: content
                state: "state_blocked"
            }

            PropertyChanges {
                target: background
                state: "state_blocked"
            }
        }
    ]
}
