import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: background
    width: 100
    height: 100
    color: "transparent"
    state: "state_idle"

    Rectangle {
        id: backgroundRect
        color: "#181614"
        radius: 3
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 1
        anchors.rightMargin: -1
    }

    Rectangle {
        id: effectsRect
        radius: 9
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 4
        anchors.rightMargin: 3
        anchors.topMargin: 2
        anchors.bottomMargin: 2
        gradient: Gradient {
            id: effectsRect_Gradient
            GradientStop {
                id: effectsRect_GradientStop_0
                position: 0
                color: "#ff858585"
            }

            GradientStop {
                id: effectsRect_GradientStop_1
                position: 1
                color: "#ff6c6c6c"
            }
            orientation: Gradient.Vertical
        }
        DesignEffect {
            id: effectsRect_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: effectsRect_DesignDropShadow_0
                    visible: true
                    color: "#6e000000"
                    spread: 0
                    offsetY: 11
                    offsetX: 8
                    blur: 18
                },
                DesignInnerShadow {
                    id: effectsRect_DesignInnerShadow_1
                    visible: true
                    color: "#7a000000"
                    spread: 0
                    offsetY: -2
                    offsetX: -2
                    blur: 3
                },
                DesignInnerShadow {
                    id: effectsRect_DesignInnerShadow_2
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 2
                    blur: 3
                }
            ]
        }
    }
    states: [
        State {
            name: "state_blocked"

            PropertyChanges {
                target: effectsRect_GradientStop_1
                color: "#ff6c6c6c"
            }

            PropertyChanges {
                target: effectsRect_GradientStop_0
                color: "#ff858585"
            }

            PropertyChanges {
                target: effectsRect
                anchors.leftMargin: 4
                anchors.rightMargin: 3
                anchors.topMargin: 2
                anchors.bottomMargin: 2
            }
        },
        State {
            name: "state_checkedPressed"

            PropertyChanges {
                target: effectsRect_GradientStop_1
                color: "#ff404040"
            }

            PropertyChanges {
                target: effectsRect_GradientStop_0
                color: "#ff5a5a5a"
            }

            PropertyChanges {
                target: effectsRect
                anchors.leftMargin: 6
                anchors.rightMargin: 4
                anchors.topMargin: 5
                anchors.bottomMargin: 6
            }
        },
        State {
            name: "state_pressed"

            PropertyChanges {
                target: effectsRect_GradientStop_1
                color: "#ff404040"
            }

            PropertyChanges {
                target: effectsRect_GradientStop_0
                color: "#ff5a5a5a"
            }

            PropertyChanges {
                target: effectsRect
                anchors.leftMargin: 6
                anchors.rightMargin: 4
                anchors.topMargin: 5
                anchors.bottomMargin: 6
            }
        },
        State {
            name: "state_checkedHovered"

            PropertyChanges {
                target: effectsRect_GradientStop_1
                color: "#ff404040"
            }

            PropertyChanges {
                target: effectsRect_GradientStop_0
                color: "#ff5a5a5a"
            }

            PropertyChanges {
                target: effectsRect
                anchors.leftMargin: 6
                anchors.rightMargin: 4
                anchors.topMargin: 5
                anchors.bottomMargin: 6
            }
        },
        State {
            name: "state_checked"

            PropertyChanges {
                target: effectsRect_GradientStop_1
                color: "#ff404040"
            }

            PropertyChanges {
                target: effectsRect_GradientStop_0
                color: "#ff5a5a5a"
            }

            PropertyChanges {
                target: effectsRect
                anchors.leftMargin: 6
                anchors.rightMargin: 4
                anchors.topMargin: 5
                anchors.bottomMargin: 6
            }
        },
        State {
            name: "state_hovered"

            PropertyChanges {
                target: effectsRect_GradientStop_1
                color: "#ff535252"
            }

            PropertyChanges {
                target: effectsRect_GradientStop_0
                color: "#ff7f7f7f"
            }

            PropertyChanges {
                target: effectsRect
                anchors.leftMargin: 4
                anchors.rightMargin: 3
                anchors.topMargin: 2
                anchors.bottomMargin: 2
            }
        },
        State {
            name: "state_idle"

            PropertyChanges {
                target: effectsRect_GradientStop_1
                color: "#ff6c6c6c"
            }

            PropertyChanges {
                target: effectsRect_GradientStop_0
                color: "#ff858585"
            }

            PropertyChanges {
                target: effectsRect
                anchors.leftMargin: 4
                anchors.rightMargin: 3
                anchors.topMargin: 2
                anchors.bottomMargin: 2
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;uuid:"e9fd9dcc-aaa2-5084-9699-a816f04df439"}D{i:1;uuid:"ed0bfe73-4154-51de-a4ba-df60bcf60b59"}
D{i:2;uuid:"5c397327-a83b-5d96-95da-6b23ac9aafad"}D{i:6;uuid:"5c397327-a83b-5d96-95da-6b23ac9aafad_DesignEffect"}
D{i:7;uuid:"5c397327-a83b-5d96-95da-6b23ac9aafad_DesignDropShadow_0"}D{i:8;uuid:"5c397327-a83b-5d96-95da-6b23ac9aafad_DesignInnerShadow_1"}
D{i:9;uuid:"5c397327-a83b-5d96-95da-6b23ac9aafad_DesignInnerShadow_2"}D{i:3;uuid:"5c397327-a83b-5d96-95da-6b23ac9aafad_Gradient"}
D{i:4;uuid:"5c397327-a83b-5d96-95da-6b23ac9aafad_GradientStop_0"}D{i:5;uuid:"5c397327-a83b-5d96-95da-6b23ac9aafad_GradientStop_1"}
}
##^##*/

