import QtQuick
import QtQuick.Controls
import QtQuick.Shapes
import QtQuick.Studio.Components
import QtQuick.Studio.DesignEffects
import DesignEffectsDemo
import QtQuick.Timeline 1.0

Item {
    id: root
    width: 1560
    height: 860

    Rectangle {
        id: fakeRoot
        color: "#e8e8e8"
        anchors.fill: parent
    }

    Item {
        id: glowDial
        width: 750
        height: 750
        anchors.verticalCenter: parent.verticalCenter
        anchors.horizontalCenter: parent.horizontalCenter

        EllipseItem {
            id: gaugeBack1
            x: 0
            y: 0
            width: 750
            height: 750
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            gradient: LinearGradient {
                y2: gaugeBack1.height * 1
                y1: gaugeBack1.height * 0
                x2: gaugeBack1.width * 1
                x1: gaugeBack1.width * 0

                GradientStop {
                    position: 1
                    color: "#ffffff"
                }

                GradientStop {
                    position: 0
                    color: "#dedede"
                }
            }
            strokeColor: "#00ff0000"

            DesignEffect {
                id: designEffect
                visible: true

                effects: [
                    DesignInnerShadow {
                        id: designInnerShadow
                        blur: 31.8
                        offsetX: 0
                        offsetY: 23
                        color: "#cda6a6a6"
                    },
                    DesignDropShadow {
                        color: "#2c000000"
                        blur: 21
                        offsetY: 0
                    },
                    DesignInnerShadow {
                        visible: true
                        color: "#ffffff"
                        blur: 10
                        offsetX: 4
                        offsetY: -3
                    }
                ]
            }
        }

        EllipseItem {
            id: center
            x: 175
            y: 175
            width: 400
            height: 400
            anchors.verticalCenter: parent.verticalCenter
            gradient: LinearGradient {
                y2: center.height * 1
                y1: center.height * 0
                x2: center.width * 1
                x1: center.width * 0
                GradientStop {
                    position: 0
                    color: "#ffffff"
                }

                GradientStop {
                    position: 1
                    color: "#dfdfdf"
                }
            }
            strokeColor: "#00ff0000"
            anchors.horizontalCenter: parent.horizontalCenter

            DesignEffect {
                id: designEffect1

                effects: [

                    DesignDropShadow {
                        blur: 103
                        offsetY: -28
                        offsetX: -70
                    },

                    DesignDropShadow {
                        id: designDropShadow
                        blur: 29.7
                        offsetX: 0
                        offsetY: 36
                        color: "#39000000"
                    },

                    DesignInnerShadow {
                        id: designInnerShadow1
                        visible: true
                        blur: 20
                        offsetX: 0
                        offsetY: 23
                        color: "#ffffff"
                    },
                    DesignInnerShadow {
                        id: designInnerShadow2
                        visible: true
                        blur: 32
                        offsetX: 0
                        offsetY: -4
                        color: "#5d000000"
                    },
                    DesignInnerShadow {
                        visible: true
                        color: "#ffffff"
                        blur: 10
                        offsetY: 10
                    }
                ]
            }
        }

        ArcItem {
            id: arcShadow
            x: 10
            y: 10
            width: 730
            height: 730
            opacity: 0.403
            visible: true
            anchors.verticalCenter: parent.verticalCenter
            end: arc.end + 20
            begin: -5
            gradient: RadialGradient {
                focalY: arcShadow.height * 0.5
                focalX: arcShadow.width * 0.5
                focalRadius: Math.min(arcShadow.width, arcShadow.height) * 0
                centerY: arcShadow.height * 0.5
                centerX: arcShadow.width * 0.5
                centerRadius: Math.min(arcShadow.width, arcShadow.height) * 0.5

                GradientStop {
                    position: 0
                    color: "#fff3195b"
                }

                GradientStop {
                    position: 0.85155
                    color: "#fff3195b"
                }

                GradientStop {
                    position: 1
                    color: "#79eb0a4e"
                }
            }
            strokeWidth: -1
            anchors.horizontalCenter: parent.horizontalCenter
            arcWidth: 165
            outlineArc: true
            strokeColor: "#00ff0000"
            DesignEffect {
                id: designEffect4
                visible: true
                layerBlurRadius: 81
                effects: [
                    DesignDropShadow {
                        visible: true
                        blur: 15
                        color: "#954141"
                        showBehind: true
                        offsetY: 9
                    }
                ]
            }
        }

        ArcItem {
            id: arc
            x: 10
            y: 10
            width: 730
            height: 730
            visible: true
            anchors.verticalCenter: parent.verticalCenter
            end: 330
            roundEnd: true
            gradient: RadialGradient {
                focalY: arc.height * 0.5
                focalX: arc.width * 0.5
                focalRadius: Math.min(arc.width, arc.height) * 0
                centerY: arc.height * 0.5
                centerX: arc.width * 0.5
                centerRadius: Math.min(arc.width, arc.height) * 0.5

                GradientStop {
                    position: 0.39972
                    color: "#6b0606"
                }

                GradientStop {
                    position: 0.77217
                    color: "#ffcd0d0d"
                }

                GradientStop {
                    position: 1
                    color: "#ec0d64"
                }
            }
            roundBegin: false
            strokeWidth: -1
            strokeColor: "#00ff0000"
            round: true
            outlineArc: true
            DesignEffect {
                id: designEffect3
                visible: true
                layerBlurRadius: 2
                effects: [
                    DesignDropShadow {
                        visible: true
                        offsetY: 0
                        blur: 7
                        offsetX: 0
                        color: "#000000"
                    },
                    DesignInnerShadow {
                        id: designInnerShadow4
                        offsetY: 8
                        offsetX: 0
                        blur: 19
                        color: "#8be9e9e9"
                    },
                    DesignInnerShadow {
                        id: designInnerShadow5
                        visible: false
                        offsetY: 14
                        offsetX: 18
                        blur: 49.7
                        color: "#ffffff"
                    }
                ]
            }
            arcWidth: 165
            anchors.horizontalCenter: parent.horizontalCenter
        }

        Text {
            id: value
            color: "#ededed"
            text: Math.round(arc.end)
            anchors.verticalCenter: parent.verticalCenter
            font.pixelSize: 128
            font.styleName: "Bold"
            font.family: "Victor Mono"
            anchors.horizontalCenter: parent.horizontalCenter

            DesignEffect {
                effects: [
                    DesignDropShadow {
                        color: "#ffffff"
                        blur: 2
                        offsetY: -4
                        offsetX: -4
                    },
                    DesignDropShadow {
                        color: "#5b000000"
                        blur: 2
                        offsetX: 4
                    }
                ]
            }
        }
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                pingPong: true
                running: root.visible
                loops: -1
                duration: 4000
                to: 1000
                from: 0
            }
        ]
        startFrame: 0
        endFrame: 1000
        enabled: true

        KeyframeGroup {
            target: arc
            property: "end"
            Keyframe {
                value: 10
                frame: 0
            }

            Keyframe {
                value: 330
                easing.bezierCurve: [0.556, 0.0138, 0.682, 0.0699, 1, 1]
                frame: 1000
            }
        }
    }
}
