/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the examples of the Qt Design Studio.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Controls
import QtQuick.Timeline
import MotorClusterData

Rectangle
{
    id: root
    width: Constants.width
    height: Constants.height

    opacity: 1
    color: "#ffffff"

    Image {
        id: background
        visible: true
        anchors.fill: parent
        source: "images/big/bg/main.png"
        anchors.rightMargin: 0
        anchors.bottomMargin: 0
        anchors.leftMargin: 0
        anchors.topMargin: 0
    }

    Logo {
        id: logo
        x: 540
        y: 260
        opacity: 0
    }

    RpmView {
        id: rpmView
        x: 64
        y: -30
        opacity: 0
        rpm: 17
        value: 1
    }

    Image {
        id: road
        x: 307
        y: 402
        opacity: 0
        source: "images/big/welcome/road.png"
    }

    ClipImage {
        id: rpmLineTop
        x: 87
        y: 63
        source: "images/big/welcome/tacho-top-line.png"
        clipScale: 0.0
        direction: 0
    }

    ClipImage {
        id: rpmLineBottom
        x: 86
        y: 195
        source: "images/big/welcome/tacho-bottom-line.png"
        clipScale: 0.0
        direction: 0
    }

    ClipImage {
        id: leftLines
        x: 164
        y: 377
        source: "images/big/welcome/left-lines.png"
        clipScale: 0.0
    }

    Tacho {
        id: tacho
        x: 491
        y: 183
        opacity: 0
        speedValue: 80
    }

    ClipImage {
        id: rightLines
        x: 716
        y: 384
        source: "images/big/welcome/right-lines.png"
        clipScale: 0.0
    }

    Blinker {
        id: rightBlinker
        opacity: 0
        isLeftBlinker: false
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.topMargin: 18
        anchors.rightMargin: 0
        sourceTop: "images/big/turn-right-top.png"
        sourceBottom: "images/big/turn-right-bottom.png"
    }

    Blinker {
        id: leftBlinker
        opacity: 0
        isLeftBlinker: true
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.topMargin: 18
        anchors.leftMargin: 0
        blinking: false
        sourceTop: "images/big/turn-left-top.png"
        sourceBottom: "images/big/turn-left-bottom.png"
    }

    FuelGauge {
        id: fuelGauge
        x: 188
        y: 245
        visibility: 0
        fuelLevel: 0
    }

    GearGauge {
        id: gearGauge
        anchors.verticalCenter: root.verticalCenter
        visibility: 0
        rpm: rpmView.rpm
        gear: 17
        anchors.verticalCenterOffset: 7
        anchors.horizontalCenter: root.horizontalCenter
        anchors.horizontalCenterOffset: 340
    }

    TellTales {
        id: telltales
        x: 491
        visibility: 1
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: parent.right
        z: 1
        anchors.verticalCenterOffset: 183
        anchors.rightMargin: 489
    }

    RangeIconWithText {
        id: rangeIconWithText
        x: 229
        y: 503
        width: 162
        height: 50
        opacity: 0
        value: 87
    }

    Dashboard {
        id: dashboard
        y: 614
        opacity: 0
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        separatorCenter: 34
        anchors.bottomMargin: 34
        anchors.leftMargin: 0
        anchors.rightMargin: 0
        separatorDistance: 433
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: 52000
                running: true
                loops: -1
                to: 1300
                from: 0
            }
        ]
        startFrame: 0
        endFrame: 1300
        enabled: true

        KeyframeGroup {
            target: logo
            property: "opacity"

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 27
                value: 0
            }

            Keyframe {
                frame: 49
                value: 1
            }

            Keyframe {
                frame: 95
                value: 1
            }

            Keyframe {
                frame: 125
                value: 0
            }
        }

        KeyframeGroup {
            target: leftBlinker
            property: "opacity"
            Keyframe {
                frame: 130
                value: 0
            }

            Keyframe {
                frame: 137
                value: 1
            }

            Keyframe {
                frame: 144
                value: 0
            }
        }

        KeyframeGroup {
            target: rightBlinker
            property: "opacity"
            Keyframe {
                frame: 130
                value: 0
            }

            Keyframe {
                frame: 137
                value: 1
            }

            Keyframe {
                frame: 144
                value: 0
            }
        }

        KeyframeGroup {
            target: telltales
            property: "visibility"
            Keyframe {
                value: 0
                frame: 144
            }

            Keyframe {
                value: 1
                frame: 175
            }

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                value: 0
                frame: 187
            }

            Keyframe {
                value: 0
                frame: 184
            }
        }

        KeyframeGroup {
            target: dashboard
            property: "opacity"
            Keyframe {
                frame: 151
                value: 0
            }

            Keyframe {
                frame: 174
                value: 1
            }
        }

        KeyframeGroup {
            target: rpmLineTop
            property: "clipScale"
            Keyframe {
                frame: 163
                value: 0
            }

            Keyframe {
                frame: 175
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: rpmLineBottom
            property: "clipScale"
            Keyframe {
                frame: 163
                value: 0
            }

            Keyframe {
                frame: 178
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: road
            property: "opacity"
            Keyframe {
                frame: 167
                value: 0
            }

            Keyframe {
                frame: 181
                value: 1
            }
        }

        KeyframeGroup {
            target: leftLines
            property: "clipScale"
            Keyframe {
                frame: 132
                value: 0
            }

            Keyframe {
                frame: 168
                value: 0
            }

            Keyframe {
                frame: 178
                value: 1
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: rightLines
            property: "clipScale"
            Keyframe {
                frame: 132
                value: 0
            }

            Keyframe {
                frame: 168
                value: 0
            }

            Keyframe {
                frame: 178
                value: 1
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: tacho
            property: "opacity"
            Keyframe {
                frame: 125
                value: 0
            }

            Keyframe {
                value: 0
                frame: 180
            }

            Keyframe {
                value: 1
                frame: 188
            }
        }

        KeyframeGroup {
            target: tacho
            property: "speedValue"

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 278
            }

            Keyframe {
                value: 19
                frame: 310
            }

            Keyframe {
                value: 22
                frame: 326
            }

            Keyframe {
                value: 31
                frame: 375
            }

            Keyframe {
                value: 37
                frame: 397
            }

            Keyframe {
                value: 58
                frame: 452
            }

            Keyframe {
                value: 61
                frame: 475
            }

            Keyframe {
                value: 79
                frame: 556
            }

            Keyframe {
                value: 82
                frame: 576
            }

            Keyframe {
                value: 117
                frame: 867
            }

            Keyframe {
                value: 115
                frame: 899
            }

            Keyframe {
                value: 0
                frame: 1159
            }
        }

        KeyframeGroup {
            target: rangeIconWithText
            property: "opacity"
            Keyframe {
                frame: 194
                value: 0
            }

            Keyframe {
                value: 1
                frame: 249
            }
        }

        KeyframeGroup {
            target: fuelGauge
            property: "visibility"
            Keyframe {
                value: 0
                frame: 196
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 235
            }
        }

        KeyframeGroup {
            target: fuelGauge
            property: "fuelLevel"
            Keyframe {
                frame: 435
                value: 0.2
            }

            Keyframe {
                frame: 197
                value: 1
            }

            Keyframe {
                value: 0
                frame: 196
            }

            Keyframe {
                value: 0.25
                frame: 249
            }
        }


        KeyframeGroup {
            target: gearGauge
            property: "visibility"
            Keyframe {
                value: 0
                frame: 197
            }

            Keyframe {
                value: 1
                frame: 235
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: gearGauge
            property: "gear"

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 234
            }

            Keyframe {
                value: 1
                frame: 268
            }

            Keyframe {
                value: 2
                frame: 316
            }

            Keyframe {
                value: 3
                frame: 386
            }

            Keyframe {
                value: 4
                frame: 461
            }

            Keyframe {
                value: 5
                frame: 565
            }

            Keyframe {
                value: 6
                frame: 698
            }

            Keyframe {
                value: 6
                frame: 863
            }

            Keyframe {
                value: 0
                frame: 871
            }
        }

        KeyframeGroup {
            target: rpmView
            property: "opacity"
            Keyframe {
                value: 1
                frame: 165
            }

            Keyframe {
                value: 0
                frame: 158
            }

            Keyframe {
                value: 0
                frame: 0
            }
        }

        KeyframeGroup {
            target: rpmView
            property: "rpm"

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 238
            }

            Keyframe {
                value: 13
                frame: 245
            }

            Keyframe {
                value: 15
                frame: 249
            }

            Keyframe {
                value: 0
                frame: 275
            }

            Keyframe {
                value: 14
                frame: 302
            }

            Keyframe {
                value: 3
                frame: 325
            }

            Keyframe {
                value: 3
                frame: 328
            }

            Keyframe {
                value: 15
                frame: 371
            }

            Keyframe {
                value: 2
                frame: 395
            }

            Keyframe {
                value: 2
                frame: 397
            }

            Keyframe {
                value: 16
                frame: 447
            }

            Keyframe {
                value: 3
                frame: 473
            }

            Keyframe {
                value: 3
                frame: 479
            }

            Keyframe {
                value: 14
                frame: 551
            }

            Keyframe {
                value: 3
                frame: 577
            }

            Keyframe {
                value: 3
                frame: 589
            }

            Keyframe {
                value: 16
                frame: 682
            }

            Keyframe {
                value: 3
                frame: 708
            }

            Keyframe {
                value: 3
                frame: 723
            }

            Keyframe {
                value: 10
                frame: 869
            }

            Keyframe {
                value: 0
                frame: 900
            }
        }

        KeyframeGroup {
            target: rangeIconWithText
            property: "value"
            Keyframe {
                value: 90
                frame: 0
            }

            Keyframe {
                value: 90
                frame: 208
            }

            Keyframe {
                value: 87
                frame: 817
            }
        }

    }
}

