/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick

Rectangle {
    id: chargingmenuside
    width: 1920
    height: 720
    color: "#00ffffff"
    property alias chargingstationText: chargingstation.text
    property alias connectthecartothechargingstationPositionontherightText: connectthecartothechargingstationPositionontheright.text
    clip: true

    Text {
        id: chargingstation
        x: 493
        y: 175
        width: 414
        height: 68
        text: "Charging station"
        font.pixelSize: 50
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        font.family: "Open Sans"
        font.weight: Font.Bold
    }

    Text {
        id: connectthecartothechargingstationPositionontheright
        x: 493
        y: 252
        width: 369
        height: 54
        color: "#ffffff"
        text: "Connect the car to the charging station.\nPosition on the right."
        font.pixelSize: 20
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        font.family: "Open Sans"
        font.weight: Font.Normal
    }

    Text {
        id: chargingstation1
        x: 493
        y: 175
        width: 414
        height: 68
        color: "#ffffff"
        text: "Charging station"
        font.pixelSize: 50
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        font.bold: true
        font.weight: Font.Bold
        font.family: "Open Sans"
    }

    Text {
        id: connectthecartothechargingstationPositionontheright1
        x: 493
        y: 252
        width: 369
        height: 54
        text: "Connect the car to the charging station.\nPosition on the right."
        font.pixelSize: 20
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        font.weight: Font.Normal
        font.family: "Open Sans"
    }
    states: [
        State {
            name: "day"
            when: !globalNightMode

            PropertyChanges {
                target: chargingstation
                opacity: 1
            }

            PropertyChanges {
                target: chargingstation1
                opacity: 0
            }

            PropertyChanges {
                target: connectthecartothechargingstationPositionontheright
                opacity: 0
            }
        },
        State {
            name: "night"
            when: globalNightMode

            PropertyChanges {
                target: chargingstation1
                opacity: 1
            }

            PropertyChanges {
                target: chargingstation
                opacity: 0
            }

            PropertyChanges {
                target: connectthecartothechargingstationPositionontheright1
                opacity: 0
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;formeditorZoom:1.33;height:720;width:1920}D{i:1;uuid:"8353002e-c45e-5295-8f71-e827ba897c1e"}
D{i:2;uuid:"27ad9727-9bac-5c5a-9aa6-04937651140a"}D{i:3;uuid:"8353002e-c45e-5295-8f71-e827ba897c1e"}
D{i:4;uuid:"27ad9727-9bac-5c5a-9aa6-04937651140a"}
}
##^##*/

