

/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Helpers
import Outrun_Cluster 1.0
import QtQuick.Timeline 1.0
import QtQuick.Studio.Effects 1.0
import QtQuick3D.Effects 6.2
import Generated.QtQuick3D.Hyperdrive 1.0
import Generated.QtQuick3D.Warp 1.0
import Generated.QtQuick3D.Lanes 1.0
import Generated.QtQuick3D.Cluster 1.0
import QtQuick3D.Particles3D 6.2
import Generated.QtQuick3D.Gaugelines 1.0
import Generated.QtQuick3D.AdasPlane 1.0
import Generated.QtQuick3D.Car_Optimized_2 1.0
import Generated.QtQuick3D.Desert_Enviroment 1.0
import Generated.QtQuick3D.Car 1.0
import Generated.QtQuick3D.Demo_City_Buildings 1.0
import Generated.QtQuick3D.Demo_City_Ground 1.0
import Generated.QtQuick3D.AdasPlane2 1.0

Item {
    id: outsidemask

    property bool show: true
    property real showAnimated: show
    property alias selfdrivingText: selfdriving.text
    property alias currentgearText: drivemodeText.text
    property alias km1Text: km1.text
    property alias odometer: odometerText.text
    property alias battery: batteryText.text
    property alias kmhText: kmh.text
    property alias odoText: odo.text
    property alias speed: speedText.text
    property alias kmText: km.text
    property alias maxdistance: maxdistanceTextt.text
    property alias gear: gearText.text
    property alias elementText: element.text
    property alias albumSongText: song.text
    property alias albumArtistText: artist.text
    property alias albumArtSource: albumArt.source
    property bool albumPlaying: true
    property real cruiseSpeed: 90
    property bool turnL: false
    property bool turnR: false
    property bool lask: false
    property bool accVisible: true
    property bool autonomousVisible: true
    property real lkasValue: 0

    //    Behavior on showAnimated {
    //        NumberAnimation {
    //            duration: 800
    //            easing.type: Easing.InOutQuad
    //        }
    //    }
    anchors.fill: parent
    scale: 1.6 - 0.6 * showAnimated

    Image {
        id: mask1
        anchors.fill: parent
        x: 0
        y: 0
        source: "../images/assets/Mask1.png"

        Image {
            id: wheel
            x: 18
            y: 581
            width: 48
            height: 48
            visible: mainScreen.state != "chargeUp" && mainScreen.state
                     != "chargeSide" && mainScreen.state != "chargeBehind" && mainScreen.state
                     != "sport" && mainScreen.state != "drive" && mainScreen.state
                     != "Intro" && mainScreen.state != "lanechange"

            source: "../images/wheel.jpg"
            fillMode: Image.PreserveAspectFit
        }

        Image {
            id: cruise
            x: 191
            y: 651
            width: 50
            height: 50
            visible: accVisible
            source: "../images/cruise.jpg"
            sourceSize.height: 50
            sourceSize.width: 50
            fillMode: Image.PreserveAspectFit
        }
        Rectangle {
            x: 108
            y: 621
            width: 50
            height: 41
            color: "#00ffffff"
            Image {
                id: assist
                x: 0
                y: 0
                width: 50
                height: 41
                visible: lask && !mainScreen.globalCardetected ? true : false
                source: "../images/ADAS_72_offLane.png"
                fillMode: Image.PreserveAspectFit
            }
            MySafety {
                id: safety
                visible: lask && mainScreen.globalCardetected ? true : false
                opacity: lask && mainScreen.globalCardetected ? 1.0 : 0.0
                nightmode: true
                height: 119
                width: 147
                x: -49
                y: -40
                stateValue: lkasValue
                scale: 0.355
            }
        }
    }

    Item {
        id: odometer
        x: 1531
        y: 668
        width: 163
        height: 27
        Text {
            id: odo
            x: 17
            y: 0
            width: 41
            height: 27
            color: "#ffffff"
            text: "Odo"
            font.pixelSize: 20
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.family: "Open Sans"
            font.weight: Font.Normal
        }

        Item {
            id: content
            x: 56
            y: 0
            width: 107
            height: 27
            Text {
                id: odometerText
                x: 5
                y: 0
                width: 70
                height: 27
                color: "#ffffff"
                text: "127250"
                font.pixelSize: 20
                horizontalAlignment: Text.AlignRight
                verticalAlignment: Text.AlignTop
                font.family: "Open Sans"
                font.weight: Font.Bold
            }

            Text {
                id: km
                x: 77
                y: 0
                width: 31
                height: 27
                color: "#9a989c"
                text: "km"
                font.pixelSize: 20
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignTop
                font.family: "Open Sans"
                font.weight: Font.Normal
            }
        }
    }

    Item {
        id: cruisecontrol
        x: 204
        y: 654
        width: 148
        height: 48
        Text {
            id: speedText
            x: 56
            y: 4
            width: 36
            height: 41
            visible: accVisible
            color: "#ffffff"
            text: " "
            font.pixelSize: 30
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            fontSizeMode: Text.HorizontalFit
            font.family: "Open Sans"
            font.weight: Font.Bold
        }

        Text {
            id: kmh
            x: 99
            y: 15
            width: 50
            height: 27
            visible: accVisible
            color: "#9a989c"
            text: "km/h"
            font.pixelSize: 20
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.family: "Open Sans"
            font.weight: Font.Normal
        }
    }

    Item {
        id: telltales
        visible: true
        Item {
            id: highbeam
            width: 48
            height: 48
            visible: false
            Item {
                id: vector10
                x: 21
                y: 11
                width: 25
                height: 26
                Image {
                    id: vector19
                    source: "../images/assets/Vector1_9.png"
                }
            }

            Item {
                id: vector20
                x: 30
                y: 13
                width: 15
                height: 21
                Image {
                    id: vector110
                    source: "../images/assets/Vector1_10.png"
                }
            }

            Item {
                id: group
                width: 47
                height: 37
                Item {
                    id: vector21
                    x: 4
                    y: 23
                    width: 13
                    height: 2
                    Image {
                        id: vector111
                        source: "../images/assets/Vector1_11.png"
                    }
                }

                Item {
                    id: vector22
                    x: 4
                    y: 28
                    width: 14
                    height: 3
                    Image {
                        id: vector112
                        source: "../images/assets/Vector1_12.png"
                    }
                }

                Item {
                    id: vector23
                    width: 22
                    height: 22
                    Image {
                        id: vector113
                        source: "../images/assets/Vector1_13.png"
                    }
                }

                Item {
                    id: vector24
                    x: 4
                    y: 17
                    width: 14
                    height: 3
                    Image {
                        id: vector114
                        source: "../images/assets/Vector1_14.png"
                    }
                }

                Item {
                    id: vector25
                    x: 21
                    y: 11
                    width: 26
                    height: 26
                    Image {
                        id: vector115
                        source: "../images/assets/Vector1_15.png"
                    }
                }

                Item {
                    id: vector26
                    x: 4
                    y: 34
                    width: 16
                    height: 3
                    Image {
                        id: vector116
                        source: "../images/assets/Vector1_16.png"
                    }
                }

                Item {
                    id: vector27
                    x: 4
                    y: 11
                    width: 16
                    height: 3
                    Image {
                        id: vector117
                        source: "../images/assets/Vector1_17.png"
                    }
                }
            }
        }

        Item {
            id: lowbeam
            x: 76
            y: 0
            width: 48
            height: 48
            visible: false
            Item {
                id: vector28
                x: 21
                y: 11
                width: 25
                height: 26
                Image {
                    id: vector118
                    source: "../images/assets/Vector1_18.png"
                }
            }

            Item {
                id: vector29
                x: 30
                y: 13
                width: 15
                height: 21
                Image {
                    id: vector119
                    source: "../images/assets/Vector1_19.png"
                }
            }

            Item {
                id: vector30
                x: 4
                y: 11
                width: 16
                height: 4
                Image {
                    id: vector120
                    source: "../images/assets/Vector1_20.png"
                }
            }

            Item {
                id: vector31
                x: 4
                y: 11
                width: 16
                height: 30
                Image {
                    id: vector121
                    source: "../images/assets/Vector1_21.png"
                }
            }

            Item {
                id: group1
                x: 21
                y: 11
                width: 26
                height: 26
                Item {
                    id: vector32
                    width: 26
                    height: 26
                    Image {
                        id: vector122
                        source: "../images/assets/Vector1_22.png"
                    }
                }
            }
        }

        Item {
            id: turnLeft
            visible: turnL
            x: 152
            y: 0
            width: 48
            height: 48
            opacity: 0
            Item {
                id: vector33
                x: 7
                y: 4
                width: 35
                height: 40
                Image {
                    id: vector123
                    x: 0
                    y: 0
                    source: "../images/assets/Vector1_23.png"
                }
            }
            SequentialAnimation {
                id: sequentialAnimation
                running: turnL
                loops: Animation.Infinite
                NumberAnimation {
                    target: turnLeft
                    property: "opacity"
                    to: 1
                    duration: 400
                }
                NumberAnimation {
                    target: turnLeft
                    property: "opacity"
                    to: 0
                    duration: 400
                }
            }
        }

        Item {
            id: turnRight
            visible: turnR
            x: 1680
            y: 0
            width: 48
            height: 48
            opacity: 0
            Item {
                id: vector65
                x: 7
                y: -36
                width: 35
                height: 40
                Image {
                    id: vector155
                    x: 0
                    y: -42
                    source: "../images/assets/Vector1_55.png"
                }
                rotation: 180
            }
            SequentialAnimation {
                running: turnR
                loops: Animation.Infinite
                NumberAnimation {
                    target: turnRight
                    property: "opacity"
                    to: 1
                    duration: 400
                }
                NumberAnimation {
                    target: turnRight
                    property: "opacity"
                    to: 0
                    duration: 400
                }
            }
        }

        Item {
            id: seatbelt
            x: 1832
            y: 0
            width: 48
            height: 48
            visible: false
            Item {
                id: vector34
                x: 6
                y: 2
                width: 37
                height: 43
                Image {
                    id: vector124
                    source: "../images/assets/Vector1_24.png"
                }
            }
        }

        Item {
            id: positionlightssidelights
            x: 0
            y: 76
            width: 48
            height: 48
            visible: false
            Item {
                id: vector35
                x: 4
                y: 13
                width: 8
                height: 4
                Image {
                    id: vector125
                    source: "../images/assets/Vector1_25.png"
                }
            }

            Item {
                id: vector36
                x: 4
                y: 31
                width: 8
                height: 4
                Image {
                    id: vector126
                    source: "../images/assets/Vector1_26.png"
                }
            }

            Item {
                id: vector37
                x: 36
                y: 31
                width: 8
                height: 4
                Image {
                    id: vector127
                    source: "../images/assets/Vector1_27.png"
                }
            }

            Item {
                id: vector38
                x: 36
                y: 13
                width: 8
                height: 4
                Image {
                    id: vector128
                    source: "../images/assets/Vector1_28.png"
                }
            }

            Item {
                id: vector39
                x: 3
                y: 23
                width: 8
                height: 2
                Image {
                    id: vector129
                    source: "../images/assets/Vector1_29.png"
                }
            }

            Item {
                id: vector40
                x: 37
                y: 23
                width: 8
                height: 2
                Image {
                    id: vector130
                    source: "../images/assets/Vector1_30.png"
                }
            }

            Item {
                id: vector41
                x: 13
                y: 16
                width: 9
                height: 16
                Image {
                    id: vector131
                    source: "../images/assets/Vector1_31.png"
                }
            }

            Item {
                id: vector42
                x: 27
                y: 16
                width: 9
                height: 16
                Image {
                    id: vector132
                    source: "../images/assets/Vector1_32.png"
                }
            }
        }

        Item {
            id: frontfoglight
            x: 0
            y: 152
            width: 48
            height: 48
            visible: false
            Item {
                id: vector43
                x: 5
                y: 4
                width: 16
                height: 39
                Image {
                    id: vector133
                    source: "../images/assets/Vector1_33.png"
                }
            }

            Item {
                id: vector44
                x: 24
                y: 5
                width: 19
                height: 38
                Image {
                    id: vector134
                    source: "../images/assets/Vector1_34.png"
                }
            }
        }

        Item {
            id: rearfoglight
            x: 68
            y: 152
            width: 48
            height: 48
            visible: false
            Item {
                id: group2
                x: 5
                y: 4
                width: 38
                height: 39
                Item {
                    id: vector45
                    x: 0
                    y: 1
                    width: 19
                    height: 38
                    Image {
                        id: vector135
                        source: "../images/assets/Vector1_35.png"
                    }
                }

                Item {
                    id: vector46
                    x: 22
                    y: 0
                    width: 16
                    height: 39
                    Image {
                        id: vector136
                        source: "../images/assets/Vector1_36.png"
                    }
                }
            }
        }

        Item {
            id: antilockbrakesystem
            x: 0
            y: 228
            width: 48
            height: 48
            visible: false
            Item {
                id: group3
                x: 6
                y: 10
                width: 37
                height: 28
                Item {
                    id: vector47
                    x: 16
                    y: 9
                    width: 5
                    height: 10
                    Image {
                        id: vector137
                        source: "../images/assets/Vector1_37.png"
                    }
                }

                Item {
                    id: vector48
                    x: 22
                    y: 9
                    width: 6
                    height: 10
                    Image {
                        id: vector138
                        source: "../images/assets/Vector1_38.png"
                    }
                }

                Item {
                    id: vector49
                    x: 30
                    y: 1
                    width: 7
                    height: 26
                    Image {
                        id: vector139
                        source: "../images/assets/Vector1_39.png"
                    }
                }

                Item {
                    id: vector50
                    x: 4
                    y: 0
                    width: 28
                    height: 28
                    Image {
                        id: vector140
                        source: "../images/assets/Vector1_40.png"
                    }
                }

                Item {
                    id: vector51
                    x: 0
                    y: 1
                    width: 7
                    height: 26
                    Image {
                        id: vector141
                        source: "../images/assets/Vector1_41.png"
                    }
                }
            }

            Item {
                id: vector52
                x: 15
                y: 19
                width: 6
                height: 10
                Image {
                    id: vector142
                    x: 0
                    y: 0
                    source: "../images/assets/Vector1_42.png"
                }
            }
        }

        Item {
            id: tyrefailuremalfunction
            x: 1832
            y: 228
            width: 48
            height: 48
            visible: false
            Item {
                id: vector53
                x: 4
                y: 4
                width: 41
                height: 39
                Image {
                    id: vector143
                    source: "../images/assets/Vector1_43.png"
                }
            }

            Item {
                id: vector54
                x: 22
                y: 7
                width: 5
                height: 28
                Image {
                    id: vector144
                    source: "../images/assets/Vector1_44.png"
                }
            }
        }

        Item {
            id: airbag
            x: 1756
            y: 0
            width: 48
            height: 48
            visible: false
            Item {
                id: vector55
                x: 5
                y: 4
                width: 39
                height: 36
                Image {
                    id: vector145
                    source: "../images/assets/Vector1_45.png"
                }
            }
        }

        Item {
            id: doorsajar
            x: 1832
            y: 152
            width: 48
            height: 48
            visible: false
            Item {
                id: vector56
                x: 4
                y: 1
                width: 32
                height: 46
                Image {
                    id: vector146
                    source: "../images/assets/Vector1_46.png"
                }
            }
        }

        Item {
            id: roadvehiclestabilitycontrolsystem
            x: 1764
            y: 152
            width: 48
            height: 48
            visible: false
            Item {
                id: vector57
                x: 6
                y: 3
                width: 35
                height: 39
                Image {
                    id: vector147
                    source: "../images/assets/Vector1_47.png"
                }
            }
        }

        Item {
            id: parkingbrake
            x: 92
            y: 76
            width: 48
            height: 48
            visible: false
            Item {
                id: vector58
                x: 4
                y: 10
                width: 8
                height: 28
                Image {
                    id: vector148
                    source: "../images/assets/Vector1_48.png"
                }
            }

            Item {
                id: vector59
                x: 36
                y: 10
                width: 8
                height: 28
                Image {
                    id: vector149
                    source: "../images/assets/Vector1_49.png"
                }
            }

            Item {
                id: vector60
                x: 19
                y: 15
                width: 12
                height: 18
                Image {
                    id: vector150
                    source: "../images/assets/Vector1_50.png"
                }
            }

            Item {
                id: vector61
                x: 8
                y: 8
                width: 32
                height: 32
                Image {
                    id: vector151
                    source: "../images/assets/Vector1_51.png"
                }
            }
        }

        Item {
            id: heightcontroldisabled
            x: 1740
            y: 76
            width: 48
            height: 48
            visible: false
            Item {
                id: vector62
                x: 19
                y: 14
                width: 11
                height: 9
                Image {
                    id: vector152
                    source: "../images/assets/Vector1_52.png"
                }
            }

            Item {
                id: vector63
                x: 19
                y: 28
                width: 11
                height: 9
                Image {
                    id: vector153
                    source: "../images/assets/Vector1_53.png"
                }
            }

            Item {
                id: vector64
                x: 2
                y: 10
                width: 43
                height: 20
                Image {
                    id: vector154
                    source: "../images/assets/Vector1_54.png"
                }
            }
        }

        Item {
            id: heightcontrolfault
            x: 1740
            y: 76
            width: 48
            height: 48
            visible: false
            Item {
                id: vector66
                x: 19
                y: 14
                width: 11
                height: 9
                Image {
                    id: vector156
                    source: "../images/assets/Vector1_56.png"
                }
            }

            Item {
                id: vector67
                x: 19
                y: 28
                width: 11
                height: 9
                Image {
                    id: vector157
                    source: "../images/assets/Vector1_57.png"
                }
            }

            Item {
                id: vector68
                x: 2
                y: 10
                width: 43
                height: 20
                Image {
                    id: vector158
                    source: "../images/assets/Vector1_58.png"
                }
            }
        }

        Item {
            id: brakefailure
            x: 1832
            y: 76
            width: 48
            height: 48
            visible: false
            Item {
                id: vector69
                x: 10
                y: 10
                width: 28
                height: 28
                Image {
                    id: vector159
                    source: "../images/assets/Vector1_59.png"
                }
            }

            Item {
                id: vector70
                x: 6
                y: 11
                width: 7
                height: 26
                Image {
                    id: vector160
                    source: "../images/assets/Vector1_60.png"
                }
            }

            Item {
                id: vector71
                x: 35
                y: 11
                width: 7
                height: 26
                Image {
                    id: vector161
                    source: "../images/assets/Vector1_61.png"
                }
            }

            Item {
                id: vector72
                Image {
                    id: vector162
                    source: "../images/assets/Vector1_62.png"
                }
            }

            Item {
                id: vector73
                x: 23
                y: 14
                width: 3
                height: 20
                Image {
                    id: vector163
                    source: "../images/assets/Vector1_63.png"
                }
            }
        }
    }

    Item {
        id: mediaplaying
        x: 509
        y: 624
        width: 224
        height: 148
        Item {
            id: albumcover
            width: 72
            height: 148
            Item {
                id: image8
                width: 72
                height: 72
                Image {
                    id: albumArt
                    anchors.fill: parent
                    source: "../images/assets/image81.png"
                }
            }

            Item {
                id: image9
                x: 0
                y: 148
                width: 72
                height: 72
                Image {
                    id: image91
                    x: -4
                    y: -4
                    source: "../images/assets/image91.png"
                }
            }
        }

        Item {
            id: musicinfo
            x: 88
            y: 7
            width: 208
            height: 58
            Item {
                id: play_48
                x: 0
                y: 8
                width: 48
                height: 48
                Item {
                    id: vector74
                    width: 48
                    height: 48
                    Image {
                        id: vector164
                        source: "../images/assets/Vector1_64.png"
                    }
                }

                Item {
                    id: vector75
                    x: 16
                    y: 10
                    width: 22
                    height: 28
                    Image {
                        id: playstate
                        source: albumPlaying ? "../images/assets/Vector1_65.png" : "../images/assets/Vector1_73.png"
                    }
                }
            }

            Text {
                id: song
                x: 64
                y: 0
                width: 200
                height: 27
                color: "#ffffff"
                text: "Midnight Fires"
                elide: Text.ElideRight
                font.pixelSize: 20
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignTop
                font.family: "Open Sans"
                font.weight: Font.Bold
            }

            Text {
                id: artist
                x: 64
                y: 31
                width: 200
                height: 27
                color: "#9a989c"
                text: "Wolfclub"
                elide: Text.ElideRight
                font.pixelSize: 20
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignTop
                font.family: "Open Sans"
                font.weight: Font.Normal
            }
        }
    }

    Text {
        id: selfdriving
        x: 887
        y: 643
        width: 147
        height: 35
        color: "#ffffff"
        text: "Self driving"
        font.pixelSize: 26
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignTop
        font.family: "Open Sans"
        font.weight: Font.Bold
    }

    Text {
        id: gearText
        x: 1187
        y: 616
        width: 49
        height: 93
        color: "#ffffff"
        text: "D"
        font.pixelSize: 70
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        font.family: "Exo 2"
        font.weight: Font.Bold
    }

    Text {
        id: drivemodeText
        x: 1263
        y: 643
        width: 137
        height: 40
        color: "#ffffff"
        text: "NORMAL"
        font.pixelSize: 30
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        font.family: "Exo 2"
        font.weight: Font.Bold
    }

    Item {
        id: frame1
        x: 1726
        y: 624
        width: 140
        height: 72
        Item {
            id: range
            x: 68
            y: 44
            width: 73
            height: 28
            Text {
                id: maxdistanceTextt
                x: -17
                y: 0
                width: 58
                height: 28
                color: "#ffffff"
                text: "248"
                font.pixelSize: 20
                horizontalAlignment: Text.AlignRight
                verticalAlignment: Text.AlignTop
                font.family: "Open Sans"
                font.weight: Font.Normal
            }

            Text {
                id: km1
                x: 43
                y: 0
                width: 31
                height: 28
                color: "#9a989c"
                text: "km"
                font.pixelSize: 20
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignTop
                font.family: "Open Sans"
                font.weight: Font.Normal
            }
        }

        Item {
            id: batteryleft
            x: 68
            y: 0
            width: 61
            height: 40
            Text {
                id: batteryText
                color: "#ffffff"
                text: "78"
                anchors.fill: parent
                font.pixelSize: 30
                horizontalAlignment: Text.AlignRight
                verticalAlignment: Text.AlignTop
                anchors.rightMargin: 8
                fontSizeMode: Text.HorizontalFit
                font.family: "Open Sans"
                font.weight: Font.Bold
            }

            Text {
                id: element
                x: 56
                y: 8
                width: 19
                height: 19
                color: "#ffffff"
                text: "%"
                font.pixelSize: 20
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignTop
                font.family: "Open Sans"
                font.weight: Font.Normal
            }
        }

        Item {
            id: evStation_48
            x: 0
            y: 12
            width: 48
            height: 48
            Item {
                id: vector76
                x: 0
                y: 6
                width: 33
                height: 36
                Image {
                    id: vector166
                    source: "../images/assets/Vector1_66.png"
                }
            }

            Item {
                id: vector77
                width: 48
                height: 48
                Image {
                    id: vector167
                    source: "../images/assets/Vector1_67.png"
                }
            }

            Item {
                id: vector78
                x: 42
                y: 18
                width: 6
                height: 12
                Image {
                    id: vector168
                    source: "../images/assets/Vector1_68.png"
                }
            }
        }
    }

    Item {
        id: arrowup_28
        x: 946
        y: 611
        width: 28
        height: 28
        Item {
            id: vector79
            width: 28
            height: 28
            Image {
                id: vector169
                visible: false
                source: "../images/assets/Vector1_69.png"
            }
        }

        Item {
            id: vector80
            x: 9
            y: 3
            width: 10
            height: 22
            Image {
                id: vector170
                source: "../images/assets/Vector1_70.png"
            }
            rotation: -90
        }
    }

    Item {
        id: arrowdown_28
        x: 946
        y: 682
        width: 28
        height: 28
        Item {
            id: vector81
            width: 28
            height: 28
            Image {
                id: vector171
                visible: false
                source: "../images/assets/Vector1_71.png"
            }
        }

        Item {
            id: vector82
            x: 9
            y: 3
            width: 10
            height: 22
            Image {
                id: vector172
                source: "../images/assets/Vector1_72.png"
            }
            rotation: 90
        }
    }
}

/*##^##
Designer {
    D{i:0;formeditorZoom:1.66;height:720;width:1920}
}
##^##*/

