import QtQuick
import QtQuick.Controls
import Generated.DesignSystem

Rectangle {
    id: settingsPanel
    width: 188
    height: 93
    color: "transparent"
    property alias rightArrowButton: rightArrowButton
    property alias panelTitleText: panelTitle.text
    property alias panelUnitText: panelUnit.text
    property alias panelValueText: panelValue.text
    property alias panelIcon: panelIcon
    property alias leftArrowButton: leftArrowButton

    Image {
        id: panelIcon
        x: 32
        y: 70
        source: "assets/panelIcon.png"
    }

    Text {
        id: panelValue
        x: 46
        y: 0
        width: 95
        height: 64
        color: Colors.currentTheme.primary
        text: qsTr("000")
        font.pixelSize: 48
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.NoWrap
        font.weight: Font.DemiBold
        font.family: "Exo"
    }

    Text {
        id: panelTitle
        x: 61
        y: 66
        width: 73
        height: 27
        color: Colors.currentTheme.primary
        text: qsTr("INCLINE")
        font.pixelSize: 20
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.NoWrap
        font.weight: Font.Medium
        font.family: "Exo"
    }

    Text {
        id: panelUnit
        y: 70
        width: 25
        height: 19
        color: Colors.currentTheme.primary
        text: qsTr("(%)")
        anchors.left: panelTitle.right
        anchors.leftMargin: 0
        font.pixelSize: 14
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.NoWrap
        font.weight: Font.Medium
        font.family: "Exo"
    }

    ArrowButton {
        id: leftArrowButton
        x: 0
        y: 20
        width: 32
        height: 28
    }

    ArrowButton {
        id: rightArrowButton
        x: 156
        y: 20
        width: 32
        height: 28
        arrowIcon.rotation: 180
    }
}

/*##^##
Designer {
    D{i:0;uuid:"dbbaf49a-10b2-5f0f-8881-44db56039fa2"}D{i:1;uuid:"59c7b6fd-2aa6-57d6-bdbd-7ea21e44c4b8"}
D{i:2;uuid:"fe391a26-42ce-5deb-b6bb-c22b60e6b76e"}D{i:3;uuid:"585c7ac4-dcf8-597f-bb07-3e6e83723f7f"}
D{i:4;uuid:"cf9b1ce6-bb74-5436-8975-e3ce14812e6e"}D{i:5;uuid:"b233ee29-a30d-5182-9bcf-d2b41cc83fa6"}
D{i:6;uuid:"fb7ce043-0f8d-5984-96fe-ef2842d39423"}
}
##^##*/

