/* @(#)filesize.c	1.13 04/08/08 Copyright 1986, 1995-2003 J. Schilling */
/*
 *	Copyright (c) 1986, 1995-2003 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#include "schilyio.h"
#include <statdefs.h>

EXPORT off_t
filesize(f)
	register FILE	*f;
{
	struct stat buf;

	down(f);
	if (fstat(fileno(f), &buf) < 0) {
		raisecond("filesize", 0L);
		return (-1);
	}
	return (buf.st_size);
}
