/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.loader;

import com.sun.jna.Pointer;
import esecurity.crypto.gui.pdf.bean.PdfAnnotation;
import esecurity.crypto.gui.pdf.loader.PdfLoaderServer$PdfLoaderServer;
import esecurity.crypto.gui.pdf.loader.PdfLoaderServer$PdfPagesLoader;
import esecurity.crypto.gui.pdf.loader.gtgzcsbm;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfPagesLoader {
    private static final EllipsLogger logger = PdfPagesLoader.UI("-53tgp", Constants.CAPI_LOGGER_NAME);
    private static final Object CLOSE_LOCK = new Object();
    private static ExecutorService EXECUTOR_SERVICE;
    private static Future<PdfPagesLoader> pdfParserLoader;
    private static PDFRenderer pdfRenderer;
    static Pointer pdfDocument;
    private static PDDocument pdd;
    private static int pages;
    private static Dimension[] pagesDimensions;
    private static boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncInitialize(File pdfFile) {
        closed = false;
        EXECUTOR_SERVICE = PdfPagesLoader.UI("1gvc2fv");
        Object object = CLOSE_LOCK;
        synchronized (object) {
            pdfParserLoader = EXECUTOR_SERVICE.submit(() -> {
                try {
                    return new PdfPagesLoader(pdfFile);
                }
                catch (IOException ex) {
                    PdfPagesLoader.UI("1qh82er", logger, PdfPagesLoader.UI("n2m2fq", ex), (Object)ex);
                    return null;
                }
            });
        }
    }

    private PdfPagesLoader(File pdfFile) throws IOException {
        Object convertedTmp = pdfFile;
        if (PdfPagesLoader.UI("dr42fs", pdfFile) != false) {
            convertedTmp = PdfPagesLoader.UI("-nhhtg3", pdfFile);
        }
        ScratchFile SCRATCH_FILE_TEMP = new ScratchFile((MemoryUsageSetting)PdfPagesLoader.UI("14ve2fi", 10000000L));
        Object pdfFileBuffer = PdfPagesLoader.UI("1il02fj", SCRATCH_FILE_TEMP, new FileInputStream((File)convertedTmp));
        PDFParser parser = new PDFParser((RandomAccessRead)pdfFileBuffer, SCRATCH_FILE_TEMP);
        PdfPagesLoader.UI("-t7jtg0", parser);
        pdd = PdfPagesLoader.UI("-su1tfv", parser);
        pdfRenderer = new PDFRenderer(pdd);
        pages = (int)PdfPagesLoader.UI("v3g2g6", pdd);
        pagesDimensions = new Dimension[pages];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BufferedImage loadPage(int page, float zoom) throws IOException {
        if (closed) {
            return null;
        }
        PdfPagesLoader.getLoaderOrThrowException();
        Object object = CLOSE_LOCK;
        synchronized (object) {
            Object image = null;
            try {
                image = PdfPagesLoader.UI("qjg2g7", pdfRenderer, page, (float)zoom, (Object)ImageType.RGB);
                if (pagesDimensions[page] == null) {
                    PdfPagesLoader.pagesDimensions[page] = new Dimension((int)((float)PdfPagesLoader.UI("1ik2g4", image) / zoom), (int)((float)PdfPagesLoader.UI("-de9tfr", image) / zoom));
                }
            }
            catch (IOException ex) {
                PdfPagesLoader.UI("1qh82er", logger, PdfPagesLoader.UI("n2m2fq", ex), (Object)ex);
            }
            return image;
        }
    }

    public static int getPageCount() throws IOException {
        if (closed) {
            return 0;
        }
        PdfPagesLoader.getLoaderOrThrowException();
        return pages;
    }

    public static boolean isLoaded() {
        return pdfParserLoader.isDone();
    }

    public static synchronized Dimension getPageDimension(int page, float zoom) throws IOException {
        if (closed) {
            return new Dimension();
        }
        PdfPagesLoader.getLoaderOrThrowException();
        if (pagesDimensions[page] != null) {
            return pagesDimensions[page];
        }
        try {
            Object image = PdfPagesLoader.UI("qjg2g7", pdfRenderer, page, (float)zoom, (Object)ImageType.RGB);
            PdfPagesLoader.pagesDimensions[page] = new Dimension((int)PdfPagesLoader.UI("1ik2g4", image), (int)PdfPagesLoader.UI("-de9tfr", image));
            return pagesDimensions[page];
        }
        catch (IOException ex) {
            PdfPagesLoader.UI("1qh82er", logger, PdfPagesLoader.UI("n2m2fq", ex), (Object)ex);
            return new Dimension(0, 0);
        }
    }

    public static List<PdfAnnotation> getPageAnnotations(int page) throws IOException {
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        PdfPagesLoader.getLoaderOrThrowException();
        try {
            Object annotationList = PdfPagesLoader.UI("-1k8vtfo", PdfPagesLoader.UI("-19kptg5", pdd, page));
            Iterator iterator = annotationList.iterator();
            while (iterator.hasNext()) {
                Object annotationType;
                PDAnnotation annotation = (PDAnnotation)iterator.next();
                Object annotationDict = PdfPagesLoader.UI("19j82g9", annotation);
                if (PdfPagesLoader.UI("-2cdthi", annotationDict, COSName.V) != null || (annotationType = PdfPagesLoader.UI("-17onthh", annotationDict, COSName.FT)) == null) continue;
                char[] cArray = "\uf840\u967e\u8c53\u0a19".toCharArray();
                cArray[2] = (char)(cArray[2] ^ 0x7D8);
                if (PdfPagesLoader.UI("dd62ed", PdfLoaderServer$PdfLoaderServer.B(cArray, (short)7761, (byte)0, 4), PdfPagesLoader.UI("9r82ec", annotationType)) == false) continue;
                Object rect = PdfPagesLoader.UI("1t3k2g2", annotationDict, COSName.RECT);
                Object annotationName = PdfPagesLoader.UI("-68vtft", annotationDict, COSName.T);
                Object llx = PdfPagesLoader.UI("-1r53thg", rect, 0);
                Object lly = PdfPagesLoader.UI("-1r53thg", rect, 1);
                Object urx = PdfPagesLoader.UI("-1r53thg", rect, 2);
                Object ury = PdfPagesLoader.UI("-1r53thg", rect, 3);
                annotations.add(new PdfAnnotation(new Rectangle((int)llx, (int)ury, (int)(urx - llx), (int)(ury - lly)), (String)annotationName));
            }
        }
        catch (IOException ex) {
            PdfPagesLoader.UI("1qh82er", logger, PdfPagesLoader.UI("n2m2fq", ex), (Object)ex);
        }
        return annotations;
    }

    public static PDDocument getPDDocument() throws IOException {
        PdfPagesLoader.getLoaderOrThrowException();
        return pdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDocument() {
        Object object = CLOSE_LOCK;
        synchronized (object) {
            closed = true;
            try {
                PdfPagesLoader.UI("tca2eh", pdd);
            }
            catch (IOException ex) {
                PdfPagesLoader.UI("1qh82er", logger, PdfPagesLoader.UI("n2m2fq", ex), (Object)ex);
            }
        }
    }

    public static void shutDown() {
        EXECUTOR_SERVICE.shutdownNow();
        if (!closed) {
            PdfPagesLoader.closeDocument();
        }
    }

    private static PdfPagesLoader getLoaderOrThrowException() throws IOException {
        PdfPagesLoader loader = null;
        try {
            loader = pdfParserLoader.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            PdfPagesLoader.UI("1qh82er", logger, PdfPagesLoader.UI("fm22eq", ex), (Object)ex);
        }
        if (loader == null) {
            char[] cArray = "\u149b\u8fb1\u51af\u5cd1\uc32c\u2d11\u90d4\u0663\ue285\uf751\u0ecf\u842e\u2562\u0d8f\u24ac\u6ae2\u9876\ud967\uceac\u2927\ub4be\u55b6\u24e7\u7a75\ud975\u2ce8".toCharArray();
            cArray[24] = (char)(cArray[24] ^ 0x737);
            throw new IOException(PdfLoaderServer$PdfPagesLoader.e(cArray, (short)5005, (byte)1, (byte)3));
        }
        return loader;
    }

    static {
        pages = 0;
        closed = false;
    }

    private static Object UI(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(gtgzcsbm.y(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

