/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.core.msg.MessageFactory;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.ProxyAutenticator;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.VolException;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.slf4j.Logger;

public class ValidatorConfig {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected static final String FALSE = "false";
    protected static final String TRUE = "true";
    protected static final String EQ_SEP = "=";
    protected static final String LINK_INDICATOR = "@";
    protected Properties configdb = null;
    protected NetworkConfig netConf = null;
    protected String fullPath = null;
    private LanguagesCode language = LanguagesCode.EN;
    private MessageFactory mf = null;
    private TimeZone timeZone = Constants.DEFAULT_TIMEZONE;

    public ValidatorConfig() {
        this.fullPath = null;
        this.configdb = new Properties();
    }

    public ValidatorConfig(String confFilePath) {
        this.fullPath = confFilePath;
        this.configdb = new Properties();
    }

    public ValidatorConfig(ValidatorConfig parent, String fileName) {
        this.fullPath = fileName;
        this.configdb = new Properties(parent.configdb);
    }

    public ValidatorConfig(ConfigFile configFile) {
        this.configdb = new Properties(configFile.getConfigDB());
        this.configdb.putAll((Map<?, ?>)configFile.getConfigDB());
        if (this.configdb.getProperty("timeZone", null) != null) {
            this.timeZone = TimeZone.getTimeZone(this.configdb.getProperty("timeZone"));
        }
        this.netConf = new NetworkConfig(logger, false);
        String proxynohosts = this.configdb.getProperty("http.proxy.noProxyHosts", null);
        this.netConf.setProxynohosts(proxynohosts != null ? proxynohosts.split(",") : null);
        this.netConf.setAutomaticProxyDiscovery(this.configdb.getProperty("http.proxy.auto", FALSE).equalsIgnoreCase(TRUE));
        this.netConf.setProxy(this.configdb.getProperty("http.proxy.host", null));
        this.netConf.setProxyPort(this.configdb.getProperty("http.proxy.port", null));
        this.netConf.setUserProxy(this.configdb.getProperty("http.proxy.user", null));
        this.netConf.setPasswordProxy(this.configdb.getProperty("http.proxy.pass", null));
        if (this.configdb.getProperty("language", null) != null) {
            try {
                this.language = LanguagesCode.valueOf(this.configdb.getProperty("language", null).toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                this.language = LanguagesCode.EN;
            }
            catch (NullPointerException ex) {
                this.language = LanguagesCode.EN;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfigFile() throws FileNotFoundException, IOException {
        try (FileInputStream input = null;){
            input = new FileInputStream(this.fullPath);
            this.configdb.load(input);
        }
    }

    public String getElement(String elementTag) {
        return this.getElement(elementTag, null);
    }

    public String getElement(String elementTag, String defaultValue) {
        String prop = this.configdb.getProperty(elementTag, defaultValue);
        if (prop != null && (prop = prop.trim()).startsWith(LINK_INDICATOR)) {
            prop = prop.substring(LINK_INDICATOR.length());
            prop = this.getElement(prop, defaultValue);
        }
        return prop;
    }

    public int getIntElement(String elementTag, int defaultValue) {
        try {
            return Integer.parseInt(this.getElement(elementTag));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBinElement(String elementTag, boolean defaultValue) {
        String res = this.getElement(elementTag);
        if (res == null) {
            return defaultValue;
        }
        return TRUE.equals(res = res.toLowerCase());
    }

    public String[] getElements(String elementTag, String defaultValue, int numElements) {
        String[] res = new String[numElements];
        for (int i = 0; i < numElements; ++i) {
            int temp = i + 1;
            res[i] = this.getElement(elementTag + temp, defaultValue);
        }
        return res;
    }

    public void setElement(String elementTag, String elementValue) {
        if (elementValue == null) {
            this.configdb.setProperty(elementTag.trim(), null);
        } else {
            this.configdb.setProperty(elementTag.trim(), elementValue.trim());
        }
    }

    public void setBinElement(String elementTag, boolean elementValue) {
        if (elementValue) {
            this.configdb.setProperty(elementTag.trim(), TRUE);
        } else {
            this.configdb.setProperty(elementTag.trim(), FALSE);
        }
    }

    public boolean saveConfigFile() {
        try {
            FileOutputStream configFile = new FileOutputStream(this.fullPath, false);
            this.configdb.store(configFile, null);
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public void setLanguage(LanguagesCode language) {
        this.language = language;
        this.configdb.setProperty("language", language.name());
        this.mf = null;
    }

    public LanguagesCode getLanguage() {
        String lang = this.configdb.getProperty("language", this.language.name());
        this.language = lang == LanguagesCode.DE.name() ? LanguagesCode.DE : (lang == LanguagesCode.IT.name() ? LanguagesCode.IT : (lang == LanguagesCode.EN.name() ? LanguagesCode.EN : LanguagesCode.EN));
        return this.language;
    }

    public MessageFactory getMessageFactory() {
        if (this.mf == null) {
            try {
                this.mf = new MessageFactory(this.language);
            }
            catch (VolException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.mf;
    }

    public NetworkConfig getNetConfiguration() {
        if (this.netConf == null) {
            this.netConf = new NetworkConfig(logger, false);
            this.netConf.setProxy(this.configdb.getProperty("http.proxy.host", null));
            this.netConf.setProxyType(this.configdb.getProperty("http.proxy.type", ""));
            this.netConf.setProxyPort(this.configdb.getProperty("http.proxy.port", "8080"));
            this.netConf.setUserProxy(this.configdb.getProperty("http.proxy.user", null));
            this.netConf.setPasswordProxy(this.configdb.getProperty("http.proxy.pass", null));
            String proxynohosts = this.configdb.getProperty("http.proxy.noProxyHosts", null);
            this.netConf.setProxynohosts(proxynohosts != null ? proxynohosts.split(",") : null);
            this.netConf.setAutomaticProxyDiscovery(this.configdb.getProperty("http.proxy.auto", FALSE).equalsIgnoreCase(TRUE));
            this.netConf.setLdapProxy(this.configdb.getProperty("ldap.proxy.host", null));
            this.netConf.setLdapProxyType(this.configdb.getProperty("ldap.proxy.type", ""));
            this.netConf.setLdapProxyPort(this.configdb.getProperty("ldap.proxy.port", "8080"));
            this.netConf.setLdapUserProxy(this.configdb.getProperty("ldap.proxy.user", null));
            this.netConf.setLdapPasswordProxy(this.configdb.getProperty("ldap.proxy.pass", null));
        }
        return this.netConf;
    }

    public void setNetConfiguration(NetworkConfig netConf) {
        this.netConf = netConf;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setProxyAuthenticator(ProxyAutenticator auth) {
        this.netConf.setProxyauthenticator(auth);
    }

    public CertDB getCertDB() throws CapiException {
        CertDB certDB = null;
        String name = this.getElement("certdb.file");
        String pwd = this.getElement("certdb.pwd");
        try {
            certDB = CertDB.getInstance(name, pwd, false, true);
        }
        catch (CertDBException e) {
            throw new CapiException("Impossibile trovare il certdb", 1003, e);
        }
        return certDB;
    }
}

