/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.SignatureInformation;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import java.io.Closeable;
import java.util.LinkedList;

public class TransientDocument
implements Closeable {
    private String id;
    private String shortName = "";
    private boolean signed = false;
    private LinkedList<TransientDocument> refsDocs = new LinkedList();
    private LinkedList<RefCertificate> certs = new LinkedList();
    private LinkedList<SignatureInformation> signerInfo = new LinkedList();
    private LinkedList<RefCRL> crls = new LinkedList();
    private LinkedList<RefOcsp> ocspresps = new LinkedList();
    protected InputHandler inputHandler = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public LinkedList<TransientDocument> getRefsDocs() {
        return this.refsDocs;
    }

    public void setRefsDocs(LinkedList<TransientDocument> refDocs) {
        for (int i = 0; i < refDocs.size(); ++i) {
            this.addRefDoc(refDocs.get(i));
        }
    }

    @JsonIgnore
    public void addRefDoc(TransientDocument refDoc) {
        boolean found = false;
        for (TransientDocument ref : this.refsDocs) {
            if (!ref.getId().equals(refDoc.getId())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.refsDocs.add(refDoc);
        }
    }

    public LinkedList<RefCertificate> getCerts() {
        return this.certs;
    }

    public void setCerts(LinkedList<RefCertificate> refCerts) {
        for (int i = 0; i < refCerts.size(); ++i) {
            this.addCert(refCerts.get(i));
        }
    }

    @JsonIgnore
    public void addCert(RefCertificate cert) {
        if (!this.certs.contains(cert)) {
            this.certs.add(cert);
        }
    }

    public LinkedList<RefCRL> getCrls() {
        return this.crls;
    }

    public void setCrls(LinkedList<RefCRL> crls) {
        for (int i = 0; i < crls.size(); ++i) {
            this.addCrl(crls.get(i));
        }
    }

    @JsonIgnore
    public void addCrl(RefCRL crl) {
        if (!this.crls.contains(crl)) {
            this.crls.add(crl);
        }
    }

    public LinkedList<RefOcsp> getOcspresps() {
        return this.ocspresps;
    }

    public void setOcspresps(LinkedList<RefOcsp> ocspresps) {
        for (int i = 0; i < ocspresps.size(); ++i) {
            this.addOcspresp(ocspresps.get(i));
        }
    }

    @JsonIgnore
    public void addOcspresp(RefOcsp ocspresp) {
        if (!this.ocspresps.contains(ocspresp)) {
            this.ocspresps.add(ocspresp);
        }
    }

    public LinkedList<SignatureInformation> getSignerInfo() {
        return this.signerInfo;
    }

    public void setSignerInfo(LinkedList<SignatureInformation> signerInfo) {
        for (int i = 0; i < signerInfo.size(); ++i) {
            this.addSignerInfo(signerInfo.get(i));
        }
    }

    @JsonIgnore
    public void addSignerInfo(SignatureInformation signerInfo) {
        if (!this.signerInfo.contains(signerInfo)) {
            this.signerInfo.add(signerInfo);
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    @JsonIgnore
    public void close() {
        for (TransientDocument doc : this.refsDocs) {
            Util.closeQuietly(doc);
        }
        if (this.inputHandler != null) {
            Util.closeQuietly(this.inputHandler);
        }
    }

    @JsonIgnore
    public void finalize() throws Throwable {
        Util.closeQuietly(this);
        super.finalize();
    }
}

