/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.tsa;

import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.parser.SignerInfoDataParser;
import java.util.Collection;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TimeStampResponse;

public class TimestampSignerInfoDataParser
extends SignerInfoDataParser {
    @Override
    public SignerInfoData parse(byte[] rawSignature) {
        SignerInfoData objReturn = null;
        try {
            TimeStampResponse resp = null;
            CMSSignedData pkcs7SignedData = null;
            try {
                resp = new TimeStampResponse(rawSignature);
                pkcs7SignedData = resp.getTimeStampToken().toCMSSignedData();
            }
            catch (Exception e) {
                pkcs7SignedData = new CMSSignedData(rawSignature);
            }
            if (pkcs7SignedData == null) {
                return null;
            }
            SignerInformationStore sig_infos = pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInformVector.size() < 1) {
                return null;
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(0);
            SignerInfo si = new SignerInfo((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])sigInfo.toASN1Structure().getEncoded()));
            objReturn = new SignerInfoData();
            objReturn.setDigestAlgo(si.getDigestAlgorithm().getAlgorithm().getId());
            objReturn.setSignerInfo(si);
            return objReturn;
        }
        catch (Exception e) {
            return null;
        }
    }
}

