/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParserUtils {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXML(InputHandler source) {
        if (source == null) {
            return false;
        }
        boolean bRet = false;
        try {
            source.resetFilter();
            InputStream is = source.getInputAsNewStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                    throw exception;
                }
            });
            Document doc = builder.parse(is);
            bRet = true;
        }
        catch (SAXException e) {
            FileOutputStream fos = null;
            FileInputStream fis = null;
            it.actalis.ellips.util.File temp = null;
            try {
                int nRead;
                InputStream is = source.getInputAsNewStream();
                temp = TmpFileUtils.createTempFile("inputStream", ".tmp");
                fos = new FileOutputStream(temp);
                byte[] data = new byte[4096];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    fos.write(data, 0, nRead);
                }
                fos.flush();
                fis = new FileInputStream(temp);
                bRet = Utils.checkXml(fis);
            }
            catch (IOException ex) {
                bRet = false;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (temp != null) {
                    ((File)temp).delete();
                }
            }
        }
        catch (ParserConfigurationException e) {
            bRet = false;
        }
        catch (IOException e) {
            bRet = false;
        }
        return bRet;
    }
}

