/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;

@StepOrder(order=3)
@StepContext(formats={ValidationSignatureFormats.CADES})
public class StepSignatureIntegrityRelaxedCheck
extends MultipleValidationSubStepImpl {
    public StepSignatureIntegrityRelaxedCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param.getSignature() == null) {
            return null;
        }
        if (param.getSignature().getSignerInfoData() == null) {
            return null;
        }
        if (param.getSignature().getSignerInfoData().getSignerInfo() == null) {
            return null;
        }
        LinkedList<ValidatorMessage> msg = new LinkedList<ValidatorMessage>();
        try {
            if (param.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes() != null && !this.isDERSignedAttributes(param.getSignature())) {
                msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0013_NO_RFC5652_SIGNEDATTRIBUTES, new Object[0]));
            }
        }
        catch (Throwable ex) {
            this.logger.debug(ex.getMessage());
        }
        try {
            if (!this.isValidSigningTime(param.getSignature(), param.getSignerCertificate())) {
                msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0014_NO_VALID_SIGNINGTIME, new Object[0]));
            }
        }
        catch (Throwable ex) {
            this.logger.debug(ex.getMessage());
        }
        return msg;
    }

    protected boolean isDERSignedAttributes(SignatureInformation si) {
        try {
            ASN1Set signedAttributeSet = si.getSignerInfoData().getSignerInfo().getAuthenticatedAttributes();
            byte[] encSigAttr1 = signedAttributeSet.getEncoded("DER");
            byte[] encSigAttr2 = signedAttributeSet.getEncoded();
            boolean bIdentical = Arrays.equals(encSigAttr1, encSigAttr2);
            if (!bIdentical) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    protected boolean isValidSigningTime(SignatureInformation si, ValidatedCertificate cert) {
        X509CertificateHolder dcv;
        Time signingTime;
        SignerInformationVerifier verifier = null;
        try {
            verifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(ProvUtils.bcProvider).build(cert.getCert().getInternalCert());
        }
        catch (OperatorCreationException ex) {
            return false;
        }
        try {
            SignerInfo info = si.getSignerInfoData().getSignerInfo();
            signingTime = StepSignatureIntegrityRelaxedCheck.getSigningTime(info);
        }
        catch (Exception ex) {
            return false;
        }
        return !verifier.hasAssociatedCertificate() || signingTime == null || (dcv = verifier.getAssociatedCertificate()).isValidOn(signingTime.getDate());
    }

    private static Time getSigningTime(SignerInfo info) throws CMSException {
        ASN1Primitive validSigningTime = StepSignatureIntegrityRelaxedCheck.getSingleValuedSignedAttribute(CMSAttributes.signingTime, "signing-time", info);
        if (validSigningTime == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)validSigningTime);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }

    private static ASN1Primitive getSingleValuedSignedAttribute(ASN1ObjectIdentifier attrOID, String printableName, SignerInfo info) throws CMSException {
        AttributeTable unsignedAttrTable = null;
        if (info.getUnauthenticatedAttributes() != null) {
            unsignedAttrTable = new AttributeTable(info.getUnauthenticatedAttributes());
        }
        if (unsignedAttrTable != null && unsignedAttrTable.getAll(attrOID).size() > 0) {
            throw new CMSException("The " + printableName + " attribute MUST NOT be an unsigned attribute");
        }
        AttributeTable signedAttrTable = null;
        if (info.getAuthenticatedAttributes() != null) {
            signedAttrTable = new AttributeTable(info.getAuthenticatedAttributes());
        }
        if (signedAttrTable == null) {
            return null;
        }
        ASN1EncodableVector v = signedAttrTable.getAll(attrOID);
        switch (v.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Attribute t = (Attribute)v.get(0);
                ASN1Set attrValues = t.getAttrValues();
                if (attrValues.size() != 1) {
                    throw new CMSException("A " + printableName + " attribute MUST have a single attribute value");
                }
                return attrValues.getObjectAt(0).toASN1Primitive();
            }
        }
        throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + printableName + " attribute");
    }
}

