/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.LinkedList;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class StepX509DPCM45SubjectDN
extends SingleValidationSubStepImpl {
    public StepX509DPCM45SubjectDN() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        ValidatorMessage msg = null;
        if (param != null && param.getSignerCertificate() != null && param.getSignerCertificate().getCert().getInternalCert().getNotBefore().after(Constants.DPCM_CNIPA_45_2009) && param.getSignerCertificate().getCert().getInternalCert().getNotBefore().before(Constants.DPCM_AGID_189_2017_STARTDATE)) {
            if (param.getSignerCertificate().getIssuer() == null) {
                return null;
            }
            if (param.getSignature() != null && param.getSignature().getFormat() != null && param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
                return null;
            }
            boolean valid = false;
            try {
                String[] countryName = param.getSignerCertificate().getCert().getSubjectDNAttribute(X509ObjectIdentifiers.countryName.getId());
                String[] serialNumbers = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.5");
                String[] organizationName = param.getSignerCertificate().getCert().getSubjectDNAttribute(X509ObjectIdentifiers.organization.getId());
                String[] dnq = param.getSignerCertificate().getCert().getSubjectDNQ();
                String[] givenName = null;
                try {
                    givenName = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.42");
                }
                catch (CapiException capiException) {
                    // empty catch block
                }
                String[] surname = null;
                try {
                    surname = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.4");
                }
                catch (CapiException capiException) {
                    // empty catch block
                }
                String[] pseudonym = null;
                try {
                    pseudonym = param.getSignerCertificate().getCert().getSubjectDNAttribute("2.5.4.65");
                }
                catch (CapiException capiException) {
                    // empty catch block
                }
                if (countryName != null && countryName.length == 1 && serialNumbers != null && serialNumbers.length == 1 && organizationName != null && organizationName.length == 1 && dnq != null && dnq.length == 1 && (givenName != null && givenName.length == 1 && surname != null && surname.length == 1 || pseudonym != null && pseudonym.length == 1)) {
                    valid = true;
                }
            }
            catch (CapiException ex) {
                valid = false;
            }
            if (!valid) {
                msg = new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0017_INVALID_SUBJECT_DPCM45, new Object[0]);
            }
        }
        return msg;
    }
}

