/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.utils;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.LoggerLevel;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.util.encoders.Hex;

public abstract class CmdLineParser {
    protected static CmdLineParser instance = null;
    protected File TSLFolder = null;
    protected File tslLogFile = null;
    protected boolean bForceTSLUpdate = false;
    protected File logFolder = null;
    protected File logFile = null;
    protected File baseFolder = null;
    protected File workFolder = null;
    protected LoggerLevel logLevel = null;
    protected File defaultConfAK = null;
    protected File guiConf = null;
    protected File blobAK = null;
    protected File langAK = null;
    protected String cdbPassword = null;
    protected boolean bVerbose = true;
    protected String timeZone = null;
    protected boolean useTimeZoneUTC = true;
    protected boolean bNoProxy = true;
    protected String proxyType = null;
    protected String proxyAddressAndPort = null;
    protected String proxyUsername = null;
    protected String proxyPassword = "password";
    protected File cdbFile = null;
    protected File configFile = null;
    protected String tutorialImagesPath = null;
    protected boolean showWizard = false;
    protected LanguagesCode languageCode = null;
    protected final String defaultPreSharedKey = "3145323430";
    protected List<File> newDocument = new ArrayList<File>();

    public abstract void parse(String[] var1) throws CapiException;

    public abstract void printHelp();

    public abstract void logParsedValues(EllipsLogger var1);

    protected String getParamValue(String[] args, int iVal) throws CapiException {
        if (args == null || args.length == 0) {
            throw new CapiException("empty command line param", 1003);
        }
        if (iVal < 0 || iVal >= args.length) {
            throw new CapiException("command line value out of bound", 1003);
        }
        String value = args[iVal];
        if (value.startsWith("--")) {
            throw new CapiException("missing value: another parameter found", 1003);
        }
        return value.trim();
    }

    public String decryptRC2(String encryptedHex, String sharedKey) throws CapiException {
        String decrypted = "";
        try {
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)sharedKey), "RC2");
            Cipher rc22 = Cipher.getInstance("RC2/ECB/NoPadding");
            rc22.init(2, keySpec);
            ISO7816d4Padding pad = new ISO7816d4Padding();
            byte[] cryptedByte = Hex.decode((String)encryptedHex);
            byte[] decryptedByte = rc22.doFinal(cryptedByte);
            int pCount = pad.padCount(decryptedByte);
            String padded = new String(decryptedByte);
            decrypted = padded.substring(0, padded.length() - pCount);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CapiException(ex.getMessage(), 3103);
        }
        catch (NoSuchPaddingException ex) {
            throw new CapiException(ex.getMessage(), 3103);
        }
        catch (InvalidKeyException ex) {
            throw new CapiException(ex.getMessage(), 3103);
        }
        catch (IllegalBlockSizeException ex) {
            throw new CapiException(ex.getMessage(), 3103);
        }
        catch (BadPaddingException ex) {
            throw new CapiException(ex.getMessage(), 3103);
        }
        catch (InvalidCipherTextException ex) {
            throw new CapiException(ex.getMessage(), 3103);
        }
        return decrypted;
    }

    public String decryptRC2(String encryptedHex) throws CapiException {
        return this.decryptRC2(encryptedHex, "3145323430");
    }

    public File getLogFolder() {
        return this.logFolder;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public File getWorkFolder() {
        return this.workFolder;
    }

    public LoggerLevel getLogLevel() {
        return this.logLevel;
    }

    public File getDefaultConf() {
        return this.defaultConfAK;
    }

    public File getGuiConf() {
        return this.guiConf;
    }

    public String getCdbPassword() {
        return this.cdbPassword;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public boolean isTimeZoneUTC() {
        return this.useTimeZoneUTC;
    }

    public static CmdLineParser getCmdLineparser() {
        return instance;
    }

    public boolean isNoProxy() {
        return this.bNoProxy;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public String getProxyAddressAndPort() {
        return this.proxyAddressAndPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public File getCdbFile() {
        return this.cdbFile;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public LanguagesCode getLanguage() {
        return this.languageCode;
    }

    public void setLanguage(LanguagesCode code) {
        this.languageCode = code;
    }

    public boolean isForceTSLUpdate() {
        return this.bForceTSLUpdate;
    }

    public File getTSLLogFile() {
        return this.tslLogFile;
    }

    public File getTSLFolder() {
        return this.TSLFolder;
    }

    public String getTutorialImagesPath() {
        return this.tutorialImagesPath;
    }

    public void setTutorialImagesPath(String tutorialImagesPath) {
        this.tutorialImagesPath = tutorialImagesPath;
    }

    public boolean isShowWizard() {
        return this.showWizard;
    }

    public void setShowWizard(boolean showWizard) {
        this.showWizard = showWizard;
    }

    public List<File> getNewDocument() {
        return this.newDocument;
    }
}

