/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.crl;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CrlBean;
import esecurity.validator.x509status.RevocationBean;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.I;
import it.actalis.vol.utils.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;

public class CRLUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int CRL_BEHAVE_HTTPFIRST = 0;
    public static final int CRL_BEHAVE_LDAPFIRST = 1;
    public static final int CRL_BEHAVE_HTTPONLY = 2;
    public static final int CRL_BEHAVE_LDAPONLY = 3;

    public static CRL getCrlForCertificate(UrlClient client, ValidatorConfig config, Certificate certificate, Date validationDate, CertDB certDB) {
        logger.debug(I.d() + "Chiamata la getCrlForCertificate ");
        String crlbeh = config.getElement("crl.behavior", "HTTPFIRST");
        int crlbehave = 0;
        crlbehave = crlbeh.equals("HTTPONLY") ? 2 : (crlbeh.equals("LDAPFIRST") ? 1 : (crlbeh.equals("LDAPONLY") ? 3 : 0));
        ArrayList<CertDBItem> certChain = new ArrayList<CertDBItem>();
        try {
            certDB.onLineVerify(client.getConf(), certificate.getInternalCert().getEncoded(), certChain);
        }
        catch (CapiException e) {
            logger.debug(I.d() + "Non trovata: " + e.getMessage());
        }
        catch (CertificateEncodingException e) {
            logger.debug(I.d() + "Non trovata: " + e.getMessage());
        }
        if (certChain.isEmpty()) {
            return null;
        }
        return CRLUtils.getCrlForCertificate(client, config, certificate.getIssuerDN(), CRLUtils.getCDP(certificate), certChain.toArray(new CertDBItem[certChain.size()]), validationDate, crlbehave);
    }

    private static String[] getCDP(Certificate certificate) {
        logger.debug(I.d() + "Chiamata la downloadCRL(Certificate)");
        String[] urls = null;
        try {
            urls = certificate.getCdpURLs();
            if (urls.length == 0) {
                logger.debug(I.d() + "Errore cdp non presente nel certificato.");
            }
        }
        catch (CapiException e) {
            logger.error(I.d() + "Errore " + e.getMessage());
            return null;
        }
        return urls;
    }

    private static CRL getCrlForCertificate(UrlClient client, ValidatorConfig config, String issuerdn, String[] urls, CertDBItem[] item, Date validationDate, int crlbehave) {
        if (item == null || item.length == 0) {
            logger.error(I.d() + "Root non trovata verifica impossibile.");
            return null;
        }
        logger.debug(I.d() + "Chiamata la getCrlForCertificate ");
        if (urls == null) {
            return null;
        }
        CRL crl = CRLUtils.downloadCRL(client, config, urls, crlbehave);
        if (crl != null) {
            int iUrl;
            try {
                crl.verify(item[0].getCertificate().getInternalCert().getEncoded());
            }
            catch (CapiException ex) {
                for (iUrl = 0; iUrl < urls.length; ++iUrl) {
                    logger.info("crl non valida: " + urls[iUrl]);
                }
                logger.error(ex.getMessage(), (Throwable)ex);
                crl = null;
            }
            catch (CertificateEncodingException ex) {
                for (iUrl = 0; iUrl < urls.length; ++iUrl) {
                    logger.info("crl non valida: " + urls[iUrl]);
                }
                logger.error(ex.getMessage(), (Throwable)ex);
                crl = null;
            }
        }
        boolean crlValid = false;
        try {
            crlValid = CRLUtils.isValidCRL(crl, validationDate);
        }
        catch (CapiException ex) {
            logger.warn(ex.getMessage());
        }
        if (crl == null || !crlValid) {
            logger.debug(I.d() + "Crl non valida");
            crl = null;
        }
        try {
            if (crl != null) {
                String idp;
                String certIssuedCn;
                String crlIssuedCn = Utils.retrieveCommonName(crl.getIssuerDN());
                if (!crlIssuedCn.equalsIgnoreCase(certIssuedCn = Utils.retrieveCommonName(issuerdn))) {
                    logger.warn(I.d() + "CRL non valida per il certificato");
                    logger.warn(I.d() + "Crl issuer " + crl.getIssuerDN());
                    logger.warn(I.d() + "Certificate issuer " + issuerdn);
                }
                if ((idp = CRLUtils.getIssuingDistibutionPointName(crl)) != null) {
                    int i;
                    boolean match = false;
                    for (i = 0; i < urls.length; ++i) {
                        if (!idp.equalsIgnoreCase(urls[i])) continue;
                        match = true;
                    }
                    if (!match) {
                        logger.warn(I.d() + "CRL non valida per il certificato");
                        logger.warn(I.d() + "idp " + idp);
                        for (i = 0; i < urls.length; ++i) {
                            logger.warn(I.d() + "cdp " + urls[i]);
                        }
                    }
                }
            }
        }
        catch (CapiException e) {
            logger.error("Errore " + e.getMessage());
        }
        logger.debug(I.d() + "Fine getCrlForCertificate");
        return crl;
    }

    private static String getIssuingDistibutionPointName(CRL crl) {
        String cdp = null;
        try {
            for (String oid : crl.getInternalCRL().getCriticalExtensionOIDs()) {
                byte[] extension;
                IssuingDistributionPoint idp;
                DistributionPointName distributionPointName;
                if (!oid.equalsIgnoreCase("2.5.29.28") || (distributionPointName = (idp = IssuingDistributionPoint.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])(extension = crl.getInternalCRL().getExtensionValue(oid))))).getDistributionPoint()).getType() != 0) continue;
                GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
                GeneralName[] generalNameArray = generalNames.getNames();
                for (int j = 0; j < generalNameArray.length; ++j) {
                    GeneralName generalName = generalNameArray[j];
                    cdp = generalName.getName().toString();
                }
            }
        }
        catch (Exception e) {
            logger.error("get distribution point: " + e.getMessage());
        }
        return cdp;
    }

    private static boolean isValidCRL(CRL crl, Date validationDate) throws CapiException {
        if (validationDate == null) {
            validationDate = new Date();
        }
        if (crl == null) {
            return false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            df.setTimeZone(Constants.DEFAULT_TIMEZONE);
            Date now = new Date();
            Date validationRefTime = validationDate;
            Date thisUpdate = df.parse(crl.getThisUpdate("dd/MM/yyyy HH:mm:ss zzz"));
            Date nextUpdate = df.parse(crl.getNextUpdate("dd/MM/yyyy HH:mm:ss zzz"));
            if (now.before(thisUpdate)) {
                throw new CapiException("crl is not valid because thisUpdate is after current time", 31006);
            }
            if (validationRefTime.after(nextUpdate)) {
                throw new CapiException("crl is not valid because nextUpdate is prior to validation time", 31006);
            }
            return true;
        }
        catch (ParseException e) {
            throw new CapiException("Error parsing crl date", 31006);
        }
    }

    static RevocationBean validateRevocationReason(CRL crl, BigInteger serialnumber, ValidationDate validationDate) {
        RevocationBean revocationBean = new RevocationBean();
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            df.setTimeZone(Constants.DEFAULT_TIMEZONE);
            if (validationDate == null) {
                validationDate = new ValidationDate(new Date(), DateSource.SYSTEM);
            }
            CrlBean crlBean = CRLUtils.retrieveCrlInfo(crl, validationDate.getDate());
            revocationBean.setCrlBean(crlBean);
            revocationBean.setCrlStatus(crlBean.getCrlStatusExplained());
            if (crlBean.isCrlValid()) {
                if (crl.isRevoked(serialnumber)) {
                    String revDate_str = crl.getRevocationDate(serialnumber);
                    Date revDate = Util.parseDate(revDate_str, "yyyyMMddHHmmss");
                    Date vDate = validationDate.getDate();
                    if (vDate.compareTo(revDate) >= 0) {
                        int rc = crl.getReasonCode(serialnumber);
                        String revstr = CRLUtils.reasonCodeToCapiString(rc);
                        revocationBean.setCertRevoked(true);
                        revocationBean.setRevocationDate(revDate);
                        revocationBean.setRevocationReason(Integer.toString(rc));
                        if (!revocationBean.getInvalidityReason().equalsIgnoreCase("")) {
                            revstr = revocationBean.getInvalidityReason() + " - " + revstr;
                        }
                        revocationBean.setInvalidityReason(revstr);
                    }
                } else {
                    revocationBean.setCertRevoked(false);
                }
            } else {
                revocationBean.setCertRevoked(false);
                if (!revocationBean.getInvalidityReason().equalsIgnoreCase("")) {
                    revocationBean.setInvalidityReason(revocationBean.getInvalidityReason() + " crl not found or expired");
                } else {
                    revocationBean.setInvalidityReason("Crl not found or expired");
                }
                revocationBean.setCrlStatus("NOT FOUND OR EXPIRED");
            }
        }
        catch (CapiException e) {
            revocationBean.setCertRevoked(false);
            revocationBean.setInvalidityReason(revocationBean.getInvalidityReason() + e.getMessage());
            revocationBean.setCrlStatus("NO_CHECK");
        }
        return revocationBean;
    }

    static String reasonCodeToCapiString(int rc) {
        String revstr = null;
        switch (rc) {
            case 3: {
                revstr = "AffiliationChanged";
                break;
            }
            case 2: {
                revstr = "CACompromise";
                break;
            }
            case 6: {
                revstr = "CertificateHold";
                break;
            }
            case 5: {
                revstr = "CessationOfOperation";
                break;
            }
            case 1: {
                revstr = "KeyCompromise";
                break;
            }
            case 8: {
                revstr = "RemoveFromCRL";
                break;
            }
            case 4: {
                revstr = "Superseded";
                break;
            }
            case 0: {
                revstr = "Unspecified";
                break;
            }
            case 9: {
                revstr = "PrivilegeWithdrawn";
                break;
            }
            case 10: {
                revstr = "AACompromise";
                break;
            }
            default: {
                revstr = "Unknown";
            }
        }
        return revstr;
    }

    static CrlBean retrieveCrlInfo(CRL crl, Date validationDate) throws CapiException {
        CrlBean crlBean = new CrlBean();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        df.setTimeZone(Constants.DEFAULT_TIMEZONE);
        try {
            String distIssPoint;
            X509CRL crl1;
            crlBean.setIssuerDN(crl.getIssuerDN());
            crlBean.setThisUpdate(crl.getThisUpdate("dd/MM/yyyy HH:mm:ss zzz"));
            crlBean.setNextUpdate(crl.getNextUpdate("dd/MM/yyyy HH:mm:ss zzz"));
            crlBean.setDownloadedUrl(crl.getDownloadedUrl());
            if (crl.getExpiredCertsOnCRL() != null) {
                crlBean.setExpiredCertsOnCRL(df.format(crl.getExpiredCertsOnCRL()));
            }
            if ((crl1 = crl.getInternalCRL()) != null) {
                byte[] v3Ext = crl1.getExtensionValue("2.5.29.20");
                if (v3Ext != null) {
                    ASN1Integer serial = (ASN1Integer)CRLUtils.toDERObject(((ASN1OctetString)CRLUtils.toDERObject(v3Ext)).getOctets());
                    crlBean.setSerial(serial.getValue().toString(16));
                }
                crlBean.setVersion(String.valueOf(crl1.getVersion()));
                crlBean.setSigAlgName(crl1.getSigAlgName());
            }
            if ((distIssPoint = CRLUtils.getIssuingDistibutionPointName(crl)) != null) {
                crlBean.setIssuingDistributionPointName(distIssPoint);
            }
            Date validateRefTime = new Date();
            boolean validcrl = true;
            try {
                Date thisUpdate = df.parse(crl.getThisUpdate("dd/MM/yyyy HH:mm:ss zzz"));
                Date nextUpdate = df.parse(crl.getNextUpdate("dd/MM/yyyy HH:mm:ss zzz"));
                Date nextUpadteDate = crl.getInternalCRL().getNextUpdate();
                crlBean.setCrlStatusExplained("VALID");
                if (validateRefTime.before(thisUpdate)) {
                    crlBean.setCrlStatusExplained("NOT YET");
                    validcrl = false;
                }
                if (validationDate.after(nextUpdate)) {
                    crlBean.setCrlStatusExplained("EXPIRED");
                    validcrl = false;
                }
            }
            catch (Exception e) {
                crlBean.setCrlStatusExplained("UNKNOWN");
            }
            crlBean.setCrlValid(validcrl);
        }
        catch (CapiException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CapiException("Internal Errore", 1003, e);
        }
        return crlBean;
    }

    private static ASN1Primitive toDERObject(byte[] data) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ASN1InputStream asnInputStream = new ASN1InputStream((InputStream)inStream);
        return asnInputStream.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CRL downloadCRL(UrlClient client, ValidatorConfig config, String[] urls, int crlbehave) {
        int i;
        int indexUrl;
        boolean isSogeiProxy;
        logger.debug(I.d() + "Chiamata la downloadCRL(urls[])");
        String ldapaddr = null;
        String httpaddr = null;
        String[] orderUrls = new String[urls.length];
        String sogeiProxy = config.getElement("sogei.proxy", "");
        boolean bl = isSogeiProxy = !sogeiProxy.isEmpty();
        if (urls != null) {
            urls = CRLUtils.url_sogei(config, urls);
            for (int i2 = 0; i2 < urls.length; ++i2) {
                if (urls[i2].startsWith("http://") || urls[i2].startsWith("https://")) {
                    httpaddr = urls[i2];
                }
                if (!urls[i2].startsWith("ldap://")) continue;
                ldapaddr = urls[i2];
            }
        }
        if (crlbehave == 0) {
            indexUrl = 0;
            for (i = 0; i < urls.length; ++i) {
                if (!urls[i].toLowerCase().startsWith("http")) continue;
                orderUrls[indexUrl] = urls[i];
                ++indexUrl;
            }
            for (i = 0; i < urls.length; ++i) {
                if (!urls[i].toLowerCase().startsWith("ldap")) continue;
                orderUrls[indexUrl] = urls[i];
                ++indexUrl;
            }
        }
        if (crlbehave == 1) {
            indexUrl = 0;
            for (i = 0; i < urls.length; ++i) {
                if (!urls[i].toLowerCase().startsWith("ldap")) continue;
                orderUrls[indexUrl] = urls[i];
                ++indexUrl;
            }
            for (i = 0; i < urls.length; ++i) {
                if (!urls[i].toLowerCase().startsWith("http")) continue;
                orderUrls[indexUrl] = urls[i];
                ++indexUrl;
            }
        }
        boolean found = false;
        CRL crl = null;
        for (int i3 = 0; i3 < orderUrls.length && !found; ++i3) {
            if (crlbehave == 2 && !orderUrls[i3].toLowerCase().startsWith("http") || crlbehave == 3 && !orderUrls[i3].toLowerCase().startsWith("ldap")) continue;
            InputStream is = null;
            try {
                logger.debug(I.d() + "Url " + orderUrls[i3]);
                if (orderUrls[i3].startsWith("ldap")) {
                    UrlReturn ret = client.downloadUrl(orderUrls[i3], null, null);
                    if (ret == null || ret.getStatus() == null || !ret.getStatus().equals("OK")) {
                        Util.closeQuietly(is);
                        continue;
                    }
                    is = new ByteArrayInputStream(ret.getData());
                } else {
                    is = client.getInputStream(new URL(orderUrls[i3]), null);
                }
                logger.debug(I.d() + "Fine download");
                crl = new CRL(new BufferedInputStream(is));
                crl.setDownloadedUrl(orderUrls[i3]);
                found = true;
                Util.closeQuietly(is);
            }
            catch (Exception e) {
                logger.error(I.d() + "Errore: " + e.getMessage());
            }
            finally {
                Util.closeQuietly(is);
            }
            continue;
        }
        SimpleDateFormat dt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        try {
            logger.debug(I.d() + "CRL recuperata " + crl.getIssuerDN());
            logger.debug(I.d() + "This update    " + dt.format(crl.getInternalCRL().getThisUpdate()));
            logger.debug(I.d() + "Next update    " + dt.format(crl.getInternalCRL().getNextUpdate()));
        }
        catch (Exception e) {
            logger.error(I.d() + "Errore recupero info CRL: " + e.getMessage());
        }
        logger.debug(I.d() + "Fine downloadCRL");
        return crl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] url_sogei(ValidatorConfig config, String[] urls) {
        if (config.getElement("sogei.proxy") != null && !config.getElement("sogei.proxy").equals("")) {
            Socket sock = null;
            for (int i = 0; i < urls.length; ++i) {
                try {
                    String url = urls[i];
                    String host = config.getElement("sogei.proxy");
                    int port = 80;
                    if (config.getElement("sogei.proxy.port") != null && !config.getElement("sogei.proxy.port").equals("")) {
                        try {
                            port = Integer.parseInt(config.getElement("sogei.proxy.port"));
                        }
                        catch (Exception e) {
                            port = 80;
                        }
                    }
                    sock = new Socket(host, port);
                    System.out.println("" + sock.getLocalAddress().getHostAddress());
                    String ut = URLDecoder.decode(url, "UTF-8");
                    ut = URLEncoder.encode(ut, "UTF-8");
                    String ip = URLEncoder.encode(sock.getLocalAddress().getHostAddress(), "UTF-8");
                    URI uri = new URI("http://" + host + ":" + port + "/crlproxy/crlproxy?hostname=" + ip + "&uri=" + ut);
                    url = uri.toString();
                    logger.debug("Url Proxy Sogei:" + url);
                    urls[i] = url;
                    continue;
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                    continue;
                }
                finally {
                    if (sock != null) {
                        try {
                            sock.close();
                        }
                        catch (IOException ex) {
                            logger.error(ex.getMessage());
                        }
                    }
                }
            }
        }
        return urls;
    }

    public static String generateCrlId(String[] urls) {
        String txt = "";
        String strId = "";
        for (int i = 0; i < urls.length; ++i) {
            txt = txt + urls[i];
        }
        SHA256Digest digest = new SHA256Digest();
        byte[] crpDigested = new byte[digest.getDigestSize()];
        byte[] message = txt.getBytes();
        digest.update(message, 0, message.length);
        digest.doFinal(crpDigested, 0);
        for (int k = 0; k < crpDigested.length; ++k) {
            strId = Hex.toHexString((byte[])crpDigested);
        }
        return strId.toUpperCase();
    }

    public static String generateCrlId(Certificate certificate) {
        return CRLUtils.generateCrlId(CRLUtils.getCDP(certificate));
    }
}

