/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.crl;

import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.RevocationBean;
import esecurity.validator.x509status.X509StatusValidator;
import esecurity.validator.x509status.crl.CRLCacheManager;
import esecurity.validator.x509status.crl.CRLUtils;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.vol.utils.I;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class CRLX509StatusValidator
implements X509StatusValidator {
    private static final HashMap<String, ReentrantLock> crlLocks = new HashMap();
    private ValidatorConfig config;
    private Logger logger;
    private CRLCacheManager cacheManager;
    private UrlClient client;
    private CertDB certDB;

    public CRLX509StatusValidator(ValidatorConfig config, CRLCacheManager cacheManager, Logger logger) throws CapiException {
        this.config = config;
        this.logger = logger;
        this.cacheManager = cacheManager;
        this.certDB = config.getCertDB();
        this.client = new UrlClient(config.getNetConfiguration(), logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertificateStatus checkStatus(Certificate cert, ValidationDate validationDate) {
        this.logger.debug(I.d() + "validateCertificate con CRL");
        CertificateStatus certificateStatus = new CertificateStatus();
        try {
            if (cert.getSubjectDN().equalsIgnoreCase(cert.getIssuerDN())) {
                this.logger.debug(I.d() + "e' selfsigned: non fa la verifica CRL");
                certificateStatus.setCertValid(true);
                certificateStatus.setCrlStatus("NO_CHECK");
                CertificateStatus certificateStatus2 = certificateStatus;
                return certificateStatus2;
            }
            if (cert.isRsVerified()) {
                this.logger.debug(I.d() + "e' RsVerified");
                certificateStatus.setVerificationType("CRL");
                certificateStatus.setCertValid(true);
                certificateStatus.setCrlStatus("VERIFIED SIGNATURE");
                CertificateStatus certificateStatus3 = certificateStatus;
                return certificateStatus3;
            }
            certificateStatus.setVerificationType("CRL");
            RevocationBean revocationBean = this.checkRevocation(cert, validationDate);
            if (revocationBean == null) {
                certificateStatus.setCertValid(false);
                certificateStatus.setInvalidityReason("Crl not found");
                certificateStatus.setCrlStatus("NOT FOUND");
                certificateStatus.setCertRevoked(false);
                certificateStatus.setCheckAnotherHelper(true);
                CertificateStatus certificateStatus4 = certificateStatus;
                return certificateStatus4;
            }
            if (revocationBean.getCertRevoked() && revocationBean.getRevocationDate().before(validationDate.getDate())) {
                certificateStatus.setCertRevoked(true);
                certificateStatus.setCertValid(false);
                certificateStatus.setInvalidityReason(revocationBean.getInvalidityReason());
                certificateStatus.setRevocationDate(revocationBean.getRevocationDate());
                certificateStatus.setRevocationReason(revocationBean.getRevocationReason());
            }
            certificateStatus.setCrlBean(revocationBean.getCrlBean());
            certificateStatus.setCrlStatus(revocationBean.getCrlStatus());
        }
        catch (Exception e) {
            certificateStatus.setCertValid(false);
            certificateStatus.setInvalidityReason(certificateStatus.getInvalidityReason() + e.getMessage());
            certificateStatus.setCrlStatus("NOT FOUND");
            certificateStatus.setCheckAnotherHelper(true);
            this.logger.error(I.d() + e.getMessage());
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("CRLX509StatusValidator result:");
                this.logger.debug(certificateStatus.toString());
            }
        }
        return certificateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevocationBean checkRevocation(Certificate cert, ValidationDate validationDate) throws CapiException {
        RevocationBean objReturn = null;
        String crlId = CRLUtils.generateCrlId(cert);
        if (this.cacheManager.isCrlInCache(crlId)) {
            return this.cacheManager.checkRevocation(cert, validationDate);
        }
        ReentrantLock lock = null;
        try {
            Object object;
            lock = crlLocks.get(crlId);
            if (lock == null) {
                object = crlLocks;
                synchronized (object) {
                    lock = crlLocks.get(crlId);
                    if (lock == null) {
                        lock = new ReentrantLock();
                        crlLocks.put(crlId, lock);
                    }
                }
            }
            lock.lock();
            if (this.cacheManager.isCrlInCache(crlId)) {
                object = this.cacheManager.checkRevocation(cert, validationDate);
                return object;
            }
            CRL crl = CRLUtils.getCrlForCertificate(this.client, this.config, cert, validationDate.getDate(), this.certDB);
            if (crl == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("CRL NULLA");
                }
                RevocationBean revocationBean = null;
                return revocationBean;
            }
            this.cacheManager.addCrlToCache(crlId, crl);
            objReturn = CRLUtils.validateRevocationReason(crl, cert.getInternalCert().getSerialNumber(), validationDate);
        }
        finally {
            lock.unlock();
        }
        return objReturn;
    }
}

