/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class Util {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final SecureRandom secureRandom = new SecureRandom();
    public static final int noWarning = 0;
    public static final int DigestNotCompliant = 1;
    public static final int SHA1NotCompliant = 2;
    public static final int NoSignerCertV2 = 3;
    public static final String enchar = "ISO8859_1";
    static boolean debug = false;

    public static Date getDateFromTStamp(TimeStampToken tst) {
        if (tst == null) {
            return null;
        }
        try {
            return tst.getTimeStampInfo().getGenTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDerSequence(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        int firstByte = fis.read();
        fis.close();
        return firstByte == 48;
    }

    public static boolean isDerSequence(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        return data[0] == 48;
    }

    public static byte[] base64Decode(byte[] data) throws CapiException {
        if (data == null) {
            return null;
        }
        try {
            return Base64.decode((byte[])data);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong Base64 format", 5001);
        }
    }

    public static byte[] base64DecodeStr(String data) throws CapiException {
        if (data == null) {
            return null;
        }
        try {
            return Base64.decode((String)data);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong Base64 format", 5001);
        }
    }

    public static byte[] base64Encode(byte[] data) {
        if (data == null) {
            return null;
        }
        return Base64.encode((byte[])data);
    }

    public static String base64EncodeStr(byte[] data) {
        if (data == null) {
            return null;
        }
        return Util.newString(Util.base64Encode(data));
    }

    public static byte[] readFile(String fileName) throws CapiException {
        if (fileName == null) {
            throw new CapiException("Null parameters", 1001);
        }
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(fileName);
            byte[] byArray = Streams.readAll((InputStream)fi);
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw new CapiException("File not found", 4002);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("File read error", 4000);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] digestStreams(String Type2, InputStream ... params) throws CapiException {
        SHA1Digest dgs = null;
        if (Type2.equals(Constants.SHA1)) {
            dgs = new SHA1Digest();
        } else if (Type2.equals(Constants.SHA256)) {
            dgs = new SHA256Digest();
        } else {
            throw new CapiException("Invalid Digest Type", 1002);
        }
        byte[] digest = new byte[dgs.getDigestSize()];
        if (params == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (params.length == 0) {
            throw new CapiException("No stream", 1002);
        }
        try {
            byte[] bs = new byte[64000];
            for (InputStream param : params) {
                int numRead;
                while ((numRead = param.read(bs, 0, bs.length)) >= 0) {
                    dgs.update(bs, 0, numRead);
                }
            }
            dgs.doFinal(digest, 0);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("File read error", 4000);
        }
        return digest;
    }

    public static void saveToFile(byte[] data, String fileName) throws CapiException {
        if (data == null || fileName == null) {
            throw new CapiException("Null parameters", 1001);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            out.write(data);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("File write error", 4001);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static boolean equalsBlock(byte[] a, byte[] b) throws CapiException {
        if (a == null || b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        return Arrays.areEqual((byte[])a, (byte[])b);
    }

    public static String bigIntToHexStr(BigInteger big) throws CapiException {
        if (big == null) {
            throw new CapiException("Null parameters", 1001);
        }
        String hex = big.toString(16);
        if (hex.length() % 2 == 0) {
            return hex;
        }
        return "0" + hex;
    }

    public static BigInteger bigIntFromHexStr(String str) throws CapiException {
        if (str == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            BigInteger big = new BigInteger(str, 16);
            return big;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong format", 6001);
        }
    }

    public static String getRDN(String DN, String RDN2) {
        if (DN == null || RDN2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(DN, ",", false);
        String rdn = RDN2.toUpperCase() + "=";
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!temp.toUpperCase().startsWith(rdn)) continue;
            return temp.substring(rdn.length());
        }
        return null;
    }

    public static String fromPemString(String in, boolean findBeginPEMclause) {
        String newline = System.getProperty("line.separator");
        if (in == null || in.equals("")) {
            return in;
        }
        try {
            BufferedReader br = new BufferedReader(new StringReader(in));
            StringBuffer sb = new StringBuffer();
            sb.setLength(0);
            int foundPEMclause = 0;
            String s1 = null;
            while ((s1 = br.readLine()) != null) {
                if (s1.startsWith("-----BEGIN")) {
                    sb.setLength(0);
                    foundPEMclause = 1;
                    continue;
                }
                if (findBeginPEMclause && foundPEMclause == 0) break;
                if (foundPEMclause == 1 && s1.startsWith("-----END")) {
                    foundPEMclause = 2;
                    break;
                }
                sb.append(s1.trim());
                sb.append(newline);
            }
            if (foundPEMclause == 0) {
                return in;
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return in;
        }
    }

    public static String formatDate(Date dt, String format) throws CapiException {
        return Util.formatDate(dt, format, null);
    }

    public static String formatDate(Date dt, String format, String timezone) throws CapiException {
        if (format == null) {
            format = "yyyyMMddHHmmss";
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            TimeZone thetz = null;
            thetz = timezone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timezone);
            if (thetz == null) {
                throw new CapiException("Timezone not present", 6002);
            }
            df.setTimeZone(thetz);
            String gt = df.format(dt);
            return gt;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Format date error", 6000);
        }
    }

    public static Date parseDate(String dt, String format) throws CapiException {
        return Util.parseDate(dt, format, null);
    }

    public static Date parseDate(String dt, String format, String timezone) throws CapiException {
        if (format == null) {
            format = "yyyyMMddHHmmss";
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            TimeZone thetz = null;
            thetz = timezone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timezone);
            if (thetz == null) {
                throw new CapiException("Timezone not present", 6002);
            }
            df.setTimeZone(thetz);
            return df.parse(dt);
        }
        catch (ParseException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Date format alert", 6000);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong date format", 6000);
        }
    }

    public static boolean fromPemString(InputStream in, OutputStream out, boolean findBeginPEMclause) throws CapiException {
        if (in == null) {
            return true;
        }
        if (out == null) {
            return true;
        }
        BufferedReader br = null;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(in);
            br = new BufferedReader(isr, 4096);
            BufferedOutputStream bos = new BufferedOutputStream(out, 4096);
            int foundPEMclause = 0;
            String s1 = null;
            while ((s1 = br.readLine()) != null) {
                if (s1.startsWith("-----BEGIN")) {
                    foundPEMclause = 1;
                    continue;
                }
                if (findBeginPEMclause && foundPEMclause == 0) break;
                if (foundPEMclause == 1 && s1.startsWith("-----END")) {
                    foundPEMclause = 2;
                    break;
                }
                String buf = s1.trim() + System.getProperty("line.separator");
                bos.write(Util.getBytes(buf), 0, buf.length());
            }
            br.close();
            bos.flush();
            if (foundPEMclause == 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("fromPemStream error", 1003);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                br.close();
            }
            catch (Exception exception) {}
            try {
                isr.close();
            }
            catch (Exception exception) {}
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static byte[] getBytes(String s) throws CapiException {
        if (s == null) {
            return null;
        }
        try {
            return s.getBytes(enchar);
        }
        catch (UnsupportedEncodingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("ISO8859_1:why encoding unsupported?", 1003);
        }
    }

    public static String newString(byte[] b) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b, enchar);
        }
        catch (UnsupportedEncodingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isSHA1ForbiddenToSign(Date date) {
        return Util.isDateInvalid("20110701", "yyyyMMdd", date);
    }

    public static boolean isDateInvalid(String invalidFrom, String invalidFromFormat, Date date) {
        boolean dateInvalid = true;
        Date sha1InvalidDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat(invalidFromFormat);
        try {
            sha1InvalidDate = sdf.parse(invalidFrom);
            if (!date.after(sha1InvalidDate)) {
                dateInvalid = false;
            }
            return dateInvalid;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static int warningDelibera45Compliant(Date signatureDate, boolean isSignValid, String alg, boolean hasSignerCrtV2) {
        if (!isSignValid) {
            return 0;
        }
        if (alg.compareToIgnoreCase("SHA-256") != 0 && alg.compareToIgnoreCase(Constants.SHA256) != 0 && alg.compareToIgnoreCase("SHA-1") != 0 && alg.compareToIgnoreCase(Constants.SHA1) != 0 && alg.compareToIgnoreCase("SHA") != 0 && alg.compareToIgnoreCase("1.3.14.3.2.26") != 0 && alg.compareToIgnoreCase("2.16.840.1.101.3.4.2.1") != 0) {
            return 1;
        }
        if (alg.compareToIgnoreCase("SHA-256") != 0 && alg.compareToIgnoreCase(Constants.SHA256) != 0 && alg.compareToIgnoreCase("2.16.840.1.101.3.4.2.1") != 0) {
            if (signatureDate == null) {
                return 2;
            }
            if (signatureDate != null && Util.isSHA1ForbiddenToSign(signatureDate)) {
                return 2;
            }
        }
        if (!hasSignerCrtV2) {
            if (signatureDate == null) {
                return 3;
            }
            if (signatureDate != null && Util.isSHA1ForbiddenToSign(signatureDate)) {
                return 3;
            }
        }
        return 0;
    }

    public static String dumpHex(byte[] b) {
        if (b == null || b.length == 0) {
            return null;
        }
        String dump = "";
        for (int i = 0; i < b.length; ++i) {
            String tmp = Util.dumpHex(b[i]) + (i == b.length - 1 ? "" : ":");
            dump = dump.concat(tmp);
        }
        return dump;
    }

    private static String dumpHex(byte byte0) {
        StringBuffer stringbuffer = new StringBuffer(2);
        int i = (byte0 & 0xF0) >> 4;
        int j = byte0 & 0xF;
        stringbuffer.append(new Character((char)(i <= 9 ? 48 + i : 55 + i)));
        stringbuffer.append(new Character((char)(j <= 9 ? 48 + j : 55 + j)));
        return stringbuffer.toString();
    }

    public static void setRemoteSignProxyParams(String proxyhost, String proxyport, String proxyrealm, String proxyuser, String proxypwd, String proxyuserdomain, Boolean preferBasic) throws Throwable {
        try {
            Class<?> class1 = Class.forName("it.actalis.ellips.capi.RemoteSignatureToken");
            Method method = class1.getMethod("setProxyParams", String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class);
            method.invoke(null, proxyhost, proxyport, proxyrealm, proxyuser, proxypwd, proxyuserdomain, preferBasic);
        }
        catch (Throwable e) {
            logger.debug(e.getMessage(), e);
            throw e;
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromInputStream(InputStream is) throws IOException {
        try (ByteArrayOutputStream os = null;){
            int len;
            os = new ByteArrayOutputStream();
            byte[] buffer = new byte[65535];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Util.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static short[] copyOf(short[] original, int newLength) {
        short[] copy = new short[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static long[] copyOf(long[] original, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static float[] copyOf(float[] original, int newLength) {
        float[] copy = new float[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        boolean[] copy = new boolean[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static List<String> readAllLines(File fileToRead) throws IOException {
        return Util.readAllLines(fileToRead, Charset.forName("UTF-8"));
    }

    public static List<String> readAllLines(File fileToRead, Charset cs) throws IOException {
        if (fileToRead == null || cs == null) {
            return null;
        }
        FileInputStream fis = new FileInputStream(fileToRead);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        fis.close();
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromPemOrBase64(byte[] data) throws CapiException {
        byte[] retByte;
        block5: {
            boolean bIsPem;
            block4: {
                retByte = data;
                byte firstByte = data[0];
                boolean bIsDer = firstByte == 48;
                boolean bl = bIsPem = firstByte == 45;
                if (bIsPem || bIsDer) break block4;
                retByte = Util.base64Decode(data);
                break block5;
            }
            if (bIsPem) {
                ByteArrayInputStream bais;
                ByteArrayOutputStream baos;
                block3: {
                    baos = null;
                    bais = null;
                    try {
                        baos = new ByteArrayOutputStream();
                        bais = new ByteArrayInputStream(data);
                        if (!Util.fromPemString(bais, baos, true)) break block3;
                        retByte = Util.base64Decode(baos.toByteArray());
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(baos);
                        Util.closeQuietly(bais);
                        throw throwable;
                    }
                }
                Util.closeQuietly(baos);
                Util.closeQuietly(bais);
            }
        }
        return retByte;
    }

    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedBasePath;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        if (normalizedTargetPath.equals(normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath))) {
            return "";
        }
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new IllegalArgumentException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    public static int[] intArrayFromList(List<Integer> lst) {
        int[] arrReturn = new int[lst.size()];
        for (int i = 0; i < arrReturn.length; ++i) {
            arrReturn[i] = lst.get(i);
        }
        return arrReturn;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

