/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core.qc;

import it.actalis.ellips.capi.core.qc.QcKnown;
import it.actalis.ellips.capi.core.qc.QcStatements;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.qualified.SemanticsInformation;

public class PkixQCSyntaxv1
extends QcKnown {
    private String semanticsIdentifier;
    private List<String> nameRegistrationAuthorities;

    public PkixQCSyntaxv1(ASN1Encodable info) {
        super(QcStatements.PkixQCSyntaxv1, info);
        SemanticsInformation si = (SemanticsInformation)info;
        if (si != null) {
            this.semanticsIdentifier = si.getSemanticsIdentifier().getId();
            GeneralName[] gns = si.getNameRegistrationAuthorities();
            if (gns != null) {
                for (int j = 0; j < gns.length; ++j) {
                    this.nameRegistrationAuthorities.add(gns[j].getName().toString());
                }
            }
        }
    }

    public List<String> getNameRegistrationAuthorities() {
        return this.nameRegistrationAuthorities;
    }

    public String getSemanticsIdentifier() {
        return this.semanticsIdentifier;
    }
}

