/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core.qc;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.qc.PkixQCSyntaxv1;
import it.actalis.ellips.capi.core.qc.PkixQCSyntaxv2;
import it.actalis.ellips.capi.core.qc.QcEuCompliance;
import it.actalis.ellips.capi.core.qc.QcEuLimitValue;
import it.actalis.ellips.capi.core.qc.QcEuRetentionPeriod;
import it.actalis.ellips.capi.core.qc.QcPDS;
import it.actalis.ellips.capi.core.qc.QcSSCD;
import it.actalis.ellips.capi.core.qc.QcSimple;
import it.actalis.ellips.capi.core.qc.QcStatements;
import it.actalis.ellips.capi.core.qc.QcType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public abstract class QcStatement {
    protected String oid;
    protected ASN1Encodable info;

    public QcStatement(String oid, ASN1Encodable info) {
        this.oid = oid;
        this.info = info;
    }

    public static QcStatement getInstance(String oid, ASN1Encodable info) throws CapiException {
        QcStatements find = QcStatements.retrieveByID(new ASN1ObjectIdentifier(oid));
        if (find == null) {
            return QcStatement.getInstance(null, oid, info);
        }
        return QcStatement.getInstance(find, null, info);
    }

    public static QcStatement getInstance(QcStatements type, ASN1Encodable info) throws CapiException {
        return QcStatement.getInstance(type, null, info);
    }

    private static QcStatement getInstance(QcStatements type, String oid, ASN1Encodable info) throws CapiException {
        if (type != null) {
            switch (type) {
                case QcEuCompliance: {
                    return new QcEuCompliance(info);
                }
                case QcEuLimitValue: {
                    return new QcEuLimitValue(info);
                }
                case QcEuRetentionPeriod: {
                    return new QcEuRetentionPeriod(info);
                }
                case QcSSCD: {
                    return new QcSSCD(info);
                }
                case PkixQCSyntaxv1: {
                    return new PkixQCSyntaxv1(info);
                }
                case PkixQCSyntaxv2: {
                    return new PkixQCSyntaxv2(info);
                }
                case QcPDS: {
                    return new QcPDS(info);
                }
                case QcType: {
                    return new QcType(info);
                }
            }
        } else {
            return new QcSimple(oid, info);
        }
        throw new CapiException("Unable to generate Qc", 1003);
    }
}

