/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.builders;

import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.builders.AmazonS3DataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.ArubaCloudDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.CloudChooserDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.GenericDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.GenericS3DataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.S3ChooserDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.URLDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.inputs.AmazonS3InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.ArubaCloudS3InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.ByteInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.FileInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.S3InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.StreamInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.TempFileInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.URLInputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.AmazonS3OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.ArubaCloudS3OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.ByteOutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.FileOutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.S3OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.StreamOutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.TempFileOutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.URLOutputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;

public abstract class DataHandlerBuilder {
    protected String name = null;
    protected Long totalSize = null;
    protected boolean replace = false;
    protected DataHandler.DATA_TYPE type = null;
    protected byte[] byteData = null;
    protected File fileData = null;
    protected String prefix = null;
    protected String suffix = null;
    protected InputStream streamInputData = null;
    protected OutputStream streamOutputData = null;
    protected URL urlEndpoint = null;
    protected URLCredentials urlCreds = null;
    protected NetworkConfig urlNetConf = null;
    protected DataHandler.CLOUD_TYPE cloudType = null;
    protected DataHandler.S3_TYPE s3Type = null;
    protected AmazonS3ClientBuilder genericS3ClientBuilder = null;
    protected String s3Bucket = null;
    protected String s3Filepath = null;
    protected String as3UserId = null;
    protected String as3SecretKey = null;
    protected String arubaCloudUserId = null;
    protected String arubaCloudSecretKey = null;
    protected String arubaCloudEndpoint = null;

    protected static GenericDataHandlerBuilderFacade getNewGenericFacade() {
        return new GenericDataHandlerBuilderFacade();
    }

    protected static URLDataHandlerBuilderFacade getNewURLFacadeFrom(DataHandlerBuilder from) {
        URLDataHandlerBuilderFacade ret = new URLDataHandlerBuilderFacade();
        ret.copyInfoFrom(from);
        ret.type = DataHandler.DATA_TYPE.URL;
        return ret;
    }

    protected static CloudChooserDataHandlerBuilderFacade getNewCloudFacadeFrom(DataHandlerBuilder from) {
        CloudChooserDataHandlerBuilderFacade ret = new CloudChooserDataHandlerBuilderFacade();
        ret.copyInfoFrom(from);
        ret.type = DataHandler.DATA_TYPE.CLOUD;
        return ret;
    }

    protected static S3ChooserDataHandlerBuilderFacade getNewS3FacadeFrom(DataHandlerBuilder from) {
        S3ChooserDataHandlerBuilderFacade ret = new S3ChooserDataHandlerBuilderFacade();
        ret.copyInfoFrom(from);
        ret.type = DataHandler.DATA_TYPE.CLOUD;
        ret.cloudType = DataHandler.CLOUD_TYPE.S3;
        return ret;
    }

    protected static GenericS3DataHandlerBuilderFacade getNewGenericS3FacadeFrom(DataHandlerBuilder from) {
        GenericS3DataHandlerBuilderFacade ret = new GenericS3DataHandlerBuilderFacade();
        ret.copyInfoFrom(from);
        ret.type = DataHandler.DATA_TYPE.CLOUD;
        ret.cloudType = DataHandler.CLOUD_TYPE.S3;
        ret.s3Type = DataHandler.S3_TYPE.GENERIC;
        return ret;
    }

    protected static AmazonS3DataHandlerBuilderFacade getNewAmazonS3FacadeFrom(DataHandlerBuilder from) {
        AmazonS3DataHandlerBuilderFacade ret = new AmazonS3DataHandlerBuilderFacade();
        ret.copyInfoFrom(from);
        ret.type = DataHandler.DATA_TYPE.CLOUD;
        ret.cloudType = DataHandler.CLOUD_TYPE.S3;
        ret.s3Type = DataHandler.S3_TYPE.AMAZON;
        return ret;
    }

    protected static ArubaCloudDataHandlerBuilderFacade getNewArubaCloudFacadeFrom(DataHandlerBuilder from) {
        ArubaCloudDataHandlerBuilderFacade ret = new ArubaCloudDataHandlerBuilderFacade();
        ret.copyInfoFrom(from);
        ret.type = DataHandler.DATA_TYPE.CLOUD;
        ret.cloudType = DataHandler.CLOUD_TYPE.S3;
        ret.s3Type = DataHandler.S3_TYPE.ARUBA;
        return ret;
    }

    public static GenericDataHandlerBuilderFacade get() {
        return DataHandlerBuilder.getNewGenericFacade();
    }

    protected DataHandlerBuilder() {
    }

    protected void copyInfoFrom(DataHandlerBuilder from) {
        this.type = from.type;
        this.name = from.name;
        this.totalSize = from.totalSize;
        this.byteData = from.byteData;
        this.fileData = from.fileData;
        this.streamInputData = from.streamInputData;
        this.streamOutputData = from.streamOutputData;
        this.urlCreds = from.urlCreds;
        this.urlEndpoint = from.urlEndpoint;
        this.urlNetConf = from.urlNetConf;
        this.cloudType = from.cloudType;
        this.s3Type = from.s3Type;
        this.s3Bucket = from.s3Bucket;
        this.s3Filepath = from.s3Filepath;
        this.genericS3ClientBuilder = from.genericS3ClientBuilder;
        this.as3UserId = from.as3UserId;
        this.as3SecretKey = from.as3SecretKey;
        this.arubaCloudUserId = from.arubaCloudUserId;
        this.arubaCloudSecretKey = from.arubaCloudSecretKey;
        this.arubaCloudEndpoint = from.arubaCloudEndpoint;
    }

    public InputHandler buildInput() throws FileNotFoundException, IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        switch (this.type) {
            case TEMP: {
                if (this.fileData != null) {
                    return new TempFileInputHandler(this.fileData);
                }
                if (this.suffix != null || this.prefix != null) {
                    return new TempFileInputHandler(this.prefix, this.suffix);
                }
                return new TempFileInputHandler();
            }
            case BYTE: {
                return new ByteInputHandler(this.byteData, this.name);
            }
            case FILE: {
                return new FileInputHandler(this.fileData, this.name);
            }
            case STREAM: {
                return new StreamInputHandler(this.streamInputData, this.name);
            }
            case URL: {
                return new URLInputHandler(this.urlEndpoint, this.urlNetConf, this.urlCreds);
            }
            case CLOUD: {
                switch (this.cloudType) {
                    case S3: {
                        switch (this.s3Type) {
                            case GENERIC: {
                                return new S3InputHandler(this.genericS3ClientBuilder, this.s3Bucket, this.s3Filepath, this.name);
                            }
                            case AMAZON: {
                                return new AmazonS3InputHandler(this.as3UserId, this.as3SecretKey, this.s3Bucket, this.s3Filepath, this.name);
                            }
                            case ARUBA: {
                                return new ArubaCloudS3InputHandler(this.arubaCloudEndpoint, this.arubaCloudUserId, this.arubaCloudSecretKey, this.s3Bucket, this.s3Filepath, this.name);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
            }
        }
        throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
    }

    public OutputHandler buildOutput() throws IOException, URISyntaxException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        switch (this.type) {
            case TEMP: {
                if (this.fileData != null) {
                    return new TempFileOutputHandler(this.fileData);
                }
                if (this.suffix != null || this.prefix != null) {
                    return new TempFileOutputHandler(this.prefix, this.suffix);
                }
                return new TempFileOutputHandler();
            }
            case BYTE: {
                return new ByteOutputHandler(this.name, this.totalSize);
            }
            case FILE: {
                return new FileOutputHandler(this.fileData, this.totalSize, this.replace);
            }
            case STREAM: {
                return new StreamOutputHandler(this.streamOutputData, this.name, this.totalSize);
            }
            case URL: {
                return new URLOutputHandler(this.urlEndpoint, this.urlNetConf, this.urlCreds, this.name, this.totalSize);
            }
            case CLOUD: {
                switch (this.cloudType) {
                    case S3: {
                        switch (this.s3Type) {
                            case GENERIC: {
                                return new S3OutputHandler(this.genericS3ClientBuilder, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                            case AMAZON: {
                                return new AmazonS3OutputHandler(this.as3UserId, this.as3SecretKey, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                            case ARUBA: {
                                return new ArubaCloudS3OutputHandler(this.arubaCloudEndpoint, this.arubaCloudUserId, this.arubaCloudSecretKey, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
            }
        }
        throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
    }

    public OutputHandler buildOutput(boolean replace) throws IOException, URISyntaxException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        switch (this.type) {
            case TEMP: {
                if (this.fileData != null) {
                    return new TempFileOutputHandler(this.fileData);
                }
                if (this.suffix != null || this.prefix != null) {
                    return new TempFileOutputHandler(this.prefix, this.suffix);
                }
                return new TempFileOutputHandler();
            }
            case BYTE: {
                return new ByteOutputHandler(this.name, this.totalSize);
            }
            case FILE: {
                return new FileOutputHandler(this.fileData, this.totalSize, replace);
            }
            case STREAM: {
                return new StreamOutputHandler(this.streamOutputData, this.name, this.totalSize);
            }
            case URL: {
                return new URLOutputHandler(this.urlEndpoint, this.urlNetConf, this.urlCreds, this.name, this.totalSize);
            }
            case CLOUD: {
                switch (this.cloudType) {
                    case S3: {
                        switch (this.s3Type) {
                            case GENERIC: {
                                return new S3OutputHandler(this.genericS3ClientBuilder, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                            case AMAZON: {
                                return new AmazonS3OutputHandler(this.as3UserId, this.as3SecretKey, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                            case ARUBA: {
                                return new ArubaCloudS3OutputHandler(this.arubaCloudEndpoint, this.arubaCloudUserId, this.arubaCloudSecretKey, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
            }
        }
        throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
    }
}

