/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.S3InputHandler;
import java.io.IOException;

public class ArubaCloudS3InputHandler
extends S3InputHandler {
    public ArubaCloudS3InputHandler(String serviceUrl, String userId, String secretKey, String bucket, String filepath, String name) throws IOException {
        if (serviceUrl == null) {
            throw new IllegalArgumentException("Please specify a non-null Aruba Cloud URL endpoint!");
        }
        if (userId == null) {
            throw new IllegalArgumentException("Please specify a non-null Aruba Cloud user id!");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("Please specify a non-null Aruba Cloud secret key!");
        }
        ClientConfiguration cc = new ClientConfiguration();
        cc.setSignerOverride("S3SignerType");
        AwsClientBuilder.EndpointConfiguration ec = new AwsClientBuilder.EndpointConfiguration(serviceUrl, "");
        AmazonS3ClientBuilder s3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(ec)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(userId, secretKey)))).withClientConfiguration(cc);
        this.initS3InputHandler(s3ClientBuilder, bucket, filepath, name);
        this.s3CloudType = DataHandler.S3_TYPE.ARUBA;
    }
}

