/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.util.TmpFileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TempFileOutputHandler
extends OutputHandler {
    protected File file = null;
    protected boolean deleteOnClose = true;

    public TempFileOutputHandler() throws IOException {
        this("handler", ".tmp");
    }

    public TempFileOutputHandler(String prefix, String suffix) throws IOException {
        this.file = TmpFileUtils.createTempFile(prefix, suffix);
        this.init();
    }

    public TempFileOutputHandler(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Please specify a non-null file!");
        }
        this.file = file;
        this.init();
    }

    private void init() throws FileNotFoundException, IOException {
        boolean isCreated;
        File fullPathFile = new File(this.file.getAbsolutePath());
        File parent = fullPathFile.getParentFile();
        if (!parent.exists() && !(isCreated = parent.mkdirs())) {
            throw new IOException("Unable to create the necessary directory structure for file " + this.file.getAbsolutePath() + ".");
        }
        if (parent.exists() && !parent.isDirectory()) {
            throw new IllegalArgumentException("Parent of " + this.file.getAbsolutePath() + " exists but it is not a folder.");
        }
        this.outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, this.file.getName(), null);
    }

    public void setDeleteOnClose(boolean deleteOnClose) throws IOException {
        this.deleteOnClose = deleteOnClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                super.close();
            }
            finally {
                if (this.deleteOnClose) {
                    this.file.delete();
                }
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFullPath() {
        return this.file.getAbsolutePath();
    }
}

