/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.enroll.CSRUtils;
import esecurity.enroll.bean.CertificateFields;
import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.AbstractSWKey;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.PureSWKey;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.ellips.capi.util.KeyUtils;
import it.actalis.ellips.capi.util.ini.IniFileException;
import it.actalis.ellips.capi.util.ini.SignedIniFile;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class SoftToken
extends TokenSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private boolean tokenSoftSia = false;
    private String tokenID = null;
    private String hmac = null;
    private boolean createNew = false;
    private boolean fromP12 = false;
    private static final String tokenIDnew = "Ellips Software Token v1.0";
    private String fileName = "Ellips.tok";
    private String path_sep = null;
    private boolean fileNameFixed = false;
    private String path = null;
    private String fullPath = null;
    private String pin = null;
    private X509Certificate[] p12SignerChain = null;
    private SignedIniFile ini = null;
    private static final String PROP_DATA = "data";
    private static final String PROP_CERT = "certificate";
    private static final String PROP_KEYS = "keys";
    private static final String PROP_KEY_CLASS = "keyclass";
    private static final String PROP_TYPE = "class";
    private static final String PROP_USE = "usage";
    private static final String TYPE_DATA = "1";
    private static final String TYPE_CERT = "2";
    private static final String TYPE_CRED_CERT = "4";
    private static final String TYPE_CRED_KEYS = "8";

    @Override
    public boolean exist(String alias) throws CapiException {
        if (this.ini == null) {
            throw new CapiException("Session not opened", 10013);
        }
        return this.ini.containsObject(alias);
    }

    @Override
    public String generateID(String[] args) {
        this.path = args[0];
        return this.path;
    }

    @Override
    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        this.tokenSoftSia = tokenSoftSia;
        this.initializeLib(args);
    }

    @Override
    public void initializeLib(String[] args) throws CapiException {
        if (args == null || args.length < 1 || args[0] == null) {
            throw new CapiException("Wrong args", 1001);
        }
        this.path = args[0];
        String path_nosep = null;
        this.path_sep = null;
        if (this.path.endsWith(File.separator)) {
            path_nosep = this.path.substring(0, this.path.length() - 1);
            this.path_sep = this.path;
        } else {
            path_nosep = this.path;
            this.path_sep = this.path + File.separator;
        }
        logger.debug("path_nosep :" + path_nosep);
        logger.debug("path_sep   :" + this.path_sep);
        if (!this.exists(this.path_sep) && !this.exists(path_nosep)) {
            throw new CapiException(this.path + " not exist", 12000);
        }
        if (!this.isDir(this.path_sep) && !this.isDir(path_nosep)) {
            throw new CapiException(this.path + " is not a directory", 12001);
        }
        this.createNew = false;
        if (args.length > 1 && args[1] != null && args[1].length() > 0) {
            this.createNew = true;
        }
        this.fallback(true);
        this.initProviders(this);
        logger.debug("init softToken");
    }

    @Override
    public void finalizeLib() {
        this.path = null;
    }

    public SoftToken(byte[] pkcs12, String pkcs12PIN) throws CapiException {
        this.initProviders(this);
        this.build(new ByteArrayInputStream(pkcs12), pkcs12PIN);
    }

    public SoftToken(InputStream is, String pkcs12PIN) throws CapiException {
        this.build(is, pkcs12PIN);
    }

    private void build(InputStream is, String pkcs12PIN) throws CapiException {
        logger.debug("init security providers");
        if (is == null || pkcs12PIN == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Key sk = null;
        it.actalis.ellips.capi.core.Certificate cert = null;
        String alias = null;
        int len = -1;
        KeyStore p12 = null;
        try {
            p12 = KeyStore.getInstance("PKCS12", ProvUtils.bcProvider);
            p12.load(is, pkcs12PIN.toCharArray());
        }
        catch (KeyStoreException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("KeyStoreException", 10035, e);
        }
        catch (IllegalArgumentException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("IllegalArgumentException-Cannot instance PKCS12", 10035, e);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException(e.getMessage(), 10036, e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("NoSuchAlgorithmException", 10035);
        }
        catch (CertificateException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CertificateException", 10035);
        }
        catch (ClassCastException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid PKCS12", 10035);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        try {
            Enumeration<String> aliases = p12.aliases();
            while (aliases.hasMoreElements()) {
                Certificate c;
                sk = null;
                String aliasRet = aliases.nextElement();
                if (!p12.isKeyEntry(aliasRet) || (sk = (PrivateKey)p12.getKey(aliasRet, pkcs12PIN.toCharArray())) == null || (c = p12.getCertificate(aliasRet)) == null) continue;
                cert = new it.actalis.ellips.capi.core.Certificate(c.getEncoded());
                alias = aliasRet;
                break;
            }
            if (cert == null) {
                throw new CapiException("PKCS12 Key and Certificate not found", 10035);
            }
            if (sk.getAlgorithm().equalsIgnoreCase("RSA")) {
                len = ((RSAKey)((Object)sk)).getModulus().bitLength();
                logger.debug("[SoftToken]pkcs12 key length=" + len);
            } else {
                PrivateKeyInfo info = PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])sk.getEncoded()));
                String curveName = ECNamedCurveTable.getName((ASN1ObjectIdentifier)((ASN1ObjectIdentifier)info.getPrivateKeyAlgorithm().getParameters().toASN1Primitive()));
                logger.debug("[SoftToken]pkcs12 Curve name =" + curveName);
            }
            logger.debug("[SoftToken]pkcs12alias=" + alias);
            try {
                Certificate[] chain = p12.getCertificateChain(alias);
                if (chain != null && chain.length > 0) {
                    this.p12SignerChain = new X509Certificate[chain.length];
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    for (int i = 0; chain != null && i < chain.length; ++i) {
                        ByteArrayInputStream in = new ByteArrayInputStream(chain[i].getEncoded());
                        this.p12SignerChain[i] = (X509Certificate)certFactory.generateCertificate(in);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.p12SignerChain = null;
            }
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        try {
            this.pin = pkcs12PIN;
            this.ini = new SignedIniFile();
            this.setPrivateKey(alias, (PrivateKey)sk, pkcs12PIN);
            this.ini.setProperty(alias, PROP_TYPE, TYPE_CRED_KEYS);
            this.ini.setProperty(alias, PROP_USE, Integer.toString(3));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error setting cred property", 10040);
        }
        logger.debug("[SoftToken]pkcs12 instcert...");
        try {
            PublicKey pk = null;
            if ((this.getObjectType(alias) & 0xC) <= 0) {
                throw new CapiException("Alias is not a credential", 10021);
            }
            pk = this.getPublicKey(alias);
            if (!cert.getPublicKey().equals(pk)) {
                throw new CapiException("Public key not corresponding", 10033);
            }
            try {
                this.ini.setProperty(alias, PROP_TYPE, TYPE_CRED_CERT);
                this.ini.setProperty(alias, PROP_CERT, cert.getEncoded());
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Error setting cert property", 10040);
            }
            SecureRandom random = new SecureRandom();
            String rnd = new BigInteger(130, random).toString(32);
            this.setId(rnd);
            Token.tokenTable.put(this.getId(), this);
            this.fromP12 = true;
            this.createNew = true;
            logger.debug("[SoftToken]pkcs12 instcert ok");
        }
        catch (CapiException e) {
            logger.debug("[SoftToken]install cert KO. " + e.getMessage());
            throw e;
        }
    }

    public SoftToken(KeyStore keyStore, String pkcs12PIN) throws CapiException {
        logger.debug("init security providers");
        this.initProviders(this);
        if (keyStore == null || pkcs12PIN == null) {
            throw new CapiException("Null parameters", 1001);
        }
        PrivateKey sk = null;
        it.actalis.ellips.capi.core.Certificate cert = null;
        String alias = null;
        int len = -1;
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate c;
                sk = null;
                String aliasRet = aliases.nextElement();
                if (!keyStore.isKeyEntry(aliasRet) || (sk = (PrivateKey)keyStore.getKey(aliasRet, pkcs12PIN.toCharArray())) == null || (c = keyStore.getCertificate(aliasRet)) == null) continue;
                cert = new it.actalis.ellips.capi.core.Certificate(c.getEncoded());
                alias = aliasRet;
                break;
            }
            if (cert == null) {
                throw new CapiException("PKCS12 Key and Certificate not found", 10035);
            }
            len = ((RSAKey)((Object)sk)).getModulus().bitLength();
            logger.debug("[SoftToken]pkcs12 key length=" + len);
            logger.debug("[SoftToken]pkcs12alias=" + alias);
            try {
                Certificate[] chain = keyStore.getCertificateChain(alias);
                if (chain != null && chain.length > 0) {
                    this.p12SignerChain = new X509Certificate[chain.length];
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    for (int i = 0; chain != null && i < chain.length; ++i) {
                        ByteArrayInputStream in = new ByteArrayInputStream(chain[i].getEncoded());
                        this.p12SignerChain[i] = (X509Certificate)certFactory.generateCertificate(in);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.p12SignerChain = null;
            }
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        try {
            this.pin = pkcs12PIN;
            this.ini = new SignedIniFile();
            this.setPrivateKey(alias, sk, pkcs12PIN);
            this.ini.setProperty(alias, PROP_TYPE, TYPE_CRED_KEYS);
            this.ini.setProperty(alias, PROP_USE, Integer.toString(3));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error setting cred property", 10040);
        }
        logger.debug("[SoftToken]pkcs12 instcert...");
        try {
            PublicKey pk = null;
            if ((this.getObjectType(alias) & 0xC) <= 0) {
                throw new CapiException("Alias is not a credential", 10021);
            }
            pk = this.getPublicKey(alias);
            if (!cert.getPublicKey().equals(pk)) {
                throw new CapiException("Public key not corresponding", 10033);
            }
            try {
                this.ini.setProperty(alias, PROP_TYPE, TYPE_CRED_CERT);
                this.ini.setProperty(alias, PROP_CERT, cert.getEncoded());
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Error setting cert property", 10040);
            }
            SecureRandom random = new SecureRandom();
            String rnd = new BigInteger(130, random).toString(32);
            this.setId(rnd);
            Token.tokenTable.put(this.getId(), this);
            this.fromP12 = true;
            this.createNew = true;
            logger.debug("[SoftToken]pkcs12 instcert ok");
        }
        catch (CapiException e) {
            logger.debug("[SoftToken]install cert KO. " + e.getMessage());
            throw e;
        }
    }

    public void destroy() {
        try {
            Token.tokenTable.remove(this.getId());
            this.p12SignerChain = null;
            logger.debug("[SoftToken] destroy done.");
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public X509Certificate[] getP12SignerChain() {
        return this.p12SignerChain;
    }

    public SoftToken() {
    }

    @Override
    public String[] getLibInfo() {
        String[] libInfo = new String[]{"Software", this.path, "Ellips software Token", "1.0", "Actalis S.p.A.", this.path, "Actalis S.p.A.", this.fileName, "Actalis S.p.A."};
        return libInfo;
    }

    @Override
    public boolean isTokenInserted() throws CapiException {
        this.fallback(false);
        try {
            if (this.fromP12) {
                return true;
            }
            if (this.createNew) {
                return this.exists(this.path);
            }
            return this.exists(this.fullPath) && this.isFile(this.fullPath);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public String getSerialNumber() throws CapiException {
        return "0";
    }

    @Override
    public String getLabel() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            byte[] tkid = null;
            if (this.ini == null) {
                SignedIniFile dummy = new SignedIniFile("dummyID");
                tkid = dummy.loadHeader(this.fullPath, false);
            } else {
                tkid = this.ini.loadHeader(this.fullPath, false);
            }
            this.tokenID = new String(tkid, "ISO8859_1");
            return this.tokenID;
        }
        catch (IniFileException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("TokenID cannot be retrieved", 12003);
        }
    }

    @Override
    public int getMaxRSAKeyLength() throws CapiException {
        return 4096;
    }

    @Override
    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    @Override
    public int getFreeSpace() throws CapiException {
        return -1;
    }

    @Override
    public void openSession(boolean asSO, String pin, int slotz) throws CapiException {
        this.openSession(asSO, pin);
    }

    @Override
    public void openSession(boolean asSO, String pin) throws CapiException {
        if (this.fromP12) {
            return;
        }
        this.fallback(false);
        this.pin = pin;
        if (this.createNew && !this.exists(this.fullPath)) {
            this.ini = new SignedIniFile(tokenIDnew);
        } else {
            try {
                this.ini = new SignedIniFile(this.fullPath, Util.getBytes(pin));
            }
            catch (UnrecoverableKeyException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Wrong PIN", 2000);
            }
            catch (FileNotFoundException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Token not initalized", 10010);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Wrong token format", 12003);
            }
        }
    }

    @Override
    public void openSessionAuthPath(boolean asSO) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    @Override
    public void openPublicSession() throws CapiException {
        throw new CapiException("openPublicSession not supported", 1004);
    }

    @Override
    public void closeSession() throws CapiException {
        this.ini = null;
        this.pin = null;
    }

    @Override
    public boolean isSessionOpen() throws CapiException {
        if (this.ini == null) {
            return false;
        }
        if (!this.isTokenInserted()) {
            logger.debug("Token not inserted");
            this.closeSession();
            return false;
        }
        if (this.fromP12) {
            return true;
        }
        if (this.createNew && !this.exists(this.fullPath)) {
            logger.debug("create new to check ...");
            return true;
        }
        try {
            byte[] tkid = this.ini.loadHeader(this.fullPath, true);
            return true;
        }
        catch (IniFileException c) {
            logger.debug(c.getMessage(), (Throwable)c);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            logger.debug("token probably removed ");
        }
        this.closeSession();
        return false;
    }

    @Override
    public byte[] getData(String alias) throws CapiException {
        try {
            return Util.base64DecodeStr(this.ini.getProperty(alias, PROP_DATA));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Alias is not a data object", 10020);
        }
    }

    @Override
    public void setData(String alias, byte[] data, int mode) throws CapiException {
        this.removeObjects(alias, mode);
        try {
            this.ini.setProperty(alias, PROP_TYPE, TYPE_DATA);
            this.ini.setProperty(alias, PROP_DATA, Util.base64EncodeStr(data));
            this.ini.store(this.fullPath, Util.getBytes(this.pin));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public String getCert(String alias) throws CapiException {
        try {
            return this.ini.getProperty(alias, PROP_CERT);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Alias is not a cert", 10022);
        }
    }

    @Override
    public void setCert(String alias, byte[] cert, int mode, boolean dummy) throws CapiException {
        this.removeObjects(alias, mode);
        it.actalis.ellips.capi.core.Certificate c = new it.actalis.ellips.capi.core.Certificate(cert);
        try {
            this.ini.setProperty(alias, PROP_TYPE, TYPE_CERT);
            this.ini.setProperty(alias, PROP_CERT, c.getEncoded());
            this.ini.store(this.fullPath, Util.getBytes(this.pin));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public String installCertificate(it.actalis.ellips.capi.core.Certificate cert) throws CapiException {
        logger.debug("installCertificate find alias ...");
        PublicKey pubKey = null;
        String pubKeyAlias = null;
        for (String alias : this.ini.getObjectList2()) {
            if ((this.getObjectType(alias) & 0xC) <= 0) continue;
            PublicKey pk = this.getPublicKey(alias);
            try {
                cert.getInternalCert().verify(pk);
                if (!this.checkKeyUsage(this.getKeyUsage(alias, true), cert.getKeyUsageBits())) continue;
                pubKey = pk;
                pubKeyAlias = alias;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pubKey == null) {
            throw new CapiException("Public key not corresponding", 10033);
        }
        logger.debug("Public key Found {}", pubKeyAlias);
        this.instCert(pubKeyAlias, cert, true, false);
        return pubKeyAlias;
    }

    @Override
    public void changePIN(String oldPin, String newPin) throws CapiException {
        boolean wasLogged = false;
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        if (this.isSessionOpen()) {
            wasLogged = true;
        } else {
            this.openSession(false, oldPin);
        }
        String[] all_keys = this.listObjects(null, (byte)12);
        for (int i = 0; i < all_keys.length; ++i) {
            this.recipherPrivateKey(all_keys[i], oldPin, newPin);
        }
        try {
            this.ini.store(this.fullPath, Util.getBytes(newPin));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
        this.pin = newPin;
        if (!wasLogged) {
            this.closeSession();
        }
    }

    @Override
    public void changePUK(String oldPin, String newPin) throws CapiException {
        throw new CapiException("Change PUK not supported", 1004);
    }

    @Override
    public void unblockPIN(String PUK, String newPin) throws CapiException {
        throw new CapiException("Unblock not supported", 1004);
    }

    @Override
    public boolean canImport() {
        return true;
    }

    @Override
    public boolean canExport(String alias) {
        return true;
    }

    @Override
    public int canUnblock() {
        return 0;
    }

    @Override
    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        this.genKeyPair(alias, KeyAlgo.RSA, type, bits, mode);
    }

    @Override
    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        this.removeObjects(alias, mode);
        PureSWKey kp = new PureSWKey(alias, algo, this.pin, bits);
        byte[] sk = ((AbstractSWKey)kp).getEncoded();
        try {
            this.ini.setProperty(alias, PROP_TYPE, TYPE_CRED_KEYS);
            this.ini.setProperty(alias, PROP_USE, Integer.toString(type));
            this.ini.setProperty(alias, PROP_KEYS, Util.base64EncodeStr(sk));
            this.ini.store(this.fullPath, Util.getBytes(this.pin));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        this.removeObjects(alias, mode);
        this.setPrivateKey(alias, sk, this.pin);
        try {
            this.ini.setProperty(alias, PROP_TYPE, TYPE_CRED_KEYS);
            this.ini.setProperty(alias, PROP_USE, Integer.toString(type));
            this.ini.store(this.fullPath, Util.getBytes(this.pin));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
        return alias;
    }

    @Override
    public PrivateKey expCred(String alias) throws CapiException {
        return this.getPrivateKeySpi(alias, this.pin);
    }

    @Override
    public PublicKey getPublicKey(String alias) throws CapiException {
        try {
            return KeyUtils.rebuildPublicKeyFromPrivate((AbstractSWKey)this.getPrivateKey(alias, this.pin));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error getting key", 10021);
        }
    }

    public PrivateKey getPrivateKey(String alias, String pin) throws CapiException {
        try {
            AbstractSWKey ret;
            String sk = this.ini.getProperty(alias, PROP_KEYS);
            String clazz = this.ini.getProperty(alias, PROP_KEY_CLASS);
            logger.debug("[getPrivateKey] keyclass is: " + clazz);
            if (clazz == null || clazz.compareTo("it.actalis.ellips.capi.provider.PureSWKey") == 0) {
                logger.debug("[getPrivateKey] PureSWKey ... TokenSpi.fromPKCS8");
                ret = new PureSWKey(alias, pin, Util.base64DecodeStr(sk));
            } else {
                logger.debug("[getPrivateKey] AbstractSWKey");
                ret = (AbstractSWKey)Class.forName(clazz, false, Thread.currentThread().getContextClassLoader()).newInstance();
                ret.setAlias(alias);
                ret.setEncoded(Util.base64DecodeStr(sk));
                ret.setPin(pin);
            }
            ret.setCryptoDev(this);
            return ret;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error getting key", 10021);
        }
    }

    public void recipherPrivateKey(String alias, String oldpin, String newpin) throws CapiException {
        try {
            AbstractSWKey k;
            String str = this.ini.getProperty(alias, PROP_KEYS);
            String clazz = this.ini.getProperty(alias, PROP_KEY_CLASS);
            logger.debug("[recipherPrivateKey] keyclass is: " + clazz);
            if (clazz == null || clazz.compareTo("it.actalis.ellips.capi.PureSWKey") == 0) {
                logger.debug("[recipherPrivateKey] PureSWKey ... TokenSpi.fromPKCS8");
                logger.debug("keys for " + alias + ": " + str);
                PureSWKey key = new PureSWKey(alias, oldpin, Util.base64DecodeStr(str));
                key.setCryptoDev(this);
                k = new PureSWKey(alias, newpin, ((AbstractSWKey)key).getPrivateKeySpi());
                k.setCryptoDev(this);
            } else {
                logger.debug("[recipherPrivateKey] AbstractSWKey");
                AbstractSWKey key = (AbstractSWKey)Class.forName(clazz, false, Thread.currentThread().getContextClassLoader()).newInstance();
                key.setAlias(alias);
                key.setEncoded(Util.base64DecodeStr(str));
                key.setPin(oldpin);
                key.setCryptoDev(this);
                k = key;
                k.setCryptoDev(this);
                k.setPin(newpin);
            }
            byte[] sk = k.getEncoded();
            logger.debug(sk == null ? "[recipherPrivateKey] sk is null" : "[setPrivateKey] sk is not null");
            logger.debug("[recipherPrivateKey][ini.setProperty] alias:" + alias + " keyclass:" + k.getClass().getName());
            this.ini.setProperty(alias, PROP_KEY_CLASS, k.getClass().getName());
            logger.debug("[ini.setProperty] alias:" + alias + " keys:" + Util.base64EncodeStr(sk));
            this.ini.setProperty(alias, PROP_KEYS, Util.base64EncodeStr(sk));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error getting key", 10021);
        }
    }

    public PrivateKey getPrivateKeySpi(String alias, String pin) throws CapiException {
        try {
            String sk = this.ini.getProperty(alias, PROP_KEYS);
            PKCS8EncodedKeySpec keySpec = SoftToken.fromPKCS8(Util.base64DecodeStr(sk), pin);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey pk = kf.generatePrivate(keySpec);
            return pk;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error getting key", 10021);
        }
    }

    @Override
    public void instCert(String alias, it.actalis.ellips.capi.core.Certificate c, boolean enforceKeyUsage, boolean dummy) throws CapiException {
        PublicKey pk = null;
        if ((this.getObjectType(alias) & 0xC) <= 0) {
            throw new CapiException("Alias is not a credential", 10021);
        }
        pk = this.getPublicKey(alias);
        if (!c.getPublicKey().equals(pk)) {
            throw new CapiException("Public key not corresponding", 10033);
        }
        if (enforceKeyUsage && !this.checkKeyUsage(this.getKeyUsage(alias, true), c.getKeyUsageBits())) {
            throw new CapiException("Key usage not corresponding", 10037);
        }
        try {
            this.ini.setProperty(alias, PROP_TYPE, TYPE_CRED_CERT);
            this.ini.setProperty(alias, PROP_CERT, c.getEncoded());
            this.ini.store(this.fullPath, Util.getBytes(this.pin));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        try {
            String res = this.ini.getProperty(alias, PROP_USE);
            return Integer.parseInt(res);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Not a credential", 10021);
        }
    }

    @Override
    public int getKeyLength(String alias) throws CapiException {
        try {
            PublicKey key = this.getPublicKey(alias);
            int realLen = ((RSAKey)((Object)key)).getModulus().bitLength();
            int len = (realLen + 255) / 256 * 256;
            logger.debug("getKeyLength alias=" + alias + " value=" + realLen + " ->" + len);
            return len;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
    }

    @Override
    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        logger.debug("doSign alias=" + alias);
        try {
            AbstractSWKey sk = (AbstractSWKey)this.getPrivateKey(alias, this.pin);
            logger.debug("signing RSA LENGTH: in=" + digest.length);
            logger.debug("hash  : " + new String(Hex.encode((byte[])digest)));
            if (sk.getAlgorithm().equalsIgnoreCase("RSA")) {
                if (mode == 3) {
                    sk.init("RSA/ECB/NoPadding", 1);
                } else {
                    sk.init("RSA/ECB/PKCS1Padding", 1);
                }
            }
            byte[] res = sk.doFinal(digest, mode);
            logger.debug("result: " + new String(Hex.encode((byte[])res)));
            return res;
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature", 3010);
        }
    }

    @Override
    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        logger.debug("doDecrypt alias=" + alias);
        try {
            AbstractSWKey sk = (AbstractSWKey)this.getPrivateKey(alias, this.pin);
            logger.debug("RSA LENGTH: in=" + digest.length);
            logger.debug("digest: " + new String(Hex.encode((byte[])digest)));
            if (mode == 4) {
                sk.init("RSA/ECB/NoPadding", 2);
            } else {
                sk.init("RSA/ECB/PKCS1Padding", 2);
            }
            byte[] res = sk.doFinal(digest, mode);
            logger.debug("result: " + new String(Hex.encode((byte[])res)));
            return res;
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature", 3010);
        }
    }

    @Override
    public String[] listObjects(String expr, byte filter) throws CapiException {
        try {
            String[] objs = this.ini.getObjectList2();
            if (objs == null) {
                return new String[0];
            }
            String[] labels = new String[objs.length];
            int j = 0;
            for (int i = 0; i < objs.length; ++i) {
                if ((this.getObjectType(objs[i]) & filter) == 0 || expr != null && objs[i].indexOf(expr) < 0) continue;
                labels[j++] = objs[i];
            }
            if (j == 0) {
                return new String[0];
            }
            String[] res = new String[j];
            for (int i = 0; i < j; ++i) {
                res[i] = labels[i];
            }
            return res;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("internal error", 1003);
        }
    }

    @Override
    public void deleteObject(String alias) throws CapiException {
        try {
            if (this.ini.removeObject(alias)) {
                this.ini.store(this.fullPath, Util.getBytes(this.pin));
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public byte getObjectType(String alias) throws CapiException {
        try {
            String typeStr = this.ini.getProperty(alias, PROP_TYPE);
            int typeInt = Integer.valueOf(typeStr);
            return (byte)typeInt;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong alias", 10023);
        }
    }

    @Override
    public int getObjectSize(String alias) throws CapiException {
        return -1;
    }

    @Override
    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        if (!this.ini.containsObject(oldAlias)) {
            throw new CapiException("Object not found", 10023);
        }
        this.removeObjects(newAlias, mode);
        try {
            if (this.ini.renameObject(oldAlias, newAlias)) {
                this.ini.store(this.fullPath, Util.getBytes(this.pin));
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public int getMaxPINLen() throws CapiException {
        return 80;
    }

    @Override
    public int getMinPINLen() throws CapiException {
        return 8;
    }

    private void fallback(boolean trying) {
        logger.debug("trying fallback " + trying);
        if (trying) {
            this.fileNameFixed = false;
        } else {
            if (this.fileNameFixed) {
                return;
            }
            this.fileNameFixed = true;
        }
        this.fileName = "Ellips.tok";
        this.fullPath = this.path_sep + this.fileName;
        if (this.createNew) {
            if (this.tokenSoftSia) {
                this.fileName = "SIAsecure.tok";
                this.fullPath = this.path_sep + this.fileName;
            }
            return;
        }
        if (this.exists(this.fullPath) && this.isFile(this.fullPath)) {
            return;
        }
        this.fileName = "SIAsecure.tok";
        this.fullPath = this.path_sep + this.fileName;
        if (this.exists(this.fullPath) && this.isFile(this.fullPath)) {
            return;
        }
        this.fileName = this.tokenSoftSia ? "SIAsecure.tok" : "Ellips.tok";
        this.fullPath = this.path_sep + this.fileName;
        logger.debug("path full  :" + this.fullPath);
    }

    private boolean exists(String name) {
        try {
            File file = new File(name);
            logger.debug("exists? " + file.getAbsolutePath());
            return file.exists();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean isDir(String name) {
        try {
            File file = new File(name);
            logger.debug("canonical dir:" + file.getCanonicalPath());
            return file.isDirectory();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean isFile(String name) {
        try {
            File file = new File(name);
            logger.debug("canonical file:" + file.getCanonicalPath());
            return file.isFile();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void setPrivateKey(String alias, PrivateKey key, String pin) throws CapiException {
        try {
            AbstractSWKey k;
            if (key instanceof AbstractSWKey) {
                logger.debug("[setPrivateKey] key instanceof AbstractSWKey");
                k = (AbstractSWKey)key;
            } else {
                logger.debug("[setPrivateKey] key instanceof PureSWKey");
                k = new PureSWKey(alias, pin, key);
            }
            k.setCryptoDev(this);
            byte[] sk = null;
            if (key instanceof AbstractSWKey) {
                logger.debug("[setPrivateKey] AbstractSWKey.getEncoded()");
                sk = k.getEncoded();
            } else {
                logger.debug("[setPrivateKey] PureSWKey.getForcedEncoded()");
                sk = k.getForcedEncoded(pin);
            }
            logger.debug("[ini.setProperty] alias:" + alias + " keyclass:" + k.getClass().getName());
            this.ini.setProperty(alias, PROP_KEY_CLASS, k.getClass().getName());
            logger.debug("[ini.setProperty] alias:" + alias + " keys:" + Util.base64EncodeStr(sk));
            this.ini.setProperty(alias, PROP_KEYS, Util.base64EncodeStr(sk));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error writing file", 12004);
        }
    }

    private void removeObjects(String alias, int mode) throws CapiException {
        if (this.ini == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (mode == 2) {
            throw new CapiException("Unsupported multiple mode on token software", 10034);
        }
        if (this.ini.containsObject(alias) && mode == 0) {
            throw new CapiException("Object already exist", 10024);
        }
        this.ini.removeObject(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) throws CapiException {
        return this.getPrivateKey(alias, this.pin);
    }

    @Override
    public String getLibName() {
        return null;
    }

    @Override
    public String getObjectID(String alias) throws CapiException {
        return null;
    }

    @Override
    public void setCert(String alias, it.actalis.ellips.capi.core.Certificate cert, int mode, byte[] id2, boolean ckapriv) throws CapiException {
    }

    @Override
    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
    }

    @Override
    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        CertificationRequestInfo reqInfo = null;
        SubjectPublicKeyInfo spki = null;
        try {
            spki = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), key.getEncoded());
            reqInfo = new CertificationRequestInfo(subject, spki, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature sig = Signature.getInstance("SHA1withRSA", ActalisSingleton.getActalisProvider());
        sig.initSign(signingKey);
        try {
            sig.update(reqInfo.getEncoded("DER"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + e);
        }
        CertificationRequestInfo cri = new CertificationRequestInfo(subject, spki, null);
        CertificationRequest cr = new CertificationRequest(cri, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE), new DERBitString(sig.sign()));
        return cr;
    }

    @Override
    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        return this.certReq(subject, rsapk, rsask, Security.getProvider(provname));
    }

    @Override
    public String certReq(String alias, X500Name subject) throws CapiException {
        return this.certReq(subject, this.getPublicKey(alias), this.getPrivateKey(alias), ProvUtils.actalisProvider);
    }

    @Override
    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, GeneralNames[] subjectAlternativeNames, String challengePasssword) throws CapiException {
        byte[] arrReturn = null;
        CertificateFields fields = null;
        try {
            fields = new CertificateFields(CN);
        }
        catch (IllegalArgumentException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Invalid CN: " + CN, 1003);
        }
        int counter = 0;
        String label = "GenericKey%d";
        String finalLabel = "";
        KeyPair pair = null;
        for (int i = counter; i < counter + 3; ++i) {
            block11: {
                try {
                    finalLabel = String.format(label, i);
                    this.genKeyPair(finalLabel, keyAlgo, 1, keySize, 0);
                    pair = new KeyPair(this.getPublicKey(finalLabel), this.getPrivateKey(finalLabel));
                }
                catch (CapiException ex) {
                    if (ex.getErrorCode() == 11002) {
                        throw ex;
                    }
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (keyType == KeyType.CNS) {
                        throw new CapiException("Unable To Generate Key", 10032, ex);
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (keyType != KeyType.CNS) break block11;
                    throw new CapiException("Unable To Generate Key", 10032, ex);
                }
            }
            if (pair != null) break;
        }
        if (pair == null) {
            throw new CapiException("Unable To Generate Key", 10032);
        }
        try {
            PKCS10CertificationRequest ret = CSRUtils.generateCertificateRequest(ProvUtils.actalisProvider, pair, fields, subjectAlternativeNames);
            arrReturn = ret.getEncoded();
        }
        catch (IOException | NoSuchAlgorithmException | OperatorCreationException ex) {
            this.deleteObject(finalLabel);
            throw new CapiException("Unable To Generate Csr", 1003, ex);
        }
        return arrReturn;
    }

    @Override
    public void initializeLib(TokenParameters param) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean requiredExtendedAuth() {
        return false;
    }

    @Override
    public RecoverySessionCredential openSessionWithExtendedAuth(boolean asSO, String pin, ExtendedCredentials cred) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, Provider prov) throws CapiException {
        Object certReqInfo = null;
        Object cReq = null;
        PKCS10CertificationRequest p10 = null;
        try {
            logger.debug("creating and signing certreq...");
            logger.debug("subject: " + subject.toString());
            JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(subject, rsapk);
            p10 = requestBuilder.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider(prov).build(rsask));
            logger.debug("certRequest ok");
        }
        catch (IllegalStateException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("IllegalStateException", 1003);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("NoSuchProviderException", 1003);
        }
        try {
            StringWriter strWriter = new StringWriter();
            PEMWriter pemWrt = new PEMWriter((Writer)strWriter);
            pemWrt.writeObject((Object)p10);
            pemWrt.close();
            String temp = new String(strWriter.getBuffer());
            return temp;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception saving PEM certificate Requet", 1003);
        }
    }

    @Override
    public void resetToken(String puk) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

