/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.CertificateExpiredException;
import it.actalis.ellips.capi.core.CertificateNotYetValidException;
import it.actalis.ellips.capi.core.KnownP11LibraryInfo;
import it.actalis.ellips.capi.core.KnownSmartcardInfo;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ATRHashtable;
import it.actalis.ellips.util.ATR;
import it.actalis.ellips.util.ATRException;
import it.actalis.ellips.util.java6.PCSC6;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;

public class Token {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static long TlastDestroyTM = 0L;
    private boolean tokenSoftSia = false;
    private String customizedSlot = null;
    private static Map p11list = null;
    private static ATRHashtable p11list_ATR = null;
    private static Hashtable p11list_Libs = null;
    private static String OSName = null;
    private static KnownSmartcardInfo[] knownSC = null;
    private static KnownP11LibraryInfo[] knownP11 = null;
    protected static Hashtable tokenTable = new Hashtable();
    private static TokenSpi tk = null;
    private static String tksem = "semaphore for init and destroy";
    static boolean debug = false;
    static final int MIN_SECURE_RSAKEY_LEN = 768;

    public final void init(String tokenType, String[] args, boolean tokenSoftSia) throws CapiException {
        this.tokenSoftSia = tokenSoftSia;
        this.init("SoftToken", args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(String tokenType, String[] args) throws CapiException {
        if (tokenType == null) {
            logger.debug("Token initialization with null parameters");
            throw new CapiException("Null parameters", 1001);
        }
        if (tokenType.equals("PKCS11Token")) {
            logger.debug("parsing Token PKCS11...");
            long waitms = 5000L;
            try {
                if (args != null && args.length > 3 && args[3] != null) {
                    long waitms_args;
                    waitms = waitms_args = Long.parseLong(args[3]);
                }
            }
            catch (NumberFormatException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            if (TlastDestroyTM != 0L) {
                long elapsed = System.currentTimeMillis() - TlastDestroyTM;
                logger.debug("elapsed after last destroy: " + elapsed + " ms");
                if (elapsed >= 0L) {
                    if (waitms > elapsed) {
                        waitms -= elapsed;
                        try {
                            logger.debug("SLEEP start");
                            Thread.sleep(waitms);
                            logger.debug("SLEEP stop");
                            logger.debug("slept: " + waitms + " ms");
                        }
                        catch (InterruptedException e) {
                            logger.debug(e.getMessage());
                        }
                    } else {
                        try {
                            logger.debug("SLEEP start");
                            Thread.sleep(waitms);
                            logger.debug("SLEEP stop");
                        }
                        catch (InterruptedException e) {
                            logger.debug(e.getMessage());
                        }
                    }
                } else {
                    try {
                        logger.debug("SLEEP start");
                        Thread.sleep(waitms);
                        logger.debug("SLEEP stop");
                    }
                    catch (InterruptedException e) {
                        logger.debug(e.getMessage());
                    }
                }
            } else {
                try {
                    Thread.sleep(waitms);
                    logger.debug("first time slept: " + waitms + " ms");
                }
                catch (InterruptedException e) {
                    logger.debug(e.getMessage());
                }
            }
            for (int i = 0; i < 20 && tk != null; ++i) {
                try {
                    logger.debug("loop " + i + ": waiting tk null for 100ms");
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.debug(e.getMessage());
                }
            }
        }
        String string = tksem;
        synchronized (string) {
            if (tk != null) {
                logger.debug("Token already initialized");
                throw new CapiException("Token already initialized", 10002);
            }
            tk = TokenHelper.initToken(tokenType, args);
            String id = tk.getClass().getName() + ":" + tk.generateID(args);
            if (tokenTable.containsKey(id)) {
                logger.debug("Token cached with id:" + id);
                tk = (TokenSpi)tokenTable.get(id);
                logger.debug("Token already initialized");
                throw new CapiException("Token already initialized", 10002);
            }
            tk.setId(id);
            logger.debug("Token loaded, now initializing...");
            try {
                tk.initializeLib(args, this.isTokenSoftSia());
                tokenTable.put(tk.getId(), tk);
                logger.debug("Token initialized");
            }
            catch (CapiException e) {
                logger.debug("Token NOT initialized");
                logger.debug(e.getMessage(), (Throwable)e);
                tk = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() throws CapiException {
        String string = tksem;
        synchronized (string) {
            logger.debug("destroy");
            this.customizedSlot = null;
            if (tk != null) {
                tokenTable.remove(tk.getId());
                TlastDestroyTM = System.currentTimeMillis();
                logger.debug("finalize starting at TlastDestroyTM: " + TlastDestroyTM + " ms");
                tk.finalizeLib();
                tk = null;
                TlastDestroyTM = System.currentTimeMillis();
                logger.debug("finalize ok at TlastDestroyTM: " + TlastDestroyTM + " ms");
            }
        }
    }

    public final String[] getInfo() throws CapiException {
        logger.debug("getInfo");
        if (tk == null) {
            throw new CapiException("Token not initalized", 10003);
        }
        return tk.getLibInfo();
    }

    public final void login(String PIN) throws CapiException {
        logger.debug("login");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (PIN == null) {
            throw new CapiException("Null parameters", 1001);
        }
        tk.openSession(false, PIN);
        logger.debug("login OK");
    }

    public final void login(int slot, String PIN) throws CapiException {
        logger.debug("slot - login");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (PIN == null) {
            throw new CapiException("Null parameters", 1001);
        }
        tk.openSession(false, PIN, slot);
        logger.debug("login OK");
    }

    public final void openPublicSession() throws CapiException {
        logger.debug("openPublicSession");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tk.openPublicSession();
        logger.debug("openPublicSession OK");
    }

    public final void login() throws CapiException {
        logger.debug("login");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tk.openSessionAuthPath(false);
        logger.debug("login OK");
    }

    public final void logout() throws CapiException {
        logger.debug("logout");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        tk.closeSession();
    }

    public final boolean isLogged() throws CapiException {
        logger.debug("isLogged");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.isSessionOpen();
    }

    public final boolean isAvailable() throws CapiException {
        logger.debug("isAvailable");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.isTokenInserted();
    }

    public final String getLabel() throws CapiException {
        logger.debug("getLabel");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.getLabel();
    }

    public final String getSerialNumber() throws CapiException {
        logger.debug("getSerialNumber");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.getSerialNumber();
    }

    public final int getMaxRSAKeyLength() throws CapiException {
        logger.debug("getMaxRSAKeyLength");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        int mkeylen = tk.getMaxRSAKeyLength();
        logger.debug("MaxRSAKeyLength is: " + mkeylen);
        return mkeylen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changePUK(String oldPin, String newPin) throws CapiException {
        logger.debug("changePUK");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (oldPin == null || newPin == null) {
            throw new CapiException("Null parameters", 1001);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.changePUK(oldPin, newPin);
        }
        logger.debug("changePUK OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changePIN(String oldPin, String newPin) throws CapiException {
        logger.debug("changePIN");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (oldPin == null || newPin == null) {
            throw new CapiException("Null parameters", 1001);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.changePIN(oldPin, newPin);
        }
        logger.debug("changePIN OK");
    }

    public final byte[] getData(String alias) throws CapiException {
        logger.debug("getData (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getData(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setData(String alias, byte[] data, int mode) throws CapiException {
        logger.debug("setData (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (data == null || alias == null || alias.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        this.checkRange("mode", mode, 0, 2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.setData(alias, data, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
        logger.debug("setCkaId (alias= " + label + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (label == null || newLabel == null || newId == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.setCkaId(label, newLabel, newId);
        }
    }

    public final String getCertificate(String alias) throws CapiException {
        logger.debug("getCertificate (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getCert(alias);
    }

    public final void setCertificate(String alias, byte[] cert, int mode) throws CapiException {
        this.setCertificate(alias, cert, mode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCertificate(String alias, byte[] cert, int mode, boolean privateCert) throws CapiException {
        logger.debug("setCertificate (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || alias.length() == 0 || cert == null) {
            throw new CapiException("Null parameters", 1001);
        }
        this.checkRange("mode", mode, 0, 2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.setCert(alias, cert, mode, privateCert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setCert(String alias, it.actalis.ellips.capi.core.Certificate cert, int mode, byte[] id, boolean ckapriv) throws CapiException {
        logger.debug("setCertificate (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || alias.length() == 0 || cert == null) {
            throw new CapiException("Null parameters", 1001);
        }
        this.checkRange("mode", mode, 0, 2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.setCert(alias, cert, mode, id, ckapriv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installCertificate(it.actalis.ellips.capi.core.Certificate cert) throws CapiException {
        logger.debug("installCertificate");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.installCertificate(cert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateRSAKeyPair(String alias, int usage, int bits, int mode) throws CapiException {
        logger.debug("generateRSAKeyPair (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || alias.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        this.checkRange("mode", mode, 0, 2);
        this.checkRange("usage", usage, 1, 3);
        this.checkRSAKeyLen(bits);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            int bitLength = 0;
            int attempt = 0;
            boolean keyLengthKO = false;
            do {
                tk.genKeyPair(alias, usage, bits, mode);
                try {
                    RSAPublicKey key = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(tk.getPublicKey(alias).getEncoded()));
                    bitLength = key.getModulus().bitLength();
                    if (bitLength == bits) {
                        keyLengthKO = false;
                        logger.debug(alias + ": keypair length ok (" + bitLength + " bit)");
                        continue;
                    }
                    keyLengthKO = true;
                    logger.debug(alias + ": keypair length ko (" + bitLength + " bit)");
                    try {
                        tk.deleteObject(alias);
                        logger.debug("keypair deleted");
                    }
                    catch (CapiException delEx) {
                        delEx.printStackTrace();
                    }
                }
                catch (Exception e) {
                    keyLengthKO = false;
                    logger.debug(alias + ": keypair invalid");
                    try {
                        tk.deleteObject(alias);
                        logger.debug("keypair deleted");
                    }
                    catch (CapiException delEx) {
                        delEx.printStackTrace();
                    }
                }
            } while (keyLengthKO && ++attempt < 5);
            if (keyLengthKO) {
                throw new CapiException("keypair length error (" + bitLength + " <> " + bits + ")", 10031);
            }
        }
    }

    public boolean canImportKeys() throws CapiException {
        logger.debug("canImportKeys");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.canImport();
    }

    public boolean canExportKeys(String alias) throws CapiException {
        logger.debug("canExportKeys (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            return tk.canExport(null);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        if ((this.getObjectType(alias) & 0xC) == 0) {
            throw new CapiException("Alias is not a credential", 10021);
        }
        logger.debug("canExport tk ... calling ");
        return tk.canExport(alias);
    }

    public final void importPKCS12(String alias, byte[] pkcs12, String pkcs12PIN, int mode, int usage, boolean enforceKeyUsage) throws CertificateExpiredException, CapiException {
        this.importPKCS12(alias, pkcs12, pkcs12PIN, mode, usage, enforceKeyUsage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importPKCS12(String alias, byte[] pkcs12, String pkcs12PIN, int mode, int usage, boolean enforceKeyUsage, boolean privateCert) throws CertificateExpiredException, CapiException {
        logger.debug("importPKCS12 (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || alias.length() == 0 || pkcs12 == null || pkcs12PIN == null) {
            throw new CapiException("Null parameters", 1001);
        }
        this.checkRange("mode", mode, 0, 2);
        this.checkRange("usage", usage, 1, 3);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        PrivateKey sk = null;
        it.actalis.ellips.capi.core.Certificate cert = null;
        int len = -1;
        KeyStore p12 = null;
        try {
            logger.debug("loading pkcs12 ...");
            p12 = KeyStore.getInstance("PKCS12", ProvUtils.bcProvider);
            p12.load(new ByteArrayInputStream(pkcs12), pkcs12PIN.toCharArray());
        }
        catch (KeyStoreException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("KeyStoreException", 10035);
        }
        catch (IllegalArgumentException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("IllegalArgumentException-Cannot instance PKCS12", 10035);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException(e.getMessage(), 10036);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("NoSuchAlgorithmException", 10035);
        }
        catch (CertificateException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CertificateException", 10035);
        }
        catch (ClassCastException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid PKCS12", 10035);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        try {
            Enumeration<String> aliases = p12.aliases();
            logger.debug("extracting pkcs12 key ...");
            while (aliases.hasMoreElements()) {
                Certificate c;
                sk = null;
                String aliasRet = aliases.nextElement();
                if (!p12.isKeyEntry(aliasRet) || (sk = (PrivateKey)p12.getKey(aliasRet, pkcs12PIN.toCharArray())) == null || (c = p12.getCertificate(aliasRet)) == null) continue;
                cert = new it.actalis.ellips.capi.core.Certificate(c.getEncoded());
                break;
            }
            if (cert == null) {
                throw new CapiException("PKCS12 Key and Certificate not found", 10035);
            }
            if (cert.getInternalCert().getKeyUsage() == null || !cert.getInternalCert().getKeyUsage()[2] && !cert.getInternalCert().getKeyUsage()[3] && !cert.getInternalCert().getKeyUsage()[7] && !cert.getInternalCert().getKeyUsage()[8]) {
                this.isInstallable(cert);
            }
            len = ((RSAKey)((Object)sk)).getModulus().bitLength();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        logger.debug("pkcs12 key length=" + len);
        this.checkRSAKeyLen(len);
        if (enforceKeyUsage) {
            logger.debug("pkcs12 check key usage");
            if (!tk.checkKeyUsage(usage, cert.getKeyUsageBits())) {
                throw new CapiException("Key usage not corresponding", 10037);
            }
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            logger.debug("pkcs12 impcred ...");
            String aliasNew = tk.impCred(alias, sk, usage, mode);
            logger.debug("pkcs12 instcert...");
            try {
                tk.instCert(aliasNew, cert, false, privateCert);
                logger.debug("pkcs12 instcert ok");
            }
            catch (CapiException e) {
                logger.debug("install cert KO. Deleting keys for " + aliasNew + " ...");
                try {
                    tk.deleteObject(aliasNew);
                    logger.debug("PKCS12 import failed. Keys deleted");
                }
                catch (CapiException ee) {
                    logger.debug(ee.getMessage(), (Throwable)ee);
                    logger.debug("PKCS12 import failed. Keys left on token.");
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String certificateRequest(String alias, String orderRDN, String name, String organization, String organUnit1, String organUnit2, String organUnit3, String locality, String stateOrProvince, String country, String eMail, String description) throws CapiException {
        logger.debug("certificateRequest (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (orderRDN == null) {
            orderRDN = "E,D,CN,OU3,OU2,OU1,O,L,ST,C";
        }
        ASN1ObjectIdentifier D = new ASN1ObjectIdentifier("2.5.4.13");
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        logger.debug("parsing orderRDN for subject creation");
        X500Name subject = null;
        X500NameBuilder namebld = new X500NameBuilder(BCStyle.INSTANCE);
        try {
            StringTokenizer ost = new StringTokenizer(orderRDN, ",");
            while (ost.hasMoreTokens()) {
                String type = ost.nextToken().toUpperCase();
                if (type.equalsIgnoreCase("CN")) {
                    if (name == null || name.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.CN, name);
                    continue;
                }
                if (type.equalsIgnoreCase("E")) {
                    if (eMail == null || eMail.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.E, eMail);
                    continue;
                }
                if (type.equalsIgnoreCase("D")) {
                    if (description == null || description.trim().equals("")) continue;
                    namebld.addRDN(D, description);
                    continue;
                }
                if (type.equalsIgnoreCase("O")) {
                    if (organization == null || organization.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.O, organization);
                    continue;
                }
                if (type.equalsIgnoreCase("OU1")) {
                    if (organUnit1 == null || organUnit1.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.OU, organUnit1);
                    continue;
                }
                if (type.equalsIgnoreCase("OU2")) {
                    if (organUnit2 == null || organUnit2.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.OU, organUnit2);
                    continue;
                }
                if (type.equalsIgnoreCase("OU3")) {
                    if (organUnit3 == null || organUnit3.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.OU, organUnit3);
                    continue;
                }
                if (type.equalsIgnoreCase("L")) {
                    if (locality == null || locality.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.L, locality);
                    continue;
                }
                if (type.equalsIgnoreCase("ST")) {
                    if (stateOrProvince == null || stateOrProvince.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.ST, stateOrProvince);
                    continue;
                }
                if (type.equalsIgnoreCase("C")) {
                    if (country == null || country.trim().equals("")) continue;
                    namebld.addRDN(BCStyle.C, country);
                    continue;
                }
                logger.debug("unsupported RDN type '" + type + "': skipped");
            }
            subject = namebld.build();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            return tk.certReq(alias, subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final String certificateRequest(String alias, Hashtable ht) throws CapiException {
        logger.debug("certificateRequest (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        logger.debug("parsing orderRDN for subject creation");
        X500Name subject = null;
        X500NameBuilder namebld = new X500NameBuilder(BCStyle.INSTANCE);
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            ASN1ObjectIdentifier key = (ASN1ObjectIdentifier)e.nextElement();
            try {
                namebld.addRDN(key, (String)ht.get(key));
                logger.debug("RDN: " + subject);
            }
            catch (Exception exc) {
                logger.debug(exc.getMessage(), (Throwable)exc);
                throw new CapiException("Internal error", 1003);
            }
        }
        subject = namebld.build();
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            return tk.certReq(alias, subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] exportPKCS12(String alias, String pkcs12PIN) throws CapiException {
        logger.debug("exportPKCS12 (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || pkcs12PIN == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        PrivateKey sk = null;
        String certpem = null;
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            sk = tk.expCred(alias);
            certpem = tk.getCert(alias);
        }
        try {
            KeyStore pkcs12KeyStore = KeyStore.getInstance("PKCS12", ProvUtils.bcProvider);
            pkcs12KeyStore.load(null, null);
            it.actalis.ellips.capi.core.Certificate c = new it.actalis.ellips.capi.core.Certificate(tk.getCert(alias).getBytes());
            Certificate[] chain = new X509Certificate[]{c.getInternalCert()};
            pkcs12KeyStore.setKeyEntry(alias, sk, pkcs12PIN.toCharArray(), chain);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            pkcs12KeyStore.store(baos, pkcs12PIN.toCharArray());
            byte[] result = baos.toByteArray();
            baos.close();
            return result;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    @Deprecated
    public final void installCertificate(String alias, byte[] cert, boolean enforcekeyUsage) throws CertificateExpiredException, CapiException {
        this.installCertificate(alias, cert, enforcekeyUsage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void installCertificate(String alias, byte[] cert, boolean enforcekeyUsage, boolean privateCert) throws CertificateExpiredException, CapiException {
        logger.debug("installCertificate (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || alias.length() == 0 || cert == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        it.actalis.ellips.capi.core.Certificate c = new it.actalis.ellips.capi.core.Certificate(cert);
        this.isInstallable(c);
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.instCert(alias, c, enforcekeyUsage, privateCert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String requestRenewal(String alias, boolean newKeys, String newAlias, int mode) throws CapiException {
        logger.debug("installCertificate (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || alias.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        this.checkRange("mode", mode, 0, 2);
        if (newAlias == null) {
            newAlias = alias + "_NEW";
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            return tk.reqRenew(alias, newKeys, newAlias, mode);
        }
    }

    public final String[] listObjects(String aliasFilter, byte typeFilter) throws CapiException {
        logger.debug("listObjects");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.listObjects(aliasFilter, typeFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteObject(String alias) throws CapiException {
        logger.debug("deleteObject (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || alias.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.deleteObject(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        logger.debug("renameObject (alias= " + oldAlias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (oldAlias == null || newAlias == null || oldAlias.length() == 0 || newAlias.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        if (oldAlias.equals(newAlias)) {
            throw new CapiException("Wrong parameters", 1002);
        }
        this.checkRange("mode", mode, 0, 2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.renameObject(oldAlias, newAlias, mode);
        }
    }

    public final byte getObjectType(String alias) throws CapiException {
        logger.debug("getObjectType (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getObjectType(alias);
    }

    public final String getObjectID(String alias) throws CapiException {
        logger.debug("getObjectType (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getObjectID(alias);
    }

    public final int getKeyUsage(String alias) throws CapiException {
        logger.debug("getKeyUsage (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getKeyUsage(alias, true);
    }

    public final int getKeyLength(String alias) throws CapiException {
        logger.debug("getKeyLength (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getKeyLength(alias);
    }

    public int getObjectSize(String alias) throws CapiException {
        logger.debug("getObjectSize (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return tk.getObjectSize(alias);
    }

    public int getFreeSpace() throws CapiException {
        logger.debug("getFreeSpace");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.getFreeSpace();
    }

    public int canUnblock() throws CapiException {
        logger.debug("canUnblock");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.canUnblock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unblockPIN(String PUK, String newPin) throws CapiException {
        logger.debug("UnblockPIN");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (PUK == null || newPin == null) {
            throw new CapiException("Null parameters", 1001);
        }
        int status = tk.canUnblock();
        switch (status) {
            case 0: {
                throw new CapiException("The token cannot be unblocked", 1004);
            }
            case 1: {
                throw new CapiException("The token can be unblocked using the vendor tool but it will be reinitialized", 1004);
            }
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            tk.unblockPIN(PUK, newPin);
        }
        logger.debug("unblockPIN OK");
    }

    private static byte[] getATR6() {
        logger.debug("[getATR6] ...");
        try {
            PCSC6 p = new PCSC6();
            byte[] atr = p.getATR();
            if (atr == null || atr.length == 0) {
                logger.debug("[getATR6] No ATR detected.");
                return null;
            }
            String atrValue = Util.dumpHex(atr);
            logger.debug("[getATR6]atrValue: " + atrValue);
            return atr;
        }
        catch (Exception e) {
            logger.debug("[getATR6] Exception " + e.getMessage());
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String[] getPCSCReaders6() throws Exception {
        String JAVA_6_VER = "1.6";
        String ver = System.getProperty("java.version");
        logger.debug("[getPCSCReaders6] Java Version: " + ver);
        if (ver.compareTo(JAVA_6_VER) < 0) {
            throw new Exception("Java Version " + ver + " not support this method");
        }
        try {
            ClassLoader cl = Token.class.getClassLoader();
            Class<?> cls = cl.loadClass("it.actalis.ellips.util.java6.PCSC6");
            Object objInstance = cls.newInstance();
            Method myMethod = cls.getMethod("getPcscReaders", null);
            String[] readers = (String[])myMethod.invoke(objInstance, (Object[])null);
            if (readers == null || readers.length == 0) {
                logger.debug("[getPCSCReaders6] No reader detected.");
                return null;
            }
            String[] pcscReaders = new String[readers.length];
            logger.debug("[getPCSCReaders6] N. readers detected: " + readers.length);
            for (int i = 0; i < readers.length; ++i) {
                logger.debug("[getPCSCReaders6] Slot n. " + i + " Reader: " + readers[i]);
                pcscReaders[i] = readers[i].trim();
            }
            return pcscReaders;
        }
        catch (Exception e) {
            logger.debug("[getPCSCReaders6] Exception " + e.getMessage());
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static final byte[] getATR() {
        String JAVA_6_VER = "1.6";
        String ver = System.getProperty("java.version");
        logger.debug("[getATR] Java Version: " + ver);
        Object atrValue = null;
        return Token.getATR6();
    }

    protected String getlibNameFromID(String id) {
        try {
            logger.debug("finding libName for ID <" + id + ">");
            String j = (String)p11list_Libs.get(id);
            if (j == null) {
                logger.debug("ID not present");
                return null;
            }
            logger.debug("found   position <" + j + ">");
            String lib = null;
            if (OSName == null || OSName.startsWith("Win")) {
                lib = Token.p11getString("lib." + j + ".p11lib");
                logger.debug("lib." + j + ".p11lib=" + lib);
                return lib;
            }
            lib = Token.p11getString("lib." + j + ".p11lib." + OSName);
            logger.debug("lib." + j + ".p11lib." + OSName + "=" + lib);
            return lib;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String[] getLibNamesfromSmartcardInfo(KnownSmartcardInfo smartcard) {
        try {
            String[] val = new String[]{smartcard.getP11LibraryID(), smartcard.getBackupP11LibraryID()};
            String lib = null;
            lib = this.getlibNameFromID(val[0]);
            if (val[1] == null) {
                String[] libs = new String[]{lib};
                return libs;
            }
            String[] p11lib = val[1].split(";");
            if (p11lib == null || p11lib.length <= 0) {
                String[] libs = new String[]{lib};
                return libs;
            }
            String[] libNames = new String[p11lib.length + 1];
            libNames[0] = lib;
            for (int i = 0; i < p11lib.length; ++i) {
                libNames[i + 1] = this.getlibNameFromID(p11lib[i]);
            }
            return libNames;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public final void init(KnownSmartcardInfo smartcard) throws CapiException {
        logger.debug("init... " + smartcard.getDescription());
        try {
            String[] val = new String[]{smartcard.getP11LibraryID(), smartcard.getBackupP11LibraryID()};
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                if (i == 0) {
                    try {
                        this.tryInit(val[i]);
                        return;
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                        continue;
                    }
                }
                String[] p11lib = val[i].split(";");
                this.init(p11lib);
                return;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        throw new CapiException("No smartcard", 10000);
    }

    public final void init(String[] p11lib) throws CapiException {
        try {
            for (int n = 0; n < p11lib.length; ++n) {
                if (p11lib[n] == null) continue;
                try {
                    logger.debug(n + ":" + p11lib[n]);
                    this.tryInit(p11lib[n]);
                    return;
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        throw new CapiException("No smartcard", 10000);
    }

    public final void init(String[] p11lib, boolean chekcard) throws CapiException {
        if (!chekcard) {
            this.init(p11lib);
        } else {
            try {
                for (int n = 0; n < p11lib.length; ++n) {
                    if (p11lib[n] == null) continue;
                    try {
                        logger.debug(n + ":" + p11lib[n]);
                        if (tk != null) {
                            this.destroy();
                        }
                        this.tryInit(p11lib[n]);
                        logger.info("Carta inserita e verificata - SerialNumber" + this.getSerialNumber());
                        return;
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 1003);
            }
        }
        throw new CapiException("No smartcard", 10000);
    }

    public static final String describeATR(byte[] atr) {
        logger.debug("describeATR ");
        try {
            String atrkey = ATR.toHexString(atr).toLowerCase();
            logger.debug("finding descr for ATR <" + atrkey + ">");
            String atrval = (String)p11list_ATR.get(atrkey + ".descr");
            if (atrval == null) {
                logger.debug("getMatching ATR <" + atrkey + ">");
                atrval = (String)p11list_ATR.getMatching(atrkey + ".descr");
            }
            logger.debug("found description for ATR <" + atrval + ">");
            return atrval;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void registerNewSmartCard(KnownSmartcardInfo[] toAdd) {
        try {
            for (int i = 0; i < toAdd.length; ++i) {
                int j;
                if (toAdd[i].getATR() == null || toAdd[i].getDescription() == null || toAdd[i].getP11LibraryID() == null) {
                    logger.debug("NULL atr or description or P11 for item n. " + i + " ...item skipped...");
                    continue;
                }
                for (j = 0; j < knownSC.length; ++j) {
                    if (knownSC[j].getATR() == null || !toAdd[i].getATR().equals(knownSC[j].getATR())) continue;
                    logger.debug("overwriting smart card info in token list...");
                    knownSC[j].setDescription(toAdd[i].getDescription());
                    knownSC[j].setP11LibraryID(toAdd[i].getP11LibraryID());
                    knownSC[j].setBackupP11LibraryID(toAdd[i].getBackupP11LibraryID());
                    logger.debug("token ATR = " + toAdd[i].getATR());
                    logger.debug("token des = " + toAdd[i].getDescription());
                    logger.debug("token lib = " + toAdd[i].getP11LibraryID());
                    if (toAdd[i].getBackupP11LibraryID() != null) {
                        logger.debug("token bk lib = " + toAdd[i].getBackupP11LibraryID());
                    }
                    int ncard = Integer.parseInt((String)p11list.get("ncards"));
                    for (int p = 1; p <= ncard; ++p) {
                        String atr = (String)p11list.get("card." + p + ".ATR");
                        if (atr == null || !atr.equals(toAdd[i].getATR())) continue;
                        p11list.put("card." + p + ".descr", toAdd[i].getDescription());
                        p11list.put("card." + p + ".lib", toAdd[i].getP11LibraryID());
                        if (toAdd[i].getBackupP11LibraryID() != null) {
                            p11list.put("card." + p + ".backuplib", toAdd[i].getBackupP11LibraryID());
                        }
                        logger.debug("updated p11list ");
                        break;
                    }
                    if (!p11list_ATR.containsKey(toAdd[i].getATR() + ".lib0")) break;
                    p11list_ATR.put(toAdd[i].getATR() + ".lib0", toAdd[i].getP11LibraryID());
                    if (toAdd[i].getBackupP11LibraryID() != null) {
                        p11list_ATR.put(toAdd[i].getATR() + ".lib1", toAdd[i].getBackupP11LibraryID());
                    }
                    logger.debug("updated atr list... ");
                    break;
                }
                if (j != knownSC.length) continue;
                logger.debug("adding smart card info to token list...");
                Vector<KnownSmartcardInfo> newTokenList = new Vector<KnownSmartcardInfo>();
                for (int n = 0; n < knownSC.length; ++n) {
                    newTokenList.add(knownSC[n]);
                }
                newTokenList.add(new KnownSmartcardInfo(toAdd[i].getATR(), toAdd[i].getDescription(), toAdd[i].getP11LibraryID(), toAdd[i].getBackupP11LibraryID()));
                knownSC = new KnownSmartcardInfo[j + 1];
                newTokenList.toArray(knownSC);
                logger.debug("token ATR = " + toAdd[i].getATR());
                logger.debug("token des = " + toAdd[i].getDescription());
                logger.debug("token lib = " + toAdd[i].getP11LibraryID());
                if (toAdd[i].getBackupP11LibraryID() != null) {
                    logger.debug("token bk lib = " + toAdd[i].getBackupP11LibraryID());
                }
                int ncard = Integer.parseInt((String)p11list.get("ncards"));
                p11list.put("card." + ++ncard + ".ATR", toAdd[i].getATR());
                p11list.put("card." + ncard + ".descr", toAdd[i].getDescription());
                p11list.put("card." + ncard + ".lib", toAdd[i].getP11LibraryID());
                p11list.put("card." + ncard + ".backuplib", toAdd[i].getBackupP11LibraryID());
                p11list.put("ncards", "" + ncard);
                logger.debug("updated p11list ");
                p11list_ATR.put(toAdd[i].getATR() + ".lib0", toAdd[i].getP11LibraryID());
                if (toAdd[i].getBackupP11LibraryID() != null) {
                    p11list_ATR.put(toAdd[i].getATR() + ".lib1", toAdd[i].getBackupP11LibraryID());
                }
                logger.debug("updated atr list... ");
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static void registerNewP11Library(KnownP11LibraryInfo[] toAdd) {
        try {
            for (int i = 0; i < toAdd.length; ++i) {
                int j;
                if (toAdd[i].getID() == null || toAdd[i].getDescription() == null || toAdd[i].getp11lib() == null || toAdd[i].getslot() == null || toAdd[i].getflags() == null || toAdd[i].gettimeout() == null) {
                    logger.debug("Null param in KnownP11LibraryInfo for item n. " + i + " ...item skipped...");
                    continue;
                }
                for (j = 0; j < knownP11.length; ++j) {
                    if (!toAdd[i].getID().equals(knownP11[j].getID())) continue;
                    logger.debug("overwriting p11 info in token list...");
                    knownP11[j].setDescription(toAdd[i].getDescription());
                    knownP11[j].setp11lib(toAdd[i].getp11lib());
                    knownP11[j].setflags(toAdd[i].getflags());
                    knownP11[j].setslot(toAdd[i].getslot());
                    knownP11[j].settimeout(toAdd[i].gettimeout());
                    logger.debug("P11 ID = " + toAdd[i].getID());
                    logger.debug("P11 des = " + toAdd[i].getDescription());
                    logger.debug("P11 lib = " + toAdd[i].getp11lib());
                    int nlib = Integer.parseInt((String)p11list.get("nlibs"));
                    for (int p = 1; p <= nlib; ++p) {
                        String libId = (String)p11list.get("lib." + p + ".ID");
                        if (libId == null || !libId.equals(toAdd[i].getID())) continue;
                        p11list.put("lib." + p + ".descr", toAdd[i].getDescription());
                        p11list.put("lib." + p + ".p11lib", toAdd[i].getp11lib());
                        p11list.put("lib." + p + ".slot", toAdd[i].getslot());
                        p11list.put("lib." + p + ".flags", toAdd[i].getflags());
                        p11list.put("lib." + p + ".timeout", toAdd[i].gettimeout());
                        logger.debug("updated p11list ");
                        break;
                    }
                    for (int q = 0; q < knownSC.length; ++q) {
                        String atr;
                        if (!toAdd[i].getID().equals(knownSC[q].getP11LibraryID()) || !p11list_ATR.containsKey((atr = knownSC[q].getATR()) + ".lib0")) continue;
                        p11list_ATR.put(atr + ".lib0", toAdd[i].getID());
                        logger.debug("updated atr list... " + atr + ".lib0: " + toAdd[i].getID());
                    }
                    break;
                }
                if (j != knownP11.length) continue;
                logger.debug("adding P11 to the list ...");
                Vector<KnownP11LibraryInfo> newP11List = new Vector<KnownP11LibraryInfo>();
                for (int n = 0; n < knownP11.length; ++n) {
                    newP11List.add(knownP11[n]);
                }
                newP11List.add(new KnownP11LibraryInfo(toAdd[i].getID(), toAdd[i].getDescription(), toAdd[i].getp11lib(), toAdd[i].getslot(), toAdd[i].getflags(), toAdd[i].gettimeout()));
                knownP11 = new KnownP11LibraryInfo[j + 1];
                newP11List.toArray(knownP11);
                logger.debug("P11 ID = " + toAdd[i].getID());
                logger.debug("P11 des = " + toAdd[i].getDescription());
                logger.debug("P11 lib = " + toAdd[i].getp11lib());
                int nlib = Integer.parseInt((String)p11list.get("nlibs"));
                p11list.put("lib." + ++nlib + ".ID", toAdd[i].getID());
                p11list.put("lib." + nlib + ".descr", toAdd[i].getDescription());
                p11list.put("lib." + nlib + ".p11lib", toAdd[i].getp11lib());
                p11list.put("lib." + nlib + ".slot", toAdd[i].getslot());
                p11list.put("lib." + nlib + ".flags", toAdd[i].getflags());
                p11list.put("lib." + nlib + ".timeout", toAdd[i].gettimeout());
                p11list.put("nlibs", "" + nlib);
                p11list_Libs.put(toAdd[i].getID(), "" + nlib);
                logger.debug("updated p11list and id_p11list");
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public final void init(KnownP11LibraryInfo library) throws CapiException {
        logger.debug("init... " + library.getDescription());
        try {
            String val = library.getID();
            this.tryInit(val);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    public final void setSlot(String slot) {
        logger.debug("setting slot value to: " + slot);
        this.customizedSlot = slot;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void init() throws ATRException, CapiException {
        Token.logger.debug("Token.init() start");
        try {
            block13: {
                atr = Token.getATR();
                atrkey = ATR.toHexString(atr).toLowerCase();
                if (atrkey == null || atrkey.length() == 0) {
                    Token.logger.error("No ATR returned");
                    throw new CapiException("No ATR returned", 1003);
                }
                Token.logger.debug("finding lib for ATR <" + atrkey + ">");
                max = 2;
                i = 0;
                block9: while (i < max) {
                    block14: {
                        val = null;
                        val = (String)Token.p11list_ATR.get(atrkey + ".lib" + i);
                        if (val != null) break block14;
                        Token.logger.debug("getMatching ATR <" + atrkey + ">");
                        val = (String)Token.p11list_ATR.getMatching(atrkey + ".lib" + i);
                        if (val == null) ** GOTO lbl27
                        Token.logger.debug("found lib for ATR <" + val + ">");
                    }
                    if (i != 0) break block13;
                    Token.logger.debug(i + ":" + atrkey + ":" + val);
                    try {
                        this.tryInit(val);
                        return;
                    }
                    catch (Exception e) {
                        Token.logger.debug(e.getMessage(), (Throwable)e);
lbl27:
                        // 3 sources

                        while (true) {
                            ++i;
                            continue block9;
                            break;
                        }
                    }
                }
                return;
            }
            Token.logger.debug(i + ":" + atrkey + ":" + val);
        }
        catch (ATRException e) {
            Token.logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Token.logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        p11lib = val.split(";");
        this.init(p11lib);
        ** while (true)
        finally {
            Token.logger.debug("Token.init() end");
        }
    }

    public boolean verifyATRMatchTokenConfig() throws CapiException {
        logger.debug("verifyATRMatchTokenConfig");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        try {
            if (!this.isAvailable()) {
                throw new CapiException("Token not inserted", 10011);
            }
            byte[] atr = Token.getATR();
            String atrkey = ATR.toHexString(atr);
            if (atrkey == null || atrkey.length() == 0) {
                return true;
            }
            boolean ret = this.verifyATRMatchTokenConfig(atrkey);
            return ret;
        }
        catch (ATRException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private boolean verifyLib(String[] idkey) {
        try {
            for (int n = 0; n < idkey.length; ++n) {
                if (idkey[n] == null) continue;
                try {
                    logger.debug(n + ":" + idkey[n]);
                    if (!this.verifyLib(idkey[n])) continue;
                    return true;
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean verifyLib(String idkey) {
        try {
            logger.debug("finding args for ID <" + idkey + ">");
            String j = (String)p11list_Libs.get(idkey);
            if (j == null) {
                return false;
            }
            logger.debug("found   position <" + j + ">");
            String p11 = null;
            if (OSName == null || OSName.startsWith("Win")) {
                p11 = Token.p11getString("lib." + j + ".p11lib");
                logger.debug("lib." + j + ".p11lib=" + p11);
            } else {
                p11 = Token.p11getString("lib." + j + ".p11lib." + OSName);
                logger.debug("lib." + j + ".p11lib." + OSName + "=" + p11);
            }
            logger.debug(idkey + ":" + Token.p11getString("lib." + j + ".descr"));
            logger.debug("verifying ... ");
            String configuredLib = tk.getLibName();
            try {
                File f = new File(configuredLib);
                f.getName();
                File fp11 = new File(p11);
                fp11.getName();
                if (f.getName() != null && fp11.getName() != null) {
                    configuredLib = f.getName();
                    p11 = fp11.getName();
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            if (tk != null && configuredLib != null && p11.compareToIgnoreCase(configuredLib) == 0) {
                logger.debug("verifyLib returning true");
                return true;
            }
            logger.debug("verifyLib returning false");
            return false;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean verifyATRMatchTokenConfig(String atrString) {
        boolean ATRknown = false;
        try {
            String atrkey = atrString.toLowerCase();
            if (atrkey == null || atrkey.length() == 0) {
                return true;
            }
            logger.debug("finding lib for ATR <" + atrkey + ">");
            int max = 2;
            for (int i = 0; i < max; ++i) {
                String val = null;
                val = (String)p11list_ATR.get(atrkey + ".lib" + i);
                if (val == null) {
                    logger.debug("getMatching ATR <" + atrkey + ">");
                    val = (String)p11list_ATR.getMatching(atrkey + ".lib" + i);
                    if (val == null) continue;
                    logger.debug("found lib for ATR <" + val + ">");
                }
                ATRknown = true;
                if (i == 0) {
                    logger.debug(i + ":" + atrkey + ":" + val);
                    try {
                        if (this.verifyLib(val)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                logger.debug(i + ":" + atrkey + ":" + val);
                String[] p11lib = val.split(";");
                if (!this.verifyLib(p11lib)) continue;
                return true;
            }
        }
        catch (ATRException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return !ATRknown;
    }

    public static KnownSmartcardInfo[] getKnownSmartcards() {
        logger.debug("getKnownSmartcards");
        return knownSC;
    }

    public static KnownP11LibraryInfo[] getKnownP11Libraries() {
        logger.debug("getKnownP11Libraries ");
        return knownP11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PrivateKey getPrivateKey(String alias) throws CapiException {
        logger.debug("getPrivateKey (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            PrivateKey sk = null;
            TokenSpi tokenSpi = tk;
            synchronized (tokenSpi) {
                sk = tk.getPrivateKey(alias);
            }
            return sk;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PublicKey getPublicKey(String alias) throws CapiException {
        logger.debug("getPublicKey (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        PublicKey pk = null;
        try {
            TokenSpi tokenSpi = tk;
            synchronized (tokenSpi) {
                pk = tk.getPublicKey(alias);
            }
            return pk;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    public static final TokenSpi getTokenSpi() throws CapiException {
        return Token.getTokenSpi(null);
    }

    public static final TokenSpi getTokenSpi(String alias) throws CapiException {
        if (tokenTable == null || tokenTable.isEmpty()) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null) {
            return (TokenSpi)tokenTable.values().iterator().next();
        }
        for (TokenSpi tks : tokenTable.values()) {
            if (!tks.exist(alias)) continue;
            return tks;
        }
        throw new CapiException("Object not found .", 10023);
    }

    private boolean isNotNull(String s) {
        return s != null && !s.equals("");
    }

    private void checkRange(String param_name, int val, int fromval, int toval) throws CapiException {
        if (val < fromval || val > toval) {
            throw new CapiException("Parameter " + param_name + " value ( " + val + " ) is out of the range allowed [" + fromval + " : " + toval + "]", 1002);
        }
    }

    public final int getMinRSAKeyLength() throws CapiException {
        logger.debug("getMinRSAKeyLength");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.getMinRSAKeyLength();
    }

    public final int getMinPINLength() throws CapiException {
        logger.debug("getMinPINLength");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.getMinPINLen();
    }

    public final int getMaxPINLength() throws CapiException {
        logger.debug("getMaxPINLength");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return tk.getMaxPINLen();
    }

    private void checkRSAKeyLen(int val) throws CapiException {
        if (val < 768) {
            throw new CapiException("Key not secure (length is " + val + ")", 10031);
        }
        int min = this.getMinRSAKeyLength();
        if (val < min) {
            throw new CapiException(val + ": key length not available on the token" + " (minimum length available is " + min + ")", 10031);
        }
    }

    private void isInstallable(it.actalis.ellips.capi.core.Certificate cert) throws CertificateExpiredException, CapiException {
        try {
            cert.isValid();
        }
        catch (CertificateExpiredException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CertificateNotYetValidException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void tryInit(String idkey) throws CapiException {
        try {
            logger.debug("finding args for ID <" + idkey + ">");
            String j = (String)p11list_Libs.get(idkey);
            if (j == null) {
                logger.debug("ID not present");
                throw new Exception("ID not present");
            }
            logger.debug("found   position <" + j + ">");
            String[] p11args = new String[4];
            if (OSName == null || OSName.startsWith("Win")) {
                p11args[0] = Token.p11getString("lib." + j + ".p11lib");
                logger.debug("lib." + j + ".p11lib=" + p11args[0]);
            } else {
                p11args[0] = Token.p11getString("lib." + j + ".p11lib." + OSName);
                logger.debug("lib." + j + ".p11lib." + OSName + "=" + p11args[0]);
            }
            if (this.customizedSlot != null) {
                p11args[1] = this.customizedSlot;
                logger.debug("customized slot number to: " + this.customizedSlot);
            } else {
                p11args[1] = Token.p11getString("lib." + j + ".slot");
            }
            p11args[2] = Token.p11getString("lib." + j + ".flags");
            p11args[3] = Token.p11getString("lib." + j + ".timeout");
            logger.debug(idkey + ":" + Token.p11getString("lib." + j + ".descr"));
            for (int i = 0; i < p11args.length; ++i) {
                logger.debug(i + ":" + p11args[i]);
            }
            this.init("PKCS11Token", p11args);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException(e.getMessage(), 1003);
        }
    }

    private static Map toMap(ResourceBundle resourceBundle) {
        Enumeration<String> enu = resourceBundle.getKeys();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (enu.hasMoreElements()) {
            String key = enu.nextElement();
            Object value = resourceBundle.getObject(key);
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setKnownSmartcards() {
        logger.debug("setKnownSmartcards start");
        knownSC = new KnownSmartcardInfo[0];
        try {
            int ncard = Integer.parseInt(Token.p11getString("ncards"));
            knownSC = new KnownSmartcardInfo[ncard];
            int j = 1;
            int i = 0;
            while (j <= ncard) {
                Token.knownSC[i] = new KnownSmartcardInfo(Token.p11getString("card." + j + ".ATR"), Token.p11getString("card." + j + ".descr"), Token.p11getString("card." + j + ".lib"), Token.p11getString("card." + j + ".backuplib"));
                ++j;
                ++i;
            }
            logger.debug(ncard + " known smartcards data loaded");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        finally {
            logger.debug("setKnownSmartcards end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setKnownP11Library() {
        logger.debug("setKnownP11Library start");
        knownP11 = new KnownP11LibraryInfo[0];
        try {
            int nlib = Integer.parseInt(Token.p11getString("nlibs"));
            knownP11 = new KnownP11LibraryInfo[nlib];
            int j = 1;
            int i = 0;
            while (j <= nlib) {
                Token.knownP11[i] = new KnownP11LibraryInfo(Token.p11getString("lib." + j + ".ID"), Token.p11getString("lib." + j + ".descr"), Token.p11getString("lib." + j + ".p11lib"), Token.p11getString("lib." + j + ".slot"), Token.p11getString("lib." + j + ".flags"), Token.p11getString("lib." + j + ".timeout"));
                ++j;
                ++i;
            }
            logger.debug(nlib + " known libraries data loaded");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        finally {
            logger.debug("setKnownP11Library end");
        }
    }

    private static String p11getString(String key) {
        String res = null;
        try {
            res = (String)p11list.get(key);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    protected boolean isTokenSoftSia() {
        return this.tokenSoftSia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importCredential(String alias, PrivateKey sk, it.actalis.ellips.capi.core.Certificate cert, int mode, int usage, boolean enforceKeyUsage, boolean privateCert) throws CertificateExpiredException, CapiException {
        logger.debug("importCredential (alias= " + alias + ")");
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (alias == null || alias.length() == 0 || sk == null || cert == null) {
            throw new CapiException("Null parameters", 1001);
        }
        this.checkRange("mode", mode, 0, 2);
        this.checkRange("usage", usage, 1, 3);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        int len = -1;
        if (cert.getInternalCert().getKeyUsage() == null || !cert.getInternalCert().getKeyUsage()[2] && !cert.getInternalCert().getKeyUsage()[3] && !cert.getInternalCert().getKeyUsage()[7] && !cert.getInternalCert().getKeyUsage()[8]) {
            this.isInstallable(cert);
        }
        len = ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength();
        logger.debug("importCredential key length=" + len);
        this.checkRSAKeyLen(len);
        if (enforceKeyUsage) {
            logger.debug("importCredential check key usage");
            if (!tk.checkKeyUsage(usage, cert.getKeyUsageBits())) {
                throw new CapiException("Key usage not corresponding", 10037);
            }
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            logger.debug("importCredential impcred ...");
            String aliasNew = tk.impCred(alias, sk, usage, mode);
            logger.debug("importCredential instcert...");
            try {
                tk.instCert(aliasNew, cert, false, privateCert);
                logger.debug("importCredential instcert ok");
            }
            catch (CapiException e) {
                logger.debug("install cert KO. Deleting keys for " + aliasNew + " ...");
                try {
                    tk.deleteObject(aliasNew);
                    logger.debug("importCredential import failed. Keys deleted");
                }
                catch (CapiException ee) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    logger.debug("importCredential import failed. Keys left on token.");
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        logger.debug("Token static initialization - start");
        try {
            OSName = System.getProperty("os.name", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            OSName = null;
        }
        try {
            logger.debug("start pkcs11devices file parsing");
            p11list = Token.toMap(ResourceBundle.getBundle("pkcs11devices"));
            p11list_ATR = new ATRHashtable();
            p11list_Libs = new Hashtable();
            int nLib = Integer.parseInt((String)p11list.get("nlibs"));
            int nCard = Integer.parseInt((String)p11list.get("ncards"));
            logger.debug("read library db items and check for map index conflicts and duplicates");
            for (int iLib = 1; iLib <= nLib; ++iLib) {
                String id = null;
                String previous = null;
                try {
                    id = (String)p11list.get("lib." + iLib + ".ID");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (id == null) {
                    logger.debug("library " + iLib + " has not an ID: skipped");
                    continue;
                }
                previous = p11list_Libs.put(id, "" + iLib);
                if (previous == null) continue;
                logger.debug("library id " + id + " now assigned to " + iLib + " was already assigned to " + previous + ". Duplicated library ID");
            }
            logger.debug("read cards db items and check for map index conflicts and duplicates");
            for (int iCard = 1; iCard <= nCard; ++iCard) {
                String atr = null;
                String desc = null;
                String lib = null;
                String previous = null;
                try {
                    atr = (String)p11list.get("card." + iCard + ".ATR");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (atr == null) {
                    logger.debug("card " + iCard + " has not an assigned ATR: skip it");
                    continue;
                }
                try {
                    desc = (String)p11list.get("card." + iCard + ".descr");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (desc != null) {
                    previous = (String)p11list_ATR.put(atr + ".descr", desc);
                    if (previous != null) {
                        logger.debug("description " + desc + " now assigned to " + atr + " was already assigned to " + previous + ". Duplicated ATR");
                    }
                } else {
                    logger.debug("card " + iCard + " has not a description: use Unknown");
                    previous = (String)p11list_ATR.put(atr + ".descr", "Unknown");
                    if (previous != null) {
                        logger.debug("Unknown description now assigned to " + iCard + " was already assigned to " + previous + ". Duplicated ATR?");
                    }
                }
                try {
                    lib = (String)p11list.get("card." + iCard + ".lib");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lib != null && (previous = (String)p11list_ATR.put(atr + ".lib0", lib)) != null) {
                    logger.debug("library " + lib + " now assigned to " + atr + " was already assigned to " + previous + ". Duplicated ATR");
                }
                try {
                    lib = (String)p11list.get("card." + iCard + ".backuplib");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lib == null || (previous = (String)p11list_ATR.put(atr + ".lib1", lib)) == null) continue;
                logger.debug("backup library " + lib + " now assigned to " + atr + " was already assigned to " + previous + ". Duplicated ATR");
            }
            Token.setKnownSmartcards();
            Token.setKnownP11Library();
            logger.debug("end pkcs11devices file parsing");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            logger.debug("Token static initialization - end");
        }
    }
}

