/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import esecurity.dts.DTSClient;
import esecurity.dts.DTSClientFactory;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.crl.CRLUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAUtil;
import it.actalis.ellips.capi.tsa.TimeStampAndCRL;
import it.actalis.ellips.capi.tsa.TimeStampedData;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.ConfigParameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;

public class TSDUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    @Deprecated
    public static void createTsd(String in, String out, String Filename, String FileType, ConfigParameter objConf) throws Exception {
        TSDUtils.createTsd(in, out, Filename, FileType, objConf, null);
    }

    @Deprecated
    public static void createTsd(String in, String out, String Filename, String FileType, ConfigParameter objConf, ValidatorConfig valConf) throws Exception {
        FileInputStream objIn = null;
        FileInputStream objIn2 = null;
        FileOutputStream objOut = null;
        TimeStampedData tsd = null;
        try {
            objIn = new FileInputStream(in);
            objIn2 = new FileInputStream(in);
            objOut = new FileOutputStream(out + ".parted");
            tsd = new TimeStampedData();
            tsd.setContent(objIn);
            tsd.setFileName(Filename);
            tsd.setMediaType(FileType);
            tsd.setHashProtected(false);
            TimeStampAndCRL[] tst_crl = new TimeStampAndCRL[1];
            TimeStampToken tst = TSAUtil.getMark("SHA-256", null, (InputStream)objIn2, objConf.getTSAPolicy(), objConf, true).getTimeStampToken();
            Store objCertStore = tst.getCertificates();
            X509CertificateHolder cert = (X509CertificateHolder)objCertStore.getMatches((Selector)tst.getSID()).iterator().next();
            tst_crl[0] = new TimeStampAndCRL();
            if (valConf != null) {
                UrlClient client = new UrlClient(valConf.getNetConfiguration());
                CRL crl = CRLUtils.getCrlForCertificate(client, valConf, new Certificate(cert.getEncoded()), new Date(), valConf.getCertDB());
                tst_crl[0].setCRL(crl.getDEREncoded());
            }
            tst_crl[0].setTimeStampToken(tst.getEncoded());
            tsd.setTstEvidence(tst_crl);
            tsd.writeTo(objOut);
            objOut.close();
            objOut = null;
            objIn.close();
            objIn = null;
            objIn2.close();
            objIn2 = null;
            File fout = new File(out);
            File ftmp = new File(out + ".parted");
            if (fout.exists()) {
                fout.delete();
            }
            ftmp.renameTo(fout);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new IOException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            if (ex instanceof CapiException) {
                throw (CapiException)ex;
            }
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new Exception(ex.getMessage(), ex);
        }
        finally {
            if (tsd != null) {
                tsd.free();
            }
            if (objOut != null) {
                try {
                    objOut.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (objIn != null) {
                try {
                    objIn.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (objIn2 != null) {
                try {
                    objIn2.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public static void createTsd(InputHandler in, OutputHandler out, String tsaUrl, String tsaUsername, String tsaPassword, String tsaPolicy, String fileName, String fileType, ValidatorConfig valConf) throws Exception {
        TSDUtils.createTsd(in, out, tsaUrl, tsaUsername, tsaPassword, tsaPolicy, fileName, fileType, valConf, false);
    }

    public static void createTsd(InputHandler in, OutputHandler out, String tsaUrl, String tsaUsername, String tsaPassword, String tsaPolicy, String fileName, String fileType, ValidatorConfig valConf, boolean derEncoding) throws Exception {
        TSAData tsaData = new TSAData(tsaUrl, "", tsaPolicy, tsaUsername, tsaPassword, "", "");
        TSDUtils.createTsd(in, out, tsaData, fileName, fileType, valConf, derEncoding);
    }

    public static void createTsd(InputHandler in, OutputHandler out, TSAData tsaData, String fileName, String fileType, ValidatorConfig valConf, boolean derEncoding) throws Exception {
        TSDUtils.createTsd(in, out, tsaData, fileName, fileType, valConf.getNetConfiguration(), derEncoding);
    }

    public static void createTsd(InputHandler in, OutputHandler out, TSAData tsaData, String fileName, String fileType, NetworkConfig conf, boolean derEncoding) throws Exception {
        DTSClient dtsClient = DTSClientFactory.createDTSClient(tsaData, conf, null);
        TSDUtils.createTsd(in, out, dtsClient, fileName, fileType, conf, derEncoding);
    }

    public static void createTsd(InputHandler in, OutputHandler out, DTSClient dtsClient, String fileName, String fileType, NetworkConfig conf, boolean derEncoding) throws Exception {
        TimeStampResponse tsr = dtsClient.getMark(in.getInputAsNewStream(), true);
        TimeStampToken tst = tsr.getTimeStampToken();
        TSDUtils.createTsd(in, out, tst.getEncoded(), tst.getCertificates(), (Selector)tst.getSID(), fileName, fileType, null, derEncoding);
    }

    public static void createTsd(InputHandler in, OutputHandler out, byte[] tstBytes, String fileName, String fileType, ValidatorConfig valConf, boolean derEncoding) throws IOException, Exception {
        TimeStampToken tst = new TimeStampToken(new CMSSignedData(tstBytes));
        TSDUtils.createTsd(in, out, tst.getEncoded(), tst.getCertificates(), (Selector)tst.getSID(), fileName, fileType, valConf, derEncoding);
    }

    public static void createTsd(InputHandler in, OutputHandler out, byte[] tstEncoded, Store objCertStore, Selector sid, String fileName, String fileType, ValidatorConfig valConf, boolean derEncoding) throws IOException, Exception {
        TimeStampedData tsd = new TimeStampedData(derEncoding);
        try {
            tsd.setContent(in.getInputAsNewStream());
            tsd.setHashProtected(false);
            if (fileName != null && !fileName.isEmpty()) {
                tsd.setFileName(fileName);
            }
            if (fileType == null || fileType.isEmpty()) {
                tsd.setMediaType("application/pkcs7-mime");
            } else {
                tsd.setMediaType(fileType);
            }
            TimeStampAndCRL[] tst_crl = new TimeStampAndCRL[]{new TimeStampAndCRL()};
            if (objCertStore != null) {
                X509CertificateHolder cert = (X509CertificateHolder)objCertStore.getMatches(sid).iterator().next();
                if (valConf != null) {
                    UrlClient client = new UrlClient(valConf.getNetConfiguration());
                    CRL crl = CRLUtils.getCrlForCertificate(client, valConf, new Certificate(cert.getEncoded()), new Date(), valConf.getCertDB());
                    tst_crl[0].setCRL(crl.getDEREncoded());
                }
            }
            tst_crl[0].setTimeStampToken(tstEncoded);
            tsd.setTstEvidence(tst_crl);
            tsd.writeTo(out.getAsOutputStream());
        }
        catch (TSAException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new IOException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new Exception(ex.getMessage(), ex);
        }
        finally {
            if (tsd != null) {
                tsd.free();
            }
        }
    }
}

