/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.tsl.ParsingResults;
import it.actalis.ellips.capi.tsl.rootupdater.TSLInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class RootUpdaterReport {
    private HashMap<String, TSLInfo> tslReportInfo = new HashMap();

    public void addTSLInfo(TSLInfo tslInfo) {
        this.tslReportInfo.put(tslInfo.getNationalId(), tslInfo);
    }

    public TSLInfo getTSLInfoByNationalID(String nationalId) {
        Set<String> keys = this.tslReportInfo.keySet();
        for (String key : keys) {
            TSLInfo value = this.tslReportInfo.get(key);
            if (!value.getNationalId().equalsIgnoreCase(nationalId)) continue;
            return value;
        }
        return null;
    }

    public ArrayList<TSLInfo> getAllTSLInfo() {
        ArrayList<TSLInfo> tsls = new ArrayList<TSLInfo>();
        Set<String> keys = this.tslReportInfo.keySet();
        for (String key : keys) {
            TSLInfo value = this.tslReportInfo.get(key);
            tsls.add(value);
        }
        return tsls;
    }

    public void reset() {
        this.tslReportInfo.clear();
    }

    public boolean isOverAllOK() {
        Set<String> keys = this.tslReportInfo.keySet();
        for (String key : keys) {
            TSLInfo value = this.tslReportInfo.get(key);
            if (value.isParsed()) continue;
            return false;
        }
        return true;
    }

    public int countNotParsed() {
        int notParsedCount = 0;
        Set<String> keys = this.tslReportInfo.keySet();
        for (String key : keys) {
            TSLInfo value = this.tslReportInfo.get(key);
            if (value.isParsed()) continue;
            ++notParsedCount;
        }
        return notParsedCount;
    }

    public ArrayList<TSLInfo> getNotParsed() {
        ArrayList<TSLInfo> tsls = new ArrayList<TSLInfo>();
        Set<String> keys = this.tslReportInfo.keySet();
        for (String key : keys) {
            TSLInfo value = this.tslReportInfo.get(key);
            if (value.isParsed()) continue;
            tsls.add(value);
        }
        return tsls;
    }

    public void toFile(File exportFile) throws IOException {
        exportFile.delete();
        ArrayList<String> lines = new ArrayList<String>();
        Set<String> keys = this.tslReportInfo.keySet();
        for (String key : keys) {
            CertDBItem rootItem;
            int i;
            TSLInfo tslInfo = this.tslReportInfo.get(key);
            if (tslInfo.getParsingResults() == null) continue;
            lines.add(String.format("TSL: %s (%s)", tslInfo.getNationalId(), tslInfo.getUrl()));
            lines.add(String.format("\tProviders: %d", tslInfo.getParsingResults().nProviders));
            lines.add(String.format("\tServices: %d", tslInfo.getParsingResults().nServices));
            lines.add(String.format("\t\tTrusted: %d", tslInfo.getParsingResults().nServiceTrusted));
            lines.add(String.format("\t\tWarning: %d", tslInfo.getParsingResults().nServiceWarning));
            lines.add(String.format("\t\tUntrusted: %d", tslInfo.getParsingResults().nServiceUntrusted));
            lines.add(String.format("\t\tRemoved: %d", tslInfo.getParsingResults().nServiceRemoved));
            lines.add(String.format("\tCertificate: %d", tslInfo.getParsingResults().nTotalCerts));
            lines.add(String.format("\t\tImported: %d", tslInfo.getParsingResults().nCertImported));
            lines.add(String.format("\t\tImported Skipped: %d", tslInfo.getParsingResults().nCertImportSkipped));
            lines.add(String.format("\t\tImported CAIssuer: %d", tslInfo.getParsingResults().nCertImportedByCAIssuer));
            lines.add(String.format("\t\tUpdated: %d", tslInfo.getParsingResults().nCertUpdated));
            lines.add(String.format("\t\tUpdated Skipped: %d", tslInfo.getParsingResults().nCertUpdateSkipped));
            lines.add(String.format("\t\tRemoved: %d", tslInfo.getParsingResults().nCertRemoved));
            lines.add(String.format("\t\tRemoved Skipped: %d", tslInfo.getParsingResults().nCertRemoveSkipped));
            lines.add(String.format("\t\tErrors: %d", tslInfo.getParsingResults().nCertErrors));
            lines.add("");
            lines.add(String.format("\tTRUSTED roots: %d", tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).size()));
            for (i = 0; i < tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).size(); ++i) {
                rootItem = tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).get(i);
                lines.add(String.format("\t\tName: %s", rootItem.getName()));
                lines.add(String.format("\t\tSubject: %s", rootItem.getSubject()));
                lines.add(String.format("\t\tIssuer: %s", rootItem.getIssuer()));
                lines.add(String.format("\t\tSource: %s", rootItem.getSourceAsString()));
                lines.add(String.format("\t\tEllipsUsage: %s", rootItem.getEllipsUsages().toString()));
                lines.add("\t\t-------------------");
            }
            lines.add(String.format("\tWARNING roots: %d", tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).size()));
            for (i = 0; i < tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).size(); ++i) {
                rootItem = tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).get(i);
                lines.add(String.format("\t\tName: %s", rootItem.getName()));
                lines.add(String.format("\t\tSubject: %s", rootItem.getSubject()));
                lines.add(String.format("\t\tIssuer: %s", rootItem.getIssuer()));
                lines.add(String.format("\t\tSource: %s", rootItem.getSourceAsString()));
                lines.add(String.format("\t\tEllipsUsage: %s", rootItem.getEllipsUsages().toString()));
                lines.add("\t\t-------------------");
            }
            lines.add(String.format("\tUNTRUSTED roots: %d", tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).size()));
            for (i = 0; i < tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).size(); ++i) {
                rootItem = tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).get(i);
                lines.add(String.format("\t\tName: %s", rootItem.getName()));
                lines.add(String.format("\t\tSubject: %s", rootItem.getSubject()));
                lines.add(String.format("\t\tIssuer: %s", rootItem.getIssuer()));
                lines.add(String.format("\t\tSource: %s", rootItem.getSourceAsString()));
                lines.add(String.format("\t\tEllipsUsage: %s", rootItem.getEllipsUsages().toString()));
                lines.add("\t\t-------------------");
            }
            lines.add(String.format("\tREMOVED roots: %d", tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.REMOVED.ordinal()).size()));
            for (i = 0; i < tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.REMOVED.ordinal()).size(); ++i) {
                rootItem = tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.REMOVED.ordinal()).get(i);
                lines.add(String.format("\t\tName: %s", rootItem.getName()));
                lines.add(String.format("\t\tSubject: %s", rootItem.getSubject()));
                lines.add(String.format("\t\tIssuer: %s", rootItem.getIssuer()));
                lines.add(String.format("\t\tSource: %s", rootItem.getSourceAsString()));
                lines.add(String.format("\t\tEllipsUsage: %s", rootItem.getEllipsUsages().toString()));
                lines.add("\t\t-------------------");
            }
            lines.add(String.format("\tCAISSUER roots: %d", tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.CAISSUER.ordinal()).size()));
            for (i = 0; i < tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.CAISSUER.ordinal()).size(); ++i) {
                rootItem = tslInfo.getParsingResults().parsedRoots.get(ParsingResults.ParsingStatus.CAISSUER.ordinal()).get(i);
                lines.add(String.format("\t\tName: %s", rootItem.getName()));
                lines.add(String.format("\t\tSubject: %s", rootItem.getSubject()));
                lines.add(String.format("\t\tIssuer: %s", rootItem.getIssuer()));
                lines.add(String.format("\t\tSource: %s", rootItem.getSourceAsString()));
                lines.add(String.format("\t\tEllipsUsage: %s", rootItem.getEllipsUsages().toString()));
                lines.add("\t\t-------------------");
            }
            lines.add("\n-----------------------------------------\n");
        }
        Files.write(exportFile.toPath(), lines, Charset.forName("UTF-8"), new OpenOption[0]);
    }
}

