/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.network;

import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.vol.exception.NetworkException;
import it.actalis.vol.network.Helper;
import it.actalis.vol.utils.ConfigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPShelper
implements Helper {
    private NetworkConfig netConfig = null;
    private Logger logger;
    private String url = null;

    public HTTPShelper(ConfigFile conf, Logger log) {
        this(conf, conf.getIntElement("crl.http.timeout", 5000), log);
    }

    public HTTPShelper(ConfigFile conf, int timeout, Logger log) {
        this(conf, timeout, log, false);
    }

    public HTTPShelper(ConfigFile conf, Logger log, boolean isSogeiProxy) {
        this(conf, conf.getIntElement("crl.http.timeout", 5000), log, isSogeiProxy);
    }

    public HTTPShelper(ValidatorConfig conf, Logger log, boolean isSogeiProxy) {
        this(conf, conf.getIntElement("crl.http.timeout", 5000), log, isSogeiProxy);
    }

    public HTTPShelper(ConfigFile conf, int timeout, Logger log, boolean isSogeiProxy) {
        String px_host = conf.getElement("http.proxy.host", null);
        int px_port = conf.getIntElement("http.proxy.port", 8080);
        String px_user = conf.getElement("http.proxy.user", null);
        String px_pass = conf.getElement("http.proxy.pass", null);
        String px_noph = conf.getElement("http.proxy.noProxyHosts", null);
        String[] px_nohosts = px_noph != null ? px_noph.split(",") : null;
        boolean useHttpProxy = Boolean.valueOf(conf.getElement("http.proxy", "false"));
        boolean useAutoHttpProxy = Boolean.valueOf(conf.getElement("http.proxy.auto", "false"));
        this.netConfig = new NetworkConfig(this.logger, false);
        if (useHttpProxy && !isSogeiProxy) {
            this.netConfig.setProxy(px_host);
            this.netConfig.setProxyPort("" + px_port);
            this.netConfig.setPasswordProxy(px_pass);
            this.netConfig.setUserProxy(px_user);
            this.netConfig.setProxynohosts(px_nohosts);
        } else {
            this.netConfig.setProxy("");
            this.netConfig.setProxyPort("");
            this.netConfig.setPasswordProxy("");
            this.netConfig.setUserProxy("");
            this.netConfig.setProxynohosts(null);
        }
        this.netConfig.setAutomaticProxyDiscovery(useAutoHttpProxy);
        this.netConfig.setConnectionTimeOut("" + timeout);
        this.logger = log == null ? LoggerFactory.getLogger(HTTPShelper.class) : log;
    }

    public HTTPShelper(ValidatorConfig conf, int timeout, Logger log, boolean isSogeiProxy) {
        this.netConfig = conf.getNetConfiguration();
        String px_host = conf.getElement("http.proxy.host", null);
        int px_port = conf.getIntElement("http.proxy.port", 8080);
        String px_user = conf.getElement("http.proxy.user", null);
        String px_pass = conf.getElement("http.proxy.pass", null);
        String px_type = conf.getElement("http.proxy.type", null);
        String px_noph = conf.getElement("http.proxy.noProxyHosts", null);
        String[] px_nohosts = px_noph != null ? px_noph.split(",") : null;
        boolean useHttpProxy = Boolean.valueOf(conf.getElement("http.proxy", "false"));
        boolean useAutoHttpProxy = Boolean.valueOf(conf.getElement("http.proxy.auto", "false"));
        if (this.netConfig == null) {
            this.netConfig = new NetworkConfig(this.logger, false);
        }
        if (useHttpProxy && !isSogeiProxy) {
            this.netConfig.setProxy(px_host);
            this.netConfig.setProxyType(px_type);
            this.netConfig.setProxyPort("" + px_port);
            this.netConfig.setPasswordProxy(px_pass);
            this.netConfig.setUserProxy(px_user);
            this.netConfig.setProxynohosts(px_nohosts);
        } else {
            this.netConfig.setProxy("");
            this.netConfig.setProxyType("");
            this.netConfig.setProxyPort("");
            this.netConfig.setPasswordProxy("");
            this.netConfig.setUserProxy("");
            this.netConfig.setProxynohosts(null);
        }
        this.netConfig.setAutomaticProxyDiscovery(useAutoHttpProxy);
        this.netConfig.setConnectionTimeOut("" + timeout);
        this.logger = log == null ? LoggerFactory.getLogger(HTTPShelper.class) : log;
    }

    @Override
    public byte[] retrieveData() throws NetworkException {
        return this.retrieveData(this.url);
    }

    @Override
    public byte[] retrieveData(String url) throws NetworkException {
        UrlClient client = new UrlClient(this.netConfig, this.logger);
        UrlReturn ret = client.downloadUrl(url, null, null);
        if (ret.getStatus().equals("OK")) {
            return ret.getData();
        }
        this.logger.error("Errore Download code :" + ret.getStatus_code());
        return null;
    }

    public byte[] postAuthData(String url, String username, String password, byte[] content, String contentType) throws NetworkException {
        UrlClient client = new UrlClient(this.netConfig, this.logger);
        URLCredentials creds = new URLCredentials(username, password, null, null);
        RequestData rdata = new RequestData();
        rdata.setContentType(contentType);
        rdata.setPostdata(content);
        UrlReturn ret = client.downloadUrl(url, rdata, creds);
        if (ret.getStatus().equals("OK")) {
            return ret.getData();
        }
        this.logger.error("Errore Download code :" + ret.getStatus_code());
        return null;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }
}

