/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class ConfigFile {
    protected static final String FALSE = "false";
    protected static final String TRUE = "true";
    protected static final String DEF_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss zzz";
    protected static final String EQ_SEP = "=";
    protected static final String LINK_INDICATOR = "@";
    protected Properties configdb = null;
    protected String fullPath = null;

    public ConfigFile(String fileName) {
        if (fileName != null) {
            this.fullPath = new File(fileName).getAbsolutePath();
        }
        this.configdb = new Properties();
    }

    public ConfigFile(ConfigFile parent, String fileName) {
        if (fileName != null) {
            this.fullPath = new File(fileName).getAbsolutePath();
        }
        this.configdb = new Properties(parent.configdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCF(String[] tags, String[] params) throws IOException {
        try (PrintWriter wCfgFile = null;){
            wCfgFile = new PrintWriter(new FileOutputStream(this.fullPath));
            for (int i = 0; i < params.length; ++i) {
                wCfgFile.println(tags[i] + EQ_SEP + params[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfigFile() throws FileNotFoundException, IOException {
        try (FileInputStream input = null;){
            input = new FileInputStream(this.fullPath);
            this.configdb.load(input);
        }
    }

    public String getElement(String elementTag) {
        return this.getElement(elementTag, null);
    }

    public String getElement(String elementTag, String defaultValue) {
        String prop = this.configdb.getProperty(elementTag, defaultValue);
        if (prop != null && (prop = prop.trim()).startsWith(LINK_INDICATOR)) {
            prop = prop.substring(LINK_INDICATOR.length());
            prop = this.getElement(prop, defaultValue);
        }
        return prop;
    }

    public int getIntElement(String elementTag, int defaultValue) {
        try {
            return Integer.parseInt(this.getElement(elementTag));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBinElement(String elementTag, boolean defaultValue) {
        String res = this.getElement(elementTag);
        if (res == null) {
            return defaultValue;
        }
        return TRUE.equals(res = res.toLowerCase());
    }

    public String[] getElements(String elementTag, String defaultValue, int numElements) {
        String[] res = new String[numElements];
        for (int i = 0; i < numElements; ++i) {
            int temp = i + 1;
            res[i] = this.getElement(elementTag + temp, defaultValue);
        }
        return res;
    }

    public void setElement(String elementTag, String elementValue) {
        if (elementValue == null) {
            this.configdb.setProperty(elementTag.trim(), null);
        } else {
            this.configdb.setProperty(elementTag.trim(), elementValue.trim());
        }
    }

    public void setBinElement(String elementTag, boolean elementValue) {
        if (elementValue) {
            this.configdb.setProperty(elementTag.trim(), TRUE);
        } else {
            this.configdb.setProperty(elementTag.trim(), FALSE);
        }
    }

    public boolean saveConfigFile() {
        try {
            FileOutputStream configFile = new FileOutputStream(this.fullPath, false);
            this.configdb.store(configFile, null);
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCF(String[][] tags_params) throws IOException {
        try (PrintWriter wCfgFile = null;){
            wCfgFile = new PrintWriter(new FileOutputStream(this.fullPath));
            for (int i = 0; i < tags_params.length; ++i) {
                if (tags_params[i][0] == null) {
                    wCfgFile.println("#" + tags_params[i][1]);
                    continue;
                }
                if (tags_params[i][1] == null) {
                    wCfgFile.println("#" + tags_params[i][0]);
                    continue;
                }
                wCfgFile.println(tags_params[i][0] + EQ_SEP + tags_params[i][1]);
            }
        }
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        if (fullPath != null) {
            this.fullPath = new File(fullPath).getAbsolutePath();
        }
    }

    public Properties getConfigDB() {
        return this.configdb;
    }

    public static enum TAG {
        isTimeZoneUTC,
        timeZone;

    }
}

