/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.utils;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;

public class Rebound {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private String packagePrefix;
    private static boolean logging = false;
    private boolean includeAbstract;
    private boolean includeInterface;
    private ClassLoader classLoader;
    private Set<Class> temp_classes_set;

    public Rebound() {
        this("");
    }

    public Rebound(String packagePrefix) {
        this(packagePrefix, false);
    }

    public Rebound(String packagePrefix, ClassLoader classLoader) {
        this(packagePrefix, false, false, classLoader);
    }

    public Rebound(String packagePrefix, boolean includeAbstractAndInteface) {
        this(packagePrefix, includeAbstractAndInteface, includeAbstractAndInteface);
    }

    public Rebound(String packagePrefix, boolean includeAbstract, boolean includeInteface) {
        this(packagePrefix, includeAbstract, includeInteface, Thread.currentThread().getContextClassLoader());
    }

    public Rebound(String packagePrefix, boolean includeAbstract, boolean includeInteface, ClassLoader classLoader) {
        this.packagePrefix = packagePrefix == null ? "" : packagePrefix;
        this.includeAbstract = includeAbstract;
        this.includeInterface = includeInteface;
        this.classLoader = classLoader;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix == null ? "" : packagePrefix;
    }

    public void setIncludeAbstractAndInteface(boolean includeAbstractAndInteface) {
        this.includeAbstract = includeAbstractAndInteface;
        this.includeInterface = includeAbstractAndInteface;
    }

    public void setIncludeAbstract(boolean includeAbstract) {
        this.includeAbstract = includeAbstract;
    }

    public void setIncludeInterface(boolean includeInterface) {
        this.includeInterface = includeInterface;
    }

    public <T> Set<Class<? extends T>> getSubClassesOf(Class<T> clazz) {
        Iterator it;
        HashSet<Class<T>> subClazzes;
        long start;
        block9: {
            start = System.currentTimeMillis();
            if (this.packagePrefix.isEmpty() && logging) {
                logger.warn("Package prefix is empty. Rebound will look for subclasses inside every jar file under your classpath in this case. This is a lengthy and time consuming process. Please consider using Rebound with prefix.");
            }
            subClazzes = new HashSet<Class<T>>();
            try {
                Set<Class> classes = this.getClassesUnderPackagePrefix(this.packagePrefix);
                for (Class clz : classes) {
                    if (!clazz.isAssignableFrom(clz)) continue;
                    subClazzes.add(clz);
                }
            }
            catch (Exception ex) {
                if (!logging) break block9;
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (!this.includeAbstract) {
            it = subClazzes.iterator();
            while (it.hasNext()) {
                int modifiers = ((Class)it.next()).getModifiers();
                if (!Modifier.isAbstract(modifiers)) continue;
                it.remove();
            }
        }
        if (!this.includeInterface) {
            it = subClazzes.iterator();
            while (it.hasNext()) {
                int modifiers = ((Class)it.next()).getModifiers();
                if (!Modifier.isInterface(modifiers)) continue;
                it.remove();
            }
        }
        long elapsed = System.currentTimeMillis() - start;
        if (logging) {
            logger.info("Rebound uses " + elapsed + " milliseconds to look up subclasses of " + clazz.getName() + " in package " + this.packagePrefix + ".*");
        }
        return subClazzes;
    }

    private Set<Class> getClassesUnderPackagePrefix(String packagePrefix) throws ClassNotFoundException, IOException {
        String packagePath = packagePrefix.replace('.', '/');
        Enumeration<URL> resources = this.classLoader.getResources(packagePath);
        this.temp_classes_set = new HashSet<Class>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (Rebound.isSqlLiteFile(resource)) {
                this.addClassesFromSqlLIte(resource, packagePrefix);
                continue;
            }
            if (Rebound.isJarFile(resource)) {
                this.addClassesFromJarFile(resource, packagePrefix);
                continue;
            }
            File file = Rebound.toFile(resource);
            if (!file.exists() || !file.isDirectory()) continue;
            this.addClassesFromDirectory(file, packagePrefix);
        }
        if (packagePrefix.isEmpty()) {
            String[] classPaths = System.getProperty("java.class.path").split(";");
            HashSet<String> classPathSet = new HashSet<String>(Arrays.asList(classPaths));
            for (String string : classPathSet) {
                URL jarUrl;
                File file = new File(string);
                if (!file.exists() || !file.isFile() || !file.getName().endsWith(".jar") || (jarUrl = Rebound.toURL(file)) == null) continue;
                this.addClassesFromJarFile(jarUrl, packagePath);
            }
        }
        return this.temp_classes_set;
    }

    private void addClassesFromDirectory(File directory, String packageName) throws ClassNotFoundException {
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                String filename = file.getName();
                if (file.isDirectory()) {
                    this.addClassesFromDirectory(file, packageName + (packageName.isEmpty() ? "" : ".") + filename);
                    continue;
                }
                if (!filename.endsWith(".class")) continue;
                this.temp_classes_set.add(Class.forName(packageName + (packageName.isEmpty() ? "" : ".") + filename.substring(0, filename.length() - 6)));
            }
        }
    }

    private void addClassesFromJarFile(URL url, String packageName) {
        String packagePathFilter = packageName.replace('.', '/');
        Enumeration<JarEntry> allEntries = Rebound.toJarFile(url).entries();
        while (allEntries.hasMoreElements()) {
            JarEntry jarEntry = allEntries.nextElement();
            String entryName = jarEntry.getName();
            if (jarEntry.isDirectory() || !entryName.startsWith(packagePathFilter) || !entryName.endsWith(".class")) continue;
            try {
                String className = jarEntry.getName().replaceFirst("\\.class$", "").replace("/", ".");
                this.temp_classes_set.add(Class.forName(className, false, this.classLoader));
            }
            catch (Throwable ex) {
                if (!logging) continue;
                logger.error("Cannot get Class for name : " + jarEntry.getName(), ex);
            }
        }
    }

    private void addClassesFromSqlLIte(URL url, String packageName) {
        block3: {
            try {
                if (url.getFile().endsWith(".class")) {
                    String className = url.getFile().replaceFirst("\\.class$", "").replace("/", ".");
                    this.temp_classes_set.add(Class.forName(className, false, this.classLoader));
                }
            }
            catch (Throwable ex) {
                if (!logging) break block3;
                logger.error("Cannot get Class for name : " + url.getFile(), ex);
            }
        }
    }

    private static boolean isJarFile(URL url) {
        return url.toString().startsWith("jar:file:");
    }

    private static boolean isSqlLiteFile(URL url) {
        return url.toString().startsWith("sqllite");
    }

    private static File toFile(URL url) {
        try {
            String filepath = URLDecoder.decode(url.getFile(), "UTF-8");
            return new File(filepath);
        }
        catch (UnsupportedEncodingException ex) {
            if (logging) {
                logger.error("Unable to decode jar file location using UTF-8.", (Throwable)ex);
            }
            if (logging) {
                logger.warn("URL is not decoded : " + url.toString());
            }
            return new File(url.toString());
        }
    }

    private static JarFile toJarFile(URL url) {
        block6: {
            try {
                String rawJarPath = URLDecoder.decode(url.getFile(), "UTF-8");
                String jarPath = rawJarPath.replaceFirst("!.*$", "").replaceFirst("^file:", "");
                try {
                    JarFile jarFile = new JarFile(jarPath);
                    return jarFile;
                }
                catch (IOException ex) {
                    if (logging) {
                        logger.error("Cannot create JarFile object for path : " + jarPath, (Throwable)ex);
                    }
                }
            }
            catch (UnsupportedEncodingException ex) {
                if (!logging) break block6;
                logger.error("Unable to decode jar file location using UTF-8.", (Throwable)ex);
            }
        }
        if (logging) {
            logger.info("Null JarFile is returned.");
        }
        return null;
    }

    private static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (IOException ex) {
            if (logging) {
                logger.error("Cannot create JarFile object for path : " + file.getPath(), (Throwable)ex);
            }
            if (logging) {
                logger.info("Null JarFile is returned.");
            }
            return null;
        }
    }
}

