/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.pades;

import esecurity.validator.bean.PadesSpecific;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.pades.enums.PadesCertificationLevel;
import java.util.LinkedList;

public class PadesStepSignatureValidCertificationCheck
extends SingleValidationSubStepImpl {
    public PadesStepSignatureValidCertificationCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        SignatureInformation signInfo;
        if (param != null && param.getSignature() != null && (signInfo = param.getSignature()).getPadesSpecific() != null) {
            PadesSpecific thisPadesSpec = signInfo.getPadesSpecific();
            if (thisPadesSpec.isNextRevisionsUpdateObject()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0017_INVALID_MODIFICATION_AFTER_SIGNING, new Object[0]);
            }
            if (thisPadesSpec.isNextRevisionsUpdateForm() && thisPadesSpec.getCertificationLevel().getLevelValue() == PadesCertificationLevel.CERTIFIED_NO_CHANGES_ALLOWED.getLiv()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0018_FORM_UPDATE_NOT_ALLOWED_AFTER_CERTIFICATION, new Object[0]);
            }
            if (thisPadesSpec.isNextRevisionsUpdateAnnotation() && (thisPadesSpec.getCertificationLevel().getLevelValue() == PadesCertificationLevel.CERTIFIED_NO_CHANGES_ALLOWED.getLiv() || thisPadesSpec.getCertificationLevel().getLevelValue() == PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING.getLiv())) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0019_ANNOTATION_UPDATE_NOT_ALLOWED_AFTER_CERTIFICATION, new Object[0]);
            }
            if (thisPadesSpec.isNextRevisionsSigned() && thisPadesSpec.getCertificationLevel().getLevelValue() == PadesCertificationLevel.CERTIFIED_NO_CHANGES_ALLOWED.getLiv()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0017_SIGNATURES_NOT_ALLOWED_AFTER_CERTIFICATION, new Object[0]);
            }
        }
        return null;
    }
}

