/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class CadesSignedDataProxy {
    private CMSSignedDataParser parser = null;
    private CMSSignedData signedData = null;

    public CadesSignedDataProxy(CMSSignedDataParser parser) {
        this.parser = parser;
    }

    public CadesSignedDataProxy(CMSSignedData signedData) {
        this.signedData = signedData;
    }

    public CMSSignedDataParser getParser() {
        return this.parser;
    }

    public CMSSignedData getSignedData() {
        return this.signedData;
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this.parser != null) {
            return this.parser.getSignerInfos();
        }
        return this.signedData.getSignerInfos();
    }

    public LinkedList<X509Certificate> getCertificates() throws Exception {
        LinkedList<X509Certificate> lstReturn = new LinkedList<X509Certificate>();
        Collection certs = null;
        certs = this.parser != null ? this.parser.getCertificates().getMatches(null) : this.signedData.getCertificates().getMatches(null);
        if (certs.isEmpty()) {
            return lstReturn;
        }
        LinkedList list = new LinkedList(certs);
        for (X509CertificateHolder holdCert : list) {
            lstReturn.add(new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(holdCert));
        }
        return lstReturn;
    }

    public LinkedList<CRL> getCRLS() throws CapiException, CRLException, CMSException {
        LinkedList<CRL> lstReturn = new LinkedList<CRL>();
        Collection crls = null;
        crls = this.parser != null ? this.parser.getCRLs().getMatches(null) : this.signedData.getCRLs().getMatches(null);
        if (crls.isEmpty()) {
            return lstReturn;
        }
        LinkedList list = new LinkedList(crls);
        for (X509CRLHolder holdCrl : list) {
            lstReturn.add(new CRL(new JcaX509CRLConverter().setProvider(ProvUtils.bcProvider).getCRL(holdCrl).getEncoded()));
        }
        return lstReturn;
    }

    public LinkedList<BasicOCSPResp> getBasicOCSPResponses() throws CMSException, CRLException {
        LinkedList<BasicOCSPResp> lstReturn = new LinkedList<BasicOCSPResp>();
        Collection responses = null;
        responses = this.parser != null ? this.parser.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic).getMatches(null) : this.signedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic).getMatches(null);
        if (responses.isEmpty()) {
            return lstReturn;
        }
        LinkedList list = new LinkedList(responses);
        for (Object resp : list) {
            lstReturn.add(this.getBasicOCSPResp((ASN1Sequence)resp));
        }
        return lstReturn;
    }

    public LinkedList<OCSPResp> getOCSPResponses() throws CMSException, CRLException {
        LinkedList<OCSPResp> lstReturn = new LinkedList<OCSPResp>();
        Collection responses = null;
        responses = this.parser != null ? this.parser.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response).getMatches(null) : this.signedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response).getMatches(null);
        if (responses.isEmpty()) {
            return lstReturn;
        }
        LinkedList list = new LinkedList(responses);
        for (Object resp : list) {
            lstReturn.add(this.getOcspResp((ASN1Sequence)resp));
        }
        return lstReturn;
    }

    private OCSPResp getOcspResp(ASN1Sequence otherRevocationInfoMatch) {
        OCSPResp ocspResp = null;
        OCSPResponse ocspResponse = OCSPResponse.getInstance((Object)otherRevocationInfoMatch);
        ocspResp = new OCSPResp(ocspResponse);
        return ocspResp;
    }

    private BasicOCSPResp getBasicOCSPResp(ASN1Sequence otherRevocationInfoMatch) {
        BasicOCSPResp basicOCSPResp = null;
        BasicOCSPResponse basicOcspResponse = BasicOCSPResponse.getInstance((Object)otherRevocationInfoMatch);
        basicOCSPResp = new BasicOCSPResp(basicOcspResponse);
        return basicOCSPResp;
    }

    public byte[] getRawSignature(int signerInfoIndex) throws CapiException {
        try {
            SignerInformationStore sig_infos = this.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            String asn1Encoding = "DER";
            if (signerInformVector.elementAt(signerInfoIndex) != null && ((SignerInformation)signerInformVector.elementAt(signerInfoIndex)).toASN1Structure() != null && ((SignerInformation)signerInformVector.elementAt(signerInfoIndex)).toASN1Structure().getAuthenticatedAttributes() != null && !Arrays.equals(((SignerInformation)signerInformVector.elementAt(signerInfoIndex)).toASN1Structure().getAuthenticatedAttributes().getEncoded(), ((SignerInformation)signerInformVector.elementAt(signerInfoIndex)).toASN1Structure().getAuthenticatedAttributes().getEncoded("DER"))) {
                asn1Encoding = "DL";
                return this.getRaw(((SignerInformation)signerInformVector.elementAt(signerInfoIndex)).toASN1Structure(), asn1Encoding);
            }
            return ((SignerInformation)signerInformVector.elementAt(signerInfoIndex)).toASN1Structure().getEncoded(asn1Encoding);
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CapiException("Cannot get signature value", 50023);
        }
    }

    private byte[] getRaw(SignerInfo info, String encoding) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector(7);
        v.add((ASN1Encodable)info.getVersion());
        v.add((ASN1Encodable)info.getSID());
        v.add((ASN1Encodable)info.getDigestAlgorithm());
        if (info.getAuthenticatedAttributes() != null) {
            v.add((ASN1Encodable)new DLTaggedObject(false, 0, (ASN1Encodable)info.getAuthenticatedAttributes()));
        }
        v.add((ASN1Encodable)info.getDigestEncryptionAlgorithm());
        v.add((ASN1Encodable)info.getEncryptedDigest());
        if (info.getUnauthenticatedAttributes() != null) {
            v.add((ASN1Encodable)new DLTaggedObject(false, 1, (ASN1Encodable)info.getUnauthenticatedAttributes()));
        }
        return new DLSequence(v).getEncoded(encoding);
    }

    public Date getSigningTime(int signerInfoIndex) throws CapiException {
        try {
            SignerInformationStore sig_infos = null;
            sig_infos = this.parser != null ? this.parser.getSignerInfos() : this.signedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            return this.getSignatureTime(sigInfo);
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CapiException("Cannot get signature value", 50023);
        }
    }

    private Date getSignatureTime(SignerInformation signer) {
        Attribute attr;
        AttributeTable atab = signer.getSignedAttributes();
        Date result = null;
        if (atab != null && (attr = atab.get(CMSAttributes.signingTime)) != null) {
            Time t = Time.getInstance((Object)attr.getAttrValues().getObjectAt(0).toASN1Primitive());
            result = t.getDate();
        }
        return result;
    }

    public int getNumberOfSigners() {
        int numOfSig = -1;
        SignerInformationStore sig_infos = null;
        if (this.parser != null) {
            try {
                sig_infos = this.parser.getSignerInfos();
            }
            catch (CMSException cMSException) {}
        } else {
            sig_infos = this.signedData.getSignerInfos();
        }
        if (sig_infos != null && sig_infos.getSigners() != null) {
            numOfSig = sig_infos.getSigners().size();
        }
        return numOfSig;
    }
}

