/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pkcs7.EncryptedEnvelope;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.cms.ContentInfoParser;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class StreamEncryptedEnvelope {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int DES_EDE3_CBC = 0;
    public static final int RC2_CBC = 1;
    public static final int AES256_CBC = 2;
    public static final int CAMELLIA256_CBC = 3;
    private int status = -1;
    private static final int ST_CREATE = 0;
    private static final int ST_CIPH_ADDING = 2;
    private static final int ST_CIPH = 3;
    private static final int ST_PARSE = 4;
    private InputStream der_enc = null;
    protected CMSEnvelopedDataParser envelopedData = null;
    private CMSEnvelopedDataStreamGenerator fact = null;
    protected ASN1ObjectIdentifier contentEA = CMSAlgorithm.DES_EDE3_CBC;
    static boolean debug = false;

    public StreamEncryptedEnvelope() throws CapiException {
        this.status = 0;
        this.contentEA = CMSAlgorithm.DES_EDE3_CBC;
        logger.debug("data encryption algorithm set to DES_EDE3_CBC");
        this.envelopedData = null;
    }

    public StreamEncryptedEnvelope(int mode) throws CapiException {
        this.status = 0;
        if (mode == 3) {
            this.contentEA = CMSAlgorithm.CAMELLIA256_CBC;
            logger.debug("Content encryption algorithm set to CAMELLIA256_CBC");
            this.envelopedData = null;
            return;
        }
        if (mode == 2) {
            this.contentEA = CMSAlgorithm.AES256_CBC;
            logger.debug("Content encryption algorithm set to AES256_CBC");
            this.envelopedData = null;
            return;
        }
        if (mode == 1) {
            this.contentEA = CMSAlgorithm.RC2_CBC;
            logger.debug("Content encryption algorithm set to RC2_CBC");
            this.envelopedData = null;
            return;
        }
        if (mode == 0) {
            this.contentEA = CMSAlgorithm.DES_EDE3_CBC;
            logger.debug("Content encryption algorithm set to DES_EDE3_CBC");
            this.envelopedData = null;
            return;
        }
        throw new CapiException("Supplied mode is invalid", 1002);
    }

    public void addRecipient(byte[] certificate) throws CapiException {
        X509Certificate x509cert = new Certificate(certificate).getInternalCert();
        this.addRecipient(x509cert);
    }

    public void addRecipient(byte[] certificate, boolean useSubjKeyId) throws CapiException {
        Certificate capicer = new Certificate(certificate);
        X509Certificate x509cert = capicer.getInternalCert();
        if (x509cert == null) {
            throw new CapiException("No certificate", 30005);
        }
        if (!useSubjKeyId) {
            this.addRecipient(x509cert);
            return;
        }
        byte[] skid = capicer.getSubjectKeyIdentifier();
        if (skid == null || skid.length <= 0) {
            throw new CapiException("Missing Extension Subject Key Identifier", 30006);
        }
        this.addRecipient(x509cert, skid);
    }

    public void addRecipientFromToken(String alias) throws CapiException {
        TokenSpi tk = ProvUtils.retrieveTokenByAlias((String)alias);
        byte[] cert = null;
        try {
            logger.debug("[addRecipientFromToken] getting credential...");
            cert = Util.getBytes((String)tk.getCert(alias));
            logger.debug("[addRecipientFromToken] getting credential ok");
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        this.addRecipient(cert);
    }

    public void getEncoded(InputStream message, OutputStream der_stream, boolean b64) throws CapiException {
        OutputStream b64Stream = null;
        try {
            if (message == null || der_stream == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.status < 2) {
                throw new CapiException("Recipient(s) must be set before", 51001);
            }
            if (this.status == 4 || this.status == 3) {
                throw new CapiException("Cannot ciphered", 51002);
            }
            logger.debug("Creating envelopedData ...");
            if (this.envelopedData != null) {
                throw new CapiException("Why envelopedData not null ?", 51002);
            }
            if (this.fact == null) {
                throw new CapiException("Factory is null ?", 51002);
            }
            OutputStream copyData = null;
            JceCMSContentEncryptorBuilder jceceb = new JceCMSContentEncryptorBuilder(this.contentEA).setProvider(ProvUtils.bcProvider);
            if (b64) {
                b64Stream = new Base64OutputStream(der_stream, true);
                copyData = this.fact.open(b64Stream, jceceb.build());
            } else {
                copyData = this.fact.open(der_stream, jceceb.build());
            }
            byte[] dataBytes = new byte[4096];
            int nread = message.read(dataBytes);
            while (nread > 0) {
                copyData.write(dataBytes, 0, nread);
                nread = message.read(dataBytes);
            }
            copyData.close();
            this.status = 3;
            logger.debug("Envelope saved.");
        }
        catch (Exception x) {
            logger.debug(x.getMessage(), (Throwable)x);
            throw new CapiException("Error encoding envelope", 50022);
        }
        catch (CapiError err) {
            logger.debug(err.getMessage(), (Throwable)err);
            throw err.getCapiException();
        }
        finally {
            try {
                if (b64Stream != null) {
                    b64Stream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                der_stream.close();
            }
            catch (Exception exception) {}
            try {
                message.close();
            }
            catch (Exception exception) {}
        }
    }

    public void getEncoded(InputStream message, OutputStream der_stream) throws CapiException {
        this.getEncoded(message, der_stream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamEncryptedEnvelope(InputStream der_encoded) throws CapiException {
        try {
            if (der_encoded == null) {
                throw new CapiException("Null data", 1001);
            }
            this.parse(der_encoded);
            logger.debug("parsed ok");
            this.status = 4;
            this.der_enc = der_encoded;
        }
        finally {
            logger.debug("der_encoded close after decrypt method");
        }
    }

    public String getEncryptionAlgorithm() {
        if (this.status == 0 || this.status == 2) {
            return this.contentEA.getId();
        }
        return this.envelopedData.getEncryptionAlgOID();
    }

    public String[] listRecipients(String separator) throws CapiException {
        if (this.envelopedData == null) {
            throw new CapiException("Data must be encrypted before", 51001);
        }
        try {
            logger.debug("getting recipients...");
            RecipientInformationStore rec_infos = this.envelopedData.getRecipientInfos();
            Collection recColl = rec_infos.getRecipients();
            Vector recVector = new Vector(recColl);
            logger.debug("recipients are " + recVector.size());
            String[] res = new String[recVector.size()];
            for (int i = 0; i < recVector.size(); ++i) {
                RecipientInformation ri = (RecipientInformation)recVector.elementAt(i);
                KeyTransRecipientId ktri = (KeyTransRecipientId)ri.getRID();
                res[i] = ktri.getSerialNumber().toString() + separator + ktri.getIssuer().toString();
            }
            return res;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    public Map<String, X500Name> listRecipients() throws CapiException {
        if (this.envelopedData == null) {
            throw new CapiException("Data must be encrypted before", 51001);
        }
        try {
            logger.debug("getting recipients...");
            RecipientInformationStore rec_infos = this.envelopedData.getRecipientInfos();
            Collection recColl = rec_infos.getRecipients();
            Vector recVector = new Vector(recColl);
            logger.debug("recipients are " + recVector.size());
            HashMap<String, X500Name> res = new HashMap<String, X500Name>();
            for (int i = 0; i < recVector.size(); ++i) {
                RecipientInformation ri = (RecipientInformation)recVector.elementAt(i);
                KeyTransRecipientId ktri = (KeyTransRecipientId)ri.getRID();
                res.put(ktri.getSerialNumber().toString(), ktri.getIssuer());
            }
            return res;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrypt(String alias, OutputStream save_internal_doc) throws CapiException {
        try {
            if (save_internal_doc == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.status < 3) {
                throw new CapiException("Data must be encrypted before", 51001);
            }
            TokenSpi tk = ProvUtils.retrieveTokenByAlias((String)alias);
            X509Certificate cert = null;
            PrivateKey privKey = null;
            try {
                logger.debug("[decrypt] getting credential from token...");
                String pemcert = tk.getCert(alias);
                if (pemcert == null) {
                    throw new CapiException("alias not found", 51010);
                }
                Certificate capicer = new Certificate(Util.getBytes((String)pemcert));
                cert = capicer.getInternalCert();
                logger.debug("...cert ok");
                KeyTransRecipientId recId = new KeyTransRecipientId(JcaX500NameUtil.getIssuer((X509Certificate)cert), cert.getSerialNumber());
                RecipientInformationStore rec_infos = this.envelopedData.getRecipientInfos();
                KeyTransRecipientInformation recipient = (KeyTransRecipientInformation)rec_infos.get((RecipientId)recId);
                if (recipient != null) {
                    logger.debug("[decrypt] recipient Issuer and Serial number match token alias certificate");
                } else {
                    logger.debug("[decrypt] try using subject key identifier...");
                    byte[] skid = capicer.getSubjectKeyIdentifier();
                    if (skid == null || skid.length == 0) {
                        throw new CapiException("Token alias certificate not match", 51010);
                    }
                    recId = new KeyTransRecipientId(skid);
                    recipient = (KeyTransRecipientInformation)rec_infos.get((RecipientId)recId);
                    if (recipient != null) {
                        logger.debug("[decrypt] recipient SubjectKeyIdentifier match token alias certificate");
                    } else {
                        throw new CapiException("Token alias certificate not match", 51010);
                    }
                }
                privKey = tk.getPrivateKey(alias);
                JceKeyTransEnvelopedRecipient jceR = new JceKeyTransEnvelopedRecipient(privKey);
                jceR.setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privKey));
                jceR.setContentProvider(ProvUtils.bcProvider);
                CMSTypedStream typedStream = recipient.getContentStream((Recipient)jceR);
                InputStream is = typedStream.getContentStream();
                logger.debug("decrypting data...");
                Streams.pipeAll((InputStream)is, (OutputStream)save_internal_doc);
                logger.debug("[decrypt] done.");
            }
            catch (CapiException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("IOException", 50050);
            }
            catch (CMSException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("CMSException", 50050);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 50050);
            }
            catch (CapiError err) {
                logger.debug(err.getMessage(), (Throwable)err);
                throw err.getCapiException();
            }
        }
        finally {
            try {
                if (save_internal_doc != null) {
                    save_internal_doc.close();
                }
            }
            catch (IOException iOException) {}
            logger.debug("closing der_encoded stream ...");
            try {
                this.der_enc.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrypt(TokenSpi tk, String alias, OutputStream save_internal_doc) throws CapiException {
        boolean bRet = true;
        try {
            if (save_internal_doc == null || tk == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.status < 3) {
                throw new CapiException("Data must be encrypted before", 51001);
            }
            X509Certificate cert = null;
            PrivateKey privKey = null;
            try {
                logger.debug("[decrypt] getting credential from token...");
                String pemcert = tk.getCert(alias);
                if (pemcert == null) {
                    throw new CapiException("alias not found", 51010);
                }
                Certificate capicer = new Certificate(Util.getBytes((String)pemcert));
                cert = capicer.getInternalCert();
                logger.debug("...cert ok");
                KeyTransRecipientId recId = new KeyTransRecipientId(JcaX500NameUtil.getIssuer((X509Certificate)cert), cert.getSerialNumber());
                RecipientInformationStore rec_infos = this.envelopedData.getRecipientInfos();
                KeyTransRecipientInformation recipient = (KeyTransRecipientInformation)rec_infos.get((RecipientId)recId);
                if (recipient != null) {
                    logger.debug("[decrypt] recipient Issuer and Serial number match token alias certificate");
                } else {
                    logger.debug("[decrypt] try using subject key identifier...");
                    byte[] skid = capicer.getSubjectKeyIdentifier();
                    if (skid == null || skid.length == 0) {
                        throw new CapiException("Token alias certificate not match", 51010);
                    }
                    recId = new KeyTransRecipientId(skid);
                    recipient = (KeyTransRecipientInformation)rec_infos.get((RecipientId)recId);
                    if (recipient != null) {
                        logger.debug("[decrypt] recipient SubjectKeyIdentifier match token alias certificate");
                    } else {
                        throw new CapiException("Token alias certificate not match", 51010);
                    }
                }
                privKey = tk.getPrivateKey(alias);
                JceKeyTransEnvelopedRecipient jceR = new JceKeyTransEnvelopedRecipient(privKey);
                jceR.setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privKey));
                jceR.setContentProvider(ProvUtils.bcProvider);
                CMSTypedStream typedStream = recipient.getContentStream((Recipient)jceR);
                InputStream is = typedStream.getContentStream();
                logger.debug("decrypting data...");
                Streams.pipeAll((InputStream)is, (OutputStream)save_internal_doc);
                logger.debug("[decrypt] done.");
            }
            catch (CapiException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("IOException", 50050);
            }
            catch (CMSException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("CMSException", 50050);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 50050);
            }
            catch (CapiError err) {
                logger.debug(err.getMessage(), (Throwable)err);
                throw err.getCapiException();
            }
        }
        finally {
            try {
                if (save_internal_doc != null) {
                    save_internal_doc.close();
                }
            }
            catch (IOException iOException) {}
            logger.debug("closing der_encoded stream ...");
            try {
                this.der_enc.close();
            }
            catch (IOException iOException) {}
        }
        return bRet;
    }

    public String toString() {
        try {
            switch (this.status) {
                case 0: {
                    return "Envelope not ciphered yet";
                }
                case 3: 
                case 4: {
                    return this.envelopedData.toString();
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEncryptedEnvelope(InputStream der_encoded) {
        boolean bl;
        if (der_encoded == null) {
            return false;
        }
        ASN1StreamParser in = null;
        ASN1SequenceParser asn1seq = null;
        try {
            in = new ASN1StreamParser(der_encoded);
            asn1seq = (ASN1SequenceParser)in.readObject();
            ContentInfoParser cinfo = new ContentInfoParser(asn1seq);
            if (cinfo.getContentType().getId().compareToIgnoreCase(PKCSObjectIdentifiers.envelopedData.getId()) == 0) {
                logger.debug("[StreamEncryptedEnvelope] isEncryptedEnvelope true");
                boolean bl2 = true;
                return bl2;
            }
            logger.debug("[StreamEncryptedEnvelope] isEncryptedEnvelope false");
            bl = false;
        }
        catch (ClassCastException ce) {
            logger.debug("[StreamEncryptedEnvelope] ClassCastException");
            logger.debug(ce.getMessage(), (Throwable)ce);
            boolean bl3 = false;
            return bl3;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                der_encoded.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    private void addRecipient(X509Certificate x509Cert, byte[] subjectKeyIdentifier) throws CapiException {
        if (this.status == 4 || this.status == 3) {
            throw new CapiException("Cannot add recipient", 51002);
        }
        logger.debug("adding Recipient ...");
        try {
            if (this.status != 2) {
                this.fact = new CMSEnvelopedDataStreamGenerator();
            }
            JceKeyTransRecipientInfoGenerator rgen = null;
            if (subjectKeyIdentifier != null) {
                logger.debug("Recipient subjectkeyidentifier ...");
                rgen = new JceKeyTransRecipientInfoGenerator(subjectKeyIdentifier, x509Cert.getPublicKey());
            } else {
                logger.debug("Recipient Issuer and Serial number ...");
                rgen = new JceKeyTransRecipientInfoGenerator(x509Cert);
            }
            this.fact.addRecipientInfoGenerator((RecipientInfoGenerator)rgen.setProvider(ProvUtils.bcProvider));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        logger.debug("Recipient added.");
        this.status = 2;
    }

    private void addRecipient(X509Certificate x509Cert) throws CapiException {
        this.addRecipient(x509Cert, null);
    }

    private void parse(InputStream der_encoded) throws CapiException {
        try {
            der_encoded = new BufferedInputStream(der_encoded);
            this.envelopedData = new CMSEnvelopedDataParser(der_encoded);
            logger.debug("Content encryption algorithm: " + this.envelopedData.getEncryptionAlgOID() + " (" + EncryptedEnvelope.getContentEncryptionAlgName(this.envelopedData.getEncryptionAlgOID()) + ")");
            logger.debug("parsed enveloped data ok");
        }
        catch (CMSException e) {
            try {
                der_encoded.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Envelope format unknown or not implemented", 50023);
        }
        catch (IOException e) {
            try {
                der_encoded.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Envelope format unknown or not implemented", 50023);
        }
        catch (RuntimeException e) {
            try {
                der_encoded.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("RuntimeException", 50050);
        }
        catch (Exception e) {
            try {
                der_encoded.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }
}

