/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.cms.ASN1SequenceGenerator;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TimeStampAndCRL;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROctetStringParser;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.slf4j.Logger;

public class TimeStampedData {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Object ASN1TaggedObject;
    private ASN1Integer version = null;
    private ASN1Sequence metadata = null;
    private DERIA5String dataUri = null;
    private DERIA5String mediaType = null;
    private DERUTF8String fileName = null;
    Hashtable hashtableOtherMetaData = null;
    private ASN1Boolean hashProtected = null;
    private ASN1OctetStringParser content = null;
    private File fileContent = null;
    private File fileEnvelope = null;
    InputStream contentInputStream = null;
    private static String envPrefix = "TSDenv";
    private static String contentPrefix = "TSDcontent";
    private int evidenceType = -1;
    TimeStampAndCRL[] timeStampandCRLarray = null;
    public static final String TIME_STAMPED_DATA_OID = "1.2.840.113549.1.9.16.1.31";
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private int status = -1;
    private boolean derEncoding = false;
    private static final int ST_CREATE = 0;
    private static final int ST_PARSED = 1;
    private static final int ST_UPDATED = 2;

    public TimeStampedData(boolean derEncoding) {
        this.version = new ASN1Integer(1L);
        this.status = 0;
        this.derEncoding = derEncoding;
    }

    public TimeStampedData() {
        this(false);
    }

    public TimeStampedData(InputStream encoded) throws CapiException {
        ASN1SequenceParser asn1seq = null;
        try {
            ASN1InputStream asni = new ASN1InputStream(encoded);
            ASN1StreamParser in = new ASN1StreamParser(encoded);
            asn1seq = (ASN1SequenceParser)in.readObject();
        }
        catch (Exception e) {
            throw new CapiException("Exception reading TimeStampedData", 50040);
        }
        this.parse(asn1seq);
        this.status = 1;
    }

    public TimeStampedData(byte[] encoded) throws CapiException {
        ASN1SequenceParser asn1seq = null;
        try {
            ASN1StreamParser in = new ASN1StreamParser(encoded);
            asn1seq = (ASN1SequenceParser)in.readObject();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception reading TimeStampedData", 50040);
        }
        this.parse(asn1seq);
        this.status = 1;
    }

    private int checkObj(Object obj, Class[] allowed) {
        int i;
        for (i = 0; i < allowed.length; ++i) {
            Class<?> cl = obj.getClass();
            logger.debug("[checkObj] obj class is:  " + cl.getName());
            if (!cl.equals(allowed[i])) continue;
            logger.debug("[checkObj] found  " + allowed[i].getName());
            return i;
        }
        logger.debug("[checkObj] obj does not belog to the requested Classes: ");
        for (i = 0; i < allowed.length; ++i) {
            logger.debug("[checkObj] " + allowed[i].getName());
        }
        return -1;
    }

    private void parse(ASN1SequenceParser sequence) throws CapiException {
        try {
            ASN1Encodable obj = sequence.readObject();
            if (obj == null || !(obj instanceof ASN1ObjectIdentifier)) {
                throw new CapiException("Invalid ContentInfo", 50040);
            }
            ASN1ObjectIdentifier contentType = (ASN1ObjectIdentifier)obj;
            if (contentType.getId().compareToIgnoreCase(TIME_STAMPED_DATA_OID) != 0) {
                throw new CapiException("Invalid Content Type. Supported OID: 1.2.840.113549.1.9.16.1.31", 50040);
            }
            logger.debug("[parse] Found Content Type.");
            obj = sequence.readObject();
            if (obj == null) {
                throw new CapiException("Missing content: TimeStampedData", 50040);
            }
            BERTaggedObjectParser btop = (BERTaggedObjectParser)obj;
            ASN1SequenceParser TSDseq = (ASN1SequenceParser)btop.getObjectParser(0, true);
            logger.debug("[parse] parsing TimeStampedData ...");
            obj = TSDseq.readObject();
            if (obj == null || !(obj instanceof ASN1Integer)) {
                throw new CapiException("Invalid TimeStampedData SEQUENCE. Version not found", 50040);
            }
            this.version = (ASN1Integer)obj;
            logger.debug("[parse] version = " + this.version.getValue().intValue());
            if (this.version.getValue().intValue() != 1) {
                throw new CapiException("TimeStampedData Version: " + this.version.getValue().intValue() + ". V1 is supported.", 50040);
            }
            obj = TSDseq.readObject();
            if (obj == null) {
                throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
            }
            this.metadata = null;
            Class[] allowedClasses = new Class[]{DERIA5String.class, BERSequenceParser.class, BEROctetStringParser.class, DERSequenceParser.class, DEROctetStringParser.class};
            int objIdx = this.checkObj(obj, allowedClasses);
            block3 : switch (objIdx) {
                case 0: {
                    int i;
                    ASN1SequenceParser mdParser;
                    this.dataUri = (DERIA5String)obj;
                    obj = TSDseq.readObject();
                    if (obj == null) {
                        throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
                    }
                    allowedClasses = new Class[]{BERSequenceParser.class, BEROctetStringParser.class, DERSequenceParser.class, DEROctetStringParser.class};
                    int idx = this.checkObj(obj, allowedClasses);
                    switch (idx) {
                        case 0: 
                        case 2: {
                            mdParser = (ASN1SequenceParser)obj;
                            this.metadata = (ASN1Sequence)mdParser.toASN1Primitive();
                            obj = TSDseq.readObject();
                            if (obj == null) {
                                throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
                            }
                            allowedClasses = new Class[]{BEROctetStringParser.class, DEROctetStringParser.class};
                            i = this.checkObj(obj, allowedClasses);
                            if (i != 0 && i != 1) break block3;
                            this.content = (ASN1OctetStringParser)obj;
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.content = (ASN1OctetStringParser)obj;
                            break;
                        }
                    }
                    break;
                }
                case 1: 
                case 3: {
                    ASN1SequenceParser mdParser = (ASN1SequenceParser)obj;
                    this.metadata = (ASN1Sequence)mdParser.toASN1Primitive();
                    obj = TSDseq.readObject();
                    if (obj == null) {
                        throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
                    }
                    allowedClasses = new Class[]{BEROctetStringParser.class, DEROctetStringParser.class};
                    int i = this.checkObj(obj, allowedClasses);
                    if (i == 0 || i == 1) {
                        this.content = (ASN1OctetStringParser)obj;
                        break;
                    }
                    throw new CapiException("Invalid TimeStampedData SEQUENCE. Missing both dataUri and content.", 50040);
                }
                case 2: 
                case 4: {
                    this.content = (ASN1OctetStringParser)obj;
                    break;
                }
                default: {
                    throw new CapiException("Invalid TimeStampedData SEQUENCE. Missing dataUri, metaData and content.", 50040);
                }
            }
            ASN1Set otherMetaData = null;
            if (this.metadata != null) {
                Enumeration e1 = this.metadata.getObjects();
                if (!e1.hasMoreElements()) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Not enough data.", 50040);
                }
                Object o = e1.nextElement();
                if (o == null) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Not enough data.", 50040);
                }
                allowedClasses = new Class[]{ASN1Boolean.class};
                int i = this.checkObj(o, allowedClasses);
                if (i != 0 && i != 1) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Missing hashProtected.", 50040);
                }
                this.hashProtected = (ASN1Boolean)o;
                if (!e1.hasMoreElements()) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Not enough data.", 50040);
                }
                o = e1.nextElement();
                if (o == null) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Not enough data.", 50040);
                }
                allowedClasses = new Class[]{DERUTF8String.class, DERIA5String.class, ASN1Set.class};
                int idx = this.checkObj(o, allowedClasses);
                block12 : switch (idx) {
                    case 0: {
                        this.fileName = (DERUTF8String)o;
                        logger.debug("[parse] filename = " + this.fileName.getString());
                        if (!e1.hasMoreElements() || (o = e1.nextElement()) == null) break;
                        allowedClasses = new Class[]{DERIA5String.class, ASN1Set.class};
                        idx = this.checkObj(o, allowedClasses);
                        switch (idx) {
                            case 0: {
                                this.mediaType = (DERIA5String)o;
                                logger.debug("[parse] mediaType = " + this.mediaType.getString());
                                if (!e1.hasMoreElements() || (o = e1.nextElement()) == null) break block12;
                                allowedClasses = new Class[]{ASN1Set.class};
                                if (this.checkObj(o, allowedClasses) == 0) {
                                    otherMetaData = (ASN1Set)o;
                                    break block12;
                                }
                                throw new CapiException("Invalid MetaData SEQUENCE. Found an invalid element after mediaType.", 50040);
                            }
                            case 1: {
                                otherMetaData = (ASN1Set)o;
                                break block12;
                            }
                            default: {
                                throw new CapiException("Invalid MetaData SEQUENCE. Found an invalid element after fileName", 50040);
                            }
                        }
                    }
                    case 1: {
                        this.mediaType = (DERIA5String)o;
                        logger.debug("[parse] mediaType = " + this.mediaType.getString());
                        if (!e1.hasMoreElements() || (o = e1.nextElement()) == null) break;
                        allowedClasses = new Class[]{ASN1Set.class};
                        if (this.checkObj(o, allowedClasses) == 0) {
                            otherMetaData = (ASN1Set)o;
                            break;
                        }
                        throw new CapiException("Invalid MetaData SEQUENCE. Found an invalid element after mediaType.", 50040);
                    }
                    case 2: {
                        otherMetaData = (ASN1Set)o;
                    }
                    default: {
                        throw new CapiException("Invalid MetaData SEQUENCE. Found an invalid element after HashProtected", 50040);
                    }
                }
                if (this.fileName == null && this.mediaType == null && otherMetaData == null) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Missing fileName, mediaType and otherMetaData", 50040);
                }
            }
            if (otherMetaData != null) {
                if (otherMetaData.size() == 0) {
                    throw new CapiException("Invalid othetMetaData. No Attribute found", 50040);
                }
                AttributeTable attTable = new AttributeTable(otherMetaData);
                this.hashtableOtherMetaData = attTable.toHashtable();
            }
            if (this.content != null) {
                FileOutputStream out1 = null;
                InputStream is = null;
                try {
                    int index;
                    is = this.content.getOctetStream();
                    logger.debug("reading content octect stream...");
                    String ext = null;
                    if (this.fileName != null && this.fileName.getString() != null && (index = this.fileName.getString().lastIndexOf(".")) > -1) {
                        ext = this.fileName.getString().substring(index);
                    }
                    this.fileContent = this.getTemporaryFile(this.fileContent, contentPrefix, ext);
                    out1 = new FileOutputStream(this.fileContent);
                    int len = -1;
                    byte[] buffer = new byte[8192];
                    while ((len = is.read(buffer)) != -1) {
                        ((OutputStream)out1).write(buffer, 0, len);
                    }
                    this.contentInputStream = new FileInputStream(this.fileContent);
                    obj = TSDseq.readObject();
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(out1);
                        Util.closeQuietly((Closeable)is);
                        throw throwable;
                    }
                }
                Util.closeQuietly((Closeable)out1);
                Util.closeQuietly((Closeable)is);
            }
            if (obj == null) {
                throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
            }
            if (!(obj instanceof BERTaggedObjectParser)) {
                throw new CapiException("Invalid TimeStampedData SEQUENCE. Evidence not found", 50040);
            }
            ASN1Primitive o = ((BERTaggedObjectParser)obj).toASN1Primitive();
            switch (((ASN1TaggedObject)o).getTagNo()) {
                case 0: {
                    ASN1Sequence timeStampAndCrlSeq = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)o), (boolean)false);
                    int numTSandCRL = timeStampAndCrlSeq.size();
                    if (numTSandCRL < 1) {
                        throw new CapiException("No TimeStampAndCRL found in TimeStampTokenEvidence", 50040);
                    }
                    logger.debug("[parse] Found " + numTSandCRL + " TimeStampAndCRL.");
                    this.timeStampandCRLarray = new TimeStampAndCRL[numTSandCRL];
                    for (int i = 0; i < numTSandCRL; ++i) {
                        ASN1Sequence TSTseq = (ASN1Sequence)timeStampAndCrlSeq.getObjectAt(i).toASN1Primitive();
                        if (TSTseq.size() < 1) {
                            throw new CapiException("Empty TimeStampAndCRL SEQUENCE.", 50040);
                        }
                        if (TSTseq.size() == 1) {
                            logger.debug("[parse] TimeStampAndCRL contains only TimeStampToken.");
                            this.timeStampandCRLarray[i] = new TimeStampAndCRL();
                            this.timeStampandCRLarray[i].setTimeStampToken(TSTseq.getObjectAt(0).toASN1Primitive().getEncoded("DER"));
                            continue;
                        }
                        if (TSTseq.size() == 2) {
                            logger.debug("[parse] TimeStampAndCRL contains both TimeStampToken and CRL");
                            this.timeStampandCRLarray[i] = new TimeStampAndCRL();
                            this.timeStampandCRLarray[i].setTimeStampToken(TSTseq.getObjectAt(0).toASN1Primitive().getEncoded("DER"));
                            this.timeStampandCRLarray[i].setCRL(TSTseq.getObjectAt(1).toASN1Primitive().getEncoded("DER"));
                            continue;
                        }
                        this.timeStampandCRLarray = null;
                        throw new CapiException("Invalid TimeStampAndCRL SEQUENCE. Too many fields in the SEQUENCE", 50040);
                    }
                    this.evidenceType = 0;
                    break;
                }
                case 1: {
                    logger.debug("[parse] EvidenceRecord is not supported. Only TimeStampTokenEvidence is supported");
                    this.evidenceType = 1;
                    break;
                }
                case 2: {
                    logger.debug("[parse] OtherEvidence is not supported. Only TimeStampTokenEvidence is supported");
                    this.evidenceType = 2;
                    break;
                }
                default: {
                    throw new CapiException("Invalid Tag for Evidence. Tag = " + ((ASN1TaggedObject)o).getTagNo() + ". Allowed values are 0, 1 and 2.", 50040);
                }
            }
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("TimeStampedData parsing exception: " + e.getMessage(), 50040);
        }
    }

    public int getVersion() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        return this.version.getValue().intValue();
    }

    public String getFileName() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.fileName != null) {
            return this.fileName.getString();
        }
        return null;
    }

    public void setFileName(String fileName) throws CapiException {
        if (this.status > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (fileName == null) {
            throw new CapiException("Null parameter", 1001);
        }
        this.fileName = new DERUTF8String(fileName);
    }

    public String getMediaType() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.mediaType != null) {
            return this.mediaType.getString();
        }
        return null;
    }

    public Map getOtherMetaData() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        return new Hashtable(this.hashtableOtherMetaData);
    }

    public TimeStampAndCRL[] getTstEvidence() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.evidenceType != 0) {
            throw new CapiException("Temporal Evidence is not a TimeStampTokenEvidence.", 50000);
        }
        if (this.timeStampandCRLarray != null && this.timeStampandCRLarray.length > 0) {
            ArrayList list = new ArrayList(this.timeStampandCRLarray.length);
            Collections.addAll(list, this.timeStampandCRLarray);
            return list.toArray(new TimeStampAndCRL[0]);
        }
        return null;
    }

    public void setTstEvidence(TimeStampAndCRL[] elements) throws CapiException {
        if (elements == null || elements.length < 1) {
            throw new CapiException("Null parameter", 1001);
        }
        ArrayList listElem = new ArrayList();
        Collections.addAll(listElem, elements);
        this.timeStampandCRLarray = listElem.toArray(new TimeStampAndCRL[0]);
        this.evidenceType = 0;
        if (this.status == 1) {
            this.status = 2;
        }
    }

    public void setOtherMetaData(Map attribs) throws CapiException {
        if (this.status > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (attribs == null) {
            throw new CapiException("Null parameter", 1001);
        }
        this.hashtableOtherMetaData = new Hashtable(attribs.size());
        for (Object key : attribs.keySet()) {
            this.hashtableOtherMetaData.put(key, attribs.get(key));
        }
    }

    public int getTemporalEvidenceType() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        return this.evidenceType;
    }

    public void setMediaType(String mime) throws CapiException {
        if (this.status > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (mime == null) {
            throw new CapiException("Null parameter", 1001);
        }
        try {
            this.mediaType = new DERIA5String(mime, true);
        }
        catch (Exception e) {
            throw new CapiException("Invalid parameter", 1002);
        }
    }

    public InputStream getContent() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.contentInputStream != null) {
            return this.contentInputStream;
        }
        throw new CapiException("FileNotFoundException", 50000);
    }

    public String getDataURI() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.dataUri != null) {
            return this.dataUri.getString();
        }
        return null;
    }

    public void setDataURI(String uri) throws CapiException {
        if (this.status > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (uri == null) {
            throw new CapiException("Null parameter", 1001);
        }
        try {
            this.dataUri = new DERIA5String(uri, true);
        }
        catch (IllegalArgumentException e) {
            throw new CapiException("Invalid parameter", 1002);
        }
    }

    public void setContent(byte[] content) throws CapiException {
        if (this.status > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (content == null) {
            throw new CapiException("Null parameter", 1001);
        }
        this.contentInputStream = new ByteArrayInputStream(content);
    }

    public void setContent(InputStream content) throws CapiException {
        if (this.status > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (content == null) {
            throw new CapiException("Null parameter", 1001);
        }
        try {
            this.contentInputStream = content;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception", 50040);
        }
    }

    public void setHashProtected(boolean flag) throws CapiException {
        if (this.status > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        this.hashProtected = ASN1Boolean.getInstance((boolean)flag);
    }

    public boolean getHashProtected() throws CapiException {
        if (this.status < 1) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.metadata == null || this.hashProtected == null) {
            throw new CapiException("No MetaData found", 50000);
        }
        return this.hashProtected.isTrue();
    }

    private DERSequence metadataASN1Object() throws CapiException {
        if (this.hashProtected == null) {
            throw new CapiException("Undefined hashProtected field", 50000);
        }
        if (this.fileName == null && this.mediaType == null && this.hashtableOtherMetaData == null) {
            throw new CapiException("At least one of fileName, mediaType and otherMetaData has to be defined", 50000);
        }
        ASN1EncodableVector metaDataV = new ASN1EncodableVector();
        metaDataV.add((ASN1Encodable)this.hashProtected);
        if (this.fileName != null) {
            metaDataV.add((ASN1Encodable)this.fileName);
        }
        if (this.mediaType != null) {
            metaDataV.add((ASN1Encodable)this.mediaType);
        }
        if (this.hashtableOtherMetaData != null) {
            AttributeTable attTable = new AttributeTable(this.hashtableOtherMetaData);
            metaDataV.add((ASN1Encodable)new DERSet(attTable.toASN1EncodableVector()));
        }
        return new DERSequence(metaDataV);
    }

    private void toASN1Object(OutputStream output) throws CapiException {
        if (this.status == 1) {
            throw new CapiException("TimeStampedData parsed and not changed", 50000);
        }
        if (!(this.dataUri != null || this.contentInputStream != null || this.fileContent != null && this.fileContent.exists())) {
            throw new CapiException("Undefined both dataUri and content", 50000);
        }
        if (this.timeStampandCRLarray == null || this.timeStampandCRLarray.length < 1) {
            throw new CapiException("No Temporal Evidencehas has been defined", 50000);
        }
        ASN1SequenceGenerator ci = null;
        ASN1SequenceGenerator envGen = null;
        OutputStream octectOutStream = null;
        try {
            ci = new ASN1SequenceGenerator(output, this.derEncoding);
            logger.debug("new BERSequenceGenerator done");
            ci.addObject((ASN1Encodable)new ASN1ObjectIdentifier(TIME_STAMPED_DATA_OID));
            logger.debug("ci.addObject done");
            envGen = new ASN1SequenceGenerator(ci.getRawOutputStream(), 0, true, this.derEncoding);
            logger.debug("new BERSequenceGenerator(ci.getRawOutputStream(), 0, true) done");
            if (this.version == null) {
                this.version = new ASN1Integer(1L);
            }
            envGen.addObject((ASN1Encodable)this.version);
            logger.debug("envGen.addObject(version) done");
            if (this.dataUri != null) {
                envGen.addObject((ASN1Encodable)this.dataUri);
            }
            if (this.metadata != null) {
                envGen.addObject((ASN1Encodable)this.metadata);
            } else {
                this.metadata = this.metadataASN1Object();
                envGen.addObject((ASN1Encodable)this.metadata);
            }
            if (this.contentInputStream == null) {
                logger.debug("this.contentInputStream is null");
            } else if (!this.derEncoding) {
                BEROctetStringGenerator octGen = new BEROctetStringGenerator(envGen.getRawOutputStream());
                octectOutStream = octGen.getOctetOutputStream();
                int len = 0;
                byte[] buffer = new byte[8192];
                while ((len = this.contentInputStream.read(buffer)) != -1) {
                    octectOutStream.write(buffer, 0, len);
                    logger.debug("contentInputStream.read(buffer) loop");
                }
                octectOutStream.close();
            } else {
                byte[] content = IOUtils.toByteArray((InputStream)this.contentInputStream);
                DEROctetString der = new DEROctetString(content);
                envGen.getRawOutputStream().write(der.getEncoded());
            }
            ASN1EncodableVector tstEvidence = new ASN1EncodableVector();
            for (int i = 0; this.timeStampandCRLarray != null && i < this.timeStampandCRLarray.length; ++i) {
                try {
                    DERSequence derS = this.timeStampandCRLarray[i].getDERSequence();
                    tstEvidence.add((ASN1Encodable)derS);
                    continue;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new CapiException("Exception adding timeStampandCRL sequence", 50040);
                }
            }
            DERTaggedObject evidence = new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence(tstEvidence));
            logger.debug("new DERTaggedObject(false, 0, new DERSequence(tstEvidence)) done");
            envGen.addObject((ASN1Encodable)evidence);
            logger.debug("envGen.addObject(evidence) done");
        }
        catch (IOException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            throw new CapiException("IOException generating envelope", 50040);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception generating envelope", 50040);
        }
        finally {
            try {
                if (envGen != null) {
                    envGen.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ci != null) {
                    ci.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (octectOutStream != null) {
                    octectOutStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] getMetaData() throws CapiException {
        if (this.hashProtected == null) {
            return null;
        }
        try {
            return this.metadataASN1Object().getEncoded("DER");
        }
        catch (CapiException c) {
            throw c;
        }
        catch (Exception c) {
            throw new CapiException("Exception in MetaData " + c.getMessage(), 50040);
        }
    }

    public void writeTo(OutputStream output) throws CapiException {
        this.toASN1Object(output);
    }

    private File getTemporaryFile(File f, String prefix, String ext) throws CapiException {
        try {
            if (f != null && f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (prefix.length() < 3) {
                prefix = prefix + "___";
            }
            f = TmpFileUtils.createTempFile((String)prefix, (String)ext);
            logger.debug("Created file: " + f.getAbsolutePath());
        }
        catch (IOException e) {
            throw new CapiException("IOException in createTempFile", 50040);
        }
        return f;
    }

    public InputStream getEncoded() throws CapiException {
        FileOutputStream out1 = null;
        FileInputStream fis = null;
        this.fileEnvelope = this.getTemporaryFile(this.fileEnvelope, envPrefix, null);
        try {
            out1 = new FileOutputStream(this.fileEnvelope);
            this.toASN1Object(out1);
            fis = new FileInputStream(this.fileEnvelope);
        }
        catch (FileNotFoundException e) {
            if (out1 == null) {
                throw new CapiException("FileNotFoundException opening FileOutputStream", 50040);
            }
            throw new CapiException("FileNotFoundException opening TimeStampedData", 50040);
        }
        finally {
            if (out1 != null) {
                try {
                    ((OutputStream)out1).close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return fis;
    }

    public void free() {
        if (this.contentInputStream != null) {
            try {
                this.contentInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

