/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ServerToken;
import it.actalis.ellips.capi.provider.pkcs11.ASProvider;
import it.actalis.ellips.capi.provider.pkcs11.AS_PrivateKey;
import it.actalis.ellips.capi.provider.pkcs11.AS_RSACipher;
import it.actalis.pkcs11.PKCS11;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.vol.utils.Constants;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;

public class ASToken
extends ServerToken {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    static final int MAX_RSAKEY_BUFLEN = 4096;
    static final String asp11library = "cryptoki";
    static final int PKCS11_CERT = 1;
    static final int PKCS11_PRIVK = 3;
    static final int PKCS11_PUBK = 2;
    private static boolean debug = false;
    private static String initk = null;
    private static String tksem = "semaphore for init and destroy";
    private static PKCS11 pkcs11 = null;
    private PKCS11Slot tokenslot = null;
    private PKCS11Session session = null;
    private PKCS11Object prvk = null;
    private PKCS11Object pubk = null;
    private PKCS11Object crtk = null;

    public ASToken(String alias) throws CapiException {
        super(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void init() throws CapiException {
        if (debug) {
            ASToken.sprint("initializing...");
        }
        String string = tksem;
        synchronized (string) {
            if (initk != null) {
                throw new CapiException("Token already initialized", 10002);
            }
            initk = "init done at " + System.currentTimeMillis();
        }
        boolean initdone = false;
        try {
            if (debug) {
                ASToken.sprint("... security provider ...");
            }
            ASProvider devProvider = new ASProvider();
            TokenSpi.addProvider((Provider)devProvider, (int)2);
            TokenSpi.addProvider((Provider)new BouncyCastleProvider(), (int)3);
            try {
                if (debug) {
                    ASToken.sprint("loading library cryptoki");
                }
                pkcs11 = NativePKCS11.getInstance(asp11library, true);
                if (debug) {
                    ASToken.sprint("loaded  library");
                }
                String bridgev = "bridge v" + pkcs11.getBridgeVersion();
                if (debug) {
                    ASToken.sprint(bridgev);
                }
            }
            catch (PKCS11Exception e) {
                logger.debug(e.getMessage() + " code: " + e.getCode(), (Throwable)e);
                throw e.toCapiException(false, true);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Cannot link Library", 11000);
            }
            catch (UnsatisfiedLinkError e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Cannot link Library", 11000);
            }
            catch (Error e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Cannot link Library", 11000);
            }
            if (debug) {
                ASToken.sprint("Initialization done.");
            }
            initdone = true;
        }
        catch (CapiException e) {
            if (debug) {
                ASToken.sprint("Initialization failed:");
            }
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("initialization failure", 10040);
        }
        finally {
            if (!initdone) {
                initk = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void destroy() throws CapiException {
        if (debug) {
            ASToken.sprint("destroying...");
        }
        String string = tksem;
        synchronized (string) {
            if (initk != null) {
                try {
                    if (debug) {
                        ASToken.sprint("unloading library...");
                    }
                    ((NativePKCS11)pkcs11).unloadLibrary();
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                catch (Error e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                pkcs11 = null;
                if (debug) {
                    ASToken.sprint("removing provider...");
                }
                TokenSpi.removeProvider((String)"ACTALIS");
            }
            initk = null;
        }
        if (debug) {
            ASToken.sprint("done.");
        }
    }

    public final void getRSACred(String PIN) throws CapiException {
        if (debug) {
            this.print("getRSACred");
        }
        if (initk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (PIN == null) {
            throw new CapiException("Null parameters", 1001);
        }
        this.getRSAcredential(PIN, true);
    }

    public final void releaseRSACred() throws CapiException {
        if (debug) {
            this.print("releaseRSACred");
        }
        if (initk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        this.tokenslot = null;
        this.session = null;
        this.prvk = null;
        this.pubk = null;
        this.crtk = null;
    }

    public final byte[] getRSAKeyCert() throws CapiException {
        try {
            return this.crtk.getByteArrayAttributeValue(17);
        }
        catch (NullPointerException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Object not found", 10022);
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode(), (Throwable)e);
            throw e.toCapiException(false, true);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    public final String getCertificate() throws CapiException {
        if (debug) {
            this.print("getCertificate");
        }
        if (initk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        byte[] cert = null;
        try {
            this.getRSAcredential(null, false);
            cert = this.getRSAKeyCert();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
        finally {
            this.releaseRSACred();
        }
        if (cert != null) {
            String b64cert = Util.base64EncodeStr((byte[])cert);
            return b64cert;
        }
        return null;
    }

    public final String getPublicKeyInfo() throws CapiException {
        if (debug) {
            this.print("getPublicKeyInfo");
        }
        if (initk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        byte[] cert = null;
        try {
            this.getRSAcredential(null, false);
            cert = this.getRSAKeyCert();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
        finally {
            this.releaseRSACred();
        }
        if (cert != null) {
            Certificate c = new Certificate(cert);
            return c.getSubjectPublicKeyInfo();
        }
        return null;
    }

    public PrivateKey getPrivateKey() throws CapiException {
        if (this.prvk == null) {
            throw new CapiException("Object not found", 10021);
        }
        return new AS_PrivateKey(this);
    }

    public byte[] doSign(byte[] digest) throws CapiException {
        if (debug) {
            this.print("doSign alias=" + this.thealias);
        }
        if (this.prvk == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            this.session.signInit(1, null, this.prvk);
            if (debug) {
                this.print("signing RSA LENGTH: in=" + digest.length);
            }
            int len = 512;
            byte[] buf = new byte[len];
            int n = this.session.sign(digest, 0, digest.length, buf, 0);
            if (debug) {
                this.print("signed  OK        :  n =" + n);
            }
            byte[] signed = new byte[n];
            System.arraycopy(buf, 0, signed, 0, n);
            return signed;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode(), (Throwable)e);
            throw e.toCapiException(false, true);
        }
    }

    public byte[] doDecrypt(byte[] digest) throws CapiException {
        if (debug) {
            this.print("doDecrypt alias=" + this.thealias);
        }
        if (this.prvk == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            this.session.decryptInit(1, null, this.prvk);
            if (debug) {
                this.print("LENGTH: in=" + digest.length);
            }
            int len = 512;
            byte[] buf = new byte[len];
            int n = this.session.decrypt(digest, 0, digest.length, buf, 0);
            if (debug) {
                this.print("decrypt OK        :  n =" + n);
            }
            byte[] result = new byte[n];
            System.arraycopy(buf, 0, result, 0, n);
            return result;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode(), (Throwable)e);
            throw e.toCapiException(false, true);
        }
    }

    public void print(String s) {
        logger.info(System.currentTimeMillis() + ":[ASToken]" + s);
    }

    static void sprint(String s) {
        logger.info(System.currentTimeMillis() + ":[ASToken]" + s);
    }

    private void getRSAcredential(String PIN, boolean withPIN) throws CapiException {
        if (debug) {
            this.print("getRSAcredential");
        }
        boolean done = false;
        try {
            PKCS11Object[] objs;
            if (debug) {
                this.print("getting alias:" + this.thealias);
            }
            if ((objs = pkcs11.getRSAcredential(this.thealias, 6, withPIN ? PIN : null)) == null || objs.length != 3) {
                throw new CapiException("array not found", 10023);
            }
            this.prvk = objs[0];
            if (withPIN && this.prvk == null) {
                throw new CapiException("private key object not found", 10021);
            }
            this.pubk = objs[1];
            if (this.pubk == null) {
                throw new CapiException("public key object not found", 10021);
            }
            this.crtk = objs[2];
            if (this.crtk == null) {
                throw new CapiException("certificate object not found", 10022);
            }
            this.session = this.crtk.getSession();
            if (this.session == null) {
                throw new CapiException("session object not found", 10040);
            }
            this.tokenslot = this.session.getSlot();
            if (this.tokenslot == null) {
                throw new CapiException("slot object not found", 10040);
            }
            if (debug) {
                this.print("get alias:" + this.thealias);
            }
            done = true;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode(), (Throwable)e);
            throw e.toCapiException(false, true);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
        finally {
            if (!done) {
                this.tokenslot = null;
                this.session = null;
                this.prvk = null;
                this.pubk = null;
                this.crtk = null;
            }
        }
    }

    public PublicKey getPublicKey() throws CapiException {
        if (debug) {
            this.print("getPublicKey...");
        }
        if (this.pubk == null) {
            throw new CapiException("Object not found", 10021);
        }
        PublicKey pk = null;
        BigInteger exp = null;
        BigInteger mod = null;
        try {
            if (debug) {
                this.print("getting BigInteger Modulus key...");
            }
            mod = this.pubk.getBigIntegerAttributeValue(288);
            if (debug) {
                this.print("getting BigInteger PubExponent key...");
            }
            exp = this.pubk.getBigIntegerAttributeValue(290);
            if (debug) {
                this.print("RSAPubKey ...");
            }
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            pk = kf.generatePublic(keySpec);
            return pk;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode(), (Throwable)e);
            throw e.toCapiException(false, true);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    public static void setDebug(boolean debugFlag) {
        debug = debugFlag;
        AS_RSACipher.debug = debugFlag;
    }
}

