/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import esecurity.enroll.CSRUtils;
import esecurity.enroll.bean.CertificateFields;
import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.pkcs11.Actalis_Object;
import it.actalis.ellips.capi.provider.pkcs11.Bit4IDConfigPkcs11Params;
import it.actalis.ellips.capi.provider.pkcs11.DsPinCallBack;
import it.actalis.ellips.capi.util.ECUtils;
import it.actalis.ellips.capi.util.KeyUtils;
import it.actalis.pkcs11.PKCS11;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Info;
import it.actalis.pkcs11.PKCS11MechanismInfo;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.PKCS11SlotInfo;
import it.actalis.pkcs11.PKCS11TokenInfo;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.pkcs11.nat.NativePKCS11Session;
import it.actalis.pkcs11.nat.NativePKCS11Slot;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.CNSStrategy;
import it.arubapec.ca.pkcs11.card.Card;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.DSStrategy;
import it.arubapec.ca.pkcs11.card.FSStrategy;
import it.arubapec.ca.pkcs11.card.FSStrategyParameters;
import it.arubapec.ca.pkcs11.card.athena.AthenaDsFsGenerator;
import it.arubapec.ca.pkcs11.card.athena.AthenaFsStrategyParameters;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class PKCS11Token
extends TokenSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private CardFamily cardFamily = null;
    private DsPinCallBack dsPinCallBack = null;
    public static boolean mcccompatibilitymode = true;
    private PKCS11 pkcs11 = null;
    private PKCS11Slot tokenslot = null;
    private PKCS11SlotInfo tokenslotinfo = null;
    private PKCS11TokenInfo tokeninfo = null;
    private long last_tokeninfo = 0L;
    private PKCS11Session session = null;
    private String[] libInfo = null;
    private String library = null;
    private int slot = -1;
    private int flags = 0;
    private byte[] dummyKeyLabel = new byte[]{122, 123, 124, 125, 126, 127};
    private int dummyKeyCnt = 0;
    private static boolean ckaprivate = false;
    HashMap<String, Actalis_Object> objects = null;
    HashMap<String, Actalis_Object> objectsID = null;
    static final int PKCS11_DATA = 0;
    static final int PKCS11_CERT = 1;
    static final int PKCS11_PRIVK = 3;
    static final int PKCS11_PUBK = 2;
    static final int PKCS11_SECK = 4;
    private static final String BIT4ID_TOKEN_PROP_DS_PIN_USE_GUI = "dspinusegui";
    private static final String BIT4ID_TOKEN_PROP_DS_PIN_IS_CNS_PIN = "dspiniscnspin";
    private boolean lockGeneratedTokenObject = false;
    private Bit4IDConfigPkcs11Params enableSessionGui = Bit4IDConfigPkcs11Params.DEFAULT;
    private Bit4IDConfigPkcs11Params enableDSPinIsCnsPin = Bit4IDConfigPkcs11Params.DEFAULT;
    private boolean loggedAsUser = false;

    public PKCS11Token() {
        logger.debug("build new PKCS11Token");
    }

    public boolean exist(String alias) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        return this.objects.containsKey(alias);
    }

    public String generateID(String[] args) {
        this.library = args[0];
        this.slot = -1;
        if (args.length > 1 && args[1] != null) {
            this.slot = Integer.parseInt(args[1]);
        }
        return this.library + "(slot=" + this.slot + ")";
    }

    @Deprecated
    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        logger.debug("[PKCS11TokenConstants.initializeLib] con parametro tokenSoftSia");
        this.initializeLib(args);
    }

    public void initializeLib(String[] args) throws CapiException {
        this.initProviders(this);
        logger.debug("parsing pkcs11 args");
        if (args == null || args.length < 1 || args[0] == null) {
            throw new CapiException("Null parameters", 1001);
        }
        this.library = args[0];
        this.slot = -1;
        this.flags = 0;
        long waitms_args = 0L;
        ckaprivate = false;
        try {
            if (args.length > 1 && args[1] != null) {
                this.slot = Integer.parseInt(args[1]);
            }
            if (args.length > 2 && args[2] != null) {
                this.flags = Integer.parseInt(args[2]);
            }
            if (args.length > 3 && args[3] != null) {
                waitms_args = Long.parseLong(args[3]);
            }
            if (args.length > 5 && args[5] != null && args[5].toLowerCase().startsWith("y")) {
                ckaprivate = true;
            }
            logger.debug("using ckaprivate attribute set to " + ckaprivate);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Invalid parameters", 1002);
        }
        try {
            logger.debug("loading actalisjpkcs11 library, then loading p11library: " + args[0]);
            this.pkcs11 = NativePKCS11.getInstance(args[0], true);
            logger.debug("loaded  actalisjpkcs11 library");
            PKCS11Info info = this.pkcs11.getInfo();
            logger.debug("library info:\n" + info);
            this.libInfo = new String[9];
            this.libInfo[0] = "Cryptoki " + this.versionString(info.cryptokiVersion()) + " (java bridge v" + this.pkcs11.getBridgeVersion() + ")";
            this.libInfo[1] = this.library + " (slot=" + this.slot + " flags=" + this.flags + ")";
            this.libInfo[2] = info.libraryDescription();
            this.libInfo[3] = this.versionString(info.libraryVersion());
            this.libInfo[4] = info.manufacturerID();
            this.libInfo[5] = "N/A";
            this.libInfo[6] = "N/A";
            this.libInfo[7] = "N/A";
            this.libInfo[8] = "N/A";
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Cannot link Library", 11000);
        }
        catch (UnsatisfiedLinkError e) {
            logger.debug(e.getMessage());
            throw new CapiException("Cannot link Library", 11000);
        }
        catch (Error e) {
            logger.debug(e.getMessage());
            throw new CapiException("Cannot link Library", 11000);
        }
    }

    public void initializeLib(TokenParameters param) throws CapiException {
        if (!(param instanceof Card)) {
            throw new UnsupportedOperationException("Not supported TokenParameters.");
        }
        Card card = (Card)param;
        this.cardFamily = card.getCardFamily();
        LinkedList<String> args = new LinkedList<String>();
        args.add(this.cardFamily.getSelected_lib().getDrive());
        args.add(String.format("%d", ((NativePKCS11Slot)card.getSlot()).getNativeID()));
        if (this.cardFamily.getName().equalsIgnoreCase("GEMALTO")) {
            args.add("4");
        }
        this.initializeLib(args.toArray(new String[0]));
    }

    public void setCardFamily(CardFamily cardFamily) {
        this.cardFamily = cardFamily;
    }

    public void finalizeLib() {
        try {
            this.session.logout();
            this.loggedAsUser = false;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        try {
            this.session.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        try {
            logger.debug("unloadLibrary ?");
            ((NativePKCS11)this.pkcs11).unloadLibrary();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        catch (Error e) {
            logger.debug(e.getMessage());
        }
        this.pkcs11 = null;
        this.session = null;
        this.tokenslot = null;
        this.tokenslotinfo = null;
        this.library = null;
        this.slot = -1;
        this.flags = 0;
        this.libInfo = null;
        PKCS11Token.removeProvider((String)"Actalis");
        logger.debug("closed Actalis security provider");
    }

    public String[] getLibInfo() {
        try {
            if (!this.isTokenInserted()) {
                return this.libInfo;
            }
            String[] libInfo2 = new String[9];
            for (int i = 0; i < 5; ++i) {
                libInfo2[i] = this.libInfo[i];
            }
            if ((this.flags & 0x80) != 0) {
                libInfo2[5] = this.tokenslotinfo.description();
                libInfo2[6] = this.tokenslotinfo.manufacturer();
                PKCS11TokenInfo tinfo = this.getTokenInfo();
                logger.debug("get info from token");
                libInfo2[7] = tinfo.model();
                libInfo2[8] = tinfo.manufacturer();
                return libInfo2;
            }
            logger.debug("getting info ... ");
            PKCS11SlotInfo sinfo = this.tokenslot.getInfo();
            logger.debug("get info from tokenslot.");
            libInfo2[5] = sinfo.description();
            libInfo2[6] = sinfo.manufacturer();
            PKCS11TokenInfo tinfo = this.tokenslot.getTokenInfo();
            logger.debug("get info from token.");
            libInfo2[7] = tinfo.model();
            libInfo2[8] = tinfo.manufacturer();
            return libInfo2;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            return this.libInfo;
        }
    }

    public boolean isTokenInserted() throws CapiException {
        logger.debug("isTokenInserted?");
        if (this.tokenslot != null) {
            try {
                if ((this.flags & 0x80) != 0) {
                    this.tokenslotinfo = this.tokenslot.getInfo();
                    logger.debug("get info from tokenslot");
                    if (this.tokenslotinfo.tokenPresent()) {
                        return true;
                    }
                } else if (this.tokenslot.getInfo().tokenPresent()) {
                    logger.debug("tokenPresent into tokenslot");
                    return true;
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
                logger.debug("...but the exception is ignored");
            }
        }
        try {
            this.getTokenSlot();
            if ((this.flags & 0x80) != 0) {
                this.tokenslotinfo = this.tokenslot.getInfo();
                logger.debug("get info after gettokenslot");
                if (this.tokenslotinfo.tokenPresent()) {
                    logger.debug("token present");
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (CapiException ce) {
            if (ce.getErrorCode() == 10014) {
                throw ce;
            }
            if (ce.getErrorCode() == 11004) {
                throw ce;
            }
            logger.debug(ce.getMessage());
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.debug("exception is ignored");
        }
        return false;
    }

    public String getLibName() {
        return this.library;
    }

    public String getLabel() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            if ((this.flags & 0x80) != 0) {
                PKCS11TokenInfo tinfo = this.getTokenInfo();
                logger.debug("get info from token");
                return tinfo.label();
            }
            return this.tokenslot.getTokenInfo().label();
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
    }

    public String getSerialNumber() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            if ((this.flags & 0x40) != 0) {
                if ((this.flags & 0x80) != 0) {
                    PKCS11TokenInfo tinfo = this.getTokenInfo();
                    logger.debug("get info from token");
                    return tinfo.label();
                }
                return this.tokenslot.getTokenInfo().label();
            }
            return this.tokenslot.getTokenInfo().serialNumber();
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
    }

    public int getFreeSpace() throws CapiException {
        try {
            if (!this.isTokenInserted()) {
                throw new CapiException("Token not inserted", 10011);
            }
            if ((this.flags & 0x80) != 0) {
                PKCS11TokenInfo tinfo = this.getTokenInfo();
                logger.debug("get info from token");
                return tinfo.freePrivateMemory();
            }
            return this.tokenslot.getTokenInfo().freePrivateMemory();
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
    }

    public void changePIN(String oldPin, String newPin) throws CapiException {
        boolean toBeClosed;
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        boolean bl = toBeClosed = !this.isSessionOpen() || this.isSessionOpen() && !this.loggedAsUser;
        if (toBeClosed) {
            if (this.isSessionOpen()) {
                this.closeSession();
            }
            this.openSession(false, oldPin);
        }
        try {
            this.session.setPIN(oldPin, newPin);
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 10040);
        }
        finally {
            if (!toBeClosed) {
                this.closeSession();
            }
        }
    }

    public void changePUK(String oldPuk, String newPuk) throws CapiException {
        boolean toBeClosed;
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        boolean bl = toBeClosed = !this.isSessionOpen() || this.isSessionOpen() && this.loggedAsUser;
        if (toBeClosed) {
            if (this.isSessionOpen()) {
                this.closeSession();
            }
            this.openSession(true, oldPuk);
        }
        try {
            this.session.setPIN(oldPuk, newPuk);
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 10040);
        }
        finally {
            if (toBeClosed) {
                this.closeSession();
            }
        }
    }

    public void unblockPIN(String PUK, String newPin) throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        if (this.isSessionOpen()) {
            this.closeSession();
        }
        if ((this.flags & 0x40) != 0) {
            byte[] pukb = Hex.encode((byte[])PUK.getBytes());
            this.openSessionEllips(pukb);
            try {
                logger.debug("setPIN ... ");
                this.session.setPINellips(pukb, pukb);
                try {
                    this.session.logout();
                    this.loggedAsUser = false;
                }
                catch (Exception exception) {}
            }
            catch (PKCS11Exception e) {
                logger.debug(e.getMessage() + " code: " + e.getCode());
                throw e.toCapiException();
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
                throw new CapiException("Internal error", 10040);
            }
            logger.debug("unblocking to default Ellips PIN done");
            this.changePIN("12345", newPin);
            logger.debug("unblocking PIN done");
            this.closeSession();
            return;
        }
        this.openSession(true, PUK);
        logger.debug("unblocking PIN ... ");
        try {
            this.session.initPIN(newPin);
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            if (e.getCode() == 160) {
                throw new CapiException("PIN not blocked or operation invalid", 2011);
            }
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 10040);
        }
        logger.debug("unblocking PIN done");
        this.closeSession();
    }

    public void openSession(boolean asSecurityOfficier, String pin, int slotz) throws CapiException {
        try {
            if (this.slot != slotz) {
                this.slot = slotz;
                this.getTokenSlot();
            }
            logger.debug("before openSession");
            this.session = this.tokenslot.openSession(6, null, null);
            this.applySessionConfig((NativePKCS11Session)this.session);
            logger.debug(this.session.getInfo().toString());
            logger.debug("before login");
            if ((this.flags & 0x20) == 0) {
                this.session.login(asSecurityOfficier, pin);
            }
            logger.debug(this.session.getInfo().toString());
            logger.debug("after openSession loading objects");
            if (!asSecurityOfficier) {
                this.loadObjects();
            }
            logger.debug("after openSession loaded objects");
        }
        catch (PKCS11Exception e) {
            this.session = null;
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException(asSecurityOfficier);
        }
    }

    public void openSession(boolean asSecurityOfficier, String pin) throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            logger.debug("before closeAllSessions");
            if (this.session != null) {
                this.session.close();
            }
            logger.debug("before openSession");
            this.session = this.tokenslot.openSession(6, null, null);
            this.applySessionConfig((NativePKCS11Session)this.session);
            logger.debug(this.session.getInfo().toString());
            logger.debug("before login");
            if ((this.flags & 0x20) == 0) {
                this.session.login(asSecurityOfficier, pin);
                this.loggedAsUser = !asSecurityOfficier;
            }
            logger.debug(this.session.getInfo().toString());
            logger.debug("after openSession loading objects");
            if (!asSecurityOfficier) {
                this.loadObjects();
            }
            logger.debug("after openSession loaded objects");
        }
        catch (PKCS11Exception e) {
            this.session = null;
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException(asSecurityOfficier);
        }
    }

    public void openPublicSession() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        logger.debug("openPublicSession loading public objects");
        try {
            logger.debug("before closeAllSessions");
            if (this.session != null) {
                this.session.close();
            }
            logger.debug("before openSession");
            this.session = this.tokenslot.openSession(6, null, null);
            this.applySessionConfig((NativePKCS11Session)this.session);
            logger.debug(this.session.getInfo().toString());
            this.loadObjects();
        }
        catch (PKCS11Exception e) {
            this.session = null;
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException(false);
        }
    }

    public void openSessionAuthPath(boolean asSecurityOfficier) throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            int p11flags = 0;
            if ((this.flags & 0x80) != 0) {
                PKCS11TokenInfo tinfo = this.getTokenInfo();
                logger.debug("get info from token");
                p11flags = tinfo.flags();
                logger.debug("Flags: " + tinfo.flagsToString(" | "));
            } else {
                p11flags = this.tokenslot.getTokenInfo().flags();
                logger.debug("Flags: " + this.tokenslot.getTokenInfo().flagsToString(" | "));
            }
            if ((p11flags & 0x100) == 0) {
                throw new PKCS11Exception(84);
            }
            logger.debug("before closeAllSessions");
            if (this.session != null) {
                this.session.close();
            }
            this.session = this.tokenslot.openSession(6, null, null);
            this.applySessionConfig((NativePKCS11Session)this.session);
            logger.debug("before login");
            this.session.loginAuthPath(asSecurityOfficier);
            if (!asSecurityOfficier) {
                logger.debug(this.session.getInfo().toString());
                logger.debug("after openSession loading objects");
                this.loadObjects();
                logger.debug("after openSession loaded objects");
            }
        }
        catch (PKCS11Exception e) {
            this.session = null;
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException(asSecurityOfficier);
        }
    }

    public void closeSession() throws CapiException {
        try {
            this.session.logout();
            this.loggedAsUser = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session = null;
        this.objects = null;
    }

    public boolean isSessionOpen() throws CapiException {
        logger.debug("isSessionOpen ?");
        if (this.session == null) {
            return false;
        }
        try {
            logger.debug("isSessionOpen: session.getInfo().state() ? ");
            int state = this.session.getInfo().state();
            logger.debug("isSessionOpen: session.getInfo().state() = " + state);
            if ((this.flags & 0x20) != 0 && state == 2) {
                return true;
            }
            if (state == 3) {
                return true;
            }
            if (state == 2) {
                return true;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return false;
    }

    public String[] listObjects(String labelFilter, byte filter) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            String[] labels = new String[this.objects.size()];
            if (this.objects.isEmpty()) {
                return labels;
            }
            int objMatchCount = 0;
            for (String label : this.objects.keySet()) {
                if ((this.getObjectType(label) & filter) == 0 || labelFilter != null && !label.contains(labelFilter)) continue;
                labels[objMatchCount] = label;
                ++objMatchCount;
            }
            if (objMatchCount == 0) {
                return new String[0];
            }
            String[] aliases = new String[objMatchCount];
            for (int j = 0; j < objMatchCount; ++j) {
                aliases[j] = labels[j];
            }
            return aliases;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error: " + e.getMessage(), 10040);
        }
    }

    public byte getObjectType(String alias) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            Actalis_Object temp = this.objects.get(alias);
            if (temp == null) {
                throw new CapiException("Object not found", 10023);
            }
            return temp.getType();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Object not found", 10023);
        }
    }

    public String getObjectID(String alias) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            Actalis_Object temp = this.objects.get(alias);
            if (temp == null) {
                throw new CapiException("Object not found", 10023);
            }
            return temp.getID();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Object not found", 10023);
        }
    }

    public void deleteObject(String alias) throws CapiException {
        this.removeObjects(alias, 1);
    }

    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            Actalis_Object temp = this.objects.get(oldAlias);
            if (temp == null) {
                throw new CapiException("Object not found", 10023);
            }
            this.removeObjects(newAlias, mode);
            Object[] objs = temp.getAllObjects();
            for (int i = 0; i < objs.length; ++i) {
                this.renameObject((PKCS11Object)objs[i], newAlias);
            }
            temp.rename(newAlias);
            this.objects.remove(oldAlias);
            this.insertObject(newAlias, temp);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 10040);
        }
    }

    public int getObjectSize(String alias) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.objects.containsKey(alias)) {
            try {
                Actalis_Object temp = this.objects.get(alias);
                Object[] objs = temp.getAllObjects();
                int res = 0;
                for (int i = 0; i < objs.length; ++i) {
                    res += ((PKCS11Object)objs[i]).size();
                }
                if (res < 0) {
                    res = -1;
                }
                return res;
            }
            catch (PKCS11Exception e) {
                logger.debug(e.getMessage() + " code: " + e.getCode());
                if (e.getCode() == 84) {
                    return -1;
                }
                if (e.getCode() == 368) {
                    return -1;
                }
                if (e.getCode() == 130 && this.library.startsWith("etpk")) {
                    logger.debug("object handle invalid for etoken");
                    return -1;
                }
                throw e.toCapiException();
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
                throw new CapiException("Internal error", 10040);
            }
        }
        throw new CapiException("Object not found", 10023);
    }

    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        logger.debug("getting key usage alias=" + alias);
        PKCS11Object obj = this.findObject(alias, 3);
        if (obj == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            logger.debug("getting BOOL attribute SIGN ");
            boolean sign = obj.getBoolAttributeValue(264);
            logger.debug("get BOOL attribute SIGN ");
            boolean ciph = obj.getBoolAttributeValue(261);
            logger.debug("get BOOL attribute DECRYPT ");
            if (sign && !ciph) {
                return 1;
            }
            if (!sign && ciph) {
                return 2;
            }
            if (!testCert) {
                return 3;
            }
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        try {
            boolean ciph;
            String c = this.getCert(alias);
            Certificate cc = new Certificate(Util.getBytes((String)c));
            byte usage = (byte)(cc.getKeyUsageBits() % 256);
            boolean sign = (usage & 0x63) > 0;
            boolean bl = ciph = (usage & 0xC) > 0;
            if (sign && !ciph) {
                return 1;
            }
            if (!sign && ciph) {
                return 2;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.debug("exception ignored");
        }
        return 3;
    }

    public byte[] getData(String alias) throws CapiException {
        PKCS11Object obj = this.findObject(alias, 0);
        if (obj == null) {
            throw new CapiException("Object not found", 10020);
        }
        try {
            logger.debug("getting DATA attribute value");
            byte[] pdata = obj.getByteArrayAttributeValue(17);
            logger.debug("get DATA attribute value");
            return pdata;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
    }

    public void setData(String alias, byte[] data, int mode) throws CapiException {
        try {
            this.removeObjects(alias, mode);
            int[] attrtypes = new int[]{0, 1, 2, 16, 3, 17};
            Object[] attrvalues = new Object[]{PKCS11Object.DATA, Boolean.TRUE, Boolean.TRUE, "Ellips", alias, data};
            logger.debug("creating DATA object");
            PKCS11Object obj = this.session.createObject(attrtypes, attrvalues);
            logger.debug("created  DATA object");
            this.addObject(obj, alias, 0);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage());
            throw e;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
    }

    public String getCert(String alias) throws CapiException {
        PKCS11Object obj = this.findObject(alias, 1);
        if (obj == null) {
            throw new CapiException("Object not found", 10022);
        }
        try {
            logger.debug("getting Cert alias=" + alias);
            if ((this.flags & 0x80) != 0) {
                String b64cert = this.getObjectCert(alias);
                if (b64cert == null) {
                    byte[] cert = obj.getByteArrayAttributeValue(17);
                    logger.debug("getCert Attribute alias=" + alias);
                    if (cert != null) {
                        b64cert = Util.base64EncodeStr((byte[])cert);
                        this.setObjectCert(alias, b64cert);
                        logger.debug("getCert alias=" + alias);
                        return b64cert;
                    }
                    logger.debug("getCert null alias=" + alias);
                    return null;
                }
                String label = obj.getStringAttributeValue(3);
                if (!alias.equals(label)) {
                    throw new CapiException("alias not found", 10023);
                }
                logger.debug("getCert b64 alias=" + alias);
                return b64cert;
            }
            byte[] certificate = obj.getByteArrayAttributeValue(17);
            logger.debug("getCert alias=" + alias);
            if (certificate != null) {
                return Util.base64EncodeStr((byte[])certificate);
            }
            return null;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage());
            throw e;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 1003);
        }
    }

    public String installCertificate(Certificate cert) throws CapiException {
        logger.debug("installCertificate find alias ...");
        PublicKey pubKey = null;
        String pubKeyAlias = null;
        for (String alias : this.objects.keySet()) {
            if ((this.getObjectType(alias) & 0xC) <= 0) continue;
            PublicKey pk = this.getPublicKey(alias);
            if (!cert.getPublicKey().equals(pk) || !this.checkKeyUsage(this.getKeyUsage(alias, true), cert.getKeyUsageBits())) continue;
            pubKey = pk;
            pubKeyAlias = alias;
            break;
        }
        if (pubKey == null) {
            throw new CapiException("Public key not corresponding", 10033);
        }
        logger.debug("Public key Found {}", pubKeyAlias);
        byte[] id = null;
        try {
            PKCS11Object obj = this.findObject(pubKeyAlias, 3);
            logger.debug("instCert getting prvkey ID");
            id = obj.getByteArrayAttributeValue(258);
            logger.debug("instCert get prvkey ID");
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        this.setCert(pubKeyAlias, cert, 9, id, false);
        return pubKeyAlias;
    }

    public void setCert(String alias, byte[] cert, int mode, boolean ckapriv) throws CapiException {
        Certificate c = new Certificate(cert);
        byte[] id = this.getUniqueID(this.hash(((RSAKey)((Object)c.getPublicKey())).getModulus().toByteArray()));
        this.setCert(alias, c, mode, id, ckapriv);
    }

    public void setCert(String alias, Certificate cert, int mode, byte[] id, boolean ckapriv) throws CapiException {
        logger.debug("setCert alias=" + alias);
        logger.debug("setCert ckapriv=" + ckapriv);
        try {
            this.removeObjects(alias, mode);
            ArrayList<Integer> lstPubAttributeType = new ArrayList<Integer>();
            lstPubAttributeType.add(0);
            lstPubAttributeType.add(1);
            lstPubAttributeType.add(128);
            lstPubAttributeType.add(2);
            lstPubAttributeType.add(258);
            lstPubAttributeType.add(3);
            lstPubAttributeType.add(257);
            lstPubAttributeType.add(129);
            lstPubAttributeType.add(130);
            lstPubAttributeType.add(17);
            if (this.lockGeneratedTokenObject) {
                lstPubAttributeType.add(370);
            }
            int[] attrtypes = Util.intArrayFromList(lstPubAttributeType);
            ArrayList<Object> lstPubAttributeValue = new ArrayList<Object>();
            lstPubAttributeValue.add(PKCS11Object.CERTIFICATE);
            lstPubAttributeValue.add(Boolean.TRUE);
            lstPubAttributeValue.add(PKCS11Object.X_509);
            lstPubAttributeValue.add(ckapriv ? Boolean.TRUE : Boolean.FALSE);
            lstPubAttributeValue.add(id);
            lstPubAttributeValue.add(alias);
            lstPubAttributeValue.add(cert.getSubjectName().getEncoded());
            lstPubAttributeValue.add(cert.getIssuerName().getEncoded());
            lstPubAttributeValue.add(cert.getInternalCert().getSerialNumber());
            lstPubAttributeValue.add(Util.base64DecodeStr((String)cert.getEncoded()));
            if (this.lockGeneratedTokenObject) {
                lstPubAttributeValue.add(false);
            }
            Object[] attrvalues = lstPubAttributeValue.toArray(new Object[lstPubAttributeValue.size()]);
            logger.debug("creating cert object");
            PKCS11Object obj = this.session.createObject(attrtypes, attrvalues);
            logger.debug("set cert object");
            String aliasNew = this.addObject(obj, alias, 1, id);
            logger.debug("setCert addobj done");
            if ((this.flags & 0x80) != 0) {
                this.setObjectCert(aliasNew, cert.getEncoded());
            }
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode(), (Throwable)e);
            throw e.toCapiException();
        }
    }

    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
        PKCS11Object objPrivKey = null;
        PKCS11Object objPubKey = null;
        PKCS11Object objCert = null;
        Object objPrivKeyId = null;
        Object objCertId = null;
        boolean privKeyFound = false;
        boolean pubKeyFound = false;
        boolean certFound = false;
        try {
            PKCS11Object obj;
            this.session.findObjectsInit(null, null);
            while ((obj = this.session.findObject()) != null) {
                int objClass = obj.getIntAttributeValue(0);
                String objLabel = obj.getStringAttributeValue(3);
                if (objClass == PKCS11Object.PRIVATE_KEY && objLabel.equals(label)) {
                    objPrivKey = obj;
                    privKeyFound = true;
                }
                if (objClass == PKCS11Object.PUBLIC_KEY && objLabel.equals(label)) {
                    objPubKey = obj;
                    pubKeyFound = true;
                }
                if (objClass != PKCS11Object.CERTIFICATE || !objLabel.equals(label)) continue;
                objCert = obj;
                certFound = true;
                logger.debug("trovato certificato " + label);
            }
            this.session.findObjectsFinal();
            logger.debug("OBJECT LIST END\n");
            if (!certFound || objCert == null) {
                logger.debug("Non trovato certificato " + label);
                return;
            }
            objCert.setAttributeValue(258, newId);
            objCert.setAttributeValue(3, newLabel);
            logger.debug("ckaId e label changed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug(" --> change ID and/or label " + label + " non performed: " + e.getMessage());
        }
    }

    public boolean canImport() {
        return (this.flags & 1) <= 0;
    }

    public boolean canExport(String alias) {
        logger.debug("canExport: alias=" + alias);
        if ((this.flags & 2) > 0) {
            return false;
        }
        logger.debug("canExport: alias null=" + alias);
        if (alias == null) {
            return true;
        }
        logger.debug("canExport: findObj =" + alias);
        try {
            PKCS11Object obj = this.findObject(alias, 3);
            if (obj == null) {
                return false;
            }
            logger.debug("canExport: getbool ");
            boolean sensitive = obj.getBoolAttributeValue(259);
            logger.debug("canExport: sensitive= " + sensitive);
            if (sensitive) {
                return false;
            }
            logger.debug("canExport: return true ");
            return true;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            return false;
        }
    }

    public int canUnblock() {
        if ((this.flags & 8) > 0) {
            return 0;
        }
        if ((this.flags & 0x10) > 0) {
            return 1;
        }
        return 2;
    }

    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        this.genKeyPair(alias, KeyAlgo.RSA, type, bits, mode);
    }

    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        this.removeObjects(alias, mode);
        try {
            Boolean sensitive;
            boolean ciph;
            boolean sign = type != 2;
            boolean bl = ciph = type != 1;
            if (type == 3) {
                sign = true;
                ciph = true;
            }
            Boolean bl2 = sensitive = ciph ? Boolean.FALSE : Boolean.TRUE;
            if ((this.flags & 4) > 0) {
                sensitive = Boolean.TRUE;
            }
            if ((this.flags & 0x200) > 0) {
                ckaprivate = true;
            }
            ArrayList<Integer> lstPubAttributeType = new ArrayList<Integer>();
            ArrayList<Object> lstPubAttributeValue = new ArrayList<Object>();
            ArrayList<Integer> lstPrivAttributeType = new ArrayList<Integer>();
            ArrayList<Object> lstPrivAttributeValue = new ArrayList<Object>();
            lstPubAttributeType.add(1);
            lstPubAttributeType.add(289);
            lstPubAttributeType.add(262);
            lstPubAttributeType.add(266);
            lstPubAttributeType.add(260);
            lstPubAttributeType.add(258);
            lstPubAttributeType.add(3);
            if (this.lockGeneratedTokenObject) {
                lstPubAttributeType.add(370);
            }
            lstPubAttributeValue.add(Boolean.TRUE);
            lstPubAttributeValue.add(new Integer(bits));
            lstPubAttributeValue.add(ciph ? Boolean.TRUE : Boolean.FALSE);
            lstPubAttributeValue.add(sign ? Boolean.TRUE : Boolean.FALSE);
            lstPubAttributeValue.add(ciph ? Boolean.TRUE : Boolean.FALSE);
            lstPubAttributeValue.add(Util.getBytes((String)alias));
            lstPubAttributeValue.add(alias);
            if (this.lockGeneratedTokenObject) {
                lstPubAttributeValue.add(Boolean.FALSE);
            }
            lstPrivAttributeType.add(1);
            lstPrivAttributeType.add(2);
            lstPrivAttributeType.add(259);
            lstPrivAttributeType.add(263);
            lstPrivAttributeType.add(264);
            lstPrivAttributeType.add(261);
            lstPrivAttributeType.add(258);
            lstPrivAttributeType.add(3);
            if (this.lockGeneratedTokenObject) {
                lstPrivAttributeType.add(370);
            }
            lstPrivAttributeValue.add(Boolean.TRUE);
            lstPrivAttributeValue.add(Boolean.TRUE);
            lstPrivAttributeValue.add(sensitive);
            lstPrivAttributeValue.add(ciph ? Boolean.TRUE : Boolean.FALSE);
            lstPrivAttributeValue.add(sign ? Boolean.TRUE : Boolean.FALSE);
            lstPrivAttributeValue.add(ciph ? Boolean.TRUE : Boolean.FALSE);
            lstPrivAttributeValue.add(Util.getBytes((String)alias));
            lstPrivAttributeValue.add(alias);
            if (this.lockGeneratedTokenObject) {
                lstPrivAttributeValue.add(Boolean.FALSE);
            }
            if (algo == KeyAlgo.RSA) {
                lstPubAttributeType.add(2);
                lstPubAttributeType.add(267);
                lstPubAttributeType.add(290);
                lstPubAttributeValue.add(ckaprivate ? Boolean.TRUE : Boolean.FALSE);
                lstPubAttributeValue.add(sign ? Boolean.TRUE : Boolean.FALSE);
                lstPubAttributeValue.add(new BigInteger("65537"));
                lstPrivAttributeType.add(265);
                lstPrivAttributeValue.add(sign ? Boolean.TRUE : Boolean.FALSE);
            } else {
                ASN1ObjectIdentifier ec_params = null;
                if (bits == 521) {
                    ec_params = SECObjectIdentifiers.secp521r1;
                } else if (bits == 384) {
                    ec_params = SECObjectIdentifiers.secp384r1;
                } else if (bits == 256) {
                    ec_params = SECObjectIdentifiers.secp256r1;
                } else {
                    throw new CapiException("Unsupported Curve Bits", 10031);
                }
                lstPubAttributeType.add(384);
                lstPubAttributeType.add(268);
                lstPubAttributeValue.add(ec_params.getEncoded());
                lstPubAttributeValue.add(Boolean.FALSE);
                lstPrivAttributeType.add(384);
                lstPrivAttributeType.add(268);
                lstPrivAttributeValue.add(ec_params.getEncoded());
                lstPrivAttributeValue.add(Boolean.FALSE);
            }
            int[] PUBattrtypes = Util.intArrayFromList(lstPubAttributeType);
            Object[] PUBattrvalues = lstPubAttributeValue.toArray(new Object[lstPubAttributeValue.size()]);
            int[] PRVattrtypes = Util.intArrayFromList(lstPrivAttributeType);
            Object[] PRVattrvalues = lstPrivAttributeValue.toArray(new Object[lstPrivAttributeValue.size()]);
            logger.debug("generating keypair");
            PKCS11Object[] newobj = null;
            int bitLength = 0;
            int attempt = 0;
            boolean keyLengthKO = false;
            do {
                if (algo == KeyAlgo.RSA) {
                    newobj = this.session.generateKeyPair(0, null, PUBattrtypes, PUBattrvalues, PRVattrtypes, PRVattrvalues);
                    bitLength = newobj[0].getBigIntegerAttributeValue(288).bitLength();
                    if (bitLength == bits) {
                        keyLengthKO = false;
                        logger.debug("keypair length ok: " + bitLength + " bit");
                    } else {
                        keyLengthKO = true;
                        logger.debug("keypair length ko: " + bitLength + " bit");
                        this.internalDeletePkcs11Object(this.session, alias, PKCS11Object.PRIVATE_KEY);
                        logger.debug("private key deleted");
                        this.internalDeletePkcs11Object(this.session, alias, PKCS11Object.PUBLIC_KEY);
                        logger.debug("public key deleted");
                    }
                    ++attempt;
                    continue;
                }
                newobj = this.session.generateKeyPair(4160, null, PUBattrtypes, PUBattrvalues, PRVattrtypes, PRVattrvalues);
                keyLengthKO = false;
            } while (keyLengthKO && attempt < 5);
            if (keyLengthKO) {
                throw new CapiException("keypair length error (" + bitLength + " <> " + bits + ")", 10031);
            }
            logger.debug("generated keypair");
            BigInteger objmod = null;
            byte[] objid = null;
            try {
                byte[] id;
                BigInteger mod;
                objmod = mod = newobj[0].getBigIntegerAttributeValue(288);
                logger.debug("get modulus key pair");
                objid = id = this.getUniqueID(this.hash(mod.toByteArray()));
                newobj[0].setAttributeValue(258, id);
                newobj[1].setAttributeValue(258, id);
                logger.debug("set ID key pair");
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
                logger.debug("Unable to change the ID - go on anyway");
            }
            this.addObject(newobj[0], alias, 2, objid);
            String aliasNew = this.addObject(newobj[1], alias, 3, objid);
            if ((this.flags & 0x80) != 0) {
                this.setObjectPublicKeyInfo(aliasNew, this.getPublicKey(aliasNew));
            }
        }
        catch (CapiException e) {
            logger.debug(e.getMessage());
            throw e;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (IOException e) {
            throw new CapiException("Unable to generate Key", 1003, (Throwable)e);
        }
    }

    private void internalDeletePkcs11Object(PKCS11Session session, String alias, Object pkcs11Object) {
        try {
            int[] ai = new int[]{0, 258, 3};
            Object[] aobj = new Object[]{pkcs11Object, Util.getBytes((String)alias), alias};
            session.findObjectsInit(ai, aobj);
            PKCS11Object obj = session.findObject();
            obj.destroy();
            session.findObjectsFinal();
        }
        catch (Exception delEx) {
            logger.debug(delEx.getMessage());
            delEx.printStackTrace();
        }
    }

    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        Boolean sensitive;
        if (!this.canImport()) {
            throw new CapiException("Cannot import", 11002);
        }
        logger.debug("impcred " + alias);
        this.removeObjects(alias, mode);
        boolean sign = type != 2;
        boolean ciph = type != 1;
        logger.debug("impcred sign " + sign + " ciph " + ciph);
        Boolean bl = sensitive = ciph ? Boolean.FALSE : Boolean.TRUE;
        if ((this.flags & 4) > 0) {
            sensitive = Boolean.TRUE;
        }
        ArrayList<Integer> lstPRVAttributeType = new ArrayList<Integer>();
        ArrayList<Object> lstPRVAttributeValue = new ArrayList<Object>();
        byte[] id = null;
        try {
            if (sk.getAlgorithm().equalsIgnoreCase("RSA")) {
                id = this.getUniqueID(this.hash(((RSAPrivateKey)sk).getModulus().toByteArray()));
                logger.debug("impcred getUniqueID ");
                lstPRVAttributeType.add(0);
                lstPRVAttributeType.add(256);
                lstPRVAttributeType.add(1);
                lstPRVAttributeType.add(2);
                lstPRVAttributeType.add(259);
                lstPRVAttributeType.add(258);
                lstPRVAttributeType.add(3);
                lstPRVAttributeType.add(261);
                lstPRVAttributeType.add(264);
                lstPRVAttributeType.add(265);
                lstPRVAttributeType.add(263);
                lstPRVAttributeType.add(288);
                lstPRVAttributeType.add(290);
                lstPRVAttributeType.add(291);
                lstPRVAttributeType.add(292);
                lstPRVAttributeType.add(293);
                lstPRVAttributeType.add(294);
                lstPRVAttributeType.add(295);
                lstPRVAttributeType.add(296);
                lstPRVAttributeValue.add(PKCS11Object.PRIVATE_KEY);
                lstPRVAttributeValue.add(PKCS11Object.RSA);
                lstPRVAttributeValue.add(Boolean.TRUE);
                lstPRVAttributeValue.add(Boolean.TRUE);
                lstPRVAttributeValue.add(sensitive);
                lstPRVAttributeValue.add(id);
                lstPRVAttributeValue.add(alias);
                lstPRVAttributeValue.add(ciph ? Boolean.TRUE : Boolean.FALSE);
                lstPRVAttributeValue.add(sign ? Boolean.TRUE : Boolean.FALSE);
                lstPRVAttributeValue.add(sign ? Boolean.TRUE : Boolean.FALSE);
                lstPRVAttributeValue.add(ciph ? Boolean.TRUE : Boolean.FALSE);
                lstPRVAttributeValue.add(((RSAPrivateCrtKey)sk).getModulus());
                lstPRVAttributeValue.add(((RSAPrivateCrtKey)sk).getPublicExponent());
                lstPRVAttributeValue.add(((RSAPrivateCrtKey)sk).getPrivateExponent());
                lstPRVAttributeValue.add(((RSAPrivateCrtKey)sk).getPrimeP());
                lstPRVAttributeValue.add(((RSAPrivateCrtKey)sk).getPrimeQ());
                lstPRVAttributeValue.add(((RSAPrivateCrtKey)sk).getPrimeExponentP());
                lstPRVAttributeValue.add(((RSAPrivateCrtKey)sk).getPrimeExponentQ());
                lstPRVAttributeValue.add(((RSAPrivateCrtKey)sk).getCrtCoefficient());
            } else {
                id = this.getUniqueID(this.hash(sk.getEncoded()));
                lstPRVAttributeType.add(258);
                lstPRVAttributeType.add(3);
                lstPRVAttributeType.add(0);
                lstPRVAttributeType.add(256);
                lstPRVAttributeType.add(1);
                lstPRVAttributeType.add(2);
                lstPRVAttributeType.add(259);
                lstPRVAttributeType.add(261);
                lstPRVAttributeType.add(264);
                lstPRVAttributeType.add(17);
                lstPRVAttributeType.add(384);
                lstPRVAttributeValue.add(id);
                lstPRVAttributeValue.add(alias);
                lstPRVAttributeValue.add(PKCS11Object.PRIVATE_KEY);
                lstPRVAttributeValue.add(PKCS11Object.ECDSA);
                lstPRVAttributeValue.add(Boolean.TRUE);
                lstPRVAttributeValue.add(Boolean.TRUE);
                lstPRVAttributeValue.add(sensitive);
                lstPRVAttributeValue.add(ciph ? Boolean.TRUE : Boolean.FALSE);
                lstPRVAttributeValue.add(sign ? Boolean.TRUE : Boolean.FALSE);
                PrivateKeyInfo info = PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])sk.getEncoded()));
                lstPRVAttributeValue.add(((DEROctetString)((DLSequence)info.parsePrivateKey().toASN1Primitive()).getObjectAt(1).toASN1Primitive()).getOctets());
                lstPRVAttributeValue.add(info.getPrivateKeyAlgorithm().getParameters().toASN1Primitive().getEncoded());
            }
            if (this.lockGeneratedTokenObject) {
                lstPRVAttributeType.add(370);
                lstPRVAttributeValue.add(Boolean.FALSE);
            }
            logger.debug("impcred creating object");
            int[] PRVattrtypes = Util.intArrayFromList(lstPRVAttributeType);
            Object[] PRVattrvalues = lstPRVAttributeValue.toArray(new Object[lstPRVAttributeValue.size()]);
            PKCS11Object newobj = this.session.createObject(PRVattrtypes, PRVattrvalues);
            logger.debug("impcred created object");
            String aliasNew = this.addObject(newobj, alias, 3, id);
            logger.debug("impcred addobj done ");
            if ((this.flags & 0x80) != 0) {
                this.setObjectPublicKeyInfo(aliasNew, KeyUtils.rebuildPublicKeyFromPrivate((PrivateKey)sk));
            }
            return aliasNew;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage());
            throw e;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug("Generic Erron on Credential Imports");
            throw new CapiException("Generic Erron on Credential Imports", 1003, (Throwable)e);
        }
    }

    public PublicKey getPublicKey(String alias) throws CapiException {
        try {
            return this.getPublicKey(alias, false);
        }
        catch (Exception ex) {
            return this.getPublicKey(alias, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey getPublicKey(String alias, boolean fromPrivateKey) throws CapiException {
        logger.debug("getting public key...");
        PublicKey pk = null;
        PKCS11Object obj = this.findObject(alias, 2);
        if (obj == null || fromPrivateKey) {
            logger.debug("public key not present, trying with private key");
            obj = this.findObject(alias, 3);
        }
        if (obj == null) {
            logger.debug("private key not present");
            throw new CapiException("public key not present", 10021);
        }
        try {
            logger.debug("getting BigInteger Modulus key...");
            PKCS11Object pKCS11Object = obj;
            synchronized (pKCS11Object) {
                if (obj.getIntAttributeValue(256) == PKCS11Object.ECDSA.intValue()) {
                    byte[] points = null;
                    byte[] params = null;
                    points = obj.getByteArrayAttributeValue(385);
                    params = obj.getByteArrayAttributeValue(384);
                    pk = ECUtils.rebuildPublicKeyFromRawCard((byte[])params, (byte[])points);
                } else {
                    BigInteger exp = null;
                    BigInteger mod = null;
                    mod = obj.getBigIntegerAttributeValue(288);
                    logger.debug("get BigInteger Modulus key");
                    try {
                        exp = (this.flags & 0x40) != 0 ? new BigInteger("65537") : obj.getBigIntegerAttributeValue(290);
                        logger.debug("get BigInteger PublicExponent key " + exp);
                    }
                    catch (Exception e) {
                        logger.debug("KO retrieving public exponent attribute");
                        logger.debug(e.getMessage());
                        throw e;
                    }
                    RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    pk = kf.generatePublic(keySpec);
                }
            }
            if ((this.flags & 0x80) != 0) {
                this.setObjectPublicKeyInfo(alias, pk);
            }
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 1003);
        }
        logger.debug("getPubKey OK");
        return pk;
    }

    public PrivateKey getPrivateKey(String alias) throws CapiException {
        PKCS11Object obj = this.findObject(alias, 3);
        if (obj == null) {
            throw new CapiException("Object not found", 10021);
        }
        Actalis_PrivateKey ret = new Actalis_PrivateKey(alias);
        ret.setCryptoDev((TokenSpi)this);
        ret.setPublicInfo(this.getPublicKey(alias, true));
        return ret;
    }

    public PrivateKey expCred(String alias) throws CapiException {
        RSAPrivateKey sk = null;
        PKCS11Object obj = this.findObject(alias, 3);
        if (obj == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            logger.debug("getting modulus");
            BigInteger mod = obj.getBigIntegerAttributeValue(288);
            logger.debug("get modulus");
            BigInteger exp = obj.getBigIntegerAttributeValue(291);
            logger.debug("get private exponent");
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(mod, exp);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            sk = (RSAPrivateKey)kf.generatePrivate(keySpec);
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 1003);
        }
        logger.debug("expCred OK");
        return sk;
    }

    public int getKeyLength(String alias) throws CapiException {
        return this.getKeyLength(this.getPrivateKey(alias));
    }

    private int getKeyLength(PrivateKey pk) throws CapiException {
        if (pk instanceof Actalis_PrivateKey) {
            PublicKey pubKey = ((Actalis_PrivateKey)pk).getPublicInfo();
            if (pubKey instanceof RSAPublicKey) {
                int realLen = ((RSAPublicKey)pubKey).getModulus().bitLength();
                int len = (realLen + 255) / 256 * 256;
                logger.debug("getKeyLength value=" + realLen + " ->" + len);
                return len;
            }
            return -1;
        }
        return 0;
    }

    public int getMaxRSAKeyLength() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            PKCS11MechanismInfo mech = this.tokenslot.getMechanismInfo(0);
            if (mech != null) {
                return mech.maxKeySize();
            }
            mech = this.tokenslot.getMechanismInfo(1);
            if (mech != null) {
                return mech.maxKeySize();
            }
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            e.toCapiException();
        }
        throw new CapiException("RSA not supported", 11013);
    }

    public int getMinRSAKeyLength() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            PKCS11MechanismInfo mech = this.tokenslot.getMechanismInfo(0);
            if (mech != null) {
                return mech.minKeySize();
            }
            mech = this.tokenslot.getMechanismInfo(1);
            if (mech != null) {
                return mech.minKeySize();
            }
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            e.toCapiException();
        }
        throw new CapiException("RSA not supported", 11013);
    }

    public void instCert(String alias, Certificate c, boolean enforceKeyUsage, boolean ckapriv) throws CapiException {
        logger.debug("instCert alias=" + alias);
        PublicKey pk = null;
        if ((this.getObjectType(alias) & 0xC) <= 0) {
            throw new CapiException("Object not found", 10021);
        }
        pk = this.getPublicKey(alias);
        logger.debug("instCert pk=" + pk);
        if (!c.getPublicKey().equals(pk)) {
            throw new CapiException("Public key not corresponding", 10033);
        }
        logger.debug("instCert check keyusage");
        if (enforceKeyUsage && !this.checkKeyUsage(this.getKeyUsage(alias, true), c.getKeyUsageBits())) {
            throw new CapiException("Key usage not corresponding", 10037);
        }
        byte[] id = null;
        try {
            PKCS11Object obj = this.findObject(alias, 3);
            logger.debug("instCert getting prvkey ID");
            id = obj.getByteArrayAttributeValue(258);
            logger.debug("instCert get prvkey ID");
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        this.setCert(alias, c, 9, id, ckapriv);
    }

    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        logger.debug("doSign alias=" + alias);
        PKCS11Object privkey = this.findObject(alias, 3);
        if (privkey == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            PublicKey pk = this.getPublicKey(alias, true);
            if (pk.getAlgorithm().equalsIgnoreCase("ec")) {
                this.session.signInit(4161, null, privkey);
                byte[] signed = new byte[256];
                int signedSize = this.session.sign(digest, 0, digest.length, signed, 0);
                return Arrays.copyOfRange(signed, 0, signedSize);
            }
            int len = this.getKeyLength(alias) / 8;
            logger.debug("signing RSA LENGTH: in=" + digest.length + " out=" + len);
            byte[] signed = new byte[len];
            if (mode == 3) {
                this.session.signInit(3, null, privkey);
            } else {
                this.session.signInit(1, null, privkey);
            }
            try {
                int n = this.session.sign(digest, 0, digest.length, signed, 0);
                logger.debug("sign OK");
            }
            catch (PKCS11Exception ex) {
                block21: {
                    if (this.dsPinCallBack == null) {
                        throw ex;
                    }
                    if (ex.getCode() == 160 && this.isSessionDsPinIsCnsPin() && this.loggedAsUser) {
                        ((NativePKCS11Session)this.session).setTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_IS_CNS_PIN, "false");
                        try {
                            int n = this.session.sign(digest, 0, digest.length, signed, 0);
                            logger.debug("sign OK");
                        }
                        catch (PKCS11Exception ex2) {
                            if (ex2.getCode() != 257) break block21;
                            ex = ex2;
                        }
                    }
                }
                if (ex.getCode() != 257) {
                    throw ex;
                }
                if (!this.canBit4IdCallBack()) {
                    throw ex;
                }
                String dsPin = this.dsPinCallBack.getPin();
                if (dsPin != null) {
                    ((NativePKCS11Session)this.session).loginContextSpecific(dsPin);
                    int n = this.session.sign(digest, 0, digest.length, signed, 0);
                    logger.debug("sign OK");
                }
                throw ex;
            }
            if (mode == 3) {
                return signed;
            }
            try {
                Cipher rsa = Cipher.getInstance("RSA/ECB/PKCS1Padding", ProvUtils.bcProvider);
                rsa.init(2, pk);
                byte[] res = rsa.doFinal(signed);
                if (!Util.equalsBlock((byte[])res, (byte[])digest)) {
                    logger.debug("hash  : " + new String(Hex.encode((byte[])digest)));
                    logger.debug("result: " + new String(Hex.encode((byte[])res)));
                    throw new Exception("Invalid signature");
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
                throw new CapiException("Invalid signature", 3010);
            }
            return signed;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 50050);
        }
    }

    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        logger.debug("doDecrypt alias=" + alias);
        PKCS11Object privkey = this.findObject(alias, 3);
        if (privkey == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            int len = this.getKeyLength(alias) / 8;
            logger.debug("LENGTH: in=" + digest.length + " out=" + len);
            byte[] signed = new byte[len];
            logger.debug("mode=" + mode);
            if (mode == 4) {
                this.session.decryptInit(3, null, privkey);
            } else {
                this.session.decryptInit(1, null, privkey);
            }
            int n = this.session.decrypt(digest, 0, digest.length, signed, 0);
            logger.debug("decrypted len=" + n + " message: " + PKCS11Object.bytesToString(signed, 0));
            logger.debug("decrypt OK");
            byte[] result = new byte[n];
            System.arraycopy(signed, 0, result, 0, n);
            return result;
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 50050);
        }
    }

    public int getMinPINLen() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            if ((this.flags & 0x80) != 0) {
                PKCS11TokenInfo tinfo = this.getTokenInfo();
                logger.debug("get info from token");
                return tinfo.minPinLen();
            }
            return this.tokenslot.getTokenInfo().minPinLen();
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
    }

    public int getMaxPINLen() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            if ((this.flags & 0x80) != 0) {
                PKCS11TokenInfo tinfo = this.getTokenInfo();
                logger.debug("get info from token");
                return tinfo.maxPinLen();
            }
            return this.tokenslot.getTokenInfo().maxPinLen();
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
    }

    private void getTokenSlot() throws CapiException {
        try {
            if (this.slot < 0) {
                logger.debug("getting token in first available slot");
                this.tokenslot = this.pkcs11.getFirstTokenSlot();
            } else {
                logger.debug("getting token in slot " + this.slot);
                PKCS11Slot[] slots = this.pkcs11.getSlotList(false);
                try {
                    logger.debug(slots.length + " slots found");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean slotFinded = false;
                for (PKCS11Slot currSlot : slots) {
                    if (!(currSlot instanceof NativePKCS11Slot)) {
                        logger.error("Invalid slot object");
                        throw new CapiException("Invalid slot object", 10015);
                    }
                    NativePKCS11Slot nativeSlot = (NativePKCS11Slot)currSlot;
                    try {
                        logger.debug(" - slotId: " + nativeSlot.getNativeID());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (nativeSlot.getNativeID() != this.slot) continue;
                    this.tokenslot = nativeSlot;
                    slotFinded = true;
                    break;
                }
                if (!slotFinded) {
                    logger.error("Invalid slot number");
                    throw new CapiException("Invalid slot number", 10014);
                }
            }
            if (this.tokenslot != null) {
                if ((this.flags & 0x80) != 0) {
                    logger.debug("opt_get_info");
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.tokenslot.getInfo().toString());
                    } else {
                        this.tokenslot.getInfo();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.tokenslot.getTokenInfo().toString());
                    } else {
                        this.tokenslot.getTokenInfo();
                    }
                }
            }
            logger.debug("end get token slot");
        }
        catch (PKCS11Exception e) {
            this.tokenslot = null;
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception e) {
            this.tokenslot = null;
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 10040);
        }
        if (this.tokenslot == null) {
            throw new CapiException("Token not inserted", 10011);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjects() throws CapiException {
        PKCS11 pKCS11 = this.pkcs11;
        synchronized (pKCS11) {
            PKCS11Object obj = null;
            this.objects = new HashMap();
            this.objectsID = new HashMap();
            Vector<PKCS11Object> certs = new Vector<PKCS11Object>();
            this.dummyKeyCnt = 0;
            try {
                Actalis_Object temp;
                String id;
                Actalis_Object temp2;
                String label;
                logger.debug("before findobjectsInit");
                this.session.findObjectsInit(null, null);
                logger.debug("after  findobjectsInit");
                while ((obj = this.session.findObject()) != null) {
                    logger.debug("after obj=session.findobject");
                    int type = obj.getIntAttributeValue(0);
                    logger.debug("after obj.getAttrVal CLASS=" + type);
                    if (type != 1 && type != 0 && type != 3 && type != 2 && type != 4) continue;
                    if (type == 4 && (this.flags & 0x100) != 0) {
                        logger.debug("skip SECRET_KEY CLASS " + type);
                        continue;
                    }
                    if (type == 1) {
                        certs.addElement(obj);
                        logger.debug("end   PKCS11_CERT    CLASS=" + type);
                        continue;
                    }
                    label = null;
                    if ((this.flags & 0x100) == 0) {
                        label = obj.getStringAttributeValue(3);
                        logger.debug("after obj.getAttrVal LABEL=" + label);
                    }
                    if (type == 0 || type == 4) {
                        if ((this.flags & 0x100) != 0) {
                            label = obj.getStringAttributeValue(3);
                            logger.debug("after obj.getAttrVal DATA-SECK LABEL=" + label);
                        }
                        temp2 = new Actalis_Object(type, obj, null, label);
                        this.insertObject(label, temp2);
                        logger.debug("end   PKCS11_DATA || SECK CLASS =" + type);
                        continue;
                    }
                    id = new String(Hex.encode((byte[])obj.getByteArrayAttributeValue(258)));
                    logger.debug("after obj.getAttrVal ID   =" + id);
                    if (this.objectsID.containsKey(id)) {
                        temp = this.objectsID.get(id);
                        if ((this.flags & 0x100) != 0) {
                            label = temp.getLabel();
                            logger.debug("after objsID.getLABEL=" + label);
                        }
                        temp.addObj(type, obj, label);
                        continue;
                    }
                    if ((this.flags & 0x100) != 0) {
                        ++this.dummyKeyCnt;
                        label = Util.newString((byte[])this.dummyKeyLabel) + "_" + this.dummyKeyCnt;
                        logger.debug("after dummy PUBK-PRVK LABEL=" + label);
                    }
                    temp = new Actalis_Object(type, obj, id, label);
                    this.objectsID.put(id, temp);
                }
                this.session.findObjectsFinal();
                logger.debug("after obj=session.findobjectsfinal");
                Enumeration e = certs.elements();
                while (e.hasMoreElements()) {
                    obj = (PKCS11Object)e.nextElement();
                    label = null;
                    if ((this.flags & 0x100) != 0) {
                        label = obj.getStringAttributeValue(3);
                        logger.debug("after CERT.getAttrVal LABEL=" + label);
                    } else {
                        label = obj.getStringAttributeValue(3);
                        logger.debug("after CERT.getAttrVal LABEL=" + label);
                    }
                    id = new String(Hex.encode((byte[])obj.getByteArrayAttributeValue(258)));
                    logger.debug("after CERT.getAttrVal ID   =" + id);
                    if (this.objectsID.containsKey(id)) {
                        temp = this.objectsID.get(id);
                        if ((this.flags & 0x100) != 0) {
                            temp.rename(label);
                            logger.debug("after objsID.getLABEL=" + label);
                        }
                        temp.addObj(1, obj, label);
                        logger.debug("end CERT ID credential =" + id);
                        continue;
                    }
                    temp = new Actalis_Object(1, obj, id, label);
                    this.insertObject(label, temp);
                    logger.debug("end CERT ID alone =" + id);
                }
                for (Map.Entry<String, Actalis_Object> entry : this.objectsID.entrySet()) {
                    temp2 = entry.getValue();
                    if ((this.flags & 0x100) != 0) {
                        String label2 = temp2.getLabel();
                        logger.debug("objectsID LABEL=" + label2);
                        if (label2.startsWith(Util.newString((byte[])this.dummyKeyLabel))) {
                            Object[] objs = temp2.getAllObjects();
                            logger.debug("objectsID n.=" + objs.length);
                            obj = (PKCS11Object)objs[0];
                            label2 = obj.getStringAttributeValue(3);
                            logger.debug("after obj.getAttrVal PUBK-PRVK LABEL=" + label2);
                            temp2.rename(label2);
                        }
                        this.insertObject(label2, temp2);
                        continue;
                    }
                    this.insertObject(temp2.getLabel(), temp2);
                }
                logger.debug("after enumeration objectsid       ");
            }
            catch (PKCS11Exception e) {
                logger.debug(e.getMessage() + " code: " + e.getCode());
                throw e.toCapiException();
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
                throw new CapiException("Internal error", 1003);
            }
        }
    }

    private String addObject(PKCS11Object obj, String alias, int classtype) throws CapiException {
        return this.addObject(obj, alias, classtype, null);
    }

    private String addObject(PKCS11Object obj, String alias, int classtype, byte[] id_obj) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            logger.debug("adding object ");
            String label = null;
            label = (this.flags & 0x80) != 0 ? alias : obj.getStringAttributeValue(3);
            logger.debug("added  object LABEL ");
            int type = 0;
            type = (this.flags & 0x80) != 0 ? classtype : obj.getIntAttributeValue(0);
            logger.debug("added  object CLASS ");
            if (type == 0) {
                Actalis_Object temp = new Actalis_Object(type, obj, null, label);
                return this.insertObject(label, temp);
            }
            String id = null;
            id = (this.flags & 0x80) != 0 ? new String(Hex.encode((byte[])id_obj)) : new String(Hex.encode((byte[])obj.getByteArrayAttributeValue(258)));
            logger.debug("added  object ID ");
            if (this.objectsID.containsKey(id)) {
                Actalis_Object temp = this.objectsID.get(id);
                temp.addObj(type, obj, label);
                return label;
            }
            Actalis_Object temp = new Actalis_Object(type, obj, id, label);
            this.objectsID.put(id, temp);
            return this.insertObject(label, temp);
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 1003);
        }
    }

    private String insertObject(String label, Actalis_Object obj) throws CapiException {
        if (!this.objects.containsKey(label)) {
            this.objects.put(label, obj);
            return label;
        }
        int i = 1;
        while (true) {
            String labelN;
            if (!this.objects.containsKey(labelN = label + "___" + i)) {
                this.objects.put(labelN, obj);
                return labelN;
            }
            ++i;
        }
    }

    private void removeObjects(String alias, int mode) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (mode == 2) {
            return;
        }
        PKCS11Object obj = null;
        if (this.objects.containsKey(alias)) {
            if (mode == 0) {
                throw new CapiException("Object already exist", 10024);
            }
            try {
                Actalis_Object temp = this.objects.get(alias);
                byte type = temp.getType();
                if ((type & 0xC) > 0) {
                    if (mode == 9) {
                        obj = (PKCS11Object)temp.removeCert();
                        if (obj != null) {
                            logger.debug("deleting installed cert. " + alias);
                            obj.destroy();
                            logger.debug("deleted already installed.");
                        }
                        return;
                    }
                    this.objectsID.remove(temp.getID());
                }
                if ((type & 2) > 0) {
                    this.objectsID.remove(temp.getID());
                }
                Object[] objs = temp.getAllObjects();
                logger.debug("deleting " + alias);
                for (int i = 0; i < objs.length; ++i) {
                    ((PKCS11Object)objs[i]).destroy();
                }
                logger.debug("deleted " + alias);
                this.objects.remove(alias);
            }
            catch (PKCS11Exception e) {
                logger.debug(e.getMessage() + " code: " + e.getCode());
                throw e.toCapiException();
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
                throw new CapiException("Internal error", 1003);
            }
        }
    }

    private void renameObject(PKCS11Object obj, String newLabel) throws CapiException {
        try {
            logger.debug("renaming " + newLabel);
            obj.setAttributeValue(3, newLabel);
            logger.debug("renamed  " + newLabel);
        }
        catch (PKCS11Exception e) {
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Internal error", 1003);
        }
    }

    private PKCS11Object findObject(String label, int type) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.objects.containsKey(label)) {
            Actalis_Object temp = this.objects.get(label);
            switch (type) {
                case 3: {
                    return (PKCS11Object)temp.getPrivateKey();
                }
                case 2: {
                    return (PKCS11Object)temp.getPublicKey();
                }
                case 1: {
                    return (PKCS11Object)temp.getCert();
                }
                case 0: {
                    return (PKCS11Object)temp.getData();
                }
                case 4: {
                    return (PKCS11Object)temp.getSek();
                }
            }
            return null;
        }
        return null;
    }

    private byte[] getUniqueID(byte[] orig) {
        String id;
        if (orig == null) {
            Util.secureRandom.nextBytes(orig);
        }
        String string = id = mcccompatibilitymode ? Util.base64EncodeStr((byte[])orig).substring(0, 8) : new String(Hex.encode((byte[])orig));
        while (this.objectsID.containsKey(id)) {
            logger.debug("getUniqueID: generating random");
            Util.secureRandom.nextBytes(orig);
            id = mcccompatibilitymode ? Util.base64EncodeStr((byte[])orig).substring(0, 8) : new String(Hex.encode((byte[])orig));
        }
        return mcccompatibilitymode ? id.getBytes() : orig;
    }

    public String versionString(int i) {
        StringBuffer stringbuffer = new StringBuffer();
        int j = i >> 8;
        int k = i & 0xFF;
        stringbuffer.append(j);
        stringbuffer.append(".");
        stringbuffer.append(k / 10);
        if (k % 10 != 0) {
            stringbuffer.append(k % 10);
        }
        return stringbuffer.toString();
    }

    private PKCS11TokenInfo getTokenInfo() throws PKCS11Exception {
        logger.debug("getting info from token");
        if ((this.flags & 0x80) != 0) {
            long slice = System.currentTimeMillis() - this.last_tokeninfo;
            if (this.tokeninfo == null || slice > 4500L) {
                this.tokeninfo = this.tokenslot.getTokenInfo();
                this.last_tokeninfo = System.currentTimeMillis();
                return this.tokeninfo;
            }
            logger.debug("getting info from token buffer");
            return this.tokeninfo;
        }
        return this.tokenslot.getTokenInfo();
    }

    private void setObjectPublicKeyInfo(String label, PublicKey publicKeyInfo) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.objects.containsKey(label)) {
            Actalis_Object temp = this.objects.get(label);
            temp.setPublicKeyInfo(publicKeyInfo);
        }
    }

    private BigInteger getObjectModule(String label) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.objects.containsKey(label)) {
            Actalis_Object temp = this.objects.get(label);
            return (BigInteger)((Object)temp.getPublicKeyInfo());
        }
        return null;
    }

    private void setObjectCert(String label, String cert) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.objects.containsKey(label)) {
            Actalis_Object temp = this.objects.get(label);
            temp.setB64Cert(cert);
        }
    }

    private String getObjectCert(String label) throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.objects.containsKey(label)) {
            Actalis_Object temp = this.objects.get(label);
            return temp.getB64Cert();
        }
        return null;
    }

    public void openSessionEllips(byte[] pin) throws CapiException {
        boolean asSecurityOfficier = true;
        try {
            logger.debug("before closeAllSessions");
            if (this.session != null) {
                this.session.close();
            }
            this.session = this.tokenslot.openSession(6, null, null);
            this.applySessionConfig((NativePKCS11Session)this.session);
            logger.debug("before login");
            this.session.loginellips(asSecurityOfficier, pin);
        }
        catch (PKCS11Exception e) {
            this.session = null;
            logger.debug(e.getMessage() + " code: " + e.getCode());
            throw e.toCapiException(asSecurityOfficier);
        }
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        CertificationRequestInfo reqInfo = null;
        SubjectPublicKeyInfo spki = null;
        try {
            spki = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), key.getEncoded());
            reqInfo = new CertificationRequestInfo(subject, spki, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature sig = Signature.getInstance("SHA1withRSA", (Provider)ActalisSingleton.getActalisProvider());
        sig.initSign(signingKey);
        try {
            sig.update(reqInfo.getEncoded("DER"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + e);
        }
        CertificationRequestInfo cri = new CertificationRequestInfo(subject, spki, null);
        CertificationRequest cr = new CertificationRequest(cri, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE), new DERBitString(sig.sign()));
        return cr;
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        return this.certReq(subject, rsapk, rsask, Security.getProvider(provname));
    }

    @Deprecated
    public String certReq(String alias, X500Name subject) throws CapiException {
        return this.certReq(subject, this.getPublicKey(alias), this.getPrivateKey(alias), ProvUtils.actalisProvider);
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, List<GeneralNames> subjectAlternativeNames, String challengePassword) throws CapiException {
        GeneralNames[] names = null;
        if (subjectAlternativeNames != null && !subjectAlternativeNames.isEmpty()) {
            names = subjectAlternativeNames.toArray(new GeneralNames[0]);
        }
        return this.generateCertificateRequest(keyType, keyAlgo, keySize, CN, names, challengePassword);
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, GeneralNames[] subjectAlternativeNames, String challengePassword) throws CapiException {
        String date;
        byte[] arrReturn = null;
        int keyUse = 3;
        CertificateFields fields = null;
        try {
            fields = new CertificateFields(CN);
        }
        catch (IllegalArgumentException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Invalid CN: " + CN, 1003);
        }
        if (keyType == KeyType.DS) {
            keyUse = 1;
            if (this.cardFamily == null) {
                throw new CapiException("No strategy to generate qualified signature key", 3011);
            }
            if (this.cardFamily.getDsStrategy() == DSStrategy.NONE) {
                throw new CapiException("No strategy to generate qualified signature key", 3011);
            }
            if (keyAlgo == KeyAlgo.RSA ? keySize < 2048 : keySize < 256) {
                throw new CapiException("Invalid Key Size for qualified signature key", 3011);
            }
        } else if (keyType == KeyType.CNS) {
            if (this.cardFamily == null) {
                throw new CapiException("No strategy to generate cns key", 3011);
            }
            if (this.cardFamily.getCnsStrategy() == CNSStrategy.NONE) {
                throw new CapiException("No strategy to generate cns key", 3011);
            }
        }
        int counter = 0;
        String label = "GenericKey%d";
        if (keyType == KeyType.DS) {
            if (this.cardFamily.getDsStrategy() == DSStrategy.LABEL) {
                counter = 3;
                label = "DS%d";
            }
            if (this.cardFamily.getDsStrategy() == DSStrategy.LABEL2) {
                label = "Firma%d";
            }
            if (this.cardFamily.getDsStrategy() == DSStrategy.PORTAL) {
                date = new SimpleDateFormat("MM-yyyy").format(new Date());
                label = "Firma Digitale Qualificata " + (date.startsWith("0") ? date.substring(1) : date);
            }
        } else if (keyType == KeyType.CNS) {
            if (this.cardFamily.getCnsStrategy() == CNSStrategy.LABEL) {
                label = "CNS0";
            }
            if (this.cardFamily.getCnsStrategy() == CNSStrategy.PORTAL) {
                date = new SimpleDateFormat("MM-yyyy").format(new Date());
                label = "Alias Authentication/CNS " + (date.startsWith("0") ? date.substring(1) : date);
            }
        }
        String finalLabel = "";
        KeyPair pair = null;
        for (int i = counter; i < counter + 3; ++i) {
            block27: {
                try {
                    finalLabel = String.format(label, i);
                    logger.debug("Tentativo Creazione Chiave {}", (Object)finalLabel);
                    this.genKeyPair(finalLabel, keyAlgo, keyUse, keySize, 0);
                    pair = new KeyPair(this.getPublicKey(finalLabel), this.getPrivateKey(finalLabel));
                }
                catch (CapiException ex) {
                    if (ex.getErrorCode() == 11002) {
                        throw ex;
                    }
                    logger.error("Errore tentativo {} : {}", (Object)counter, (Object)ex.getMessage());
                    if (keyType == KeyType.CNS) {
                        throw new CapiException("Unable To Generate Key", 10032, (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    logger.error("Errore tentativo {} : {}", (Object)counter, (Object)ex.getMessage());
                    if (keyType != KeyType.CNS) break block27;
                    throw new CapiException("Unable To Generate Key", 10032, (Throwable)ex);
                }
            }
            if (pair != null) break;
        }
        if (pair == null) {
            throw new CapiException("Unable To Generate Key", 10032);
        }
        try {
            PKCS10CertificationRequest ret = CSRUtils.generateCertificateRequest((Provider)ProvUtils.actalisProvider, pair, (CertificateFields)fields, (GeneralNames[])subjectAlternativeNames);
            arrReturn = ret.getEncoded();
        }
        catch (IOException | NoSuchAlgorithmException | OperatorCreationException ex) {
            this.deleteObject(finalLabel);
            throw new CapiException("Unable To Generate Csr", 1003, ex);
        }
        return arrReturn;
    }

    public boolean requiredExtendedAuth() {
        return false;
    }

    public RecoverySessionCredential openSessionWithExtendedAuth(boolean asSecurityOfficier, String pin, ExtendedCredentials cred) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, Provider prov) throws CapiException {
        Object certReqInfo = null;
        Object cReq = null;
        PKCS10CertificationRequest p10 = null;
        try {
            logger.debug("creating and signing certreq...");
            logger.debug("subject: " + subject.toString());
            JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(subject, rsapk);
            p10 = requestBuilder.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider(prov).build(rsask));
            logger.debug("certRequest ok");
        }
        catch (IllegalStateException e) {
            logger.debug(e.getMessage());
            throw new CapiException("IllegalStateException", 1003);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("NoSuchProviderException", 1003);
        }
        try {
            StringWriter strWriter = new StringWriter();
            PEMWriter pemWrt = new PEMWriter((Writer)strWriter);
            pemWrt.writeObject((Object)p10);
            pemWrt.close();
            String temp = new String(strWriter.getBuffer());
            return temp;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CapiException("Exception saving PEM certificate Requet", 1003);
        }
    }

    public boolean isOpenCns() {
        byte[] pdata;
        block7: {
            if (this.cardFamily == null) {
                return false;
            }
            if (this.cardFamily.getCnsStrategy() == CNSStrategy.NONE) {
                return false;
            }
            pdata = null;
            try {
                pdata = this.getData("PDATA");
            }
            catch (Exception ex) {
                if (ex instanceof CapiException || ((CapiException)((Object)ex)).getErrorCode() != 10020) break block7;
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            if (pdata == null) {
                this.setData("PDATA", "ciao                                                                                                                                                                                                                                                                                                                                                                                                           ".getBytes(), 1);
                this.deleteObject("PDATA");
                return true;
            }
            this.setData("PDATA", pdata, 1);
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public void cleanCard() throws CapiException {
        if (this.objects == null) {
            throw new CapiException("Session not opened", 10013);
        }
        logger.debug("cleanCard...");
        ArrayList<String> keyToRemove = new ArrayList<String>();
        for (String alias : this.objects.keySet()) {
            if ((this.getObjectType(alias) & 0xC) <= 0) continue;
            PublicKey pk = this.getPublicKey(alias);
            boolean certFound = false;
            for (String aliasCert : this.objects.keySet()) {
                Certificate cert;
                if (this.findObject(aliasCert, 1) == null || !(cert = new Certificate(this.getCert(aliasCert).getBytes())).getPublicKey().equals(pk)) continue;
                certFound = true;
                break;
            }
            if (certFound) continue;
            keyToRemove.add(alias);
        }
        for (String alias : keyToRemove) {
            this.deleteObject(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToken(String puk) throws CapiException {
        try {
            if (this.cardFamily == null || this.cardFamily.getDefaultPUK() == null) {
                throw new CapiException("Unable to reset unknown cards", 11002);
            }
            logger.debug("resetCard...");
            this.changePUK(puk, this.cardFamily.getDefaultPUK());
            this.unblockPIN(this.cardFamily.getDefaultPUK(), this.cardFamily.getDefaultPIN());
            this.openSession(false, this.cardFamily.getDefaultPIN());
            if (this.objects.size() > 0) {
                ArrayList<String> objectToDelete = new ArrayList<String>();
                objectToDelete.addAll(this.objects.keySet());
                for (String objectId : objectToDelete) {
                    this.deleteObject(objectId);
                }
            }
        }
        finally {
            this.closeSession();
        }
    }

    public void finalize() throws Throwable {
        if (this.pkcs11 != null) {
            logger.info("Token pkcs11 non chiuso");
            this.finalizeLib();
        }
        super.finalize();
    }

    public void createDsFs(FSStrategyParameters params) throws CapiException {
        if (this.cardFamily.getFsStrategy() == FSStrategy.NONE) {
            throw new UnsupportedOperationException("Not supported TokenParameters.");
        }
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        if (this.isSessionOpen()) {
            this.closeSession();
        }
        if (this.cardFamily.getFsStrategy() == FSStrategy.ATHENA) {
            if (params instanceof AthenaFsStrategyParameters) {
                AthenaDsFsGenerator generator = new AthenaDsFsGenerator((NativePKCS11)this.pkcs11, (NativePKCS11Slot)this.tokenslot, (AthenaFsStrategyParameters)params);
                generator.generateDsFs();
            } else {
                throw new CapiException("Invalid Parameters", 1002);
            }
        }
    }

    public DsPinCallBack getDsPinCallBack() {
        return this.dsPinCallBack;
    }

    public void setDsPinCallBack(DsPinCallBack dsPinCallBack) {
        this.dsPinCallBack = dsPinCallBack;
    }

    private boolean isBit4IdMiddeleware() throws CapiException {
        if (this.session == null) {
            throw new CapiException("session object not found", 10040);
        }
        try {
            ((NativePKCS11Session)this.session).getTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_USE_GUI);
            return true;
        }
        catch (PKCS11Exception ex) {
            return false;
        }
    }

    private boolean canBit4IdCallBack() throws CapiException {
        if (this.isBit4IdMiddeleware()) {
            return ((NativePKCS11Session)this.session).getTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_USE_GUI).equals("false");
        }
        return false;
    }

    private Bit4IDConfigPkcs11Params getEnableSessionGui() {
        if (this.enableSessionGui == Bit4IDConfigPkcs11Params.DEFAULT && System.getProperty("esecurity.pkcs11.dsPinUseGuiSys") != null) {
            if (System.getProperty("esecurity.pkcs11.dsPinUseGuiSys").equals("true")) {
                return Bit4IDConfigPkcs11Params.ENABLE;
            }
            if (System.getProperty("esecurity.pkcs11.dsPinUseGuiSys").equals("false")) {
                return Bit4IDConfigPkcs11Params.DISABLE;
            }
        }
        return this.enableSessionGui;
    }

    public void setEnableSessionGui(Bit4IDConfigPkcs11Params enableSessionGui) {
        this.enableSessionGui = enableSessionGui;
    }

    private Bit4IDConfigPkcs11Params getEnableDSPinIsCnsPin() {
        if (this.enableDSPinIsCnsPin == Bit4IDConfigPkcs11Params.DEFAULT && System.getProperty("esecurity.pkcs11.dsPinIsCnsPinSys") != null) {
            if (System.getProperty("esecurity.pkcs11.dsPinIsCnsPinSys").equals("true")) {
                return Bit4IDConfigPkcs11Params.ENABLE;
            }
            if (System.getProperty("esecurity.pkcs11.dsPinIsCnsPinSys").equals("false")) {
                return Bit4IDConfigPkcs11Params.DISABLE;
            }
        }
        return this.enableDSPinIsCnsPin;
    }

    public void setEnableDSPinIsCnsPin(Bit4IDConfigPkcs11Params enableDSPinIsCnsPin) {
        this.enableDSPinIsCnsPin = enableDSPinIsCnsPin;
    }

    public boolean isSessionDsPinIsCnsPin() throws CapiException {
        if (this.isBit4IdMiddeleware()) {
            return ((NativePKCS11Session)this.session).getTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_IS_CNS_PIN).equals("true");
        }
        return false;
    }

    public boolean isSessionDsPinGuiEnable() throws CapiException {
        if (this.isBit4IdMiddeleware()) {
            return ((NativePKCS11Session)this.session).getTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_USE_GUI).equals("true");
        }
        return false;
    }

    public boolean isLockGeneratedTokenObject() {
        return this.lockGeneratedTokenObject;
    }

    public void setLockGeneratedTokenObject(boolean lockGeneratedTokenObject) {
        this.lockGeneratedTokenObject = lockGeneratedTokenObject;
    }

    private void applySessionConfig(NativePKCS11Session sessione) throws CapiException {
        if (this.isBit4IdMiddeleware()) {
            if (this.getEnableSessionGui() != Bit4IDConfigPkcs11Params.DEFAULT) {
                if (this.getEnableSessionGui() == Bit4IDConfigPkcs11Params.ENABLE) {
                    sessione.setTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_USE_GUI, "true");
                } else {
                    sessione.setTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_USE_GUI, "false");
                }
            }
            if (this.getEnableDSPinIsCnsPin() != Bit4IDConfigPkcs11Params.DEFAULT) {
                if (this.getEnableDSPinIsCnsPin() == Bit4IDConfigPkcs11Params.ENABLE) {
                    sessione.setTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_IS_CNS_PIN, "true");
                } else {
                    sessione.setTokenParam(BIT4ID_TOKEN_PROP_DS_PIN_IS_CNS_PIN, "false");
                }
            }
        }
    }
}

