/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11;

import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final int CLASS = 0;
    public static final int TOKEN = 1;
    public static final int PRIVATE = 2;
    public static final int LABEL = 3;
    public static final int APPLICATION = 16;
    public static final int VALUE = 17;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int ISSUER = 129;
    public static final int SERIAL_NUMBER = 130;
    public static final int KEY_TYPE = 256;
    public static final int SUBJECT = 257;
    public static final int ID = 258;
    public static final int SENSITIVE = 259;
    public static final int ENCRYPT = 260;
    public static final int DECRYPT = 261;
    public static final int WRAP = 262;
    public static final int UNWRAP = 263;
    public static final int SIGN = 264;
    public static final int SIGN_RECOVER = 265;
    public static final int VERIFY = 266;
    public static final int VERIFY_RECOVER = 267;
    public static final int DERIVE = 268;
    public static final int START_DATE = 272;
    public static final int END_DATE = 273;
    public static final int MODULUS = 288;
    public static final int MODULUS_BITS = 289;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PRIME_1 = 292;
    public static final int PRIME_2 = 293;
    public static final int EXPONENT_1 = 294;
    public static final int EXPONENT_2 = 295;
    public static final int COEFFICIENT = 296;
    public static final int PRIME = 304;
    public static final int SUBPRIME = 305;
    public static final int BASE = 306;
    public static final int VALUE_BITS = 352;
    public static final int VALUE_LEN = 353;
    public static final int EXTRACTABLE = 354;
    public static final int LOCAL = 355;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int MODIFIABLE = 368;
    public static final int COPYABLE = 369;
    public static final int DESTROYABLE = 370;
    public static final int ECDSA_PARAMS = 384;
    public static final int EC_POINT = 385;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int INVALID = -1;
    public static final Integer DATA = new Integer(0);
    public static final Integer CERTIFICATE = new Integer(1);
    public static final Integer PUBLIC_KEY = new Integer(2);
    public static final Integer PRIVATE_KEY = new Integer(3);
    public static final Integer SECRET_KEY = new Integer(4);
    public static final Integer RSA;
    public static final Integer DSA;
    public static final Integer DH;
    public static final Integer ECDSA;
    public static final Integer MAYFLY;
    public static final Integer KEA;
    public static final Integer GENERIC_SECRET;
    public static final Integer RC2;
    public static final Integer RC4;
    public static final Integer DES;
    public static final Integer DES2;
    public static final Integer DES3;
    public static final Integer CAST;
    public static final Integer CAST3;
    public static final Integer CAST5;
    public static final Integer CAST128;
    public static final Integer RC5;
    public static final Integer IDEA;
    public static final Integer SKIPJACK;
    public static final Integer BATON;
    public static final Integer JUNIPER;
    public static final Integer CDMF;
    public static final Integer X_509;
    public static final Boolean TRUE;
    public static final Boolean FALSE;
    private static final String[] objclassNames;
    private static final int[] attrtypeList;
    private static final String[] attrtypeNames;
    private static final Class[] attrValueClasses;
    private static final Integer[] keytypeList;
    private static final String[] keytypeNames;
    private static final char[] hexChars;

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract int size() throws PKCS11Exception;

    public Object[] getAttributeValues(int[] ai) throws PKCS11Exception {
        Object[] aobj = new Object[ai.length];
        for (int i = 0; i < ai.length; ++i) {
            aobj[i] = this.getAttributeValue(ai[i]);
        }
        return aobj;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public boolean getBoolAttributeValue(int i) throws PKCS11Exception {
        if (PKCS11Object.valueClass(i) != Boolean.class) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(i);
    }

    public int getIntAttributeValue(int i) throws PKCS11Exception {
        if (PKCS11Object.valueClass(i) != Integer.class) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(i);
    }

    public String getStringAttributeValue(int i) throws PKCS11Exception {
        if (PKCS11Object.valueClass(i) != String.class) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(i);
    }

    public byte[] getByteArrayAttributeValue(int i) throws PKCS11Exception {
        Class<byte[]> c = byte[].class;
        if (PKCS11Object.valueClass(i) != c) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(i);
    }

    public Date getDateAttributeValue(int i) throws PKCS11Exception {
        if (PKCS11Object.valueClass(i) != Date.class) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(i);
    }

    public BigInteger getBigIntegerAttributeValue(int i) throws PKCS11Exception {
        if (PKCS11Object.valueClass(i) != BigInteger.class) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(i);
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public void setBoolAttributeValue(int i, boolean flag) throws PKCS11Exception {
        if (PKCS11Object.valueClass(i) != Boolean.class) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(i, new Boolean(flag));
    }

    public void setIntAttributeValue(int i, int j) throws PKCS11Exception {
        if (PKCS11Object.valueClass(i) != Integer.class) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(i, new Integer(j));
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer(256);
        String s = "                    ";
        stringbuffer.append("object:\n");
        for (int i = 0; i < attrtypeList.length; ++i) {
            String s2;
            String s1;
            block5: {
                int j = attrtypeList[i];
                s1 = PKCS11Object.typeToString(j);
                s2 = null;
                try {
                    Object obj = this.getAttributeValue(j);
                    s2 = PKCS11Object.attrToString(j, obj);
                }
                catch (PKCS11Exception pkcs11exception) {
                    if (pkcs11exception.getCode() != 17) break block5;
                    s2 = "(ATTRIBUTE_SENSITIVE)";
                }
            }
            if (s2 == null) continue;
            stringbuffer.append("\t").append(s1).append(":");
            stringbuffer.append(s.substring(s1.length()));
            stringbuffer.append(s2).append("\n");
        }
        try {
            int k = this.size();
            stringbuffer.append("\tSIZE:").append(s.substring(4)).append(k).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        return stringbuffer.toString();
    }

    public static Class valueClass(int i) {
        for (int j = 0; j < attrtypeList.length; ++j) {
            if (attrtypeList[j] != i) continue;
            return attrValueClasses[j];
        }
        return null;
    }

    public static String typeToString(int i) {
        for (int j = 0; j < attrtypeList.length; ++j) {
            if (attrtypeList[j] != i) continue;
            return attrtypeNames[j];
        }
        return "0x" + Integer.toString(i, 16);
    }

    public static String classToString(Integer integer) {
        int i = integer;
        if (i >= 0 && i < objclassNames.length) {
            return objclassNames[i];
        }
        return "0x" + Integer.toString(i, 16);
    }

    public static String keyToString(Integer integer) {
        int i = integer;
        for (int j = 0; j < keytypeList.length; ++j) {
            if (keytypeList[j] != i) continue;
            return keytypeNames[j];
        }
        return "0x" + Integer.toHexString(i);
    }

    public static String certToString(Integer integer) {
        if (integer.equals(X_509)) {
            return "X_509";
        }
        return integer.toString();
    }

    public static String attrToString(int i, Object obj) {
        if (obj == null) {
            return "null";
        }
        switch (i) {
            case 0: {
                return PKCS11Object.classToString((Integer)obj);
            }
            case 256: {
                return PKCS11Object.keyToString((Integer)obj);
            }
            case 128: {
                return PKCS11Object.certToString((Integer)obj);
            }
            case 17: 
            case 129: 
            case 130: 
            case 257: 
            case 258: {
                return PKCS11Object.bytesToString((byte[])obj, 10);
            }
            case 288: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 304: 
            case 305: 
            case 306: {
                return "0x" + ((BigInteger)obj).toString(16);
            }
        }
        return obj.toString();
    }

    public static String bytesToString(byte[] abyte0, int i) {
        if (abyte0 == null) {
            return "null";
        }
        StringBuffer stringbuffer = new StringBuffer(256);
        int j = 0;
        int k = 0;
        while (k < abyte0.length) {
            if (i != 0 && k > i) {
                stringbuffer.append(" ... (").append(abyte0.length).append(" bytes)");
                break;
            }
            if (j == 16) {
                stringbuffer.append('\n');
                j = 0;
            }
            if (j > 0) {
                stringbuffer.append(' ');
            }
            stringbuffer.append(hexChars[abyte0[k] >> 4 & 0xF]);
            stringbuffer.append(hexChars[abyte0[k] & 0xF]);
            ++k;
            ++j;
        }
        return stringbuffer.toString();
    }

    public static String docuTable() {
        StringBuffer stringbuffer = new StringBuffer(1024);
        stringbuffer.append("  * <TABLE BORDER RULES=ALL CELLPADDING=3>\n");
        stringbuffer.append("  * <TR> <TH> attribute type     <TH> object type\n");
        for (int i = 0; i < attrtypeList.length; ++i) {
            String s = attrValueClasses[i].getName();
            s = s.endsWith("[B") ? "byte[]" : s.substring(s.lastIndexOf(46) + 1);
            stringbuffer.append("  * <TR> <TD> <TT>").append(attrtypeNames[i]);
            stringbuffer.append("</TT> <TD> <TT>").append(s).append("</TT>\n");
        }
        stringbuffer.append("  * </TABLE> <P>\n");
        return stringbuffer.toString();
    }

    static {
        CAST128 = new Integer(24);
        X_509 = new Integer(0);
        objclassNames = new String[]{"DATA", "CERTIFICATE", "PUBLIC_KEY", "PRIVATE_KEY", "SECRET_KEY"};
        attrtypeList = new int[]{0, 1, 2, 3, 16, 17, 128, 129, 130, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 272, 273, 288, 289, 290, 291, 292, 293, 294, 295, 296, 304, 305, 306, 352, 353, 354, 355, 356, 357, 368, 384, 385};
        attrtypeNames = new String[]{"CLASS", "TOKEN", "PRIVATE", "LABEL", "APPLICATION", "VALUE", "CERTIFICATE_TYPE", "ISSUER", "SERIAL_NUMBER", "KEY_TYPE", "SUBJECT", "ID", "SENSITIVE", "ENCRYPT", "DECRYPT", "WRAP", "UNWRAP", "SIGN", "SIGN_RECOVER", "VERIFY", "VERIFY_RECOVER", "DERIVE", "START_DATE", "END_DATE", "MODULUS", "MODULUS_BITS", "PUBLIC_EXPONENT", "PRIVATE_EXPONENT", "PRIME_1", "PRIME_2", "EXPONENT_1", "EXPONENT_2", "COEFFICIENT", "PRIME", "SUBPRIME", "BASE", "VALUE_BITS", "VALUE_LEN", "EXTRACTABLE", "LOCAL", "NEVER_EXTRACTABLE", "ALWAYS_SENSITIVE", "MODIFIABLE", "ECDSA_PARAMS", "EC_POINT"};
        keytypeNames = new String[]{"RSA", "DSA", "DH", "ECDSA", "MAYFLY", "KEA", "GENERIC_SECRET", "RC2", "RC4", "DES", "DES2", "DES3", "CAST", "CAST3", "CAST5", "RC5", "IDEA", "SKIPJACK", "BATON", "JUNIPER", "CDMF"};
        hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        RSA = new Integer(0);
        DSA = new Integer(1);
        DH = new Integer(2);
        ECDSA = new Integer(3);
        MAYFLY = new Integer(4);
        KEA = new Integer(5);
        GENERIC_SECRET = new Integer(16);
        RC2 = new Integer(17);
        RC4 = new Integer(18);
        DES = new Integer(19);
        DES2 = new Integer(20);
        DES3 = new Integer(21);
        CAST = new Integer(22);
        CAST3 = new Integer(23);
        CAST5 = new Integer(24);
        RC5 = new Integer(25);
        IDEA = new Integer(26);
        SKIPJACK = new Integer(27);
        BATON = new Integer(28);
        JUNIPER = new Integer(29);
        CDMF = new Integer(30);
        TRUE = Boolean.TRUE;
        FALSE = Boolean.FALSE;
        attrValueClasses = new Class[]{Integer.class, Boolean.class, Boolean.class, String.class, String.class, byte[].class, Integer.class, byte[].class, byte[].class, Integer.class, byte[].class, byte[].class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Date.class, Date.class, BigInteger.class, Integer.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, byte[].class, byte[].class};
        keytypeList = new Integer[]{RSA, DSA, DH, ECDSA, MAYFLY, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF};
    }
}

