/*
 * Decompiled with CFR 0.152.
 */
package esecurity.internal.asb.gw;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import esecurity.arubacipherservice.DecryptReq;
import esecurity.arubacipherservice.DecryptRet;
import esecurity.internal.asb.gw.GwClientI;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.rest.RestClient;
import it.actalis.ellips.capi.http.arubautils.rest.RestResponse;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.arubapec.signservice.ArssAudit;
import it.arubapec.signservice.Auth;
import it.arubapec.signservice.AutomaticSignatureControl;
import it.arubapec.signservice.AutomaticSignatureControlReturn;
import it.arubapec.signservice.CertListResponse;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.CertsListRequestAuth;
import it.arubapec.signservice.ChangePassword;
import it.arubapec.signservice.CloseSessionRequest;
import it.arubapec.signservice.CreateSessionReturn;
import it.arubapec.signservice.CredentialListQuery;
import it.arubapec.signservice.CredentialListReturn;
import it.arubapec.signservice.GWReturn;
import it.arubapec.signservice.RetriveCredential;
import it.arubapec.signservice.RetriveCredentialReturn;
import it.arubapec.signservice.SendCredential;
import it.arubapec.signservice.SessionSignRequest;
import it.arubapec.signservice.SignRequest;
import it.arubapec.signservice.SignResponse;
import it.arubapec.signservice.StrongCredential;
import it.arubapec.signservice.TempPwdRequest;
import it.arubapec.signservice.TempPwdRequestEx;
import it.arubapec.signservice.TempPwdResponse;
import it.arubapec.signservice.TempPwdResponseEx;
import it.arubapec.signservice.TestCredential;
import it.arubapec.signservice.UserAuthenticationInfoRequest;
import it.arubapec.signservice.UserAuthenticationInfoResponse;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import org.slf4j.Logger;

public class GwClientDefault
extends GwClientI {
    private static Logger logger = null;
    UrlClient client;
    RestClient rsclient = null;
    ObjectMapper mapper = new ObjectMapper();
    ObjectWriter writer = null;
    ObjectWriter writer_signreq = null;
    ObjectWriter writer_ses_signreq = null;
    ObjectWriter writer_certlist = null;
    ObjectWriter writer_certlist_auth = null;
    ObjectWriter writer_auto_sign_control = null;
    ObjectWriter writer_retrive_credential = null;
    ObjectWriter writer_auth_methods = null;
    ObjectWriter writer_authext_methods = null;
    ObjectWriter writer_credential_list_return = null;
    ObjectWriter writer_testcredential = null;
    ObjectReader reader_certlist = null;
    ObjectReader reader_signresponse = null;
    ObjectReader reader_tmppwdext = null;
    ObjectReader reader_tmppwd = null;
    ObjectReader reader_auto_sign_control = null;
    ObjectReader reader_retrive_credential = null;
    ObjectReader reader_string_array = null;
    ObjectReader reader_credential_list_return = null;
    ObjectReader reader_gwreturn = null;
    ObjectReader reader_create_session_return = null;
    ObjectReader reader_decrypt_return = null;
    boolean debug = false;
    URLCredentials cred;
    boolean enforcemode;

    public GwClientDefault(UrlClient client) throws CertDBException {
        this(client, null, null, null, false, true);
    }

    public GwClientDefault(UrlClient client, Logger logger, URLCredentials cred, KeyStore store, boolean ignorecert, boolean enforcemode) {
        this.client = client;
        GwClientDefault.logger = logger != null ? logger : EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        this.cred = cred;
        this.enforcemode = enforcemode;
        this.rsclient = new RestClient(client, store, ignorecert);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.writer = this.mapper.writer();
        this.writer_signreq = this.mapper.writerFor(SignRequest.class);
        this.writer_ses_signreq = this.mapper.writerFor(SessionSignRequest.class);
        this.writer_certlist = this.mapper.writerFor(CertsListRequest.class);
        this.writer_certlist_auth = this.mapper.writerFor(CertsListRequestAuth.class);
        this.writer_auto_sign_control = this.mapper.writerFor(AutomaticSignatureControl.class);
        this.writer_retrive_credential = this.mapper.writerFor(CredentialListQuery.class);
        this.writer_auth_methods = this.mapper.writerFor(Auth.class);
        this.writer_credential_list_return = this.mapper.writerFor(CredentialListReturn.class);
        this.writer_testcredential = this.mapper.writerFor(TestCredential.class);
        this.reader_certlist = this.mapper.readerFor(CertListResponse.class);
        this.reader_signresponse = this.mapper.readerFor(SignResponse.class);
        this.reader_tmppwdext = this.mapper.readerFor(TempPwdResponseEx.class);
        this.reader_tmppwd = this.mapper.readerFor(TempPwdResponse.class);
        this.reader_auto_sign_control = this.mapper.readerFor(AutomaticSignatureControlReturn.class);
        this.reader_retrive_credential = this.mapper.readerFor(RetriveCredentialReturn.class);
        this.reader_string_array = this.mapper.readerFor(String[].class);
        this.reader_credential_list_return = this.mapper.readerFor(CredentialListReturn.class);
        this.reader_gwreturn = this.mapper.readerFor(GWReturn.class);
        this.reader_create_session_return = this.mapper.readerFor(CreateSessionReturn.class);
        this.reader_decrypt_return = this.mapper.readerFor(DecryptRet.class);
        if (System.getProperties().getProperty("esecurity.asb.gw.debug") != null) {
            this.debug = System.getProperties().getProperty("esecurity.asb.gw.debug").equals("true");
        }
    }

    @Override
    public void setEnforceMode(boolean enforce) {
        this.enforcemode = enforce;
    }

    @Override
    public SignResponse signop(String baseurl, SignRequest request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        SignResponse response = new SignResponse();
        try {
            byte[] object = this.writer_signreq.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/signop", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (SignResponse)this.reader_signresponse.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public SignResponse signop2(String baseurl, SessionSignRequest request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        SignResponse response = new SignResponse();
        try {
            byte[] object = this.writer_ses_signreq.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/signop2", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (SignResponse)this.reader_signresponse.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public CertListResponse certlistop(String baseurl, CertsListRequest request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        CertListResponse response = new CertListResponse();
        try {
            byte[] object = this.writer_certlist.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/certlistop", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (CertListResponse)this.reader_certlist.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public CertListResponse certlistopauth(String baseurl, CertsListRequestAuth request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        CertListResponse response = null;
        try {
            byte[] object = this.writer_certlist_auth.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/certlistopauth", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (CertListResponse)this.reader_certlist.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public GWReturn close_session(String baseurl, CloseSessionRequest request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        GWReturn response = null;
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/close_session", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (GWReturn)this.reader_gwreturn.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public CreateSessionReturn create_session(String baseurl, TempPwdRequestEx identity) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        CreateSessionReturn response = null;
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)identity);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/create_session", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (CreateSessionReturn)this.reader_create_session_return.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public TempPwdResponse temppwd(String baseurl, TempPwdRequest request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        TempPwdResponse response = new TempPwdResponse();
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/temppwd", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (TempPwdResponse)this.reader_tmppwd.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public String arssaudit(String baseurl, ArssAudit request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        String response = null;
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/arssaudit", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = new String(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public TempPwdResponseEx temppwd_ext(String baseurl, TempPwdRequestEx request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        TempPwdResponseEx response = new TempPwdResponseEx();
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/temppwd_ext", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (TempPwdResponseEx)this.reader_tmppwdext.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public String send_credential(String baseurl, SendCredential request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        String response = null;
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/send_credential", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = new String(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public String verify_credential(String baseurl, StrongCredential request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        String response = null;
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/verify_credential", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = new String(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public String verify_otp(String baseurl, StrongCredential request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        String response = null;
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/verify_otp", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = new String(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public AutomaticSignatureControlReturn enable_automatic_signature(String baseurl, AutomaticSignatureControl request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        AutomaticSignatureControlReturn response = new AutomaticSignatureControlReturn();
        try {
            byte[] object = this.writer_auto_sign_control.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/temppwd_ext", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (AutomaticSignatureControlReturn)this.reader_auto_sign_control.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public RetriveCredentialReturn retrieve_credential(String baseurl, RetriveCredential retrive_request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        RetriveCredentialReturn response = new RetriveCredentialReturn();
        try {
            byte[] object = this.writer_retrive_credential.writeValueAsBytes((Object)retrive_request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/retrive_credential", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (RetriveCredentialReturn)this.reader_retrive_credential.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public String[] auth_methods(String baseurl, Auth identity) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        String[] response = null;
        try {
            byte[] object = this.writer_auth_methods.writeValueAsBytes((Object)identity);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/auth_methods", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (String[])this.reader_string_array.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public String getInfoMiddlewareUrl() {
        return "";
    }

    @Override
    public CredentialListReturn credentials_query(String baseurl, CredentialListQuery credential_query) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        CredentialListReturn response = new CredentialListReturn();
        try {
            byte[] object = this.writer_retrive_credential.writeValueAsBytes((Object)credential_query);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/credentials_query", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
                logger.debug("{}", (Object)new String(object));
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (CredentialListReturn)this.reader_credential_list_return.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public GWReturn test_otp(String baseurl, TestCredential test_credential) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        GWReturn response = new GWReturn();
        try {
            byte[] object = this.writer_testcredential.writeValueAsBytes((Object)test_credential);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/test_otp", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
                logger.debug("{}", (Object)new String(object));
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (GWReturn)this.reader_gwreturn.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public DecryptRet decrypt(String baseurl, DecryptReq request) throws IOException {
        if (!baseurl.toUpperCase().startsWith("HTTPS")) {
            URL url = new URL(baseurl);
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        DecryptRet response = null;
        try {
            byte[] object = this.writer.writeValueAsBytes((Object)request);
            RestResponse restResp = this.rsclient.sendRawJson(baseurl + "/decrypt", object, this.cred);
            if (this.debug) {
                logger.info("{}", (Object)object);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            response = (DecryptRet)this.reader_decrypt_return.readValue(restResp.getResponseData());
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return response;
    }

    @Override
    public GWReturn changePassword(String baseurl, ChangePassword request) throws IOException {
        return null;
    }

    @Override
    public UserAuthenticationInfoResponse userAuthenticationInfo(String baseurl, UserAuthenticationInfoRequest request) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

