/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import esecurity.arubacipherservice.DecryptReq;
import esecurity.arubacipherservice.DecryptRet;
import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import esecurity.internal.asb.gw.GwClient;
import esecurity.internal.asb.gw.GwClientI;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.SessionCredentials;
import it.actalis.ellips.capi.core.StaticSessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.VerifiedSignatureToken;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.bc.Base64;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.rs.OtpCredentials;
import it.actalis.ellips.capi.rs.RemoteHsmInitializeParameters;
import it.actalis.ellips.capi.util.map.LRUMap;
import it.actalis.vol.utils.Constants;
import it.arubapec.signservice.ApplicationAuth;
import it.arubapec.signservice.Auth;
import it.arubapec.signservice.CertListResponse;
import it.arubapec.signservice.Certificato;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.CloseSessionRequest;
import it.arubapec.signservice.CreateSessionReturn;
import it.arubapec.signservice.SessionSignRequest;
import it.arubapec.signservice.SignRequest;
import it.arubapec.signservice.SignResponse;
import it.arubapec.signservice.TempPwdRequest;
import it.arubapec.signservice.TempPwdRequestEx;
import it.arubapec.signservice.TempPwdResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.slf4j.Logger;

public class RemoteSignatureTokenV2
extends TokenSpi
implements VerifiedSignatureToken {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final LRUMap<String, LoginCache> resps = new LRUMap(50);
    private static final LRUMap<String, FailoverCache> failovers = new LRUMap(50);
    public static final String TOKEN_RS = "RemoteSignatureToken";
    private static final int MAX_PIN_LENGHT = 100;
    private static final int MIN_PIN_LENGHT = 0;
    private static final int MAX_RSA_KEY_LENGTH = 2048;
    private static final int MIN_RSA_KEY_LENGTH = 768;
    private static final String SERIAL_NUMBER = "0";
    private boolean public_session_open = false;
    private String user;
    private String domain;
    private String delegatedUser;
    private String delegatedDomain;
    private String applicationUser;
    private String applicationPassword;
    private String sessionOtp = null;
    private String sessionId = null;
    private String sessionPassword = null;
    private UrlClient net_client = null;
    private GwClientI client = null;
    private ApplicationAuth appidentity = null;
    private LoginCache login = null;
    private String cacheKey = null;
    private HashMap<String, PrivateKey> keyCache = new HashMap();

    public RemoteSignatureTokenV2() {
    }

    public RemoteSignatureTokenV2(RemoteHsmInitializeParameters param) throws CapiException {
        this.initializeLib(param);
    }

    public void initializeLib(String[] args) throws CapiException {
        throw new CapiException("This token doesn't support this initialization mode", 1004);
    }

    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        throw new CapiException("This token doesn't support this initialization mode", 1004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeLib(TokenParameters param) throws CapiException {
        String automaticOtp = null;
        CertListResponse certResp = null;
        String[] authMethods = null;
        String alternateUrl = null;
        if (param instanceof RemoteHsmInitializeParameters) {
            String selectedUrl;
            RemoteHsmInitializeParameters hsmParams = (RemoteHsmInitializeParameters)param;
            if (hsmParams == null) {
                throw new CapiException("Wrong args", 1001);
            }
            if (hsmParams.getIdentity() == null) {
                throw new CapiException("Wrong args", 1001);
            }
            if (hsmParams.getIdentity().getUserid() == null) {
                throw new CapiException("Wrong args usr", 1001);
            }
            if (hsmParams.getIdentity().getPassword() == null) {
                if (hsmParams.getIdentity().getDelegatedBy() == null) {
                    throw new CapiException("Wrong args psw", 1001);
                }
                if (hsmParams.getIdentity().getDelegatedBy().getPassword() == null) {
                    throw new CapiException("Wrong args delegated psw", 1001);
                }
            }
            if (hsmParams.getUrl1() == null) {
                throw new CapiException("Wrong args", 1001);
            }
            String userId = hsmParams.getIdentity().getUserid();
            int indexTok = userId.lastIndexOf("@");
            if (indexTok < 1 || indexTok == userId.length() - 1) {
                throw new CapiException("Invalid user domain, @ expected", 2012);
            }
            this.domain = userId.substring(indexTok + 1);
            this.user = userId.substring(0, indexTok);
            if (hsmParams.getUrl2() != null) {
                if (this.domain.hashCode() % 2 == 0) {
                    selectedUrl = hsmParams.getUrl1();
                    alternateUrl = hsmParams.getUrl2();
                } else {
                    alternateUrl = hsmParams.getUrl1();
                    selectedUrl = hsmParams.getUrl2();
                }
                FailoverCache cache = (FailoverCache)failovers.get((Object)selectedUrl);
                if (cache != null && cache.getExpiredDate().after(new Date())) {
                    String tmp = selectedUrl;
                    selectedUrl = alternateUrl;
                    alternateUrl = tmp;
                }
            } else {
                selectedUrl = hsmParams.getUrl1();
            }
            if (hsmParams.getApplicationUser() != null) {
                this.applicationUser = hsmParams.getApplicationUser();
            }
            if (hsmParams.getApplicationPassword() != null) {
                this.applicationPassword = hsmParams.getApplicationPassword();
            }
            Auth identity = null;
            if (hsmParams.getIdentity().getDelegatedBy() != null) {
                String delegateId = hsmParams.getIdentity().getDelegatedBy().getUserid();
                int indexTok2 = delegateId.lastIndexOf("@");
                if (indexTok2 == -1 && indexTok > 1) {
                    throw new CapiException("Invalid delegated user domain, @ expected", 2012);
                }
                this.delegatedDomain = delegateId.substring(indexTok2 + 1);
                this.delegatedUser = delegateId.substring(0, indexTok2);
                identity = this.retrieveIdByPassword(hsmParams.getIdentity().getDelegatedBy().getPassword());
            } else {
                identity = this.retrieveIdByPassword(hsmParams.getIdentity().getPassword());
            }
            this.net_client = new UrlClient(hsmParams.getNetworkConfig(), logger);
            URLCredentials creds = null;
            if (!Util.isNullOrEmpty((String)hsmParams.getBasicAuthUser()) && !Util.isNullOrEmpty((String)hsmParams.getBasicAuthPwd())) {
                creds = new URLCredentials(hsmParams.getBasicAuthUser(), hsmParams.getBasicAuthPwd(), null, null);
            }
            this.client = GwClient.getInstance(this.net_client, logger, creds, ArubaTrustStore.getTSRS((String)this.domain), false, hsmParams.isEnforceMode(), this.user);
            this.cacheKey = RemoteSignatureTokenV2.createCacheKey(this.user, this.domain, selectedUrl, identity);
            this.login = (LoginCache)resps.get((Object)this.cacheKey);
            if (this.login != null) {
                if (this.login.getResp() == null || this.login.automaticOtp == null) {
                    automaticOtp = RemoteSignatureTokenV2.decryptPin(this.login.resp.getKey(), hsmParams.getStore(), hsmParams.getStorePassword());
                    this.login = new LoginCache(this.login.resp, this.login.authMethods, this.login.selectedUrl, automaticOtp, this.login.usage);
                    LRUMap<String, LoginCache> lRUMap = resps;
                    synchronized (lRUMap) {
                        resps.put((Object)this.cacheKey, (Object)this.login);
                    }
                }
                return;
            }
            LRUMap<String, LoginCache> lRUMap = resps;
            synchronized (lRUMap) {
                this.login = (LoginCache)resps.get((Object)this.cacheKey);
                if (this.login != null) {
                    if (this.login.getResp() != null && this.login.automaticOtp == null) {
                        automaticOtp = RemoteSignatureTokenV2.decryptPin(this.login.getResp().getKey(), hsmParams.getStore(), hsmParams.getStorePassword());
                        this.login = new LoginCache(this.login.resp, this.login.authMethods, this.login.selectedUrl, automaticOtp, this.login.usage);
                        resps.put((Object)this.cacheKey, (Object)this.login);
                    }
                    return;
                }
                CertsListRequest req = new CertsListRequest();
                req.setIdentity(identity);
                try {
                    certResp = this.client.certlistop(selectedUrl, req);
                }
                catch (IOException ex) {
                    logger.warn("Impossibile contattare l'url " + selectedUrl, (Throwable)ex);
                }
                if (certResp == null && alternateUrl != null) {
                    this.cacheKey = RemoteSignatureTokenV2.createCacheKey(this.user, this.domain, alternateUrl, identity);
                    if (failovers.get((Object)selectedUrl) == null) {
                        failovers.put((Object)selectedUrl, (Object)new FailoverCache(selectedUrl));
                    }
                    selectedUrl = alternateUrl;
                    try {
                        certResp = this.client.certlistop(selectedUrl, req);
                    }
                    catch (IOException ex) {
                        logger.warn("Impossibile contattare l'url " + selectedUrl, (Throwable)ex);
                    }
                }
                if (certResp == null) {
                    throw new CapiException("Network Error", -2147483136);
                }
                failovers.remove((Object)selectedUrl);
                if (certResp.getReturn_code() == null) {
                    throw new CapiException("Unknown error: " + certResp.getDescription(), 2012);
                }
                if (certResp.getReturn_code() != null && !certResp.getReturn_code().equals("0000")) {
                    switch (certResp.getReturn_code()) {
                        case "0002": {
                            throw new CapiException("Invalid user credential: " + this.user, 2012);
                        }
                        case "0025": {
                            throw new CapiException("User Temporary Suspended", 2030);
                        }
                        case "0005": {
                            throw new CapiException("Invalid delegated credentials: " + this.delegatedUser, 2016);
                        }
                        case "0007": {
                            throw new CapiException("User is blocked", 2022);
                        }
                        case "0008": {
                            throw new CapiException("Delegated user is blocked", 2022);
                        }
                        case "0009": {
                            throw new CapiException("User is suspended or revoked: " + this.user, 2023);
                        }
                        case "0010": {
                            throw new CapiException("Delegated user is suspended or revoked: " + this.delegatedUser, 2023);
                        }
                        case "0011": {
                            throw new CapiException("Expired certificate", 2024);
                        }
                        case "0012": {
                            throw new CapiException("HSM not available", -2147483136);
                        }
                        case "0015": {
                            throw new CapiException("Invalid applicative credentials", 2025);
                        }
                        case "0018": {
                            throw new CapiException("Operational status blocked", 2019);
                        }
                        case "0021": {
                            this.login = new LoginCache(certResp, authMethods, selectedUrl, automaticOtp, certResp.getUsage());
                            throw new CapiException("Password Expired", 2017);
                        }
                    }
                    throw new CapiException("Unknown error", -2147483136);
                }
                if (Util.isNullOrEmpty((String)certResp.getUsage()) || !certResp.getUsage().equalsIgnoreCase("cipher")) {
                    logger.debug("Selezionato URL :" + selectedUrl);
                    try {
                        authMethods = this.client.auth_methods(selectedUrl, identity);
                        if (authMethods != null) {
                            for (String method : authMethods) {
                                logger.debug("Method enable :" + method);
                            }
                        }
                    }
                    catch (IOException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                CertListResponse certResp2 = null;
                int numOfCerts = 1;
                if (alternateUrl != null && !alternateUrl.equals(selectedUrl) && !failovers.containsKey((Object)alternateUrl)) {
                    try {
                        certResp2 = this.client.certlistop(selectedUrl, req);
                        if (certResp2 != null) {
                            ++numOfCerts;
                        }
                    }
                    catch (IOException ex) {
                        logger.warn("Impossibile contattare l'url " + selectedUrl, (Throwable)ex);
                    }
                }
                CertListResponse[] certResps = new CertListResponse[numOfCerts];
                certResps[0] = certResp;
                if (certResp2 != null) {
                    certResps[1] = certResp2;
                }
                if (certResp.getKey() != null) {
                    automaticOtp = RemoteSignatureTokenV2.decryptPin(certResp.getKey(), hsmParams.getStore(), hsmParams.getStorePassword());
                }
                this.login = new LoginCache(certResp, authMethods, selectedUrl, automaticOtp, certResp.getUsage());
                resps.put((Object)this.cacheKey, (Object)this.login);
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void finalizeLib() {
        try {
            this.closeSession();
        }
        catch (CapiException e) {
            logger.debug("Error closing session: " + e.getMessage());
        }
    }

    public String[] getLibInfo() {
        String tokenType = "Remote Signature";
        String libraryName = "";
        String libraryDescription = "Ellips Remote Signature Token";
        String libraryVersion = "1.0";
        String libraryManufacturer = "Actalis S.p.A.";
        String slotDescription = "";
        String slotManufacturer = "Actalis S.p.A.";
        String tokenModel = "";
        String tokenManufacturer = "Actalis S.p.A.";
        return new String[]{tokenType, libraryName, libraryDescription, libraryVersion, libraryManufacturer, slotDescription, slotManufacturer, tokenModel, tokenManufacturer};
    }

    public String getLibName() {
        return null;
    }

    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    public String getLabel() throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public String getSerialNumber() throws CapiException {
        return SERIAL_NUMBER;
    }

    public int getFreeSpace() throws CapiException {
        return -1;
    }

    public void changePIN(String oldPin, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PIN changing", 1004);
    }

    public void changePUK(String oldPuk, String newPuk) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PUK changing", 1004);
    }

    public int getMaxRSAKeyLength() throws CapiException {
        return 2048;
    }

    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    public void unblockPIN(String PUK, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support unblocking", 1004);
    }

    public int getMaxPINLen() throws CapiException {
        return 100;
    }

    public int getMinPINLen() throws CapiException {
        return 0;
    }

    public void openSession(boolean asSO, String pin) throws CapiException {
        if (!this.isSessionOpen()) {
            if (Util.isNullOrEmpty((String)this.login.getUsage()) || !this.login.getUsage().equalsIgnoreCase("cipher")) {
                if (this.login.getAutomaticOtp() == null) {
                    throw new CapiException("Required Extended Auth user specific Method", -2147483136);
                }
            } else if (this.login.getUsage().equalsIgnoreCase("cipher") && this.login.getResp().isRequireExtendedAuth()) {
                throw new CapiException("Required Extende Auth user specific Method", -2147483136);
            }
            if (this.cacheKey.endsWith(RemoteSignatureTokenV2.digestWithSalt(pin))) {
                this.sessionPassword = pin;
            } else {
                throw new CapiException("Invalid password/OTP for cached object", 2014);
            }
        }
    }

    public void openSession(boolean asSO, String pin, int slot) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    public void openSessionAuthPath(boolean asSO) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    public void openPublicSession() throws CapiException {
        this.public_session_open = true;
    }

    public void closeSession() throws CapiException {
        if (this.sessionId != null && (this.client.getInfoMiddlewareUrl() == null || "".equals(this.client.getInfoMiddlewareUrl()))) {
            CloseSessionRequest closeReq = new CloseSessionRequest();
            closeReq.setIdentity(this.retrieveIdByPassword(this.sessionPassword));
            closeReq.setSession_id(this.sessionId);
            try {
                this.client.close_session(this.login.getSelectedUrl(), closeReq);
            }
            catch (IOException ex) {
                logger.error("Errore nella chiusura della sessione.");
            }
        }
        logger.debug("Closing session");
        this.sessionId = null;
        this.sessionOtp = null;
        this.sessionPassword = null;
        this.public_session_open = false;
    }

    public boolean isSessionOpen() throws CapiException {
        return this.login != null && !Util.isNullOrEmpty((String)this.sessionPassword) || this.login != null && this.public_session_open;
    }

    public byte[] getData(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    public void setData(String alias, byte[] data, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    public String getCert(String alias) throws CapiException {
        if (this.login != null && this.login.getResp() != null) {
            for (Certificato cert : this.login.getResp().getCertlist()) {
                if (!cert.getId().equals(alias)) continue;
                return new String(org.bouncycastle.util.encoders.Base64.encode((byte[])cert.getContent()));
            }
        }
        return null;
    }

    public void setCert(String alias, byte[] cert, int mode, boolean ckapriv) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support setting certificates into the token", 1004);
    }

    public String installCertificate(Certificate cert) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support setting certificates into the token", 1004);
    }

    public boolean canImport() {
        return false;
    }

    public boolean canExport(String alias) {
        return false;
    }

    public int canUnblock() {
        return 0;
    }

    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    public PrivateKey expCred(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    public PublicKey getPublicKey(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving public keys", 1004);
    }

    public PrivateKey getPrivateKey(String alias) throws CapiException {
        if (this.login != null && this.login.getResp() != null) {
            if (this.keyCache.get(alias) == null) {
                for (Certificato cert : this.login.getResp().getCertlist()) {
                    if (!cert.getId().equals(alias)) continue;
                    Actalis_PrivateKey ret = new Actalis_PrivateKey(alias);
                    Certificate certf = new Certificate(org.bouncycastle.util.encoders.Base64.decode((String)this.getCert(alias)));
                    ret.setPublicInfo((PublicKey)((RSAPublicKey)certf.getInternalCert().getPublicKey()));
                    ret.setCryptoDev((TokenSpi)this);
                    this.keyCache.put(alias, (PrivateKey)ret);
                    return ret;
                }
            } else {
                return this.keyCache.get(alias);
            }
        }
        return null;
    }

    public void instCert(String alias, Certificate c, boolean enforceKeyUsage, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public int getKeyLength(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        block68: {
            if (!this.isSessionOpen()) {
                throw new CapiException("Session not opened", 10013);
            }
            try {
                logger.debug("mode:" + mode);
                logger.debug("DigestInfo:" + new String(org.bouncycastle.util.encoders.Base64.encode((byte[])digest)));
                logger.debug("alias:" + alias);
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)digest);
                DigestInfo dinfo = new DigestInfo(seq);
                logger.debug("digest:" + new String(org.bouncycastle.util.encoders.Base64.encode((byte[])dinfo.getDigest())));
                SignRequest req = new SignRequest();
                Auth identity = this.retrieveIdByPassword(this.sessionPassword);
                req.setIdentity(identity);
                req.setCertID(alias);
                req.setDataToSign(dinfo.getDigest());
                SignResponse resp = null;
                if (this.login.getAutomaticOtp() != null) {
                    identity.setOtpPwd(this.login.getAutomaticOtp());
                    resp = this.client.signop(this.login.getSelectedUrl(), req);
                    logger.debug("return_code" + resp.getReturn_code());
                } else {
                    SessionSignRequest sessionReq = new SessionSignRequest();
                    sessionReq.setRequest(req);
                    sessionReq.setSession(this.sessionId);
                    resp = this.client.signop2(this.login.getSelectedUrl(), sessionReq);
                }
                if (this.client.getInfoMiddlewareUrl() != null && !"".equals(this.client.getInfoMiddlewareUrl())) {
                    switch (resp.getReturn_code()) {
                        case "0000": {
                            return resp.getSignData();
                        }
                        case "0002": {
                            this.invalidaCache();
                            throw new CapiError("Invalid User", 2012);
                        }
                        case "0003": {
                            throw new CapiException("Invalid OTP", 2014);
                        }
                        case "0017": {
                            throw new CapiException("Invalid session", 2018);
                        }
                        case "0025": {
                            throw new CapiException("User Temporary Suspended", 2030);
                        }
                    }
                    break block68;
                }
                switch (resp.getReturn_code()) {
                    case "0000": {
                        return resp.getSignData();
                    }
                    case "0002": {
                        this.invalidaCache();
                        throw new CapiException("Invalid Credentials: " + this.user, 2012);
                    }
                    case "0025": {
                        this.invalidaCache();
                        throw new CapiException("User Temporary Suspended", 2030);
                    }
                    case "0005": {
                        this.invalidaCache();
                        throw new CapiException("Invalid delegated credentials", 2016);
                    }
                    case "0007": {
                        this.invalidaCache();
                        throw new CapiException("User is blocked", 2022);
                    }
                    case "0008": {
                        this.invalidaCache();
                        throw new CapiException("Delegated user is blocked", 2022);
                    }
                    case "0009": {
                        this.invalidaCache();
                        throw new CapiException("User is suspended or revoked: " + this.user, 2023);
                    }
                    case "0010": {
                        this.invalidaCache();
                        throw new CapiException("Delegated user is suspended or revoked: " + this.delegatedUser, 2023);
                    }
                    case "0011": {
                        this.invalidaCache();
                        throw new CapiException("Expired certificate", 2024);
                    }
                    case "0012": {
                        this.invalidaCache();
                        throw new CapiException("HSM not available", -2147483136);
                    }
                    case "0015": {
                        throw new CapiException("Invalid applicative credentials", 2025);
                    }
                    case "0018": {
                        throw new CapiException("Operational status blocked", 2019);
                    }
                    case "0021": {
                        this.invalidaCache();
                        throw new CapiException("Password Expired", 2017);
                    }
                    case "0003": {
                        throw new CapiException("Invalid OTP", 2014);
                    }
                    case "0006": {
                        this.invalidaCache();
                        throw new CapiException("Certificate is changed", 2026);
                    }
                    case "0013": {
                        throw new CapiException("Invalid signature type", 3003);
                    }
                    case "0014": {
                        throw new CapiException("Invalid verified signature type", 3003);
                    }
                    case "0016": {
                        throw new CapiException("Invalid query", 3003);
                    }
                    case "0017": {
                        throw new CapiException("Invalid session", 2018);
                    }
                    case "0019": {
                        throw new CapiException("Signature timeout", 2020);
                    }
                    case "0020": {
                        throw new CapiException("Too many signature requests", 2021);
                    }
                }
                throw new CapiException("Unknown error", -2147483136);
            }
            catch (CapiException t) {
                throw t;
            }
            catch (Throwable t) {
                this.invalidaCache();
                logger.error(t.getMessage(), t);
            }
        }
        return null;
    }

    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        if (!this.isSessionOpen()) {
            throw new CapiException("Session not opened", 10013);
        }
        Auth identity = this.retrieveIdByPassword(this.sessionPassword);
        DecryptReq request = new DecryptReq();
        request.setIdentity(identity);
        request.setEncryptedValue(digest);
        request.setKeyId(alias);
        DecryptRet response = null;
        try {
            if (this.sessionId != null) {
                request.setSessionId(this.sessionId);
            }
            response = this.client.decrypt(this.login.getSelectedUrl(), request);
        }
        catch (IOException ex) {
            throw new CapiException("Network Error", -2147483136);
        }
        if (response == null || response.getReturn_code() == null || !response.getReturn_code().equals("0000") || Util.isNullOrEmpty((String)response.getDecryptedValue())) {
            throw new CapiException("Cannot decrypt", 1003);
        }
        return Base64.decode((String)response.getDecryptedValue());
    }

    public String[] listObjects(String expr, byte filter) throws CapiException {
        if (this.login != null && this.login.getResp() == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            ArrayList<String> labels = new ArrayList<String>();
            if (this.login.getResp() == null) {
                return labels.toArray(new String[0]);
            }
            for (Certificato cert : this.login.getResp().getCertlist()) {
                String label = cert.getId();
                if ((this.getObjectType(label) & filter) == 0 || expr != null && label.indexOf(expr) < 0 || labels.contains(label)) continue;
                labels.add(label);
            }
            return labels.toArray(new String[0]);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
    }

    public void deleteObject(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public byte getObjectType(String alias) throws CapiException {
        return 2;
    }

    public String getObjectID(String alias) throws CapiException {
        return alias;
    }

    public int getObjectSize(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void setCert(String alias, Certificate cert, int mode, byte[] id2, boolean ckapriv) throws CapiException {
    }

    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
    }

    public boolean exist(String alias) throws CapiException {
        for (String id : this.listObjects(null, (byte)2)) {
            if (!alias.equals(id)) continue;
            return true;
        }
        return false;
    }

    public String generateID(String[] args) {
        return this.argsResolver(args, 2) + "@" + this.argsResolver(args, 3);
    }

    public String[] getAuthMethods() {
        if (this.login != null) {
            return this.login.getAuthMethods();
        }
        return new String[0];
    }

    public byte[] verifiedSignature(byte[] digest, String alias) throws CapiException {
        if (!this.isSessionOpen()) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            SignRequest req = new SignRequest();
            Auth identity = this.retrieveIdByPassword(this.sessionPassword);
            req.setIdentity(identity);
            req.setCertID(alias);
            req.setDataToSign(digest);
            req.setSignMech("P7M_SINFO");
            if (this.login.getAutomaticOtp() != null) {
                identity.setOtpPwd(this.login.getAutomaticOtp());
                if (logger.isDebugEnabled()) {
                    logger.debug("signerinfo:" + new String(org.bouncycastle.util.encoders.Base64.encode((byte[])digest)));
                }
                SignResponse resp = this.client.signop(this.login.getSelectedUrl(), req);
                logger.debug("return_code" + resp.getReturn_code());
                if (resp.getReturn_code().equals("0000")) {
                    return resp.getSignData();
                }
                if (resp.getReturn_code().equals("0003")) {
                    throw new CapiError("Invalid OTP", 2014);
                }
            } else {
                SessionSignRequest sessionReq = new SessionSignRequest();
                sessionReq.setRequest(req);
                sessionReq.setSession(this.sessionId);
                SignResponse resp = this.client.signop2(this.login.getSelectedUrl(), sessionReq);
                logger.debug("return_code" + resp.getReturn_code());
                if (resp.getReturn_code().equals("0000")) {
                    return resp.getSignData();
                }
                if (resp.getReturn_code().equals("0003")) {
                    throw new CapiError("Invalid OTP", 2014);
                }
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public byte[] xmlVerifiedSignature(byte[] input, String alias) throws CapiException {
        if (!this.isSessionOpen()) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            SignRequest req = new SignRequest();
            Auth identity = this.retrieveIdByPassword(this.sessionPassword);
            req.setIdentity(identity);
            req.setCertID(alias);
            req.setDataToSign(input);
            req.setSignMech("XML_SINFO");
            if (this.login.getAutomaticOtp() != null) {
                identity.setOtpPwd(this.login.getAutomaticOtp());
                if (logger.isDebugEnabled()) {
                    logger.debug("xml_sinfo:" + new String(org.bouncycastle.util.encoders.Base64.encode((byte[])input)));
                }
                SignResponse resp = this.client.signop(this.login.getSelectedUrl(), req);
                logger.debug("return_code" + resp.getReturn_code());
                if (resp.getReturn_code().equals("0000")) {
                    return resp.getSignData();
                }
                if (resp.getReturn_code().equals("0003")) {
                    throw new CapiError("Invalid OTP", 2014);
                }
            } else {
                SessionSignRequest sessionReq = new SessionSignRequest();
                sessionReq.setRequest(req);
                sessionReq.setSession(this.sessionId);
                SignResponse resp = this.client.signop2(this.login.getSelectedUrl(), sessionReq);
                logger.debug("return_code" + resp.getReturn_code());
                if (resp.getReturn_code().equals("0000")) {
                    return resp.getSignData();
                }
                if (resp.getReturn_code().equals("0003")) {
                    throw new CapiError("Invalid OTP", 2014);
                }
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(String alias, X500Name subject) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, GeneralNames[] subjectAlternativeNames, String challengePasssword) throws CapiException {
        return new byte[0];
    }

    private Auth retrieveIdByPassword(String password) {
        Auth objRet = new Auth();
        if (this.applicationUser != null && !"".equals(this.applicationUser) && this.applicationPassword != null && !"".equals(this.applicationPassword)) {
            this.appidentity = new ApplicationAuth();
            this.appidentity.setApplicationuser(this.applicationUser);
            this.appidentity.setApplicationpassword(this.applicationPassword);
            objRet.setAppidentity(this.appidentity);
        }
        objRet.setUser(this.user);
        objRet.setDomain(this.domain);
        objRet.setTypeHSM("COSIGN");
        if (this.delegatedUser == null) {
            objRet.setUserPWD(password);
            if (this.sessionOtp != null && this.sessionId == null) {
                objRet.setOtpPwd(this.sessionOtp);
            }
        } else {
            objRet.setDelegated_domain(this.delegatedDomain);
            objRet.setDelegated_user(this.delegatedUser);
            objRet.setDelegated_password(password);
        }
        return objRet;
    }

    public boolean requiredExtendedAuth() {
        return this.login != null && this.login.getAutomaticOtp() == null && (Util.isNullOrEmpty((String)this.login.getUsage()) || !this.login.getUsage().equalsIgnoreCase("cipher") || this.login.getResp().isRequireExtendedAuth());
    }

    protected void setStaticCredential(String pin, String otp) throws CapiException {
        this.sessionOtp = otp;
        this.sessionPassword = pin;
    }

    public SessionCredentials openSessionWithExtendedAuth(boolean asSO, String pin, ExtendedCredentials cred) throws CapiException {
        if (!this.isSessionOpen()) {
            block24: {
                if (this.login.getAutomaticOtp() != null) {
                    throw new CapiException("Extende Auth not Required", -2147483136);
                }
                if (this.client.getInfoMiddlewareUrl() != null && !"".equals(this.client.getInfoMiddlewareUrl())) {
                    try {
                        if (cred instanceof RecoverySessionCredential) {
                            this.sessionId = ((RecoverySessionCredential)cred).getSessionid();
                        }
                        if (!(cred instanceof OtpCredentials)) {
                            throw new CapiException("openSessionWithExtendedAuth for InfoMiddleware is supported only with Otp", 1004);
                        }
                        TempPwdRequest req = new TempPwdRequest();
                        Auth identity = this.retrieveIdByPassword(pin);
                        identity.setOtpPwd(((OtpCredentials)cred).getOtp());
                        req.setIdentity(identity);
                        TempPwdResponse sessionResp = this.client.temppwd(this.login.getSelectedUrl(), req);
                        if (sessionResp == null) {
                            throw new CapiException("Network Error", -2147483136);
                        }
                        if (sessionResp.getStatus().startsWith("KO-2")) {
                            throw new CapiException("Invalid Password", 2012);
                        }
                        if (sessionResp.getStatus().startsWith("KO-3")) {
                            throw new CapiException("Invalid Otp", 2014);
                        }
                        if (sessionResp.getStatus().startsWith("KO-1")) {
                            throw new CapiException("Invalid User", 2012);
                        }
                        if (sessionResp.getStatus().startsWith("KO")) {
                            throw new CapiException("Errore interno :" + sessionResp.getStatus(), 1003);
                        }
                        this.sessionId = sessionResp.getTmppwd();
                    }
                    catch (IOException ex) {
                        throw new CapiException("Network Error", -2147483136);
                    }
                } else {
                    try {
                        if (cred instanceof RecoverySessionCredential) {
                            this.sessionId = ((RecoverySessionCredential)cred).getSessionid();
                            break block24;
                        }
                        if (cred instanceof StaticSessionCredential) {
                            this.setStaticCredential(pin, ((StaticSessionCredential)cred).getSessionOtp());
                            return (StaticSessionCredential)cred;
                        }
                        if (cred instanceof OtpCredentials) {
                            TempPwdRequestEx req = new TempPwdRequestEx();
                            Auth identity = this.retrieveIdByPassword(pin);
                            req.setTypeAuth("OTP");
                            req.setValue(((OtpCredentials)cred).getOtp());
                            req.setIdentity(identity);
                            CreateSessionReturn ret = this.client.create_session(this.login.getSelectedUrl(), req);
                            if (ret == null) {
                                this.invalidaCache();
                                throw new CapiException("Network Error", -2147483136);
                            }
                            if (ret.getReturn_code().equals("0002")) {
                                this.invalidaCache();
                                throw new CapiException("Invalid Password", 2012);
                            }
                            if (ret.getReturn_code().equals("0025")) {
                                this.invalidaCache();
                                throw new CapiException("Invalid Password", 2030);
                            }
                            if (ret.getReturn_code().equals("0003")) {
                                throw new CapiException("Invalid Otp", 2014);
                            }
                            if (ret.getReturn_code().equals("0022")) {
                                this.setStaticCredential(pin, ((OtpCredentials)cred).getOtp());
                                return new StaticSessionCredential(((OtpCredentials)cred).getOtp());
                            }
                            if (!ret.getReturn_code().equals("0000")) {
                                throw new CapiException("Errore interno :" + ret.getReturn_code(), 1003);
                            }
                            this.sessionId = ret.getSessionId();
                            break block24;
                        }
                        throw new CapiException("openSessionWithExtendedAuth is supported only with Otp or Session", 1004);
                    }
                    catch (IOException ex) {
                        this.invalidaCache();
                        throw new CapiException("Network Error", -2147483136);
                    }
                }
            }
            this.sessionPassword = pin;
        }
        return new RecoverySessionCredential(this.sessionId);
    }

    private static String decryptPin(String encryptedPin, KeyStore store, String keystorePassword) throws CapiException {
        try {
            if (store == null) {
                return null;
            }
            Enumeration<String> alias = store.aliases();
            while (alias.hasMoreElements()) {
                String keyId = alias.nextElement();
                if (!store.isKeyEntry(keyId)) continue;
                Key tokenKey = store.getKey(keyId, keystorePassword.toCharArray());
                byte[] arrKey = org.bouncycastle.util.encoders.Base64.decode((String)encryptedPin);
                Cipher objChip = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                objChip.init(2, tokenKey);
                byte[] arrClear = objChip.doFinal(arrKey);
                return new String(arrClear);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, Provider prov) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resetToken(String puk) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static String digestWithSalt(String message) throws CapiException {
        String message2 = "dkajfw39o2jn1ndwndvcp" + message;
        return Util.dumpHex((byte[])Util.digestStreams((String)Constants.SHA256, (InputStream[])new InputStream[]{new ByteArrayInputStream(message2.getBytes())}));
    }

    private void invalidaCache() {
        resps.remove((Object)this.cacheKey);
    }

    private String argsResolver(String[] args, int index) {
        if (args.length >= index + 1 && args[index] != null) {
            return args[index];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CertListResponse> listCerts(RemoteHsmInitializeParameters hsmParams) throws CapiException {
        ArrayList<CertListResponse> certs = new ArrayList<CertListResponse>();
        String selectedUrl = null;
        String automaticOtp = null;
        CertListResponse certResp = null;
        String[] authMethods = null;
        String alternateUrl = null;
        String applicationUser = null;
        String applicationPassword = null;
        String delegatedDomain = null;
        String delegatedUser = null;
        if (hsmParams == null) {
            throw new CapiException("Wrong args", 1001);
        }
        if (hsmParams.getIdentity() == null) {
            throw new CapiException("Wrong args", 1001);
        }
        if (hsmParams.getIdentity().getUserid() == null) {
            throw new CapiException("Wrong args usr", 1001);
        }
        if (hsmParams.getIdentity().getPassword() == null) {
            if (hsmParams.getIdentity().getDelegatedBy() == null) {
                throw new CapiException("Wrong args psw", 1001);
            }
            if (hsmParams.getIdentity().getDelegatedBy().getPassword() == null) {
                throw new CapiException("Wrong args delegated psw", 1001);
            }
        }
        if (hsmParams.getUrl1() == null) {
            throw new CapiException("Wrong args", 1001);
        }
        String userId = hsmParams.getIdentity().getUserid();
        int indexTok = userId.lastIndexOf("@");
        if (indexTok < 1 || indexTok == userId.length() - 1) {
            throw new CapiException("Invalid user domain, @ expected", 2012);
        }
        String domain = userId.substring(indexTok + 1);
        String user = userId.substring(0, indexTok);
        if (hsmParams.getUrl2() != null) {
            if (domain.hashCode() % 2 == 0) {
                selectedUrl = hsmParams.getUrl1();
                alternateUrl = hsmParams.getUrl2();
            } else {
                alternateUrl = hsmParams.getUrl1();
                selectedUrl = hsmParams.getUrl2();
            }
            FailoverCache cache = (FailoverCache)failovers.get((Object)selectedUrl);
            if (cache != null && cache.getExpiredDate().after(new Date())) {
                String tmp = selectedUrl;
                selectedUrl = alternateUrl;
                alternateUrl = tmp;
            }
        } else {
            selectedUrl = hsmParams.getUrl1();
        }
        if (hsmParams.getApplicationUser() != null) {
            applicationUser = hsmParams.getApplicationUser();
        }
        if (hsmParams.getApplicationPassword() != null) {
            applicationPassword = hsmParams.getApplicationPassword();
        }
        Auth identity = new Auth();
        if (hsmParams.getIdentity().getDelegatedBy() != null) {
            String delegateId = hsmParams.getIdentity().getDelegatedBy().getUserid();
            int indexTok2 = delegateId.lastIndexOf("@");
            if (indexTok2 == -1 && indexTok > 1) {
                throw new CapiException("Invalid delegated user domain, @ expected", 2012);
            }
            delegatedDomain = delegateId.substring(indexTok2 + 1);
            delegatedUser = delegateId.substring(0, indexTok2);
            identity.setDelegated_domain(delegatedDomain);
            identity.setDelegated_user(delegatedUser);
            identity.setDelegated_password(hsmParams.getIdentity().getDelegatedBy().getPassword());
        } else {
            identity.setUserPWD(hsmParams.getIdentity().getPassword());
        }
        ApplicationAuth appidentity = null;
        if (applicationUser != null && !"".equals(applicationUser) && applicationPassword != null && !"".equals(applicationPassword)) {
            appidentity = new ApplicationAuth();
            appidentity.setApplicationuser(applicationUser);
            appidentity.setApplicationpassword(applicationPassword);
            identity.setAppidentity(appidentity);
        }
        identity.setUser(user);
        identity.setDomain(domain);
        identity.setTypeHSM("COSIGN");
        UrlClient net_client = new UrlClient(hsmParams.getNetworkConfig(), logger);
        URLCredentials creds = null;
        if (!Util.isNullOrEmpty((String)hsmParams.getBasicAuthUser()) && !Util.isNullOrEmpty((String)hsmParams.getBasicAuthPwd())) {
            creds = new URLCredentials(hsmParams.getBasicAuthUser(), hsmParams.getBasicAuthPwd(), null, null);
        }
        GwClientI client = GwClient.getInstance(net_client, logger, creds, ArubaTrustStore.getTSRS((String)domain), false, hsmParams.isEnforceMode(), user);
        String cacheKey = RemoteSignatureTokenV2.createCacheKey(user, domain, selectedUrl, identity);
        LoginCache login = null;
        CertsListRequest req = new CertsListRequest();
        req.setIdentity(identity);
        try {
            certResp = client.certlistop(selectedUrl, req);
        }
        catch (IOException ex) {
            logger.warn("Impossibile contattare l'url " + selectedUrl, (Throwable)ex);
        }
        if (certResp != null) {
            failovers.remove((Object)selectedUrl);
            if (certResp.getReturn_code() != null && !certResp.getReturn_code().equals("0000")) {
                switch (certResp.getReturn_code()) {
                    case "0002": {
                        throw new CapiException("Invalid Credentials: " + user, 2012);
                    }
                    case "0025": {
                        throw new CapiException("User Temporary Suspended", 2030);
                    }
                    case "0003": {
                        throw new CapiException("Invalid OTP", 2014);
                    }
                    case "0005": {
                        throw new CapiException("Invalid delegated credentials", 2016);
                    }
                    case "0006": {
                        throw new CapiException("Certificate is changed", 2015);
                    }
                    case "0007": {
                        throw new CapiException("User is blocked", 2015);
                    }
                    case "0008": {
                        throw new CapiException("Delegated user is blocked", 2015);
                    }
                    case "0009": {
                        throw new CapiException("User is suspended or revoked: " + user, 2015);
                    }
                    case "0010": {
                        throw new CapiException("Delegated user is suspended or revoked: " + delegatedUser, 2015);
                    }
                    case "0011": {
                        throw new CapiException("Expired certificate", 2015);
                    }
                    case "0012": {
                        throw new CapiException("HSM not available", 2015);
                    }
                    case "0013": {
                        throw new CapiException("Invalid signature type", 2015);
                    }
                    case "0014": {
                        throw new CapiException("Invalid verified signature type", 2015);
                    }
                    case "0015": {
                        throw new CapiException("Invalid applicative credentials", 2015);
                    }
                    case "0016": {
                        throw new CapiException("Invalid query", 2015);
                    }
                    case "0017": {
                        throw new CapiException("Invalid session", 2015);
                    }
                    case "0018": {
                        throw new CapiException("Operational status blocked", 2015);
                    }
                    case "0019": {
                        throw new CapiException("Signature timeout", 2015);
                    }
                    case "0020": {
                        throw new CapiException("Too many signature requests", 2015);
                    }
                    case "0021": {
                        login = new LoginCache(certResp, authMethods, selectedUrl, automaticOtp, certResp.getUsage());
                        throw new CapiException("Password Expired", 2017);
                    }
                }
                throw new CapiException("Unknown error", 2015);
            }
            if (Util.isNullOrEmpty((String)certResp.getUsage()) || !certResp.getUsage().equalsIgnoreCase("cipher")) {
                logger.debug("Selezionato URL :" + selectedUrl);
                try {
                    authMethods = client.auth_methods(selectedUrl, identity);
                    if (authMethods != null) {
                        for (String method : authMethods) {
                            logger.debug("Method enable :" + method);
                        }
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            login = new LoginCache(certResp, authMethods, selectedUrl, automaticOtp, certResp.getUsage());
            LRUMap<String, LoginCache> ex = resps;
            synchronized (ex) {
                resps.put((Object)cacheKey, (Object)login);
            }
        }
        if (failovers.get((Object)selectedUrl) == null) {
            failovers.put((Object)selectedUrl, (Object)new FailoverCache(selectedUrl));
        }
        boolean recallAuthMethods = true;
        if (login != null) {
            certs.add(login.getResp());
            authMethods = login.getAuthMethods();
            automaticOtp = login.getAutomaticOtp();
            recallAuthMethods = false;
        }
        if (alternateUrl != null) {
            cacheKey = RemoteSignatureTokenV2.createCacheKey(user, domain, alternateUrl, identity);
            try {
                certResp = client.certlistop(alternateUrl, req);
            }
            catch (IOException ex) {
                logger.warn("Impossibile contattare l'url " + alternateUrl, (Throwable)ex);
            }
            if (certResp != null) {
                failovers.remove((Object)alternateUrl);
                if (recallAuthMethods) {
                    if (certResp.getReturn_code() != null && !certResp.getReturn_code().equals("0000")) {
                        switch (certResp.getReturn_code()) {
                            case "0002": {
                                throw new CapiException("Invalid Credentials: " + user, 2012);
                            }
                            case "0025": {
                                throw new CapiException("User Temporary Suspended", 2030);
                            }
                            case "0003": {
                                throw new CapiException("Invalid OTP", 2014);
                            }
                            case "0005": {
                                throw new CapiException("Invalid delegated credentials: " + delegatedUser, 2016);
                            }
                            case "0006": {
                                throw new CapiException("Certificate is changed", 2015);
                            }
                            case "0007": {
                                throw new CapiException("User is blocked", 2015);
                            }
                            case "0008": {
                                throw new CapiException("Delegated user is blocked", 2015);
                            }
                            case "0009": {
                                throw new CapiException("User is suspended or revoked: " + user, 2015);
                            }
                            case "0010": {
                                throw new CapiException("Delegated user is suspended or revoked: " + delegatedUser, 2015);
                            }
                            case "0011": {
                                throw new CapiException("Expired certificate", 2015);
                            }
                            case "0012": {
                                throw new CapiException("HSM not available", 2015);
                            }
                            case "0013": {
                                throw new CapiException("Invalid signature type", 2015);
                            }
                            case "0014": {
                                throw new CapiException("Invalid verified signature type", 2015);
                            }
                            case "0015": {
                                throw new CapiException("Invalid applicative credentials", 2015);
                            }
                            case "0016": {
                                throw new CapiException("Invalid query", 2015);
                            }
                            case "0017": {
                                throw new CapiException("Invalid session", 2015);
                            }
                            case "0018": {
                                throw new CapiException("Operational status blocked", 2015);
                            }
                            case "0019": {
                                throw new CapiException("Signature timeout", 2015);
                            }
                            case "0020": {
                                throw new CapiException("Too many signature requests", 2015);
                            }
                        }
                        throw new CapiException("Unknown error", 2015);
                    }
                    if (Util.isNullOrEmpty((String)certResp.getUsage()) || !certResp.getUsage().equalsIgnoreCase("cipher")) {
                        logger.debug("Selezionato URL :" + selectedUrl);
                        try {
                            authMethods = client.auth_methods(selectedUrl, identity);
                            if (authMethods != null) {
                                for (String method : authMethods) {
                                    logger.debug("Method enable :" + method);
                                }
                            }
                        }
                        catch (IOException ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                login = new LoginCache(certResp, authMethods, alternateUrl, automaticOtp, certResp.getUsage());
                LRUMap<String, LoginCache> lRUMap = resps;
                synchronized (lRUMap) {
                    resps.put((Object)cacheKey, (Object)login);
                }
            }
            if (failovers.get((Object)alternateUrl) == null) {
                failovers.put((Object)alternateUrl, (Object)new FailoverCache(alternateUrl));
            }
            if (login != null) {
                certs.add(login.getResp());
            }
        }
        return certs;
    }

    private static String createCacheKey(String user, String domain, String selectedUrl, Auth identity) throws CapiException {
        return user + domain + selectedUrl + (!Util.isNullOrEmpty((String)identity.getDelegated_user()) ? identity.getDelegated_user() : "-") + (!Util.isNullOrEmpty((String)identity.getDelegated_domain()) ? identity.getDelegated_domain() : "-") + (!Util.isNullOrEmpty((String)identity.getUserPWD()) ? RemoteSignatureTokenV2.digestWithSalt(identity.getUserPWD()) : RemoteSignatureTokenV2.digestWithSalt(identity.getDelegated_password()));
    }

    private static class LoginCache {
        private final CertListResponse resp;
        private final String[] authMethods;
        private final String selectedUrl;
        private final String automaticOtp;
        private final String usage;

        public LoginCache(CertListResponse response, String[] authMeth, String selUrl, String autoOtp, String use) {
            this.resp = response;
            this.authMethods = authMeth;
            this.selectedUrl = selUrl;
            this.automaticOtp = autoOtp;
            this.usage = use;
        }

        public CertListResponse getResp() {
            return this.resp;
        }

        public String[] getAuthMethods() {
            return this.authMethods;
        }

        public String getSelectedUrl() {
            return this.selectedUrl;
        }

        public String getAutomaticOtp() {
            return this.automaticOtp;
        }

        public String getUsage() {
            return this.usage;
        }
    }

    private static class FailoverCache {
        private String url;
        private Date expiredDate;

        public FailoverCache(String url) {
            this.url = url;
            Calendar cal = Calendar.getInstance();
            cal.add(12, 5);
            this.expiredDate = cal.getTime();
        }

        public String getUrl() {
            return this.url;
        }

        public Date getExpiredDate() {
            return this.expiredDate;
        }
    }
}

