/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class StepX509VersionCompliance
extends SingleValidationSubStepImpl {
    public StepX509VersionCompliance() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignature() == null || validationContextParameters.getSignature().getFormat() != null && !validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
            boolean bl = false;
            try {
                if (validationContextParameters.getSignerCertificate().getCert().getVersion() == 3) {
                    bl = true;
                }
            }
            catch (CapiException capiException) {
                bl = false;
            }
            if (!bl) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0017_INVALID_CERT_VERSION, new Object[0]);
            }
        }
        return null;
    }
}

